/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.ActionMenuPresenter;
import android.widget.ActionMenuView;
import com.android.internal.R;

public abstract class AbsActionBarView
extends ViewGroup {
    private static final int FADE_DURATION = 200;
    private static final TimeInterpolator sAlphaInterpolator = new DecelerateInterpolator();
    protected ActionMenuPresenter mActionMenuPresenter;
    protected int mContentHeight;
    protected ActionMenuView mMenuView;
    protected final Context mPopupContext;
    protected boolean mSplitActionBar;
    protected ViewGroup mSplitView;
    protected boolean mSplitWhenNarrow;
    protected final VisibilityAnimListener mVisAnimListener = new VisibilityAnimListener();
    protected Animator mVisibilityAnim;

    public AbsActionBarView(Context context) {
        this(context, null);
    }

    public AbsActionBarView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AbsActionBarView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AbsActionBarView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedValue typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(16843917, typedValue, true) && typedValue.resourceId != 0) {
            this.mPopupContext = new ContextThemeWrapper(context, typedValue.resourceId);
            return;
        }
        this.mPopupContext = context;
    }

    protected static int next(int n, int n2, boolean bl) {
        if (bl) {
            return n - n2;
        }
        return n + n2;
    }

    public void animateToVisibility(int n) {
        if (this.mVisibilityAnim != null) {
            this.mVisibilityAnim.cancel();
        }
        if (n == 0) {
            if (this.getVisibility() != 0) {
                this.setAlpha(0.0f);
                if (this.mSplitView != null && this.mMenuView != null) {
                    this.mMenuView.setAlpha(0.0f);
                }
            }
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, "alpha", 1.0f);
            objectAnimator.setDuration(200L);
            objectAnimator.setInterpolator(sAlphaInterpolator);
            if (this.mSplitView != null && this.mMenuView != null) {
                AnimatorSet animatorSet = new AnimatorSet();
                ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.mMenuView, "alpha", 1.0f);
                objectAnimator2.setDuration(200L);
                animatorSet.addListener(this.mVisAnimListener.withFinalVisibility(n));
                animatorSet.play(objectAnimator).with(objectAnimator2);
                animatorSet.start();
                return;
            }
            objectAnimator.addListener(this.mVisAnimListener.withFinalVisibility(n));
            objectAnimator.start();
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, "alpha", 0.0f);
        objectAnimator.setDuration(200L);
        objectAnimator.setInterpolator(sAlphaInterpolator);
        if (this.mSplitView != null && this.mMenuView != null) {
            AnimatorSet animatorSet = new AnimatorSet();
            ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)this.mMenuView, "alpha", 0.0f);
            objectAnimator3.setDuration(200L);
            animatorSet.addListener(this.mVisAnimListener.withFinalVisibility(n));
            animatorSet.play(objectAnimator).with(objectAnimator3);
            animatorSet.start();
            return;
        }
        objectAnimator.addListener(this.mVisAnimListener.withFinalVisibility(n));
        objectAnimator.start();
    }

    public boolean canShowOverflowMenu() {
        return this.isOverflowReserved() && this.getVisibility() == 0;
    }

    public void dismissPopupMenus() {
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
    }

    public int getAnimatedVisibility() {
        if (this.mVisibilityAnim != null) {
            return this.mVisAnimListener.mFinalVisibility;
        }
        return this.getVisibility();
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    public boolean hideOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.hideOverflowMenu();
        }
        return false;
    }

    public boolean isOverflowMenuShowPending() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.isOverflowMenuShowPending();
        }
        return false;
    }

    public boolean isOverflowMenuShowing() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.isOverflowMenuShowing();
        }
        return false;
    }

    public boolean isOverflowReserved() {
        return this.mActionMenuPresenter != null && this.mActionMenuPresenter.isOverflowReserved();
    }

    protected int measureChildView(View view, int n, int n2, int n3) {
        view.measure(View.MeasureSpec.makeMeasureSpec(n, Integer.MIN_VALUE), n2);
        return Math.max(0, n - view.getMeasuredWidth() - n3);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(null, R.styleable.ActionBar, 16843470, 0);
        this.setContentHeight(typedArray.getLayoutDimension(4, 0));
        typedArray.recycle();
        if (this.mSplitWhenNarrow) {
            this.setSplitToolbar(this.getContext().getResources().getBoolean(17956870));
        }
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.onConfigurationChanged(configuration);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int positionChild(View view, int n, int n2, int n3, boolean bl) {
        int n4 = view.getMeasuredWidth();
        int n5 = view.getMeasuredHeight();
        int n6 = n2 + (n3 - n5) / 2;
        if (bl) {
            view.layout(n - n4, n6, n, n6 + n5);
        } else {
            view.layout(n, n6, n + n4, n6 + n5);
        }
        if (!bl) return n4;
        return -n4;
    }

    public void postShowOverflowMenu() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AbsActionBarView.this.showOverflowMenu();
            }
        });
    }

    public void setContentHeight(int n) {
        this.mContentHeight = n;
        this.requestLayout();
    }

    public void setSplitToolbar(boolean bl) {
        this.mSplitActionBar = bl;
    }

    public void setSplitView(ViewGroup viewGroup) {
        this.mSplitView = viewGroup;
    }

    public void setSplitWhenNarrow(boolean bl) {
        this.mSplitWhenNarrow = bl;
    }

    @Override
    public void setVisibility(int n) {
        if (n != this.getVisibility()) {
            if (this.mVisibilityAnim != null) {
                this.mVisibilityAnim.end();
            }
            super.setVisibility(n);
        }
    }

    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.showOverflowMenu();
        }
        return false;
    }

    protected class VisibilityAnimListener
    implements Animator.AnimatorListener {
        private boolean mCanceled = false;
        int mFinalVisibility;

        protected VisibilityAnimListener() {
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            this.mCanceled = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onAnimationEnd(Animator animator2) {
            block3: {
                block2: {
                    if (this.mCanceled) break block2;
                    AbsActionBarView.this.mVisibilityAnim = null;
                    AbsActionBarView.this.setVisibility(this.mFinalVisibility);
                    if (AbsActionBarView.this.mSplitView != null && AbsActionBarView.this.mMenuView != null) break block3;
                }
                return;
            }
            AbsActionBarView.this.mMenuView.setVisibility(this.mFinalVisibility);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            AbsActionBarView.this.setVisibility(0);
            AbsActionBarView.this.mVisibilityAnim = animator2;
            this.mCanceled = false;
        }

        public VisibilityAnimListener withFinalVisibility(int n) {
            this.mFinalVisibility = n;
            return this;
        }
    }
}

