/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.util.LinkedList;
import java.util.List;

public abstract class ExploreByTouchHelper
extends View.AccessibilityDelegate {
    private static final String DEFAULT_CLASS_NAME = View.class.getName();
    public static final int INVALID_ID = Integer.MIN_VALUE;
    private Context mContext;
    private int mFocusedVirtualViewId;
    private int mHoveredVirtualViewId;
    private final AccessibilityManager mManager;
    private ExploreByTouchNodeProvider mNodeProvider;
    private final int[] mTempGlobalRect;
    private final Rect mTempParentRect;
    private final Rect mTempScreenRect = new Rect();
    private final Rect mTempVisibleRect;
    private final View mView;

    public ExploreByTouchHelper(View view) {
        this.mTempParentRect = new Rect();
        this.mTempVisibleRect = new Rect();
        this.mTempGlobalRect = new int[2];
        this.mFocusedVirtualViewId = Integer.MIN_VALUE;
        this.mHoveredVirtualViewId = Integer.MIN_VALUE;
        if (view == null) {
            throw new IllegalArgumentException("View may not be null");
        }
        this.mView = view;
        this.mContext = view.getContext();
        this.mManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
    }

    private boolean clearAccessibilityFocus(int n) {
        if (this.isAccessibilityFocused(n)) {
            this.mFocusedVirtualViewId = Integer.MIN_VALUE;
            this.mView.invalidate();
            this.sendEventForVirtualView(n, 65536);
            return true;
        }
        return false;
    }

    private AccessibilityEvent createEvent(int n, int n2) {
        switch (n) {
            default: {
                return this.createEventForChild(n, n2);
            }
            case -1: 
        }
        return this.createEventForHost(n2);
    }

    private AccessibilityEvent createEventForChild(int n, int n2) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain(n2);
        accessibilityEvent.setEnabled(true);
        accessibilityEvent.setClassName(DEFAULT_CLASS_NAME);
        this.onPopulateEventForVirtualView(n, accessibilityEvent);
        if (accessibilityEvent.getText().isEmpty() && accessibilityEvent.getContentDescription() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateEventForVirtualViewId()");
        }
        accessibilityEvent.setPackageName(this.mView.getContext().getPackageName());
        accessibilityEvent.setSource(this.mView, n);
        return accessibilityEvent;
    }

    private AccessibilityEvent createEventForHost(int n) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain(n);
        this.onInitializeAccessibilityEvent(this.mView, accessibilityEvent);
        return accessibilityEvent;
    }

    private AccessibilityNodeInfo createNode(int n) {
        switch (n) {
            default: {
                return this.createNodeForChild(n);
            }
            case -1: 
        }
        return this.createNodeForHost();
    }

    /*
     * Enabled aggressive block sorting
     */
    private AccessibilityNodeInfo createNodeForChild(int n) {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain();
        accessibilityNodeInfo.setEnabled(true);
        accessibilityNodeInfo.setClassName(DEFAULT_CLASS_NAME);
        this.onPopulateNodeForVirtualView(n, accessibilityNodeInfo);
        if (accessibilityNodeInfo.getText() == null && accessibilityNodeInfo.getContentDescription() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateNodeForVirtualViewId()");
        }
        accessibilityNodeInfo.getBoundsInParent(this.mTempParentRect);
        if (this.mTempParentRect.isEmpty()) {
            throw new RuntimeException("Callbacks must set parent bounds in populateNodeForVirtualViewId()");
        }
        int n2 = accessibilityNodeInfo.getActions();
        if ((n2 & 0x40) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        if ((n2 & 0x80) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_CLEAR_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        accessibilityNodeInfo.setPackageName(this.mView.getContext().getPackageName());
        accessibilityNodeInfo.setSource(this.mView, n);
        accessibilityNodeInfo.setParent(this.mView);
        if (this.mFocusedVirtualViewId == n) {
            accessibilityNodeInfo.setAccessibilityFocused(true);
            accessibilityNodeInfo.addAction(128);
        } else {
            accessibilityNodeInfo.setAccessibilityFocused(false);
            accessibilityNodeInfo.addAction(64);
        }
        if (this.intersectVisibleToUser(this.mTempParentRect)) {
            accessibilityNodeInfo.setVisibleToUser(true);
            accessibilityNodeInfo.setBoundsInParent(this.mTempParentRect);
        }
        this.mView.getLocationOnScreen(this.mTempGlobalRect);
        int n3 = this.mTempGlobalRect[0];
        int n4 = this.mTempGlobalRect[1];
        this.mTempScreenRect.set(this.mTempParentRect);
        this.mTempScreenRect.offset(n3, n4);
        accessibilityNodeInfo.setBoundsInScreen(this.mTempScreenRect);
        return accessibilityNodeInfo;
    }

    private AccessibilityNodeInfo createNodeForHost() {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain(this.mView);
        this.onInitializeAccessibilityNodeInfo(this.mView, accessibilityNodeInfo);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        this.getVisibleVirtualViews(linkedList);
        for (Integer n : linkedList) {
            accessibilityNodeInfo.addChild(this.mView, n);
        }
        return accessibilityNodeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean intersectVisibleToUser(Rect rect) {
        if (rect == null || rect.isEmpty() || this.mView.getWindowVisibility() != 0) return false;
        ViewParent viewParent = this.mView.getParent();
        while (viewParent instanceof View) {
            View view = (View)((Object)viewParent);
            if (view.getAlpha() <= 0.0f || view.getVisibility() != 0) return false;
            viewParent = view.getParent();
        }
        if (viewParent != null && this.mView.getLocalVisibleRect(this.mTempVisibleRect)) return rect.intersect(this.mTempVisibleRect);
        return false;
    }

    private boolean isAccessibilityFocused(int n) {
        return this.mFocusedVirtualViewId == n;
    }

    private boolean manageFocusForChild(int n, int n2, Bundle bundle) {
        switch (n2) {
            default: {
                return false;
            }
            case 64: {
                return this.requestAccessibilityFocus(n);
            }
            case 128: 
        }
        return this.clearAccessibilityFocus(n);
    }

    private boolean performAction(int n, int n2, Bundle bundle) {
        switch (n) {
            default: {
                return this.performActionForChild(n, n2, bundle);
            }
            case -1: 
        }
        return this.performActionForHost(n2, bundle);
    }

    private boolean performActionForChild(int n, int n2, Bundle bundle) {
        switch (n2) {
            default: {
                return this.onPerformActionForVirtualView(n, n2, bundle);
            }
            case 64: 
            case 128: 
        }
        return this.manageFocusForChild(n, n2, bundle);
    }

    private boolean performActionForHost(int n, Bundle bundle) {
        return this.performAccessibilityAction(this.mView, n, bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean requestAccessibilityFocus(int n) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        if (!this.mManager.isEnabled() || !accessibilityManager.isTouchExplorationEnabled() || this.isAccessibilityFocused(n)) {
            return false;
        }
        this.mFocusedVirtualViewId = n;
        this.mView.invalidate();
        this.sendEventForVirtualView(n, 32768);
        return true;
    }

    private void updateHoveredVirtualView(int n) {
        if (this.mHoveredVirtualViewId == n) {
            return;
        }
        int n2 = this.mHoveredVirtualViewId;
        this.mHoveredVirtualViewId = n;
        this.sendEventForVirtualView(n, 128);
        this.sendEventForVirtualView(n2, 256);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        boolean bl = true;
        if (!this.mManager.isEnabled()) return false;
        if (!this.mManager.isTouchExplorationEnabled()) {
            return false;
        }
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 7: 
            case 9: {
                int n = this.getVirtualViewAt(motionEvent.getX(), motionEvent.getY());
                this.updateHoveredVirtualView(n);
                if (n == Integer.MIN_VALUE) return false;
                return bl;
            }
            case 10: 
        }
        if (this.mFocusedVirtualViewId == Integer.MIN_VALUE) return false;
        this.updateHoveredVirtualView(Integer.MIN_VALUE);
        return bl;
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider(View view) {
        if (this.mNodeProvider == null) {
            this.mNodeProvider = new ExploreByTouchNodeProvider();
        }
        return this.mNodeProvider;
    }

    public int getFocusedVirtualView() {
        return this.mFocusedVirtualViewId;
    }

    protected abstract int getVirtualViewAt(float var1, float var2);

    protected abstract void getVisibleVirtualViews(List<Integer> var1);

    public void invalidateRoot() {
        this.invalidateVirtualView(-1);
    }

    public void invalidateVirtualView(int n) {
        this.sendEventForVirtualView(n, 2048);
    }

    protected abstract boolean onPerformActionForVirtualView(int var1, int var2, Bundle var3);

    protected abstract void onPopulateEventForVirtualView(int var1, AccessibilityEvent var2);

    protected abstract void onPopulateNodeForVirtualView(int var1, AccessibilityNodeInfo var2);

    /*
     * Enabled aggressive block sorting
     */
    public boolean sendEventForVirtualView(int n, int n2) {
        ViewParent viewParent;
        if (n == Integer.MIN_VALUE || !this.mManager.isEnabled() || (viewParent = this.mView.getParent()) == null) {
            return false;
        }
        AccessibilityEvent accessibilityEvent = this.createEvent(n, n2);
        return viewParent.requestSendAccessibilityEvent(this.mView, accessibilityEvent);
    }

    private class ExploreByTouchNodeProvider
    extends AccessibilityNodeProvider {
        private ExploreByTouchNodeProvider() {
        }

        @Override
        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
            return ExploreByTouchHelper.this.createNode(n);
        }

        @Override
        public boolean performAction(int n, int n2, Bundle bundle) {
            return ExploreByTouchHelper.this.performAction(n, n2, bundle);
        }
    }
}

