/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;

public class SwipeDismissLayout
extends FrameLayout {
    private static final float DISMISS_MIN_DRAG_WIDTH_RATIO = 0.33f;
    private static final String TAG = "SwipeDismissLayout";
    private int mActiveTouchId;
    private long mAnimationTime;
    private TimeInterpolator mCancelInterpolator;
    private boolean mDiscardIntercept;
    private TimeInterpolator mDismissInterpolator;
    private boolean mDismissed;
    private OnDismissedListener mDismissedListener;
    private float mDownX;
    private float mDownY;
    private float mLastX;
    private int mMaxFlingVelocity;
    private int mMinFlingVelocity;
    private OnSwipeProgressChangedListener mProgressListener;
    private int mSlop;
    private boolean mSwiping;
    private float mTranslationX;
    private VelocityTracker mVelocityTracker;

    public SwipeDismissLayout(Context context) {
        super(context);
        this.init(context);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void dismiss() {
        if (this.mDismissedListener != null) {
            this.mDismissedListener.onDismissed(this);
        }
    }

    private void init(Context context) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.getContext());
        this.mSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mAnimationTime = this.getContext().getResources().getInteger(0x10E0000);
        this.mCancelInterpolator = new DecelerateInterpolator(1.5f);
        this.mDismissInterpolator = new AccelerateInterpolator(1.5f);
    }

    private void resetMembers() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mTranslationX = 0.0f;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDismissed = false;
        this.mDiscardIntercept = false;
    }

    private void setProgress(float f) {
        this.mTranslationX = f;
        if (this.mProgressListener != null && f >= 0.0f) {
            this.mProgressListener.onSwipeProgressChanged(this, f / (float)this.getWidth(), f);
        }
    }

    private void updateDismiss(MotionEvent motionEvent) {
        float f = motionEvent.getRawX() - this.mDownX;
        if (!this.mDismissed) {
            this.mVelocityTracker.addMovement(motionEvent);
            this.mVelocityTracker.computeCurrentVelocity(1000);
            if (f > 0.33f * (float)this.getWidth() && motionEvent.getRawX() >= this.mLastX) {
                this.mDismissed = true;
            }
        }
        if (this.mDismissed && this.mSwiping && f < 0.33f * (float)this.getWidth()) {
            this.mDismissed = false;
        }
    }

    private void updateSwiping(MotionEvent motionEvent) {
        block6: {
            block5: {
                float f;
                if (this.mSwiping) break block5;
                float f2 = motionEvent.getRawX() - this.mDownX;
                if (!(f2 * f2 + (f = motionEvent.getRawY() - this.mDownY) * f > (float)(this.mSlop * this.mSlop))) break block6;
                float f3 = f2 - (float)(2 * this.mSlop);
                float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
                boolean bl = false;
                if (f4 > 0) {
                    float f5 = Math.abs(f) - (float)(2 * this.mSlop);
                    float f6 = f5 == 0.0f ? 0 : (f5 < 0.0f ? -1 : 1);
                    bl = false;
                    if (f6 < 0) {
                        bl = true;
                    }
                }
                this.mSwiping = bl;
            }
            return;
        }
        this.mSwiping = false;
    }

    protected boolean canScroll(View view, boolean bl, float f, float f2, float f3) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = view.getScrollX();
            int n2 = view.getScrollY();
            for (int i = -1 + viewGroup.getChildCount(); i >= 0; --i) {
                View view2 = viewGroup.getChildAt(i);
                if (!(f2 + (float)n >= (float)view2.getLeft()) || !(f2 + (float)n < (float)view2.getRight()) || !(f3 + (float)n2 >= (float)view2.getTop()) || !(f3 + (float)n2 < (float)view2.getBottom()) || !this.canScroll(view2, true, f, f2 + (float)n - (float)view2.getLeft(), f3 + (float)n2 - (float)view2.getTop())) continue;
                return true;
            }
        }
        return bl && view.canScrollHorizontally((int)(-f));
    }

    protected void cancel() {
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeCancelled(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        motionEvent.offsetLocation(this.mTranslationX, 0.0f);
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = motionEvent.getRawX();
                this.mDownY = motionEvent.getRawY();
                this.mActiveTouchId = motionEvent.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(motionEvent);
                break;
            }
            case 5: {
                this.mActiveTouchId = motionEvent.getPointerId(motionEvent.getActionIndex());
                break;
            }
            case 6: {
                int n = motionEvent.getActionIndex();
                if (motionEvent.getPointerId(n) != this.mActiveTouchId) break;
                int n2 = n == 0 ? 1 : 0;
                this.mActiveTouchId = motionEvent.getPointerId(n2);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mDiscardIntercept) break;
                int n = motionEvent.findPointerIndex(this.mActiveTouchId);
                if (n == -1) {
                    Log.e(TAG, "Invalid pointer index: ignoring.");
                    this.mDiscardIntercept = true;
                    break;
                }
                float f = motionEvent.getRawX() - this.mDownX;
                float f2 = motionEvent.getX(n);
                float f3 = motionEvent.getY(n);
                if (f != 0.0f && this.canScroll(this, false, f, f2, f3)) {
                    this.mDiscardIntercept = true;
                    break;
                }
                this.updateSwiping(motionEvent);
            }
        }
        return !this.mDiscardIntercept && this.mSwiping;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mVelocityTracker == null) {
            return super.onTouchEvent(motionEvent);
        }
        switch (motionEvent.getActionMasked()) {
            case 1: {
                this.updateDismiss(motionEvent);
                if (this.mDismissed) {
                    this.dismiss();
                } else if (this.mSwiping) {
                    this.cancel();
                }
                this.resetMembers();
                return true;
            }
            case 3: {
                this.cancel();
                this.resetMembers();
                return true;
            }
            case 2: {
                this.mVelocityTracker.addMovement(motionEvent);
                this.mLastX = motionEvent.getRawX();
                this.updateSwiping(motionEvent);
                if (!this.mSwiping) return true;
                this.setProgress(motionEvent.getRawX() - this.mDownX);
                return true;
            }
        }
        return true;
    }

    public void setOnDismissedListener(OnDismissedListener onDismissedListener) {
        this.mDismissedListener = onDismissedListener;
    }

    public void setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener onSwipeProgressChangedListener) {
        this.mProgressListener = onSwipeProgressChangedListener;
    }

    public static interface OnDismissedListener {
        public void onDismissed(SwipeDismissLayout var1);
    }

    public static interface OnSwipeProgressChangedListener {
        public void onSwipeCancelled(SwipeDismissLayout var1);

        public void onSwipeProgressChanged(SwipeDismissLayout var1, float var2, float var3);
    }
}

