/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.LinearLayout;
import com.android.internal.R;

public class WeightedLinearLayout
extends LinearLayout {
    private float mMajorWeightMax;
    private float mMajorWeightMin;
    private float mMinorWeightMax;
    private float mMinorWeightMin;

    public WeightedLinearLayout(Context context) {
        super(context);
    }

    public WeightedLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WeightedLinearLayout);
        this.mMajorWeightMin = typedArray.getFloat(0, 0.0f);
        this.mMinorWeightMin = typedArray.getFloat(1, 0.0f);
        this.mMajorWeightMax = typedArray.getFloat(2, 0.0f);
        this.mMinorWeightMax = typedArray.getFloat(3, 0.0f);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        int n3 = displayMetrics.widthPixels;
        boolean bl = n3 < displayMetrics.heightPixels;
        int n4 = View.MeasureSpec.getMode(n);
        super.onMeasure(n, n2);
        int n5 = this.getMeasuredWidth();
        int n6 = View.MeasureSpec.makeMeasureSpec(n5, 0x40000000);
        float f = bl ? this.mMinorWeightMin : this.mMajorWeightMin;
        float f2 = bl ? this.mMinorWeightMax : this.mMajorWeightMax;
        boolean bl2 = false;
        if (n4 == Integer.MIN_VALUE) {
            int n7 = (int)(f * (float)n3);
            int n8 = (int)(f * (float)n3);
            if (f > 0.0f && n5 < n7) {
                n6 = View.MeasureSpec.makeMeasureSpec(n7, 0x40000000);
                bl2 = true;
            } else {
                float f3 = f2 - 0.0f;
                float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
                bl2 = false;
                if (f4 > 0) {
                    bl2 = false;
                    if (n5 > n8) {
                        n6 = View.MeasureSpec.makeMeasureSpec(n8, 0x40000000);
                        bl2 = true;
                    }
                }
            }
        }
        if (bl2) {
            super.onMeasure(n6, n2);
        }
    }
}

