/*
 * Decompiled with CFR 0.152.
 */
package com.asus.analytics;

import android.content.Context;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteDatabase;
import android.os.SystemProperties;
import android.util.Log;
import java.util.HashMap;

public class AnalyticsDatabaseUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = "AnalyticsDatabaseUtils";
    public static final String VERSION_2_0BETA5 = "2.0beta5";
    private static HashMap<String, VersionValue> sVersionMap;

    /*
     * Enabled aggressive block sorting
     */
    static {
        int n = 1;
        if (SystemProperties.getInt("ro.debuggable", 0) != n) {
            n = 0;
        }
        DEBUG = n;
        sVersionMap = new HashMap();
        AnalyticsDatabaseUtils.addVersionValue(VERSION_2_0BETA5, "google_analytics_v2.db", "hits2");
    }

    private static void addVersionValue(String string2, String string3, String string4) {
        VersionValue versionValue = new VersionValue(string3, string4);
        sVersionMap.put(string2, versionValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void clearDatabase(Context context, String string2) {
        VersionValue versionValue;
        SQLiteDatabase sQLiteDatabase = AnalyticsDatabaseUtils.getDatabase(context, string2, true);
        if (sQLiteDatabase == null || (versionValue = sVersionMap.get(string2)) == null) {
            return;
        }
        sQLiteDatabase.delete(versionValue.table, null, null);
        if (DEBUG) {
            Log.d(TAG, "db version = " + sQLiteDatabase.getVersion() + " clean table");
        }
        sQLiteDatabase.close();
    }

    public static SQLiteDatabase getDatabase(Context context, String string2) {
        return AnalyticsDatabaseUtils.getDatabase(context, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SQLiteDatabase getDatabase(Context context, String string2, boolean bl) {
        VersionValue versionValue = sVersionMap.get(string2);
        if (versionValue == null) {
            Log.e(TAG, "No version match");
            return null;
        }
        String string3 = context.getDatabasePath(versionValue.database).getPath();
        int n = bl ? 0 : 1;
        try {
            return SQLiteDatabase.openDatabase(string3, null, n, null);
        }
        catch (SQLiteCantOpenDatabaseException sQLiteCantOpenDatabaseException) {
            Log.e(TAG, "Couldn't open " + string3);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getRecordNumbers(Context context, String string2) {
        SQLiteDatabase sQLiteDatabase = AnalyticsDatabaseUtils.getDatabase(context, string2);
        if (sQLiteDatabase == null) {
            return 0L;
        }
        VersionValue versionValue = sVersionMap.get(string2);
        long l = 0L;
        if (versionValue == null) return l;
        long l2 = DatabaseUtils.queryNumEntries(sQLiteDatabase, versionValue.table);
        if (DEBUG) {
            Log.d(TAG, "db version = " + sQLiteDatabase.getVersion() + " numRows = " + l2);
        }
        sQLiteDatabase.close();
        return l2;
    }

    static final class VersionValue {
        final String database;
        final String table;

        VersionValue(String string2, String string3) {
            this.database = string2;
            this.table = string3;
        }
    }
}

