/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.ChooseAccountTypeActivity;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChooseTypeAndAccountActivity
extends Activity
implements AccountManagerCallback<Bundle> {
    public static final String EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING = "authTokenType";
    public static final String EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE = "addAccountOptions";
    public static final String EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY = "addAccountRequiredFeatures";
    public static final String EXTRA_ALLOWABLE_ACCOUNTS_ARRAYLIST = "allowableAccounts";
    public static final String EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY = "allowableAccountTypes";
    public static final String EXTRA_ALWAYS_PROMPT_FOR_ACCOUNT = "alwaysPromptForAccount";
    public static final String EXTRA_DESCRIPTION_TEXT_OVERRIDE = "descriptionTextOverride";
    public static final String EXTRA_SELECTED_ACCOUNT = "selectedAccount";
    private static final String KEY_INSTANCE_STATE_ACCOUNT_LIST = "accountList";
    private static final String KEY_INSTANCE_STATE_EXISTING_ACCOUNTS = "existingAccounts";
    private static final String KEY_INSTANCE_STATE_PENDING_REQUEST = "pendingRequest";
    private static final String KEY_INSTANCE_STATE_SELECTED_ACCOUNT_NAME = "selectedAccountName";
    private static final String KEY_INSTANCE_STATE_SELECTED_ADD_ACCOUNT = "selectedAddAccount";
    public static final int REQUEST_ADD_ACCOUNT = 2;
    public static final int REQUEST_CHOOSE_TYPE = 1;
    public static final int REQUEST_NULL = 0;
    private static final int SELECTED_ITEM_NONE = -1;
    private static final String TAG = "AccountChooser";
    private ArrayList<Account> mAccounts;
    private boolean mAlwaysPromptForAccount = false;
    private String mCallingPackage;
    private int mCallingUid;
    private String mDescriptionOverride;
    private boolean mDisallowAddAccounts;
    private boolean mDontShowPicker;
    private Parcelable[] mExistingAccounts = null;
    private Button mOkButton;
    private int mPendingRequest = 0;
    private String mSelectedAccountName = null;
    private boolean mSelectedAddNewAccount = false;
    private int mSelectedItemIndex;
    private Set<Account> mSetOfAllowableAccounts;
    private Set<String> mSetOfRelevantAccountTypes;

    static /* synthetic */ int access$002(ChooseTypeAndAccountActivity chooseTypeAndAccountActivity, int n) {
        chooseTypeAndAccountActivity.mSelectedItemIndex = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayList<Account> getAcceptableAccountChoices(AccountManager accountManager) {
        Account[] accountArray = accountManager.getAccountsForPackage(this.mCallingPackage, this.mCallingUid);
        ArrayList<Account> arrayList = new ArrayList<Account>(accountArray.length);
        int n = accountArray.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if ((this.mSetOfAllowableAccounts == null || this.mSetOfAllowableAccounts.contains(account)) && (this.mSetOfRelevantAccountTypes == null || this.mSetOfRelevantAccountTypes.contains(account.type))) {
                arrayList.add(account);
            }
            ++n2;
        }
        return arrayList;
    }

    private Set<Account> getAllowableAccountSet(Intent intent) {
        ArrayList arrayList = intent.getParcelableArrayListExtra(EXTRA_ALLOWABLE_ACCOUNTS_ARRAYLIST);
        HashSet<Account> hashSet = null;
        if (arrayList != null) {
            hashSet = new HashSet<Account>(arrayList.size());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                hashSet.add((Account)((Parcelable)iterator.next()));
            }
        }
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getItemIndexToSelect(ArrayList<Account> arrayList, String string2, boolean bl) {
        if (bl) {
            return arrayList.size();
        }
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get((int)n).name.equals(string2)) return n;
            ++n;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] getListOfDisplayableOptions(ArrayList<Account> arrayList) {
        int n = arrayList.size();
        int n2 = this.mDisallowAddAccounts ? 0 : 1;
        String[] stringArray = new String[n2 + n];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = arrayList.get((int)i).name;
        }
        if (!this.mDisallowAddAccounts) {
            stringArray[arrayList.size()] = this.getResources().getString(17040749);
        }
        return stringArray;
    }

    private Set<String> getReleventAccountTypes(Intent intent) {
        String[] stringArray = intent.getStringArrayExtra(EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY);
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = Sets.newHashSet(stringArray);
            AuthenticatorDescription[] authenticatorDescriptionArray = AccountManager.get(this).getAuthenticatorTypes();
            HashSet<String> hashSet2 = new HashSet<String>(authenticatorDescriptionArray.length);
            int n = authenticatorDescriptionArray.length;
            for (int i = 0; i < n; ++i) {
                hashSet2.add(authenticatorDescriptionArray[i].type);
            }
            hashSet.retainAll(hashSet2);
        }
        return hashSet;
    }

    private void onAccountSelected(Account account) {
        Log.d(TAG, "selected account " + account);
        this.setResultAndFinish(account.name, account.type);
    }

    private void overrideDescriptionIfSupplied(String string2) {
        TextView textView = (TextView)this.findViewById(16909030);
        if (!TextUtils.isEmpty(string2)) {
            textView.setText(string2);
            return;
        }
        textView.setVisibility(8);
    }

    private final void populateUIAccountList(String[] stringArray) {
        ListView listView = (ListView)this.findViewById(16908298);
        listView.setAdapter(new ArrayAdapter<String>((Context)this, 17367055, stringArray));
        listView.setChoiceMode(1);
        listView.setItemsCanFocus(false);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                ChooseTypeAndAccountActivity.access$002(ChooseTypeAndAccountActivity.this, n);
                ChooseTypeAndAccountActivity.this.mOkButton.setEnabled(true);
            }
        });
        if (this.mSelectedItemIndex != -1) {
            listView.setItemChecked(this.mSelectedItemIndex, true);
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "List item " + this.mSelectedItemIndex + " should be selected");
            }
        }
    }

    private void setResultAndFinish(String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", string2);
        bundle.putString("accountType", string3);
        this.setResult(-1, new Intent().putExtras(bundle));
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseTypeAndAccountActivity.setResultAndFinish: selected account " + string2 + ", " + string3);
        }
        this.finish();
    }

    private void startChooseAccountTypeActivity() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseAccountTypeActivity.startChooseAccountTypeActivity()");
        }
        Intent intent = new Intent(this, ChooseAccountTypeActivity.class);
        intent.setFlags(524288);
        intent.putExtra(EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY, this.getIntent().getStringArrayExtra(EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY));
        intent.putExtra(EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE, this.getIntent().getBundleExtra(EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE));
        intent.putExtra(EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY, this.getIntent().getStringArrayExtra(EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY));
        intent.putExtra(EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING, this.getIntent().getStringExtra(EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING));
        this.startActivityForResult(intent, 1);
        this.mPendingRequest = 1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void onActivityResult(int var1_1, int var2_2, Intent var3_3) {
        block20: {
            if (!Log.isLoggable("AccountChooser", 2)) ** GOTO lbl10
            if (var3_3 != null && var3_3.getExtras() != null) {
                var3_3.getExtras().keySet();
            }
            if (var3_3 != null) {
                var19_4 = var3_3.getExtras();
lbl7:
                // 2 sources

                while (true) {
                    Log.v("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult(reqCode=" + var1_1 + ", resCode=" + var2_2 + ", extras=" + var19_4 + ")");
lbl10:
                    // 2 sources

                    this.mPendingRequest = 0;
                    if (var2_2 == 0) {
                        if (this.mAccounts.isEmpty()) {
                            this.setResult(0);
                            this.finish();
                        }
                        return;
                    }
                    break;
                }
            } else {
                var19_4 = null;
                ** continue;
            }
            if (var2_2 != -1) ** GOTO lbl29
            if (var1_1 != 1) break block20;
            if (var3_3 != null && (var18_5 = var3_3.getStringExtra("accountType")) != null) {
                this.runAddAccountForAuthenticator(var18_5);
                return;
            }
            Log.d("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult: unable to find account type, pretending the request was canceled");
lbl26:
            // 3 sources

            while (true) {
                Log.d("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult: unable to find added account, pretending the request was canceled");
lbl29:
                // 2 sources

                if (Log.isLoggable("AccountChooser", 2)) {
                    Log.v("AccountChooser", "ChooseTypeAndAccountActivity.onActivityResult: canceled");
                }
                this.setResult(0);
                this.finish();
                return;
            }
        }
        if (var1_1 != 2) ** GOTO lbl26
        var5_6 = null;
        var6_7 = null;
        if (var3_3 != null) {
            var5_6 = var3_3.getStringExtra("authAccount");
            var6_7 = var3_3.getStringExtra("accountType");
        }
        if (var5_6 != null && var6_7 != null) ** GOTO lbl59
        var7_8 = AccountManager.get(this).getAccountsForPackage(this.mCallingPackage, this.mCallingUid);
        var8_9 = new HashSet<Account>();
        var9_10 = this.mExistingAccounts;
        var10_11 = var9_10.length;
        for (var11_12 = 0; var11_12 < var10_11; ++var11_12) {
            var8_9.add((Account)var9_10[var11_12]);
        }
        var12_13 = var7_8.length;
        var13_14 = 0;
        while (true) {
            block22: {
                block21: {
                    if (var13_14 >= var12_13) break block21;
                    var15_15 = var7_8[var13_14];
                    if (var8_9.contains(var15_15)) break block22;
                    var5_6 = var15_15.name;
                    var6_7 = var15_15.type;
                }
                if (var5_6 != null || var6_7 != null) ** break;
                ** continue;
                this.setResultAndFinish(var5_6, var6_7);
                return;
            }
            ++var13_14;
        }
    }

    public void onCancelButtonClicked(View view) {
        this.onBackPressed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseTypeAndAccountActivity.onCreate(savedInstanceState=" + bundle + ")");
        }
        try {
            IBinder iBinder = this.getActivityToken();
            this.mCallingUid = ActivityManagerNative.getDefault().getLaunchedFromUid(iBinder);
            this.mCallingPackage = ActivityManagerNative.getDefault().getLaunchedFromPackage(iBinder);
            if (this.mCallingUid != 0 && this.mCallingPackage != null) {
                this.mDisallowAddAccounts = UserManager.get(this).getUserRestrictions(new UserHandle(UserHandle.getUserId(this.mCallingUid))).getBoolean("no_modify_accounts", false);
            }
        }
        catch (RemoteException remoteException) {
            Log.w(this.getClass().getSimpleName(), "Unable to get caller identity \n" + remoteException);
        }
        Intent intent = this.getIntent();
        if (bundle != null) {
            this.mPendingRequest = bundle.getInt(KEY_INSTANCE_STATE_PENDING_REQUEST);
            this.mExistingAccounts = bundle.getParcelableArray(KEY_INSTANCE_STATE_EXISTING_ACCOUNTS);
            this.mSelectedAccountName = bundle.getString(KEY_INSTANCE_STATE_SELECTED_ACCOUNT_NAME);
            this.mSelectedAddNewAccount = bundle.getBoolean(KEY_INSTANCE_STATE_SELECTED_ADD_ACCOUNT, false);
            this.mAccounts = bundle.getParcelableArrayList(KEY_INSTANCE_STATE_ACCOUNT_LIST);
        } else {
            this.mPendingRequest = 0;
            this.mExistingAccounts = null;
            Account account = (Account)intent.getParcelableExtra(EXTRA_SELECTED_ACCOUNT);
            if (account != null) {
                this.mSelectedAccountName = account.name;
            }
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "selected account name is " + this.mSelectedAccountName);
        }
        this.mSetOfAllowableAccounts = this.getAllowableAccountSet(intent);
        this.mSetOfRelevantAccountTypes = this.getReleventAccountTypes(intent);
        this.mAlwaysPromptForAccount = intent.getBooleanExtra(EXTRA_ALWAYS_PROMPT_FOR_ACCOUNT, false);
        this.mDescriptionOverride = intent.getStringExtra(EXTRA_DESCRIPTION_TEXT_OVERRIDE);
        this.mAccounts = this.getAcceptableAccountChoices(AccountManager.get(this));
        if (this.mAccounts.isEmpty() && this.mDisallowAddAccounts) {
            this.requestWindowFeature(1);
            this.setContentView(17367089);
            this.mDontShowPicker = true;
        }
    }

    @Override
    protected void onDestroy() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseTypeAndAccountActivity.onDestroy()");
        }
        super.onDestroy();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onOkButtonClicked(View view) {
        if (this.mSelectedItemIndex == this.mAccounts.size()) {
            this.startChooseAccountTypeActivity();
            return;
        } else {
            if (this.mSelectedItemIndex == -1) return;
            this.onAccountSelected(this.mAccounts.get(this.mSelectedItemIndex));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onResume() {
        super.onResume();
        if (this.mDontShowPicker) {
            return;
        }
        this.mAccounts = this.getAcceptableAccountChoices(AccountManager.get(this));
        if (this.mPendingRequest == 0) {
            if (this.mAccounts.isEmpty()) {
                if (this.mSetOfRelevantAccountTypes.size() == 1) {
                    this.runAddAccountForAuthenticator(this.mSetOfRelevantAccountTypes.iterator().next());
                    return;
                }
                this.startChooseAccountTypeActivity();
                return;
            }
            if (!this.mAlwaysPromptForAccount && this.mAccounts.size() == 1) {
                Account account = this.mAccounts.get(0);
                this.setResultAndFinish(account.name, account.type);
                return;
            }
        }
        String[] stringArray = this.getListOfDisplayableOptions(this.mAccounts);
        this.mSelectedItemIndex = this.getItemIndexToSelect(this.mAccounts, this.mSelectedAccountName, this.mSelectedAddNewAccount);
        this.setContentView(17367130);
        this.overrideDescriptionIfSupplied(this.mDescriptionOverride);
        this.populateUIAccountList(stringArray);
        Button button = this.mOkButton = (Button)this.findViewById(16908314);
        boolean bl = this.mSelectedItemIndex != -1;
        button.setEnabled(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(KEY_INSTANCE_STATE_PENDING_REQUEST, this.mPendingRequest);
        if (this.mPendingRequest == 2) {
            bundle.putParcelableArray(KEY_INSTANCE_STATE_EXISTING_ACCOUNTS, this.mExistingAccounts);
        }
        if (this.mSelectedItemIndex != -1) {
            if (this.mSelectedItemIndex == this.mAccounts.size()) {
                bundle.putBoolean(KEY_INSTANCE_STATE_SELECTED_ADD_ACCOUNT, true);
            } else {
                bundle.putBoolean(KEY_INSTANCE_STATE_SELECTED_ADD_ACCOUNT, false);
                bundle.putString(KEY_INSTANCE_STATE_SELECTED_ACCOUNT_NAME, this.mAccounts.get((int)this.mSelectedItemIndex).name);
            }
        }
        bundle.putParcelableArrayList(KEY_INSTANCE_STATE_ACCOUNT_LIST, this.mAccounts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
        try {
            Intent intent = (Intent)accountManagerFuture.getResult().getParcelable("intent");
            if (intent != null) {
                this.mPendingRequest = 2;
                this.mExistingAccounts = AccountManager.get(this).getAccountsForPackage(this.mCallingPackage, this.mCallingUid);
                intent.setFlags(0xEFFFFFFF & intent.getFlags());
                this.startActivityForResult(intent, 2);
                return;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            this.setResult(0);
            this.finish();
            return;
        }
        catch (AuthenticatorException authenticatorException) {
            // empty catch block
        }
        catch (IOException iOException) {}
        Bundle bundle = new Bundle();
        bundle.putString("errorMessage", "error communicating with server");
        this.setResult(-1, new Intent().putExtras(bundle));
        this.finish();
    }

    protected void runAddAccountForAuthenticator(String string2) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "runAddAccountForAuthenticator: " + string2);
        }
        Bundle bundle = this.getIntent().getBundleExtra(EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE);
        String[] stringArray = this.getIntent().getStringArrayExtra(EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY);
        String string3 = this.getIntent().getStringExtra(EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING);
        AccountManager.get(this).addAccount(string2, string3, stringArray, bundle, null, this, null);
    }
}

