/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.PackageInstallObserver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ContainerEncryptionParams;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.KeySet;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.content.pm.VerificationParams;
import android.content.pm.VerifierDeviceIdentity;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.internal.util.UserIcons;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

final class ApplicationPackageManager
extends PackageManager {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_ICONS = false;
    private static final String TAG = "ApplicationPackageManager";
    private static final int sDefaultFlags = 1024;
    private static ArrayMap<ResourceName, WeakReference<Drawable.ConstantState>> sIconCache;
    private static ArrayMap<ResourceName, WeakReference<CharSequence>> sStringCache;
    private static final Object sSync;
    int mCachedSafeMode = -1;
    private final ContextImpl mContext;
    @GuardedBy(value="mLock")
    private PackageInstaller mInstaller;
    private final Object mLock = new Object();
    private final IPackageManager mPM;
    @GuardedBy(value="mLock")
    private UserManager mUserManager;

    static {
        sSync = new Object();
        sIconCache = new ArrayMap();
        sStringCache = new ArrayMap();
    }

    ApplicationPackageManager(ContextImpl contextImpl, IPackageManager iPackageManager) {
        this.mContext = contextImpl;
        this.mPM = iPackageManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void configurationChanged() {
        Object object = sSync;
        synchronized (object) {
            sIconCache.clear();
            sStringCache.clear();
            return;
        }
    }

    private int getBadgeResIdForUser(int n) {
        UserInfo userInfo = this.getUserIfProfile(n);
        if (userInfo != null && userInfo.isManagedProfile()) {
            return 17302583;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getBadgedDrawable(Drawable drawable2, Drawable drawable3, Rect rect, boolean bl) {
        int n = drawable2.getIntrinsicWidth();
        int n2 = drawable2.getIntrinsicHeight();
        boolean bl2 = bl && drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap().isMutable();
        Bitmap bitmap = bl2 ? ((BitmapDrawable)drawable2).getBitmap() : Bitmap.createBitmap(n, n2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        if (!bl2) {
            drawable2.setBounds(0, 0, n, n2);
            drawable2.draw(canvas);
        }
        if (rect != null) {
            if (rect.left < 0 || rect.top < 0 || rect.width() > n || rect.height() > n2) {
                throw new IllegalArgumentException("Badge location " + rect + " not in badged drawable bounds " + new Rect(0, 0, n, n2));
            }
            drawable3.setBounds(0, 0, rect.width(), rect.height());
            canvas.save();
            canvas.translate(rect.left, rect.top);
            drawable3.draw(canvas);
            canvas.restore();
        } else {
            drawable3.setBounds(0, 0, n, n2);
            drawable3.draw(canvas);
        }
        if (bl2) {
            return drawable2;
        }
        BitmapDrawable bitmapDrawable = new BitmapDrawable(this.mContext.getResources(), bitmap);
        if (drawable2 instanceof BitmapDrawable) {
            bitmapDrawable.setTargetDensity(((BitmapDrawable)drawable2).getBitmap().getDensity());
        }
        return bitmapDrawable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getCachedIcon(ResourceName resourceName) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<Drawable.ConstantState> weakReference = sIconCache.get(resourceName);
            if (weakReference == null) return null;
            Drawable.ConstantState constantState = (Drawable.ConstantState)weakReference.get();
            if (constantState != null) {
                return constantState.newDrawable();
            }
            sIconCache.remove(resourceName);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CharSequence getCachedString(ResourceName resourceName) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<CharSequence> weakReference = sStringCache.get(resourceName);
            if (weakReference != null) {
                CharSequence charSequence = (CharSequence)weakReference.get();
                if (charSequence != null) {
                    return charSequence;
                }
                sStringCache.remove(resourceName);
            }
            return null;
        }
    }

    private UserInfo getUserIfProfile(int n) {
        for (UserInfo userInfo : this.getUserManager().getProfiles(UserHandle.myUserId())) {
            if (userInfo.id != n) continue;
            return userInfo;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void handlePackageBroadcast(int n, String[] stringArray, boolean bl) {
        boolean bl2 = false;
        if (n == 1) {
            bl2 = true;
        }
        if (stringArray == null || stringArray.length <= 0) return;
        boolean bl3 = false;
        int n2 = stringArray.length;
        int n3 = 0;
        block3: while (true) {
            String string2;
            if (n3 < n2) {
                string2 = stringArray[n3];
                Object object = sSync;
                synchronized (object) {
                }
            } else {
                if (!bl3 && !bl) return;
                if (!bl2) {
                    ActivityThread.currentActivityThread().scheduleGcIdler();
                    return;
                }
                Runtime.getRuntime().gc();
                return;
            }
            {
                int n4 = -1 + sIconCache.size();
                while (true) {
                    if (n4 < 0) break;
                    if (ApplicationPackageManager.sIconCache.keyAt((int)n4).packageName.equals(string2)) {
                        sIconCache.removeAt(n4);
                        bl3 = true;
                    }
                    --n4;
                }
                int n5 = -1 + sStringCache.size();
                while (true) {
                    if (n5 >= 0) {
                        if (ApplicationPackageManager.sStringCache.keyAt((int)n5).packageName.equals(string2)) {
                            sStringCache.removeAt(n5);
                            bl3 = true;
                        }
                    } else {
                        // MONITOREXIT @DISABLED, blocks:[2, 3, 5, 11] lbl38 : MonitorExitStatement: MONITOREXIT : var8_8
                        ++n3;
                        continue block3;
                    }
                    --n5;
                }
            }
            break;
        }
    }

    private void installCommon(Uri uri, PackageInstallObserver packageInstallObserver, int n, String string2, VerificationParams verificationParams, ContainerEncryptionParams containerEncryptionParams) {
        if (!"file".equals(uri.getScheme())) {
            throw new UnsupportedOperationException("Only file:// URIs are supported");
        }
        if (containerEncryptionParams != null) {
            throw new UnsupportedOperationException("ContainerEncryptionParams not supported");
        }
        String string3 = uri.getPath();
        try {
            this.mPM.installPackage(string3, packageInstallObserver.getBinder(), n, string2, verificationParams, null);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private static void maybeAdjustApplicationInfo(ApplicationInfo applicationInfo) {
        if (applicationInfo.primaryCpuAbi != null && applicationInfo.secondaryCpuAbi != null && VMRuntime.getRuntime().vmInstructionSet().equals(VMRuntime.getInstructionSet((String)applicationInfo.secondaryCpuAbi))) {
            applicationInfo.nativeLibraryDir = applicationInfo.secondaryNativeLibraryDir;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void putCachedIcon(ResourceName resourceName, Drawable drawable2) {
        Object object = sSync;
        synchronized (object) {
            sIconCache.put(resourceName, new WeakReference<Drawable.ConstantState>(drawable2.getConstantState()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void putCachedString(ResourceName resourceName, CharSequence charSequence) {
        Object object = sSync;
        synchronized (object) {
            sStringCache.put(resourceName, new WeakReference<CharSequence>(charSequence));
            return;
        }
    }

    @Override
    public void addCrossProfileIntentFilter(IntentFilter intentFilter, int n, int n2, int n3) {
        try {
            this.mPM.addCrossProfileIntentFilter(intentFilter, this.mContext.getOpPackageName(), this.mContext.getUserId(), n, n2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void addPackageToPreferred(String string2) {
        try {
            this.mPM.addPackageToPreferred(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public boolean addPermission(PermissionInfo permissionInfo) {
        try {
            boolean bl = this.mPM.addPermission(permissionInfo);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public boolean addPermissionAsync(PermissionInfo permissionInfo) {
        try {
            boolean bl = this.mPM.addPermissionAsync(permissionInfo);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public void addPreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
        try {
            this.mPM.addPreferredActivity(intentFilter, n, componentNameArray, componentName, this.mContext.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void addPreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName, int n2) {
        try {
            this.mPM.addPreferredActivity(intentFilter, n, componentNameArray, componentName, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public String[] canonicalToCurrentPackageNames(String[] stringArray) {
        try {
            String[] stringArray2 = this.mPM.canonicalToCurrentPackageNames(stringArray);
            return stringArray2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public int checkPermission(String string2, String string3) {
        try {
            int n = this.mPM.checkPermission(string2, string3);
            return n;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public int checkSignatures(int n, int n2) {
        try {
            int n3 = this.mPM.checkUidSignatures(n, n2);
            return n3;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public int checkSignatures(String string2, String string3) {
        try {
            int n = this.mPM.checkSignatures(string2, string3);
            return n;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public void clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
        try {
            this.mPM.clearApplicationUserData(string2, iPackageDataObserver, this.mContext.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void clearCrossProfileIntentFilters(int n) {
        try {
            this.mPM.clearCrossProfileIntentFilters(n, this.mContext.getOpPackageName(), this.mContext.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void clearPackagePreferredActivities(String string2) {
        try {
            this.mPM.clearPackagePreferredActivities(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public String[] currentToCanonicalPackageNames(String[] stringArray) {
        try {
            String[] stringArray2 = this.mPM.currentToCanonicalPackageNames(stringArray);
            return stringArray2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public void deleteApplicationCacheFiles(String string2, IPackageDataObserver iPackageDataObserver) {
        try {
            this.mPM.deleteApplicationCacheFiles(string2, iPackageDataObserver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void deleteBundledSystemPackages(String[] stringArray) {
        try {
            this.mPM.deleteBundledSystemPackages(stringArray);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void deletePackage(String string2, IPackageDeleteObserver iPackageDeleteObserver, int n) {
        try {
            this.mPM.deletePackageAsUser(string2, iPackageDeleteObserver, UserHandle.myUserId(), n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void extendVerificationTimeout(int n, int n2, long l) {
        try {
            this.mPM.extendVerificationTimeout(n, n2, l);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void freeStorage(long l, IntentSender intentSender) {
        try {
            this.mPM.freeStorage(l, intentSender);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void freeStorageAndNotify(long l, IPackageDataObserver iPackageDataObserver) {
        try {
            this.mPM.freeStorageAndNotify(l, iPackageDataObserver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public Drawable getActivityBanner(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(componentName, 1024).loadBanner(this);
    }

    @Override
    public Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityBanner(intent.getComponent());
        }
        ResolveInfo resolveInfo = this.resolveActivity(intent, 65536);
        if (resolveInfo != null) {
            return resolveInfo.activityInfo.loadBanner(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public Drawable getActivityIcon(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(componentName, 1024).loadIcon(this);
    }

    @Override
    public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityIcon(intent.getComponent());
        }
        ResolveInfo resolveInfo = this.resolveActivity(intent, 65536);
        if (resolveInfo != null) {
            return resolveInfo.activityInfo.loadIcon(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public ActivityInfo getActivityInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        try {
            ActivityInfo activityInfo = this.mPM.getActivityInfo(componentName, n, this.mContext.getUserId());
            if (activityInfo != null) {
                return activityInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(componentName.toString());
    }

    @Override
    public Drawable getActivityLogo(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(componentName, 1024).loadLogo(this);
    }

    @Override
    public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityLogo(intent.getComponent());
        }
        ResolveInfo resolveInfo = this.resolveActivity(intent, 65536);
        if (resolveInfo != null) {
            return resolveInfo.activityInfo.loadLogo(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public List<PermissionGroupInfo> getAllPermissionGroups(int n) {
        try {
            List<PermissionGroupInfo> list = this.mPM.getAllPermissionGroups(n);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public Drawable getApplicationBanner(ApplicationInfo applicationInfo) {
        return applicationInfo.loadBanner(this);
    }

    @Override
    public Drawable getApplicationBanner(String string2) throws PackageManager.NameNotFoundException {
        return this.getApplicationBanner(this.getApplicationInfo(string2, 1024));
    }

    @Override
    public int getApplicationEnabledSetting(String string2) {
        try {
            int n = this.mPM.getApplicationEnabledSetting(string2, this.mContext.getUserId());
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    @Override
    public boolean getApplicationHiddenSettingAsUser(String string2, UserHandle userHandle) {
        try {
            boolean bl = this.mPM.getApplicationHiddenSettingAsUser(string2, userHandle.getIdentifier());
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public Drawable getApplicationIcon(ApplicationInfo applicationInfo) {
        return applicationInfo.loadIcon(this);
    }

    @Override
    public Drawable getApplicationIcon(String string2) throws PackageManager.NameNotFoundException {
        return this.getApplicationIcon(this.getApplicationInfo(string2, 1024));
    }

    @Override
    public ApplicationInfo getApplicationInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        block3: {
            ApplicationInfo applicationInfo;
            try {
                applicationInfo = this.mPM.getApplicationInfo(string2, n, this.mContext.getUserId());
                if (applicationInfo == null) break block3;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            ApplicationPackageManager.maybeAdjustApplicationInfo(applicationInfo);
            return applicationInfo;
        }
        throw new PackageManager.NameNotFoundException(string2);
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        return applicationInfo.loadLabel(this);
    }

    @Override
    public Drawable getApplicationLogo(ApplicationInfo applicationInfo) {
        return applicationInfo.loadLogo(this);
    }

    @Override
    public Drawable getApplicationLogo(String string2) throws PackageManager.NameNotFoundException {
        return this.getApplicationLogo(this.getApplicationInfo(string2, 1024));
    }

    @Override
    public int getComponentEnabledSetting(ComponentName componentName) {
        try {
            int n = this.mPM.getComponentEnabledSetting(componentName, this.mContext.getUserId());
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    @Override
    public Drawable getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    /*
     * Loose catch block
     */
    @Override
    public Drawable getDrawable(String string2, int n, ApplicationInfo applicationInfo) {
        ResourceName resourceName = new ResourceName(string2, n);
        Drawable drawable2 = this.getCachedIcon(resourceName);
        if (drawable2 != null) {
            return drawable2;
        }
        if (applicationInfo == null) {
            ApplicationInfo applicationInfo2;
            applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, 1024);
        }
        Drawable drawable3 = this.getResourcesForApplication(applicationInfo).getDrawable(n);
        this.putCachedIcon(resourceName, drawable3);
        return drawable3;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w("PackageManager", "Failure retrieving resources for " + applicationInfo.packageName);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.w("PackageManager", "Failure retrieving resources for " + applicationInfo.packageName + ": " + notFoundException.getMessage());
            return null;
        }
        catch (RuntimeException runtimeException) {
            Log.w("PackageManager", "Failure retrieving icon 0x" + Integer.toHexString(n) + " in package " + string2, runtimeException);
            return null;
        }
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> list) {
        try {
            ComponentName componentName = this.mPM.getHomeActivities(list);
            return componentName;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public List<ApplicationInfo> getInstalledApplications(int n) {
        int n2 = this.mContext.getUserId();
        try {
            List<ApplicationInfo> list = this.mPM.getInstalledApplications(n, n2).getList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<PackageInfo> getInstalledPackages(int n) {
        return this.getInstalledPackages(n, this.mContext.getUserId());
    }

    @Override
    public List<PackageInfo> getInstalledPackages(int n, int n2) {
        try {
            List<PackageInfo> list = this.mPM.getInstalledPackages(n, n2).getList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public String getInstallerPackageName(String string2) {
        try {
            String string3 = this.mPM.getInstallerPackageName(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        try {
            InstrumentationInfo instrumentationInfo = this.mPM.getInstrumentationInfo(componentName, n);
            if (instrumentationInfo != null) {
                return instrumentationInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(componentName.toString());
    }

    @Override
    public KeySet getKeySetByAlias(String string2, String string3) {
        Preconditions.checkNotNull(string2);
        Preconditions.checkNotNull(string3);
        try {
            KeySet keySet = this.mPM.getKeySetByAlias(string2, string3);
            return keySet;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public Intent getLaunchIntentForPackage(String string2) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.INFO");
        intent.setPackage(string2);
        List<ResolveInfo> list = this.queryIntentActivities(intent, 0);
        if (list == null || list.size() <= 0) {
            intent.removeCategory("android.intent.category.INFO");
            intent.addCategory("android.intent.category.LAUNCHER");
            intent.setPackage(string2);
            list = this.queryIntentActivities(intent, 0);
        }
        if (list == null || list.size() <= 0) {
            return null;
        }
        Intent intent2 = new Intent(intent);
        intent2.setFlags(0x10000000);
        intent2.setClassName(list.get((int)0).activityInfo.packageName, list.get((int)0).activityInfo.name);
        return intent2;
    }

    @Override
    public Intent getLeanbackLaunchIntentForPackage(String string2) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LEANBACK_LAUNCHER");
        intent.setPackage(string2);
        List<ResolveInfo> list = this.queryIntentActivities(intent, 0);
        if (list == null || list.size() <= 0) {
            return null;
        }
        Intent intent2 = new Intent(intent);
        intent2.setFlags(0x10000000);
        intent2.setClassName(list.get((int)0).activityInfo.packageName, list.get((int)0).activityInfo.name);
        return intent2;
    }

    @Override
    public String getNameForUid(int n) {
        try {
            String string2 = this.mPM.getNameForUid(n);
            return string2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public int[] getPackageGids(String string2) throws PackageManager.NameNotFoundException {
        block5: {
            int[] nArray;
            block4: {
                try {
                    nArray = this.mPM.getPackageGids(string2);
                    if (nArray == null) break block4;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeException("Package manager has died", remoteException);
                }
                int n = nArray.length;
                if (n <= 0) break block5;
            }
            return nArray;
        }
        throw new PackageManager.NameNotFoundException(string2);
    }

    @Override
    public PackageInfo getPackageInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        try {
            PackageInfo packageInfo = this.mPM.getPackageInfo(string2, n, this.mContext.getUserId());
            if (packageInfo != null) {
                return packageInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PackageInstaller getPackageInstaller() {
        Object object = this.mLock;
        synchronized (object) {
            PackageInstaller packageInstaller = this.mInstaller;
            if (packageInstaller != null) return this.mInstaller;
            try {
                this.mInstaller = new PackageInstaller(this.mContext, this, this.mPM.getPackageInstaller(), this.mContext.getPackageName(), this.mContext.getUserId());
                return this.mInstaller;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }
    }

    @Override
    public void getPackageSizeInfo(String string2, int n, IPackageStatsObserver iPackageStatsObserver) {
        try {
            this.mPM.getPackageSizeInfo(string2, n, iPackageStatsObserver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public int getPackageUid(String string2, int n) throws PackageManager.NameNotFoundException {
        try {
            int n2 = this.mPM.getPackageUid(string2, n);
            if (n2 >= 0) {
                return n2;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(string2);
    }

    @Override
    public String[] getPackagesForUid(int n) {
        try {
            String[] stringArray = this.mPM.getPackagesForUid(n);
            return stringArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<PackageInfo> getPackagesHoldingPermissions(String[] stringArray, int n) {
        int n2 = this.mContext.getUserId();
        try {
            List<PackageInfo> list = this.mPM.getPackagesHoldingPermissions(stringArray, n, n2).getList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        try {
            PermissionGroupInfo permissionGroupInfo = this.mPM.getPermissionGroupInfo(string2, n);
            if (permissionGroupInfo != null) {
                return permissionGroupInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(string2);
    }

    @Override
    public PermissionInfo getPermissionInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        try {
            PermissionInfo permissionInfo = this.mPM.getPermissionInfo(string2, n);
            if (permissionInfo != null) {
                return permissionInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(string2);
    }

    @Override
    public int getPreferredActivities(List<IntentFilter> list, List<ComponentName> list2, String string2) {
        try {
            int n = this.mPM.getPreferredActivities(list, list2, string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    @Override
    public List<PackageInfo> getPreferredPackages(int n) {
        try {
            List<PackageInfo> list = this.mPM.getPreferredPackages(n);
            return list;
        }
        catch (RemoteException remoteException) {
            return new ArrayList<PackageInfo>();
        }
    }

    @Override
    public ProviderInfo getProviderInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        try {
            ProviderInfo providerInfo = this.mPM.getProviderInfo(componentName, n, this.mContext.getUserId());
            if (providerInfo != null) {
                return providerInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(componentName.toString());
    }

    @Override
    public ActivityInfo getReceiverInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        try {
            ActivityInfo activityInfo = this.mPM.getReceiverInfo(componentName, n, this.mContext.getUserId());
            if (activityInfo != null) {
                return activityInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(componentName.toString());
    }

    @Override
    public Resources getResourcesForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getActivityInfo((ComponentName)componentName, (int)1024).applicationInfo);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
        if (applicationInfo.packageName.equals("system")) {
            return this.mContext.mMainThread.getSystemContext().getResources();
        }
        boolean bl = applicationInfo.uid == Process.myUid();
        ActivityThread activityThread = this.mContext.mMainThread;
        String string2 = bl ? applicationInfo.sourceDir : applicationInfo.publicSourceDir;
        String[] stringArray = bl ? applicationInfo.splitSourceDirs : applicationInfo.splitPublicSourceDirs;
        Resources resources = activityThread.getTopLevelResources(string2, stringArray, applicationInfo.resourceDirs, applicationInfo.sharedLibraryFiles, 0, null, this.mContext.mPackageInfo, applicationInfo.packageName);
        if (resources != null) return resources;
        throw new PackageManager.NameNotFoundException("Unable to open " + applicationInfo.publicSourceDir);
    }

    @Override
    public Resources getResourcesForApplication(String string2) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getApplicationInfo(string2, 1024));
    }

    @Override
    public Resources getResourcesForApplicationAsUser(String string2, int n) throws PackageManager.NameNotFoundException {
        block5: {
            ApplicationInfo applicationInfo;
            if (n < 0) {
                throw new IllegalArgumentException("Call does not support special user #" + n);
            }
            if ("system".equals(string2)) {
                return this.mContext.mMainThread.getSystemContext().getResources();
            }
            try {
                applicationInfo = this.mPM.getApplicationInfo(string2, 1024, n);
                if (applicationInfo == null) break block5;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Package manager has died", remoteException);
            }
            Resources resources = this.getResourcesForApplication(applicationInfo);
            return resources;
        }
        throw new PackageManager.NameNotFoundException("Package " + string2 + " doesn't exist");
    }

    @Override
    public ServiceInfo getServiceInfo(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo serviceInfo = this.mPM.getServiceInfo(componentName, n, this.mContext.getUserId());
            if (serviceInfo != null) {
                return serviceInfo;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(componentName.toString());
    }

    @Override
    public KeySet getSigningKeySet(String string2) {
        Preconditions.checkNotNull(string2);
        try {
            KeySet keySet = this.mPM.getSigningKeySet(string2);
            return keySet;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public FeatureInfo[] getSystemAvailableFeatures() {
        try {
            FeatureInfo[] featureInfoArray = this.mPM.getSystemAvailableFeatures();
            return featureInfoArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public String[] getSystemSharedLibraryNames() {
        try {
            String[] stringArray = this.mPM.getSystemSharedLibraryNames();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public CharSequence getText(String string2, int n, ApplicationInfo applicationInfo) {
        ResourceName resourceName = new ResourceName(string2, n);
        CharSequence charSequence = this.getCachedString(resourceName);
        if (charSequence != null) {
            return charSequence;
        }
        if (applicationInfo == null) {
            ApplicationInfo applicationInfo2;
            applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, 1024);
        }
        CharSequence charSequence2 = this.getResourcesForApplication(applicationInfo).getText(n);
        this.putCachedString(resourceName, charSequence2);
        return charSequence2;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w("PackageManager", "Failure retrieving resources for " + applicationInfo.packageName);
            return null;
        }
        catch (RuntimeException runtimeException) {
            Log.w("PackageManager", "Failure retrieving text 0x" + Integer.toHexString(n) + " in package " + string2, runtimeException);
            return null;
        }
    }

    @Override
    public int getUidForSharedUser(String string2) throws PackageManager.NameNotFoundException {
        try {
            int n = this.mPM.getUidForSharedUser(string2);
            if (n != -1) {
                return n;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException("No shared userid for user:" + string2);
    }

    @Override
    public Drawable getUserBadgeForDensity(UserHandle userHandle, int n) {
        UserInfo userInfo = this.getUserIfProfile(userHandle.getIdentifier());
        if (userInfo != null && userInfo.isManagedProfile()) {
            if (n <= 0) {
                n = this.mContext.getResources().getDisplayMetrics().densityDpi;
            }
            return Resources.getSystem().getDrawableForDensity(17302581, n);
        }
        return null;
    }

    @Override
    public Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle userHandle, Rect rect, int n) {
        Drawable drawable3 = this.getUserBadgeForDensity(userHandle, n);
        if (drawable3 == null) {
            return drawable2;
        }
        return this.getBadgedDrawable(drawable2, drawable3, rect, true);
    }

    @Override
    public Drawable getUserBadgedIcon(Drawable drawable2, UserHandle userHandle) {
        int n = this.getBadgeResIdForUser(userHandle.getIdentifier());
        if (n == 0) {
            return drawable2;
        }
        return this.getBadgedDrawable(drawable2, this.getDrawable("system", n, null), null, true);
    }

    @Override
    public CharSequence getUserBadgedLabel(CharSequence charSequence, UserHandle userHandle) {
        UserInfo userInfo = this.getUserIfProfile(userHandle.getIdentifier());
        if (userInfo != null && userInfo.isManagedProfile()) {
            charSequence = Resources.getSystem().getString(17041008, charSequence);
        }
        return charSequence;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    UserManager getUserManager() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserManager != null) return this.mUserManager;
            this.mUserManager = UserManager.get(this.mContext);
            return this.mUserManager;
        }
    }

    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() {
        try {
            VerifierDeviceIdentity verifierDeviceIdentity = this.mPM.getVerifierDeviceIdentity();
            return verifierDeviceIdentity;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public XmlResourceParser getXml(String string2, int n, ApplicationInfo applicationInfo) {
        if (applicationInfo == null) {
            ApplicationInfo applicationInfo2;
            applicationInfo = applicationInfo2 = this.getApplicationInfo(string2, 1024);
        }
        XmlResourceParser xmlResourceParser = this.getResourcesForApplication(applicationInfo).getXml(n);
        return xmlResourceParser;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            Log.w("PackageManager", "Failure retrieving xml 0x" + Integer.toHexString(n) + " in package " + string2, runtimeException);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w("PackageManager", "Failure retrieving resources for " + applicationInfo.packageName);
            return null;
        }
    }

    @Override
    public void grantPermission(String string2, String string3) {
        try {
            this.mPM.grantPermission(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public boolean hasSystemFeature(String string2) {
        try {
            boolean bl = this.mPM.hasSystemFeature(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public int installExistingPackage(String string2) throws PackageManager.NameNotFoundException {
        int n;
        block3: {
            try {
                n = this.mPM.installExistingPackageAsUser(string2, UserHandle.myUserId());
                if (n != -3) break block3;
            }
            catch (RemoteException remoteException) {
                throw new PackageManager.NameNotFoundException("Package " + string2 + " doesn't exist");
            }
            throw new PackageManager.NameNotFoundException("Package " + string2 + " doesn't exist");
        }
        return n;
    }

    @Override
    public void installPackage(Uri uri, PackageInstallObserver packageInstallObserver, int n, String string2) {
        this.installCommon(uri, packageInstallObserver, n, string2, new VerificationParams(null, null, null, -1, null), null);
    }

    @Override
    public void installPackage(Uri uri, IPackageInstallObserver iPackageInstallObserver, int n, String string2) {
        VerificationParams verificationParams = new VerificationParams(null, null, null, -1, null);
        this.installCommon(uri, new PackageManager.LegacyPackageInstallObserver(iPackageInstallObserver), n, string2, verificationParams, null);
    }

    @Override
    public void installPackageWithVerification(Uri uri, PackageInstallObserver packageInstallObserver, int n, String string2, Uri uri2, ManifestDigest manifestDigest, ContainerEncryptionParams containerEncryptionParams) {
        this.installCommon(uri, packageInstallObserver, n, string2, new VerificationParams(uri2, null, null, -1, manifestDigest), containerEncryptionParams);
    }

    @Override
    public void installPackageWithVerification(Uri uri, IPackageInstallObserver iPackageInstallObserver, int n, String string2, Uri uri2, ManifestDigest manifestDigest, ContainerEncryptionParams containerEncryptionParams) {
        VerificationParams verificationParams = new VerificationParams(uri2, null, null, -1, manifestDigest);
        this.installCommon(uri, new PackageManager.LegacyPackageInstallObserver(iPackageInstallObserver), n, string2, verificationParams, containerEncryptionParams);
    }

    @Override
    public void installPackageWithVerificationAndEncryption(Uri uri, PackageInstallObserver packageInstallObserver, int n, String string2, VerificationParams verificationParams, ContainerEncryptionParams containerEncryptionParams) {
        this.installCommon(uri, packageInstallObserver, n, string2, verificationParams, containerEncryptionParams);
    }

    @Override
    public void installPackageWithVerificationAndEncryption(Uri uri, IPackageInstallObserver iPackageInstallObserver, int n, String string2, VerificationParams verificationParams, ContainerEncryptionParams containerEncryptionParams) {
        this.installCommon(uri, new PackageManager.LegacyPackageInstallObserver(iPackageInstallObserver), n, string2, verificationParams, containerEncryptionParams);
    }

    @Override
    public boolean isNeedProtectSecPreloadedApps() {
        try {
            boolean bl = this.mPM.isNeedProtectSecPreloadedApps();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean isPackageAvailable(String string2) {
        try {
            boolean bl = this.mPM.isPackageAvailable(string2, this.mContext.getUserId());
            return bl;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSafeMode() {
        try {
            int n;
            if (this.mCachedSafeMode < 0) {
                int n2 = this.mPM.isSafeMode() ? 1 : 0;
                this.mCachedSafeMode = n2;
            }
            return (n = this.mCachedSafeMode) != 0;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public boolean isSignedBy(String string2, KeySet keySet) {
        Preconditions.checkNotNull(string2);
        Preconditions.checkNotNull(keySet);
        try {
            boolean bl = this.mPM.isPackageSignedByKeySet(string2, keySet);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean isSignedByExactly(String string2, KeySet keySet) {
        Preconditions.checkNotNull(string2);
        Preconditions.checkNotNull(keySet);
        try {
            boolean bl = this.mPM.isPackageSignedByKeySetExactly(string2, keySet);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean isSupportUninstallablePreloadedApps() {
        try {
            boolean bl = this.mPM.isSupportUninstallablePreloadedApps();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public Drawable loadItemIcon(PackageItemInfo packageItemInfo, ApplicationInfo applicationInfo) {
        if (packageItemInfo.showUserIcon != -10000) {
            Bitmap bitmap = this.getUserManager().getUserIcon(packageItemInfo.showUserIcon);
            if (bitmap == null) {
                return UserIcons.getDefaultUserIcon(packageItemInfo.showUserIcon, false);
            }
            return new BitmapDrawable(bitmap);
        }
        String string2 = packageItemInfo.packageName;
        Drawable drawable2 = null;
        if (string2 != null) {
            drawable2 = this.getDrawable(packageItemInfo.packageName, packageItemInfo.icon, applicationInfo);
        }
        if (drawable2 == null) {
            drawable2 = packageItemInfo.loadDefaultIcon(this);
        }
        return this.getUserBadgedIcon(drawable2, new UserHandle(this.mContext.getUserId()));
    }

    @Override
    public void movePackage(String string2, IPackageMoveObserver iPackageMoveObserver, int n) {
        try {
            this.mPM.movePackage(string2, iPackageMoveObserver, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int n) {
        return this.queryBroadcastReceivers(intent, n, this.mContext.getUserId());
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int n, int n2) {
        try {
            List<ResolveInfo> list = this.mPM.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n, n2);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String string2, int n, int n2) {
        try {
            List<ProviderInfo> list = this.mPM.queryContentProviders(string2, n, n2);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<InstrumentationInfo> queryInstrumentation(String string2, int n) {
        try {
            List<InstrumentationInfo> list = this.mPM.queryInstrumentation(string2, n);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, int n) {
        return this.queryIntentActivitiesAsUser(intent, n, this.mContext.getUserId());
    }

    @Override
    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int n, int n2) {
        try {
            List<ResolveInfo> list = this.mPM.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n, n2);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName componentName, Intent[] intentArray, Intent intent, int n) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        String[] stringArray = null;
        if (intentArray != null) {
            int n2 = intentArray.length;
            for (int i = 0; i < n2; ++i) {
                String string2;
                Intent intent2 = intentArray[i];
                if (intent2 == null || (string2 = intent2.resolveTypeIfNeeded(contentResolver)) == null) continue;
                if (stringArray == null) {
                    stringArray = new String[n2];
                }
                stringArray[i] = string2;
            }
        }
        try {
            List<ResolveInfo> list = this.mPM.queryIntentActivityOptions(componentName, intentArray, stringArray, intent, intent.resolveTypeIfNeeded(contentResolver), n, this.mContext.getUserId());
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, int n) {
        return this.queryIntentContentProvidersAsUser(intent, n, this.mContext.getUserId());
    }

    @Override
    public List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int n, int n2) {
        try {
            List<ResolveInfo> list = this.mPM.queryIntentContentProviders(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n, n2);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, int n) {
        return this.queryIntentServicesAsUser(intent, n, this.mContext.getUserId());
    }

    @Override
    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int n, int n2) {
        try {
            List<ResolveInfo> list = this.mPM.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n, n2);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public List<PermissionInfo> queryPermissionsByGroup(String string2, int n) throws PackageManager.NameNotFoundException {
        try {
            List<PermissionInfo> list = this.mPM.queryPermissionsByGroup(string2, n);
            if (list != null) {
                return list;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
        throw new PackageManager.NameNotFoundException(string2);
    }

    @Override
    public void removePackageFromPreferred(String string2) {
        try {
            this.mPM.removePackageFromPreferred(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void removePermission(String string2) {
        try {
            this.mPM.removePermission(string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public void replacePreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) {
        try {
            this.mPM.replacePreferredActivity(intentFilter, n, componentNameArray, componentName, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void replacePreferredActivityAsUser(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName, int n2) {
        try {
            this.mPM.replacePreferredActivity(intentFilter, n, componentNameArray, componentName, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public ResolveInfo resolveActivity(Intent intent, int n) {
        return this.resolveActivityAsUser(intent, n, this.mContext.getUserId());
    }

    @Override
    public ResolveInfo resolveActivityAsUser(Intent intent, int n, int n2) {
        try {
            ResolveInfo resolveInfo = this.mPM.resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n, n2);
            return resolveInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public ProviderInfo resolveContentProvider(String string2, int n) {
        return this.resolveContentProviderAsUser(string2, n, this.mContext.getUserId());
    }

    @Override
    public ProviderInfo resolveContentProviderAsUser(String string2, int n, int n2) {
        try {
            ProviderInfo providerInfo = this.mPM.resolveContentProvider(string2, n, n2);
            return providerInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, int n) {
        try {
            ResolveInfo resolveInfo = this.mPM.resolveService(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), n, this.mContext.getUserId());
            return resolveInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public void revokePermission(String string2, String string3) {
        try {
            this.mPM.revokePermission(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Package manager has died", remoteException);
        }
    }

    @Override
    public void setApplicationEnabledSetting(String string2, int n, int n2) {
        try {
            this.mPM.setApplicationEnabledSetting(string2, n, n2, this.mContext.getUserId(), this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public boolean setApplicationHiddenSettingAsUser(String string2, boolean bl, UserHandle userHandle) {
        try {
            boolean bl2 = this.mPM.setApplicationHiddenSettingAsUser(string2, bl, userHandle.getIdentifier());
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int n, int n2) {
        try {
            this.mPM.setComponentEnabledSetting(componentName, n, n2, this.mContext.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void setInstallerPackageName(String string2, String string3) {
        try {
            this.mPM.setInstallerPackageName(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void verifyPendingInstall(int n, int n2) {
        try {
            this.mPM.verifyPendingInstall(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private static final class ResourceName {
        final int iconId;
        final String packageName;

        ResourceName(ApplicationInfo applicationInfo, int n) {
            this(applicationInfo.packageName, n);
        }

        ResourceName(ComponentInfo componentInfo, int n) {
            this(componentInfo.applicationInfo.packageName, n);
        }

        ResourceName(ResolveInfo resolveInfo, int n) {
            this(resolveInfo.activityInfo.applicationInfo.packageName, n);
        }

        ResourceName(String string2, int n) {
            this.packageName = string2;
            this.iconId = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            if (this == object) return true;
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ResourceName resourceName = (ResourceName)object;
            if (this.iconId != resourceName.iconId) {
                return false;
            }
            if (this.packageName != null) {
                if (!this.packageName.equals(resourceName.packageName)) return false;
                return true;
            }
            if (resourceName.packageName == null) return true;
            return false;
        }

        public int hashCode() {
            return 31 * this.packageName.hashCode() + this.iconId;
        }

        public String toString() {
            return "{ResourceName " + this.packageName + " / " + this.iconId + "}";
        }
    }
}

