/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActionBar;
import android.app.Activity;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.app.WindowDecorActionBar;
import com.android.internal.policy.PolicyManager;
import java.lang.ref.WeakReference;

public class Dialog
implements DialogInterface,
Window.Callback,
KeyEvent.Callback,
View.OnCreateContextMenuListener,
Window.OnWindowDismissedCallback {
    private static final int CANCEL = 68;
    private static final String DIALOG_HIERARCHY_TAG = "android:dialogHierarchy";
    private static final String DIALOG_SHOWING_TAG = "android:dialogShowing";
    private static final int DISMISS = 67;
    private static final int SHOW = 69;
    private static final String TAG = "Dialog";
    private ActionBar mActionBar;
    private ActionMode mActionMode;
    private String mCancelAndDismissTaken;
    private Message mCancelMessage;
    protected boolean mCancelable = true;
    private boolean mCanceled = false;
    final Context mContext;
    private boolean mCreated = false;
    View mDecor;
    private final Runnable mDismissAction;
    private Message mDismissMessage;
    private final Handler mHandler = new Handler();
    private Handler mListenersHandler;
    private DialogInterface.OnKeyListener mOnKeyListener;
    private Activity mOwnerActivity;
    private Message mShowMessage;
    private boolean mShowing = false;
    Window mWindow;
    final WindowManager mWindowManager;

    public Dialog(Context context) {
        this(context, 0, true);
    }

    public Dialog(Context context, int n) {
        this(context, n, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    Dialog(Context context, int n, boolean bl) {
        Window window;
        this.mDismissAction = new Runnable(){

            @Override
            public void run() {
                Dialog.this.dismissDialog();
            }
        };
        if (bl) {
            if (n == 0) {
                TypedValue typedValue = new TypedValue();
                context.getTheme().resolveAttribute(16843528, typedValue, true);
                n = typedValue.resourceId;
            }
            this.mContext = new ContextThemeWrapper(context, n);
        } else {
            this.mContext = context;
        }
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mWindow = window = PolicyManager.makeNewWindow(this.mContext);
        window.setCallback(this);
        window.setOnWindowDismissedCallback(this);
        window.setWindowManager(this.mWindowManager, null, null);
        window.setGravity(17);
        this.mListenersHandler = new ListenersHandler(this);
    }

    protected Dialog(Context context, boolean bl, DialogInterface.OnCancelListener onCancelListener) {
        this(context);
        this.mCancelable = bl;
        this.setOnCancelListener(onCancelListener);
    }

    @Deprecated
    protected Dialog(Context context, boolean bl, Message message) {
        this(context);
        this.mCancelable = bl;
        this.mCancelMessage = message;
    }

    private ComponentName getAssociatedActivity() {
        Activity activity = this.mOwnerActivity;
        Context context = this.getContext();
        while (activity == null && context != null) {
            if (context instanceof Activity) {
                activity = (Activity)context;
                continue;
            }
            if (context instanceof ContextWrapper) {
                context = ((ContextWrapper)context).getBaseContext();
                continue;
            }
            context = null;
        }
        if (activity == null) {
            return null;
        }
        return activity.getComponentName();
    }

    private void sendDismissMessage() {
        if (this.mDismissMessage != null) {
            Message.obtain(this.mDismissMessage).sendToTarget();
        }
    }

    private void sendShowMessage() {
        if (this.mShowMessage != null) {
            Message.obtain(this.mShowMessage).sendToTarget();
        }
    }

    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.mWindow.addContentView(view, layoutParams);
    }

    @Override
    public void cancel() {
        if (!this.mCanceled && this.mCancelMessage != null) {
            this.mCanceled = true;
            Message.obtain(this.mCancelMessage).sendToTarget();
        }
        this.dismiss();
    }

    public void closeOptionsMenu() {
        this.mWindow.closePanel(0);
    }

    public void create() {
        if (!this.mCreated) {
            this.dispatchOnCreate(null);
        }
    }

    @Override
    public void dismiss() {
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            this.dismissDialog();
            return;
        }
        this.mHandler.post(this.mDismissAction);
    }

    void dismissDialog() {
        if (this.mDecor == null || !this.mShowing) {
            return;
        }
        if (this.mWindow.isDestroyed()) {
            Log.e(TAG, "Tried to dismissDialog() but the Dialog's window was already destroyed!");
            return;
        }
        try {
            this.mWindowManager.removeViewImmediate(this.mDecor);
            return;
        }
        finally {
            if (this.mActionMode != null) {
                this.mActionMode.finish();
            }
            this.mDecor = null;
            this.mWindow.closeAllPanels();
            this.onStop();
            this.mShowing = false;
            this.sendDismissMessage();
        }
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mWindow.superDispatchGenericMotionEvent(motionEvent)) {
            return true;
        }
        return this.onGenericMotionEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        KeyEvent.DispatcherState dispatcherState;
        if (this.mOnKeyListener != null && this.mOnKeyListener.onKey(this, keyEvent.getKeyCode(), keyEvent)) {
            return true;
        }
        if (this.mWindow.superDispatchKeyEvent(keyEvent)) return true;
        if (this.mDecor != null) {
            dispatcherState = this.mDecor.getKeyDispatcherState();
            return keyEvent.dispatch(this, dispatcherState, this);
        }
        dispatcherState = null;
        return keyEvent.dispatch(this, dispatcherState, this);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        if (this.mWindow.superDispatchKeyShortcutEvent(keyEvent)) {
            return true;
        }
        return this.onKeyShortcut(keyEvent.getKeyCode(), keyEvent);
    }

    void dispatchOnCreate(Bundle bundle) {
        if (!this.mCreated) {
            this.onCreate(bundle);
            this.mCreated = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        accessibilityEvent.setClassName(this.getClass().getName());
        accessibilityEvent.setPackageName(this.mContext.getPackageName());
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        boolean bl = layoutParams.width == -1 && layoutParams.height == -1;
        accessibilityEvent.setFullScreen(bl);
        return false;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.mWindow.superDispatchTouchEvent(motionEvent)) {
            return true;
        }
        return this.onTouchEvent(motionEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        if (this.mWindow.superDispatchTrackballEvent(motionEvent)) {
            return true;
        }
        return this.onTrackballEvent(motionEvent);
    }

    public View findViewById(int n) {
        return this.mWindow.findViewById(n);
    }

    public ActionBar getActionBar() {
        return this.mActionBar;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public View getCurrentFocus() {
        if (this.mWindow != null) {
            return this.mWindow.getCurrentFocus();
        }
        return null;
    }

    public LayoutInflater getLayoutInflater() {
        return this.getWindow().getLayoutInflater();
    }

    public final Activity getOwnerActivity() {
        return this.mOwnerActivity;
    }

    public final int getVolumeControlStream() {
        return this.getWindow().getVolumeControlStream();
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public void hide() {
        if (this.mDecor != null) {
            this.mDecor.setVisibility(8);
        }
    }

    public void invalidateOptionsMenu() {
        this.mWindow.invalidatePanelMenu(0);
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    @Override
    public void onActionModeFinished(ActionMode actionMode) {
        if (actionMode == this.mActionMode) {
            this.mActionMode = null;
        }
    }

    @Override
    public void onActionModeStarted(ActionMode actionMode) {
        this.mActionMode = actionMode;
    }

    @Override
    public void onAttachedToWindow() {
    }

    public void onBackPressed() {
        if (this.mCancelable) {
            this.cancel();
        }
    }

    @Override
    public void onContentChanged() {
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onContextMenuClosed(Menu menu2) {
    }

    protected void onCreate(Bundle bundle) {
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        return true;
    }

    @Override
    public boolean onCreatePanelMenu(int n, Menu menu2) {
        if (n == 0) {
            return this.onCreateOptionsMenu(menu2);
        }
        return false;
    }

    @Override
    public View onCreatePanelView(int n) {
        return null;
    }

    @Override
    public void onDetachedFromWindow() {
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return false;
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n == 4) {
            keyEvent.startTracking();
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return false;
    }

    public boolean onKeyShortcut(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (n == 4 && keyEvent.isTracking() && !keyEvent.isCanceled()) {
            this.onBackPressed();
            return true;
        }
        return false;
    }

    @Override
    public boolean onMenuItemSelected(int n, MenuItem menuItem) {
        return false;
    }

    @Override
    public boolean onMenuOpened(int n, Menu menu2) {
        if (n == 8) {
            this.mActionBar.dispatchMenuVisibilityChanged(true);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onOptionsMenuClosed(Menu menu2) {
    }

    @Override
    public void onPanelClosed(int n, Menu menu2) {
        if (n == 8) {
            this.mActionBar.dispatchMenuVisibilityChanged(false);
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        return true;
    }

    @Override
    public boolean onPreparePanel(int n, View view, Menu menu2) {
        return n != 0 || menu2 == null || this.onPrepareOptionsMenu(menu2) && menu2.hasVisibleItems();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onRestoreInstanceState(Bundle bundle) {
        block3: {
            block2: {
                Bundle bundle2 = bundle.getBundle(DIALOG_HIERARCHY_TAG);
                if (bundle2 == null) break block2;
                this.dispatchOnCreate(bundle);
                this.mWindow.restoreHierarchyState(bundle2);
                if (bundle.getBoolean(DIALOG_SHOWING_TAG)) break block3;
            }
            return;
        }
        this.show();
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putBoolean(DIALOG_SHOWING_TAG, this.mShowing);
        if (this.mCreated) {
            bundle.putBundle(DIALOG_HIERARCHY_TAG, this.mWindow.saveHierarchyState());
        }
        return bundle;
    }

    @Override
    public boolean onSearchRequested() {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        ComponentName componentName = this.getAssociatedActivity();
        boolean bl = false;
        if (componentName != null) {
            SearchableInfo searchableInfo = searchManager.getSearchableInfo(componentName);
            bl = false;
            if (searchableInfo != null) {
                searchManager.startSearch(null, false, componentName, null, false);
                this.dismiss();
                bl = true;
            }
        }
        return bl;
    }

    protected void onStart() {
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(true);
        }
    }

    protected void onStop() {
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(false);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mCancelable && this.mShowing && this.mWindow.shouldCloseOnTouch(this.mContext, motionEvent)) {
            this.cancel();
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return false;
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        if (this.mDecor != null) {
            this.mWindowManager.updateViewLayout(this.mDecor, layoutParams);
        }
    }

    @Override
    public void onWindowDismissed() {
        this.dismiss();
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        if (this.mActionBar != null) {
            return this.mActionBar.startActionMode(callback);
        }
        return null;
    }

    public void openContextMenu(View view) {
        view.showContextMenu();
    }

    public void openOptionsMenu() {
        this.mWindow.openPanel(0, null);
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    public final boolean requestWindowFeature(int n) {
        return this.getWindow().requestFeature(n);
    }

    public void setCancelMessage(Message message) {
        this.mCancelMessage = message;
    }

    public void setCancelable(boolean bl) {
        this.mCancelable = bl;
    }

    public void setCanceledOnTouchOutside(boolean bl) {
        if (bl && !this.mCancelable) {
            this.mCancelable = true;
        }
        this.mWindow.setCloseOnTouchOutside(bl);
    }

    public void setContentView(int n) {
        this.mWindow.setContentView(n);
    }

    public void setContentView(View view) {
        this.mWindow.setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.mWindow.setContentView(view, layoutParams);
    }

    public void setDismissMessage(Message message) {
        this.mDismissMessage = message;
    }

    public final void setFeatureDrawable(int n, Drawable drawable2) {
        this.getWindow().setFeatureDrawable(n, drawable2);
    }

    public final void setFeatureDrawableAlpha(int n, int n2) {
        this.getWindow().setFeatureDrawableAlpha(n, n2);
    }

    public final void setFeatureDrawableResource(int n, int n2) {
        this.getWindow().setFeatureDrawableResource(n, n2);
    }

    public final void setFeatureDrawableUri(int n, Uri uri) {
        this.getWindow().setFeatureDrawableUri(n, uri);
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        if (this.mCancelAndDismissTaken != null) {
            throw new IllegalStateException("OnCancelListener is already taken by " + this.mCancelAndDismissTaken + " and can not be replaced.");
        }
        if (onCancelListener != null) {
            this.mCancelMessage = this.mListenersHandler.obtainMessage(68, onCancelListener);
            return;
        }
        this.mCancelMessage = null;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        if (this.mCancelAndDismissTaken != null) {
            throw new IllegalStateException("OnDismissListener is already taken by " + this.mCancelAndDismissTaken + " and can not be replaced.");
        }
        if (onDismissListener != null) {
            this.mDismissMessage = this.mListenersHandler.obtainMessage(67, onDismissListener);
            return;
        }
        this.mDismissMessage = null;
    }

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.mOnKeyListener = onKeyListener;
    }

    public void setOnShowListener(DialogInterface.OnShowListener onShowListener) {
        if (onShowListener != null) {
            this.mShowMessage = this.mListenersHandler.obtainMessage(69, onShowListener);
            return;
        }
        this.mShowMessage = null;
    }

    public final void setOwnerActivity(Activity activity) {
        this.mOwnerActivity = activity;
        this.getWindow().setVolumeControlStream(this.mOwnerActivity.getVolumeControlStream());
    }

    public void setTitle(int n) {
        this.setTitle(this.mContext.getText(n));
    }

    public void setTitle(CharSequence charSequence) {
        this.mWindow.setTitle(charSequence);
        this.mWindow.getAttributes().setTitle(charSequence);
    }

    public final void setVolumeControlStream(int n) {
        this.getWindow().setVolumeControlStream(n);
    }

    public void show() {
        if (this.mShowing) {
            if (this.mDecor != null) {
                if (this.mWindow.hasFeature(8)) {
                    this.mWindow.invalidatePanelMenu(8);
                }
                this.mDecor.setVisibility(0);
            }
            return;
        }
        this.mCanceled = false;
        if (!this.mCreated) {
            this.dispatchOnCreate(null);
        }
        this.onStart();
        this.mDecor = this.mWindow.getDecorView();
        if (this.mActionBar == null && this.mWindow.hasFeature(8)) {
            ApplicationInfo applicationInfo = this.mContext.getApplicationInfo();
            this.mWindow.setDefaultIcon(applicationInfo.icon);
            this.mWindow.setDefaultLogo(applicationInfo.logo);
            this.mActionBar = new WindowDecorActionBar(this);
        }
        WindowManager.LayoutParams layoutParams = this.mWindow.getAttributes();
        if ((0x100 & layoutParams.softInputMode) == 0) {
            WindowManager.LayoutParams layoutParams2 = new WindowManager.LayoutParams();
            layoutParams2.copyFrom(layoutParams);
            layoutParams2.softInputMode = 0x100 | layoutParams2.softInputMode;
            layoutParams = layoutParams2;
        }
        this.mWindowManager.addView(this.mDecor, layoutParams);
        this.mShowing = true;
        this.sendShowMessage();
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean takeCancelAndDismissListeners(String string2, DialogInterface.OnCancelListener onCancelListener, DialogInterface.OnDismissListener onDismissListener) {
        if (this.mCancelAndDismissTaken != null) {
            this.mCancelAndDismissTaken = null;
        } else if (this.mCancelMessage != null || this.mDismissMessage != null) {
            return false;
        }
        this.setOnCancelListener(onCancelListener);
        this.setOnDismissListener(onDismissListener);
        this.mCancelAndDismissTaken = string2;
        return true;
    }

    public void takeKeyEvents(boolean bl) {
        this.mWindow.takeKeyEvents(bl);
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    private static final class ListenersHandler
    extends Handler {
        private WeakReference<DialogInterface> mDialog;

        public ListenersHandler(Dialog dialog) {
            this.mDialog = new WeakReference<Dialog>(dialog);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 67: {
                    ((DialogInterface.OnDismissListener)message.obj).onDismiss((DialogInterface)this.mDialog.get());
                    return;
                }
                case 68: {
                    ((DialogInterface.OnCancelListener)message.obj).onCancel((DialogInterface)this.mDialog.get());
                    return;
                }
                case 69: 
            }
            ((DialogInterface.OnShowListener)message.obj).onShow((DialogInterface)this.mDialog.get());
        }
    }
}

