/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.LayoutTransition;
import android.app.Activity;
import android.app.BackStackRecord;
import android.app.FragmentManager;
import android.app.FragmentManagerImpl;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.R;

@Deprecated
public class FragmentBreadCrumbs
extends ViewGroup
implements FragmentManager.OnBackStackChangedListener {
    private static final int DEFAULT_GRAVITY = 8388627;
    Activity mActivity;
    LinearLayout mContainer;
    private int mGravity;
    LayoutInflater mInflater;
    private int mLayoutResId;
    int mMaxVisible = -1;
    private OnBreadCrumbClickListener mOnBreadCrumbClickListener;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onClick(View view) {
            FragmentManager.BackStackEntry backStackEntry;
            OnBreadCrumbClickListener onBreadCrumbClickListener;
            if (!(view.getTag() instanceof FragmentManager.BackStackEntry)) return;
            FragmentManager.BackStackEntry backStackEntry2 = (FragmentManager.BackStackEntry)view.getTag();
            if (backStackEntry2 == FragmentBreadCrumbs.this.mParentEntry) {
                if (FragmentBreadCrumbs.this.mParentClickListener == null) return;
                FragmentBreadCrumbs.this.mParentClickListener.onClick(view);
                return;
            }
            if (FragmentBreadCrumbs.this.mOnBreadCrumbClickListener != null && (onBreadCrumbClickListener = FragmentBreadCrumbs.this.mOnBreadCrumbClickListener).onBreadCrumbClick(backStackEntry = backStackEntry2 == FragmentBreadCrumbs.this.mTopEntry ? null : backStackEntry2, 0)) {
                return;
            }
            if (backStackEntry2 == FragmentBreadCrumbs.this.mTopEntry) {
                FragmentBreadCrumbs.this.mActivity.getFragmentManager().popBackStack();
                return;
            }
            FragmentBreadCrumbs.this.mActivity.getFragmentManager().popBackStack(backStackEntry2.getId(), 0);
        }
    };
    private View.OnClickListener mParentClickListener;
    BackStackRecord mParentEntry;
    private int mTextColor;
    BackStackRecord mTopEntry;

    public FragmentBreadCrumbs(Context context) {
        this(context, null);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843809);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FragmentBreadCrumbs, n, n2);
        this.mGravity = typedArray.getInt(0, 8388627);
        this.mLayoutResId = typedArray.getResourceId(1, 17367148);
        this.mTextColor = typedArray.getColor(2, 0);
        typedArray.recycle();
    }

    private BackStackRecord createBackStackEntry(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null) {
            return null;
        }
        BackStackRecord backStackRecord = new BackStackRecord((FragmentManagerImpl)this.mActivity.getFragmentManager());
        backStackRecord.setBreadCrumbTitle(charSequence);
        backStackRecord.setBreadCrumbShortTitle(charSequence2);
        return backStackRecord;
    }

    private FragmentManager.BackStackEntry getPreEntry(int n) {
        if (this.mParentEntry != null) {
            if (n == 0) {
                return this.mParentEntry;
            }
            return this.mTopEntry;
        }
        return this.mTopEntry;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getPreEntryCount() {
        int n = 1;
        int n2 = this.mTopEntry != null ? n : 0;
        if (this.mParentEntry != null) {
            return n2 + n;
        }
        n = 0;
        return n2 + n;
    }

    @Override
    public void onBackStackChanged() {
        this.updateCrumbs();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.getChildCount() == 0) {
            return;
        }
        View view = this.getChildAt(0);
        int n7 = this.mPaddingTop;
        int n8 = this.mPaddingTop + view.getMeasuredHeight() - this.mPaddingBottom;
        int n9 = this.getLayoutDirection();
        switch (Gravity.getAbsoluteGravity(0x800007 & this.mGravity, n9)) {
            default: {
                n6 = this.mPaddingLeft;
                n5 = n6 + view.getMeasuredWidth();
                break;
            }
            case 5: {
                n5 = this.mRight - this.mLeft - this.mPaddingRight;
                n6 = n5 - view.getMeasuredWidth();
                break;
            }
            case 1: {
                n6 = this.mPaddingLeft + (this.mRight - this.mLeft - view.getMeasuredWidth()) / 2;
                n5 = n6 + view.getMeasuredWidth();
            }
        }
        if (n6 < this.mPaddingLeft) {
            n6 = this.mPaddingLeft;
        }
        if (n5 > this.mRight - this.mLeft - this.mPaddingRight) {
            n5 = this.mRight - this.mLeft - this.mPaddingRight;
        }
        view.layout(n6, n7, n5, n8);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.getChildCount();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            this.measureChild(view, n, n2);
            n5 = Math.max(n5, view.getMeasuredWidth());
            n4 = Math.max(n4, view.getMeasuredHeight());
            n6 = FragmentBreadCrumbs.combineMeasuredStates(n6, view.getMeasuredState());
        }
        int n7 = n5 + (this.mPaddingLeft + this.mPaddingRight);
        int n8 = Math.max(n4 + (this.mPaddingTop + this.mPaddingBottom), this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(FragmentBreadCrumbs.resolveSizeAndState(Math.max(n7, this.getSuggestedMinimumWidth()), n, n6), FragmentBreadCrumbs.resolveSizeAndState(n8, n2, n6 << 16));
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
        this.mInflater = (LayoutInflater)activity.getSystemService("layout_inflater");
        this.mContainer = (LinearLayout)this.mInflater.inflate(17367150, (ViewGroup)this, false);
        this.addView(this.mContainer);
        activity.getFragmentManager().addOnBackStackChangedListener(this);
        this.updateCrumbs();
        this.setLayoutTransition(new LayoutTransition());
    }

    public void setMaxVisible(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("visibleCrumbs must be greater than zero");
        }
        this.mMaxVisible = n;
    }

    public void setOnBreadCrumbClickListener(OnBreadCrumbClickListener onBreadCrumbClickListener) {
        this.mOnBreadCrumbClickListener = onBreadCrumbClickListener;
    }

    public void setParentTitle(CharSequence charSequence, CharSequence charSequence2, View.OnClickListener onClickListener) {
        this.mParentEntry = this.createBackStackEntry(charSequence, charSequence2);
        this.mParentClickListener = onClickListener;
        this.updateCrumbs();
    }

    public void setTitle(CharSequence charSequence, CharSequence charSequence2) {
        this.mTopEntry = this.createBackStackEntry(charSequence, charSequence2);
        this.updateCrumbs();
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateCrumbs() {
        int n;
        FragmentManager fragmentManager = this.mActivity.getFragmentManager();
        int n2 = fragmentManager.getBackStackEntryCount();
        int n3 = this.getPreEntryCount();
        int n4 = this.mContainer.getChildCount();
        for (int i = 0; i < n2 + n3; ++i) {
            FragmentManager.BackStackEntry backStackEntry = i < n3 ? this.getPreEntry(i) : fragmentManager.getBackStackEntryAt(i - n3);
            if (i < n4 && this.mContainer.getChildAt(i).getTag() != backStackEntry) {
                for (int j = i; j < n4; ++j) {
                    this.mContainer.removeViewAt(i);
                }
                n4 = i;
            }
            if (i < n4) continue;
            View view = this.mInflater.inflate(this.mLayoutResId, (ViewGroup)this, false);
            TextView textView = (TextView)view.findViewById(16908310);
            textView.setText(backStackEntry.getBreadCrumbTitle());
            textView.setTag(backStackEntry);
            textView.setTextColor(this.mTextColor);
            if (i == 0) {
                view.findViewById(16908338).setVisibility(8);
            }
            this.mContainer.addView(view);
            textView.setOnClickListener(this.mOnClickListener);
        }
        int n5 = n2 + n3;
        for (n = this.mContainer.getChildCount(); n > n5; --n) {
            this.mContainer.removeViewAt(n - 1);
        }
        int n6 = 0;
        while (n6 < n) {
            View view = this.mContainer.getChildAt(n6);
            View view2 = view.findViewById(16908310);
            boolean bl = n6 < n - 1;
            view2.setEnabled(bl);
            if (this.mMaxVisible > 0) {
                int n7 = n6 < n - this.mMaxVisible ? 8 : 0;
                view.setVisibility(n7);
                View view3 = view.findViewById(16908338);
                int n8 = n6 > n - this.mMaxVisible && n6 != 0 ? 0 : 8;
                view3.setVisibility(n8);
            }
            ++n6;
        }
        return;
    }

    public static interface OnBreadCrumbClickListener {
        public boolean onBreadCrumbClick(FragmentManager.BackStackEntry var1, int var2);
    }
}

