/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Fragment;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IUiAutomationConnection;
import android.app.UiAutomation;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.hardware.input.InputManager;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.PerformanceCollector;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Instrumentation {
    public static final String REPORT_KEY_IDENTIFIER = "id";
    public static final String REPORT_KEY_STREAMRESULT = "stream";
    private static final String TAG = "Instrumentation";
    private List<ActivityMonitor> mActivityMonitors;
    private Context mAppContext;
    private boolean mAutomaticPerformanceSnapshots = false;
    private ComponentName mComponent;
    private Context mInstrContext;
    private MessageQueue mMessageQueue = null;
    private Bundle mPerfMetrics;
    private PerformanceCollector mPerformanceCollector;
    private Thread mRunner;
    private final Object mSync = new Object();
    private ActivityThread mThread = null;
    private UiAutomation mUiAutomation;
    private IUiAutomationConnection mUiAutomationConnection;
    private List<ActivityWaiter> mWaitingActivities;
    private IInstrumentationWatcher mWatcher;

    public Instrumentation() {
        this.mPerfMetrics = new Bundle();
    }

    private void addValue(String string2, int n, Bundle bundle) {
        if (bundle.containsKey(string2)) {
            ArrayList<Integer> arrayList = bundle.getIntegerArrayList(string2);
            if (arrayList != null) {
                arrayList.add(n);
            }
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n);
        bundle.putIntegerArrayList(string2, arrayList);
    }

    public static void checkStartActivityResult(int n, Object object) {
        if (n >= 0) {
            return;
        }
        switch (n) {
            default: {
                throw new AndroidRuntimeException("Unknown error code " + n + " when starting " + object);
            }
            case -2: 
            case -1: {
                if (object instanceof Intent && ((Intent)object).getComponent() != null) {
                    throw new ActivityNotFoundException("Unable to find explicit activity class " + ((Intent)object).getComponent().toShortString() + "; have you declared this activity in your AndroidManifest.xml?");
                }
                throw new ActivityNotFoundException("No Activity found to handle " + object);
            }
            case -4: {
                throw new SecurityException("Not allowed to start activity " + object);
            }
            case -3: {
                throw new AndroidRuntimeException("FORWARD_RESULT_FLAG used while also requesting a result");
            }
            case -5: {
                throw new IllegalArgumentException("PendingIntent is not an activity");
            }
            case -7: 
        }
        throw new SecurityException("Starting under voice control not allowed for: " + object);
    }

    public static Application newApplication(Class<?> clazz, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Application application = (Application)clazz.newInstance();
        application.attach(context);
        return application;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postPerformCreate(Activity activity) {
        if (this.mActivityMonitors == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            int n = this.mActivityMonitors.size();
            int n2 = 0;
            while (n2 < n) {
                this.mActivityMonitors.get(n2).match(activity, activity, activity.getIntent());
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prePerformCreate(Activity activity) {
        if (this.mWaitingActivities == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            int n = this.mWaitingActivities.size();
            int n2 = 0;
            while (n2 < n) {
                ActivityWaiter activityWaiter = this.mWaitingActivities.get(n2);
                if (activityWaiter.intent.filterEquals(activity.getIntent())) {
                    activityWaiter.activity = activity;
                    this.mMessageQueue.addIdleHandler(new ActivityGoing(activityWaiter));
                }
                ++n2;
            }
            return;
        }
    }

    private final void validateNotAppThread() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("This method can not be called from the main application thread");
        }
    }

    public ActivityMonitor addMonitor(IntentFilter intentFilter, ActivityResult activityResult, boolean bl) {
        ActivityMonitor activityMonitor = new ActivityMonitor(intentFilter, activityResult, bl);
        this.addMonitor(activityMonitor);
        return activityMonitor;
    }

    public ActivityMonitor addMonitor(String string2, ActivityResult activityResult, boolean bl) {
        ActivityMonitor activityMonitor = new ActivityMonitor(string2, activityResult, bl);
        this.addMonitor(activityMonitor);
        return activityMonitor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMonitor(ActivityMonitor activityMonitor) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityMonitors == null) {
                this.mActivityMonitors = new ArrayList<ActivityMonitor>();
            }
            this.mActivityMonitors.add(activityMonitor);
            return;
        }
    }

    public void callActivityOnCreate(Activity activity, Bundle bundle) {
        this.prePerformCreate(activity);
        activity.performCreate(bundle);
        this.postPerformCreate(activity);
    }

    public void callActivityOnCreate(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        this.prePerformCreate(activity);
        activity.performCreate(bundle, persistableBundle);
        this.postPerformCreate(activity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void callActivityOnDestroy(Activity activity) {
        activity.performDestroy();
        if (this.mActivityMonitors == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            int n = this.mActivityMonitors.size();
            int n2 = 0;
            while (n2 < n) {
                this.mActivityMonitors.get(n2).match(activity, activity, activity.getIntent());
                ++n2;
            }
            return;
        }
    }

    public void callActivityOnNewIntent(Activity activity, Intent intent) {
        activity.onNewIntent(intent);
    }

    public void callActivityOnPause(Activity activity) {
        activity.performPause();
    }

    public void callActivityOnPostCreate(Activity activity, Bundle bundle) {
        activity.onPostCreate(bundle);
    }

    public void callActivityOnPostCreate(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        activity.onPostCreate(bundle, persistableBundle);
    }

    public void callActivityOnRestart(Activity activity) {
        activity.onRestart();
    }

    public void callActivityOnRestoreInstanceState(Activity activity, Bundle bundle) {
        activity.performRestoreInstanceState(bundle);
    }

    public void callActivityOnRestoreInstanceState(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        activity.performRestoreInstanceState(bundle, persistableBundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void callActivityOnResume(Activity activity) {
        activity.mResumed = true;
        activity.onResume();
        if (this.mActivityMonitors == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            int n = this.mActivityMonitors.size();
            int n2 = 0;
            while (n2 < n) {
                this.mActivityMonitors.get(n2).match(activity, activity, activity.getIntent());
                ++n2;
            }
            return;
        }
    }

    public void callActivityOnSaveInstanceState(Activity activity, Bundle bundle) {
        activity.performSaveInstanceState(bundle);
    }

    public void callActivityOnSaveInstanceState(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        activity.performSaveInstanceState(bundle, persistableBundle);
    }

    public void callActivityOnStart(Activity activity) {
        activity.onStart();
    }

    public void callActivityOnStop(Activity activity) {
        activity.onStop();
    }

    public void callActivityOnUserLeaving(Activity activity) {
        activity.performUserLeaving();
    }

    public void callApplicationOnCreate(Application application) {
        application.onCreate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkMonitorHit(ActivityMonitor activityMonitor, int n) {
        this.waitForIdleSync();
        Object object = this.mSync;
        synchronized (object) {
            if (activityMonitor.getHits() < n) {
                return false;
            }
            this.mActivityMonitors.remove(activityMonitor);
            return true;
        }
    }

    public void endPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerfMetrics = this.mPerformanceCollector.endSnapshot();
        }
    }

    public void execStartActivities(Context context, IBinder iBinder, IBinder iBinder2, Activity activity, Intent[] intentArray, Bundle bundle) {
        this.execStartActivitiesAsUser(context, iBinder, iBinder2, activity, intentArray, bundle, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execStartActivitiesAsUser(Context var1_1, IBinder var2_2, IBinder var3_3, Activity var4_4, Intent[] var5_5, Bundle var6_6, int var7_7) {
        var8_8 = (IApplicationThread)var2_2;
        if (this.mActivityMonitors == null) ** GOTO lbl16
        var13_9 = this.mSync;
        synchronized (var13_9) {
            var15_10 = this.mActivityMonitors.size();
            var16_11 = 0;
            while (true) {
                if (var16_11 < var15_10) {
                    var17_12 = this.mActivityMonitors.get(var16_11);
                    if (var17_12.match(var1_1, null, var5_5[0])) {
                        var17_12.mHits = 1 + var17_12.mHits;
                        if (var17_12.isBlocking()) {
                            return;
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 10] lbl16 : MonitorExitStatement: MONITOREXIT : var13_9
lbl16:
                    // 2 sources

                    try {
                        var10_13 = new String[var5_5.length];
                        for (var11_14 = 0; var11_14 < var5_5.length; ++var11_14) {
                            var5_5[var11_14].migrateExtraStreamToClipData();
                            var5_5[var11_14].prepareToLeaveProcess();
                            var10_13[var11_14] = var5_5[var11_14].resolveTypeIfNeeded(var1_1.getContentResolver());
                        }
                    }
                    catch (RemoteException var9_15) {
                        return;
                    }
                    {
                        Instrumentation.checkStartActivityResult(ActivityManagerNative.getDefault().startActivities(var8_8, var1_1.getBasePackageName(), var5_5, var10_13, var3_3, var6_6, var7_7), var5_5[0]);
                        return;
                    }
                }
                ++var16_11;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActivityResult execStartActivity(Context var1_1, IBinder var2_2, IBinder var3_3, Activity var4_4, Intent var5_5, int var6_6, Bundle var7_7) {
        var8_8 = (IApplicationThread)var2_2;
        if (this.mActivityMonitors == null) ** GOTO lbl17
        var15_9 = this.mSync;
        synchronized (var15_9) {
            var17_10 = this.mActivityMonitors.size();
            var18_11 = 0;
            while (true) {
                if (var18_11 < var17_10) {
                    var19_12 = this.mActivityMonitors.get(var18_11);
                    if (var19_12.match(var1_1, null, var5_5)) {
                        var19_12.mHits = 1 + var19_12.mHits;
                        if (var19_12.isBlocking()) {
                            if (var6_6 < 0) return null;
                            return var19_12.getResult();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var15_9
lbl17:
                    // 2 sources

                    try {
                        var5_5.migrateExtraStreamToClipData();
                        var5_5.prepareToLeaveProcess();
                        var11_14 = ActivityManagerNative.getDefault();
                        var12_15 = var1_1.getBasePackageName();
                        var13_16 = var5_5.resolveTypeIfNeeded(var1_1.getContentResolver());
                        var14_17 = var4_4 != null ? var4_4.mEmbeddedID : null;
                        Instrumentation.checkStartActivityResult(var11_14.startActivity(var8_8, var12_15, var5_5, var13_16, var3_3, var14_17, var6_6, 0, null, var7_7), var5_5);
                        return null;
                    }
                    catch (RemoteException var9_18) {
                        return null;
                    }
                }
                ++var18_11;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActivityResult execStartActivity(Context var1_1, IBinder var2_2, IBinder var3_3, Activity var4_4, Intent var5_5, int var6_6, Bundle var7_7, UserHandle var8_8) {
        var9_9 = (IApplicationThread)var2_2;
        if (this.mActivityMonitors == null) ** GOTO lbl17
        var16_10 = this.mSync;
        synchronized (var16_10) {
            var18_11 = this.mActivityMonitors.size();
            var19_12 = 0;
            while (true) {
                if (var19_12 < var18_11) {
                    var20_13 = this.mActivityMonitors.get(var19_12);
                    if (var20_13.match(var1_1, null, var5_5)) {
                        var20_13.mHits = 1 + var20_13.mHits;
                        if (var20_13.isBlocking()) {
                            if (var6_6 < 0) return null;
                            return var20_13.getResult();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var16_10
lbl17:
                    // 2 sources

                    try {
                        var5_5.migrateExtraStreamToClipData();
                        var5_5.prepareToLeaveProcess();
                        var12_15 = ActivityManagerNative.getDefault();
                        var13_16 = var1_1.getBasePackageName();
                        var14_17 = var5_5.resolveTypeIfNeeded(var1_1.getContentResolver());
                        var15_18 = var4_4 != null ? var4_4.mEmbeddedID : null;
                        Instrumentation.checkStartActivityResult(var12_15.startActivityAsUser(var9_9, var13_16, var5_5, var14_17, var3_3, var15_18, var6_6, 0, null, var7_7, var8_8.getIdentifier()), var5_5);
                        return null;
                    }
                    catch (RemoteException var10_19) {
                        return null;
                    }
                }
                ++var19_12;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActivityResult execStartActivity(Context var1_1, IBinder var2_2, IBinder var3_3, Fragment var4_4, Intent var5_5, int var6_6, Bundle var7_7) {
        var8_8 = (IApplicationThread)var2_2;
        if (this.mActivityMonitors == null) ** GOTO lbl17
        var15_9 = this.mSync;
        synchronized (var15_9) {
            var17_10 = this.mActivityMonitors.size();
            var18_11 = 0;
            while (true) {
                if (var18_11 < var17_10) {
                    var19_12 = this.mActivityMonitors.get(var18_11);
                    if (var19_12.match(var1_1, null, var5_5)) {
                        var19_12.mHits = 1 + var19_12.mHits;
                        if (var19_12.isBlocking()) {
                            if (var6_6 < 0) return null;
                            return var19_12.getResult();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var15_9
lbl17:
                    // 2 sources

                    try {
                        var5_5.migrateExtraStreamToClipData();
                        var5_5.prepareToLeaveProcess();
                        var11_14 = ActivityManagerNative.getDefault();
                        var12_15 = var1_1.getBasePackageName();
                        var13_16 = var5_5.resolveTypeIfNeeded(var1_1.getContentResolver());
                        var14_17 = var4_4 != null ? var4_4.mWho : null;
                        Instrumentation.checkStartActivityResult(var11_14.startActivity(var8_8, var12_15, var5_5, var13_16, var3_3, var14_17, var6_6, 0, null, var7_7), var5_5);
                        return null;
                    }
                    catch (RemoteException var9_18) {
                        return null;
                    }
                }
                ++var18_11;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActivityResult execStartActivityAsCaller(Context var1_1, IBinder var2_2, IBinder var3_3, Activity var4_4, Intent var5_5, int var6_6, Bundle var7_7, int var8_8) {
        var9_9 = (IApplicationThread)var2_2;
        if (this.mActivityMonitors == null) ** GOTO lbl17
        var16_10 = this.mSync;
        synchronized (var16_10) {
            var18_11 = this.mActivityMonitors.size();
            var19_12 = 0;
            while (true) {
                if (var19_12 < var18_11) {
                    var20_13 = this.mActivityMonitors.get(var19_12);
                    if (var20_13.match(var1_1, null, var5_5)) {
                        var20_13.mHits = 1 + var20_13.mHits;
                        if (var20_13.isBlocking()) {
                            if (var6_6 < 0) return null;
                            return var20_13.getResult();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var16_10
lbl17:
                    // 2 sources

                    try {
                        var5_5.migrateExtraStreamToClipData();
                        var5_5.prepareToLeaveProcess();
                        var12_15 = ActivityManagerNative.getDefault();
                        var13_16 = var1_1.getBasePackageName();
                        var14_17 = var5_5.resolveTypeIfNeeded(var1_1.getContentResolver());
                        var15_18 = var4_4 != null ? var4_4.mEmbeddedID : null;
                        Instrumentation.checkStartActivityResult(var12_15.startActivityAsCaller(var9_9, var13_16, var5_5, var14_17, var3_3, var15_18, var6_6, 0, null, var7_7, var8_8), var5_5);
                        return null;
                    }
                    catch (RemoteException var10_19) {
                        return null;
                    }
                }
                ++var19_12;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execStartActivityFromAppTask(Context var1_1, IBinder var2_2, IAppTask var3_3, Intent var4_4, Bundle var5_5) {
        var6_6 = (IApplicationThread)var2_2;
        if (this.mActivityMonitors == null) ** GOTO lbl16
        var9_7 = this.mSync;
        synchronized (var9_7) {
            var11_8 = this.mActivityMonitors.size();
            var12_9 = 0;
            while (true) {
                if (var12_9 < var11_8) {
                    var13_10 = this.mActivityMonitors.get(var12_9);
                    if (var13_10.match(var1_1, null, var4_4)) {
                        var13_10.mHits = 1 + var13_10.mHits;
                        if (var13_10.isBlocking()) {
                            return;
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var9_7
lbl16:
                    // 2 sources

                    try {
                        var4_4.migrateExtraStreamToClipData();
                        var4_4.prepareToLeaveProcess();
                        Instrumentation.checkStartActivityResult(var3_3.startActivity(var6_6.asBinder(), var1_1.getBasePackageName(), var4_4, var4_4.resolveTypeIfNeeded(var1_1.getContentResolver()), var5_5), var4_4);
                        return;
                    }
                    catch (RemoteException var7_11) {
                        return;
                    }
                }
                ++var12_9;
            }
        }
    }

    public void finish(int n, Bundle bundle) {
        if (this.mAutomaticPerformanceSnapshots) {
            this.endPerformanceSnapshot();
        }
        if (this.mPerfMetrics != null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putAll(this.mPerfMetrics);
        }
        if (this.mUiAutomation != null) {
            this.mUiAutomation.disconnect();
            this.mUiAutomation = null;
        }
        this.mThread.finishInstrumentation(n, bundle);
    }

    public Bundle getAllocCounts() {
        Bundle bundle = new Bundle();
        bundle.putLong("global_alloc_count", Debug.getGlobalAllocCount());
        bundle.putLong("global_alloc_size", Debug.getGlobalAllocSize());
        bundle.putLong("global_freed_count", Debug.getGlobalFreedCount());
        bundle.putLong("global_freed_size", Debug.getGlobalFreedSize());
        bundle.putLong("gc_invocation_count", Debug.getGlobalGcInvocationCount());
        return bundle;
    }

    public Bundle getBinderCounts() {
        Bundle bundle = new Bundle();
        bundle.putLong("sent_transactions", Debug.getBinderSentTransactions());
        bundle.putLong("received_transactions", Debug.getBinderReceivedTransactions());
        return bundle;
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    public Context getContext() {
        return this.mInstrContext;
    }

    public Context getTargetContext() {
        return this.mAppContext;
    }

    public UiAutomation getUiAutomation() {
        if (this.mUiAutomationConnection != null) {
            if (this.mUiAutomation == null) {
                this.mUiAutomation = new UiAutomation(this.getTargetContext().getMainLooper(), this.mUiAutomationConnection);
                this.mUiAutomation.connect();
            }
            return this.mUiAutomation;
        }
        return null;
    }

    final void init(ActivityThread activityThread, Context context, Context context2, ComponentName componentName, IInstrumentationWatcher iInstrumentationWatcher, IUiAutomationConnection iUiAutomationConnection) {
        this.mThread = activityThread;
        this.mThread.getLooper();
        this.mMessageQueue = Looper.myQueue();
        this.mInstrContext = context;
        this.mAppContext = context2;
        this.mComponent = componentName;
        this.mWatcher = iInstrumentationWatcher;
        this.mUiAutomationConnection = iUiAutomationConnection;
    }

    public boolean invokeContextMenuAction(Activity activity, int n, int n2) {
        this.validateNotAppThread();
        this.sendKeySync(new KeyEvent(0, 23));
        this.waitForIdleSync();
        try {
            Thread.sleep(ViewConfiguration.getLongPressTimeout());
            this.sendKeySync(new KeyEvent(1, 23));
            this.waitForIdleSync();
            1ContextMenuRunnable contextMenuRunnable = new 1ContextMenuRunnable(activity, n, n2);
            this.runOnMainSync(contextMenuRunnable);
            return contextMenuRunnable.returnValue;
        }
        catch (InterruptedException interruptedException) {
            Log.e(TAG, "Could not sleep for long press timeout", interruptedException);
            return false;
        }
    }

    public boolean invokeMenuActionSync(Activity activity, int n, int n2) {
        1MenuRunnable menuRunnable = new 1MenuRunnable(activity, n, n2);
        this.runOnMainSync(menuRunnable);
        return menuRunnable.returnValue;
    }

    public boolean isProfiling() {
        return this.mThread.isProfiling();
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder iBinder, Application application, Intent intent, ActivityInfo activityInfo, CharSequence charSequence, Activity activity, String string2, Object object) throws InstantiationException, IllegalAccessException {
        Activity activity2 = (Activity)clazz.newInstance();
        activity2.attach(context, null, this, iBinder, 0, application, intent, activityInfo, charSequence, activity, string2, (Activity.NonConfigurationInstances)object, new Configuration(), null);
        return activity2;
    }

    public Activity newActivity(ClassLoader classLoader, String string2, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (Activity)classLoader.loadClass(string2).newInstance();
    }

    public Application newApplication(ClassLoader classLoader, String string2, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Instrumentation.newApplication(classLoader.loadClass(string2), context);
    }

    public void onCreate(Bundle bundle) {
    }

    public void onDestroy() {
    }

    public boolean onException(Object object, Throwable throwable) {
        return false;
    }

    public void onStart() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMonitor(ActivityMonitor activityMonitor) {
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(activityMonitor);
            return;
        }
    }

    public void runOnMainSync(Runnable runnable) {
        this.validateNotAppThread();
        SyncRunnable syncRunnable = new SyncRunnable(runnable);
        this.mThread.getHandler().post(syncRunnable);
        syncRunnable.waitForComplete();
    }

    public void sendCharacterSync(int n) {
        this.sendKeySync(new KeyEvent(0, n));
        this.sendKeySync(new KeyEvent(1, n));
    }

    public void sendKeyDownUpSync(int n) {
        this.sendKeySync(new KeyEvent(0, n));
        this.sendKeySync(new KeyEvent(1, n));
    }

    public void sendKeySync(KeyEvent keyEvent) {
        this.validateNotAppThread();
        long l = keyEvent.getDownTime();
        long l2 = keyEvent.getEventTime();
        int n = keyEvent.getAction();
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getRepeatCount();
        int n4 = keyEvent.getMetaState();
        int n5 = keyEvent.getDeviceId();
        int n6 = keyEvent.getScanCode();
        int n7 = keyEvent.getSource();
        int n8 = keyEvent.getFlags();
        if (n7 == 0) {
            n7 = 257;
        }
        if (l2 == 0L) {
            l2 = SystemClock.uptimeMillis();
        }
        if (l == 0L) {
            l = l2;
        }
        KeyEvent keyEvent2 = new KeyEvent(l, l2, n, n2, n3, n4, n5, n6, n8 | 8, n7);
        InputManager.getInstance().injectInputEvent(keyEvent2, 2);
    }

    public void sendPointerSync(MotionEvent motionEvent) {
        this.validateNotAppThread();
        if ((2 & motionEvent.getSource()) == 0) {
            motionEvent.setSource(4098);
        }
        InputManager.getInstance().injectInputEvent(motionEvent, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendStatus(int n, Bundle bundle) {
        if (this.mWatcher == null) return;
        try {
            this.mWatcher.instrumentationStatus(this.mComponent, n, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.mWatcher = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendStringSync(String string2) {
        KeyEvent[] keyEventArray;
        if (string2 != null && (keyEventArray = KeyCharacterMap.load(-1).getEvents(string2.toCharArray())) != null) {
            for (int i = 0; i < keyEventArray.length; ++i) {
                this.sendKeySync(KeyEvent.changeTimeRepeat(keyEventArray[i], SystemClock.uptimeMillis(), 0));
            }
        }
    }

    public void sendTrackballEventSync(MotionEvent motionEvent) {
        this.validateNotAppThread();
        if ((4 & motionEvent.getSource()) == 0) {
            motionEvent.setSource(65540);
        }
        InputManager.getInstance().injectInputEvent(motionEvent, 2);
    }

    public void setAutomaticPerformanceSnapshots() {
        this.mAutomaticPerformanceSnapshots = true;
        this.mPerformanceCollector = new PerformanceCollector();
    }

    public void setInTouchMode(boolean bl) {
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).setInTouchMode(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void start() {
        if (this.mRunner != null) {
            throw new RuntimeException("Instrumentation already started");
        }
        this.mRunner = new InstrumentationThread("Instr: " + this.getClass().getName());
        this.mRunner.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Activity startActivitySync(Intent intent) {
        ActivityInfo activityInfo;
        Intent intent2;
        block11: {
            this.validateNotAppThread();
            Object object = this.mSync;
            // MONITORENTER : object
            intent2 = new Intent(intent);
            activityInfo = intent2.resolveActivityInfo(this.getTargetContext().getPackageManager(), 0);
            if (activityInfo != null) break block11;
            throw new RuntimeException("Unable to resolve activity for: " + intent2);
        }
        String string2 = this.mThread.getProcessName();
        if (!activityInfo.processName.equals(string2)) {
            throw new RuntimeException("Intent in process " + string2 + " resolved to different process " + activityInfo.processName + ": " + intent2);
        }
        intent2.setComponent(new ComponentName(activityInfo.applicationInfo.packageName, activityInfo.name));
        ActivityWaiter activityWaiter = new ActivityWaiter(intent2);
        if (this.mWaitingActivities == null) {
            this.mWaitingActivities = new ArrayList<ActivityWaiter>();
        }
        this.mWaitingActivities.add(activityWaiter);
        this.getTargetContext().startActivity(intent2);
        do {
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {}
        } while (this.mWaitingActivities.contains(activityWaiter));
        Activity activity = activityWaiter.activity;
        // MONITOREXIT : object
        return activity;
    }

    public void startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    public void startPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerformanceCollector.beginSnapshot(null);
        }
    }

    public void startProfiling() {
        if (this.mThread.isProfiling()) {
            File file = new File(this.mThread.getProfileFilePath());
            file.getParentFile().mkdirs();
            Debug.startMethodTracing(file.toString(), 0x800000);
        }
    }

    public void stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    public void stopProfiling() {
        if (this.mThread.isProfiling()) {
            Debug.stopMethodTracing();
        }
    }

    public void waitForIdle(Runnable runnable) {
        this.mMessageQueue.addIdleHandler(new Idler(runnable));
        this.mThread.getHandler().post(new EmptyRunnable());
    }

    public void waitForIdleSync() {
        this.validateNotAppThread();
        Idler idler = new Idler(null);
        this.mMessageQueue.addIdleHandler(idler);
        this.mThread.getHandler().post(new EmptyRunnable());
        idler.waitForIdle();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Activity waitForMonitor(ActivityMonitor activityMonitor) {
        Activity activity = activityMonitor.waitForActivity();
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(activityMonitor);
            return activity;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Activity waitForMonitorWithTimeout(ActivityMonitor activityMonitor, long l) {
        Activity activity = activityMonitor.waitForActivityWithTimeout(l);
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(activityMonitor);
            return activity;
        }
    }

    class 1ContextMenuRunnable
    implements Runnable {
        private final Activity activity;
        private final int flags;
        private final int identifier;
        boolean returnValue;

        public 1ContextMenuRunnable(Activity activity, int n, int n2) {
            this.activity = activity;
            this.identifier = n;
            this.flags = n2;
        }

        @Override
        public void run() {
            this.returnValue = this.activity.getWindow().performContextMenuIdentifierAction(this.identifier, this.flags);
        }
    }

    class 1MenuRunnable
    implements Runnable {
        private final Activity activity;
        private final int flags;
        private final int identifier;
        boolean returnValue;

        public 1MenuRunnable(Activity activity, int n, int n2) {
            this.activity = activity;
            this.identifier = n;
            this.flags = n2;
        }

        @Override
        public void run() {
            this.returnValue = this.activity.getWindow().performPanelIdentifierAction(0, this.identifier, this.flags);
        }
    }

    private final class ActivityGoing
    implements MessageQueue.IdleHandler {
        private final ActivityWaiter mWaiter;

        public ActivityGoing(ActivityWaiter activityWaiter) {
            this.mWaiter = activityWaiter;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final boolean queueIdle() {
            Object object = Instrumentation.this.mSync;
            synchronized (object) {
                Instrumentation.this.mWaitingActivities.remove(this.mWaiter);
                Instrumentation.this.mSync.notifyAll();
                return false;
            }
        }
    }

    public static class ActivityMonitor {
        private final boolean mBlock;
        private final String mClass;
        int mHits = 0;
        Activity mLastActivity = null;
        private final ActivityResult mResult;
        private final IntentFilter mWhich;

        public ActivityMonitor(IntentFilter intentFilter, ActivityResult activityResult, boolean bl) {
            this.mWhich = intentFilter;
            this.mClass = null;
            this.mResult = activityResult;
            this.mBlock = bl;
        }

        public ActivityMonitor(String string2, ActivityResult activityResult, boolean bl) {
            this.mWhich = null;
            this.mClass = string2;
            this.mResult = activityResult;
            this.mBlock = bl;
        }

        public final IntentFilter getFilter() {
            return this.mWhich;
        }

        public final int getHits() {
            return this.mHits;
        }

        public final Activity getLastActivity() {
            return this.mLastActivity;
        }

        public final ActivityResult getResult() {
            return this.mResult;
        }

        public final boolean isBlocking() {
            return this.mBlock;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final boolean match(Context context, Activity activity, Intent intent) {
            synchronized (this) {
                if (this.mWhich != null && this.mWhich.match(context.getContentResolver(), intent, true, Instrumentation.TAG) < 0) {
                    return false;
                }
                if (this.mClass != null) {
                    String string2;
                    if (activity != null) {
                        string2 = activity.getClass().getName();
                    } else {
                        ComponentName componentName = intent.getComponent();
                        string2 = null;
                        if (componentName != null) {
                            string2 = intent.getComponent().getClassName();
                        }
                    }
                    if (string2 == null || !this.mClass.equals(string2)) {
                        return false;
                    }
                }
                if (activity != null) {
                    this.mLastActivity = activity;
                    this.notifyAll();
                }
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Activity waitForActivity() {
            synchronized (this) {
                while (true) {
                    Activity activity;
                    if ((activity = this.mLastActivity) != null) {
                        Activity activity2 = this.mLastActivity;
                        this.mLastActivity = null;
                        return activity2;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Activity waitForActivityWithTimeout(long l) {
            synchronized (this) {
                Activity activity = this.mLastActivity;
                if (activity == null) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.mLastActivity == null) {
                    return null;
                }
                Activity activity2 = this.mLastActivity;
                this.mLastActivity = null;
                return activity2;
            }
        }
    }

    public static final class ActivityResult {
        private final int mResultCode;
        private final Intent mResultData;

        public ActivityResult(int n, Intent intent) {
            this.mResultCode = n;
            this.mResultData = intent;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public Intent getResultData() {
            return this.mResultData;
        }
    }

    private static final class ActivityWaiter {
        public Activity activity;
        public final Intent intent;

        public ActivityWaiter(Intent intent) {
            this.intent = intent;
        }
    }

    private static final class EmptyRunnable
    implements Runnable {
        private EmptyRunnable() {
        }

        @Override
        public void run() {
        }
    }

    private static final class Idler
    implements MessageQueue.IdleHandler {
        private final Runnable mCallback;
        private boolean mIdle;

        public Idler(Runnable runnable) {
            this.mCallback = runnable;
            this.mIdle = false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final boolean queueIdle() {
            if (this.mCallback != null) {
                this.mCallback.run();
            }
            synchronized (this) {
                this.mIdle = true;
                this.notifyAll();
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitForIdle() {
            synchronized (this) {
                boolean bl;
                while (!(bl = this.mIdle)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return;
            }
        }
    }

    private final class InstrumentationThread
    extends Thread {
        public InstrumentationThread(String string2) {
            super(string2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Process.setThreadPriority(-8);
            }
            catch (RuntimeException runtimeException) {
                Log.w(Instrumentation.TAG, "Exception setting priority of instrumentation thread " + Process.myTid(), runtimeException);
            }
            if (Instrumentation.this.mAutomaticPerformanceSnapshots) {
                Instrumentation.this.startPerformanceSnapshot();
            }
            Instrumentation.this.onStart();
        }
    }

    private static final class SyncRunnable
    implements Runnable {
        private boolean mComplete;
        private final Runnable mTarget;

        public SyncRunnable(Runnable runnable) {
            this.mTarget = runnable;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.mTarget.run();
            synchronized (this) {
                this.mComplete = true;
                this.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitForComplete() {
            synchronized (this) {
                boolean bl;
                while (!(bl = this.mComplete)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return;
            }
        }
    }
}

