/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Notification;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

public final class RemoteInput
implements Parcelable {
    public static final Parcelable.Creator<RemoteInput> CREATOR = new Parcelable.Creator<RemoteInput>(){

        @Override
        public RemoteInput createFromParcel(Parcel parcel) {
            return new RemoteInput(parcel);
        }

        public RemoteInput[] newArray(int n) {
            return new RemoteInput[n];
        }
    };
    private static final int DEFAULT_FLAGS = 1;
    public static final String EXTRA_RESULTS_DATA = "android.remoteinput.resultsData";
    private static final int FLAG_ALLOW_FREE_FORM_INPUT = 1;
    public static final String RESULTS_CLIP_LABEL = "android.remoteinput.results";
    private final CharSequence[] mChoices;
    private final Bundle mExtras;
    private final int mFlags;
    private final CharSequence mLabel;
    private final String mResultKey;

    private RemoteInput(Parcel parcel) {
        this.mResultKey = parcel.readString();
        this.mLabel = parcel.readCharSequence();
        this.mChoices = parcel.readCharSequenceArray();
        this.mFlags = parcel.readInt();
        this.mExtras = parcel.readBundle();
    }

    private RemoteInput(String string2, CharSequence charSequence, CharSequence[] charSequenceArray, int n, Bundle bundle) {
        this.mResultKey = string2;
        this.mLabel = charSequence;
        this.mChoices = charSequenceArray;
        this.mFlags = n;
        this.mExtras = bundle;
    }

    public static void addResultsToIntent(RemoteInput[] remoteInputArray, Intent intent, Bundle bundle) {
        Bundle bundle2 = new Bundle();
        for (RemoteInput remoteInput : remoteInputArray) {
            Object object = bundle.get(remoteInput.getResultKey());
            if (!(object instanceof CharSequence)) continue;
            bundle2.putCharSequence(remoteInput.getResultKey(), (CharSequence)object);
        }
        Intent intent2 = new Intent();
        intent2.putExtra(EXTRA_RESULTS_DATA, bundle2);
        intent.setClipData(ClipData.newIntent(RESULTS_CLIP_LABEL, intent2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bundle getResultsFromIntent(Intent intent) {
        ClipDescription clipDescription;
        ClipData clipData = intent.getClipData();
        if (clipData == null || !(clipDescription = clipData.getDescription()).hasMimeType("text/vnd.android.intent") || !clipDescription.getLabel().equals(RESULTS_CLIP_LABEL)) {
            return null;
        }
        return (Bundle)clipData.getItemAt(0).getIntent().getExtras().getParcelable(EXTRA_RESULTS_DATA);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean getAllowFreeFormInput() {
        return (1 & this.mFlags) != 0;
    }

    public CharSequence[] getChoices() {
        return this.mChoices;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public String getResultKey() {
        return this.mResultKey;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mResultKey);
        parcel.writeCharSequence(this.mLabel);
        parcel.writeCharSequenceArray(this.mChoices);
        parcel.writeInt(this.mFlags);
        parcel.writeBundle(this.mExtras);
    }

    public static final class Builder {
        private CharSequence[] mChoices;
        private Bundle mExtras = new Bundle();
        private int mFlags = 1;
        private CharSequence mLabel;
        private final String mResultKey;

        public Builder(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Result key can't be null");
            }
            this.mResultKey = string2;
        }

        private void setFlag(int n, boolean bl) {
            if (bl) {
                this.mFlags = n | this.mFlags;
                return;
            }
            this.mFlags &= ~n;
        }

        public Builder addExtras(Bundle bundle) {
            if (bundle != null) {
                this.mExtras.putAll(bundle);
            }
            return this;
        }

        public RemoteInput build() {
            return new RemoteInput(this.mResultKey, this.mLabel, this.mChoices, this.mFlags, this.mExtras);
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public Builder setAllowFreeFormInput(boolean bl) {
            this.setFlag(this.mFlags, bl);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder setChoices(CharSequence[] charSequenceArray) {
            if (charSequenceArray == null) {
                this.mChoices = null;
                return this;
            } else {
                this.mChoices = new CharSequence[charSequenceArray.length];
                for (int i = 0; i < charSequenceArray.length; ++i) {
                    this.mChoices[i] = Notification.safeCharSequence(charSequenceArray[i]);
                }
            }
            return this;
        }

        public Builder setLabel(CharSequence charSequence) {
            this.mLabel = Notification.safeCharSequence(charSequence);
            return this;
        }
    }
}

