/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;

public class DeviceAdminReceiver
extends BroadcastReceiver {
    public static final String ACTION_DEVICE_ADMIN_DISABLED = "android.app.action.DEVICE_ADMIN_DISABLED";
    public static final String ACTION_DEVICE_ADMIN_DISABLE_REQUESTED = "android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED";
    public static final String ACTION_DEVICE_ADMIN_ENABLED = "android.app.action.DEVICE_ADMIN_ENABLED";
    public static final String ACTION_LOCK_TASK_ENTERING = "android.app.action.LOCK_TASK_ENTERING";
    public static final String ACTION_LOCK_TASK_EXITING = "android.app.action.LOCK_TASK_EXITING";
    public static final String ACTION_PASSWORD_CHANGED = "android.app.action.ACTION_PASSWORD_CHANGED";
    public static final String ACTION_PASSWORD_EXPIRING = "android.app.action.ACTION_PASSWORD_EXPIRING";
    public static final String ACTION_PASSWORD_FAILED = "android.app.action.ACTION_PASSWORD_FAILED";
    public static final String ACTION_PASSWORD_SUCCEEDED = "android.app.action.ACTION_PASSWORD_SUCCEEDED";
    public static final String ACTION_PROFILE_PROVISIONING_COMPLETE = "android.app.action.PROFILE_PROVISIONING_COMPLETE";
    public static final String DEVICE_ADMIN_META_DATA = "android.app.device_admin";
    public static final String EXTRA_DISABLE_WARNING = "android.app.extra.DISABLE_WARNING";
    public static final String EXTRA_LOCK_TASK_PACKAGE = "android.app.extra.LOCK_TASK_PACKAGE";
    private static String TAG = "DevicePolicy";
    private static boolean localLOGV = false;
    private DevicePolicyManager mManager;
    private ComponentName mWho;

    public DevicePolicyManager getManager(Context context) {
        if (this.mManager != null) {
            return this.mManager;
        }
        this.mManager = (DevicePolicyManager)context.getSystemService("device_policy");
        return this.mManager;
    }

    public ComponentName getWho(Context context) {
        if (this.mWho != null) {
            return this.mWho;
        }
        this.mWho = new ComponentName(context, this.getClass());
        return this.mWho;
    }

    public CharSequence onDisableRequested(Context context, Intent intent) {
        return null;
    }

    public void onDisabled(Context context, Intent intent) {
    }

    public void onEnabled(Context context, Intent intent) {
    }

    public void onLockTaskModeEntering(Context context, Intent intent, String string2) {
    }

    public void onLockTaskModeExiting(Context context, Intent intent) {
    }

    public void onPasswordChanged(Context context, Intent intent) {
    }

    public void onPasswordExpiring(Context context, Intent intent) {
    }

    public void onPasswordFailed(Context context, Intent intent) {
    }

    public void onPasswordSucceeded(Context context, Intent intent) {
    }

    public void onProfileProvisioningComplete(Context context, Intent intent) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getAction();
        if (ACTION_PASSWORD_CHANGED.equals(string2)) {
            this.onPasswordChanged(context, intent);
            return;
        } else {
            if (ACTION_PASSWORD_FAILED.equals(string2)) {
                this.onPasswordFailed(context, intent);
                return;
            }
            if (ACTION_PASSWORD_SUCCEEDED.equals(string2)) {
                this.onPasswordSucceeded(context, intent);
                return;
            }
            if (ACTION_DEVICE_ADMIN_ENABLED.equals(string2)) {
                this.onEnabled(context, intent);
                return;
            }
            if (ACTION_DEVICE_ADMIN_DISABLE_REQUESTED.equals(string2)) {
                CharSequence charSequence = this.onDisableRequested(context, intent);
                if (charSequence == null) return;
                this.getResultExtras(true).putCharSequence(EXTRA_DISABLE_WARNING, charSequence);
                return;
            } else {
                if (ACTION_DEVICE_ADMIN_DISABLED.equals(string2)) {
                    this.onDisabled(context, intent);
                    return;
                }
                if (ACTION_PASSWORD_EXPIRING.equals(string2)) {
                    this.onPasswordExpiring(context, intent);
                    return;
                }
                if (ACTION_PROFILE_PROVISIONING_COMPLETE.equals(string2)) {
                    this.onProfileProvisioningComplete(context, intent);
                    return;
                }
                if (ACTION_LOCK_TASK_ENTERING.equals(string2)) {
                    this.onLockTaskModeEntering(context, intent, intent.getStringExtra(EXTRA_LOCK_TASK_PACKAGE));
                    return;
                }
                if (!ACTION_LOCK_TASK_EXITING.equals(string2)) return;
                this.onLockTaskModeExiting(context, intent);
                return;
            }
        }
    }
}

