/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.util.ArrayMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class UsageStatsManager {
    public static final int INTERVAL_BEST = 4;
    public static final int INTERVAL_COUNT = 4;
    public static final int INTERVAL_DAILY = 0;
    public static final int INTERVAL_MONTHLY = 2;
    public static final int INTERVAL_WEEKLY = 1;
    public static final int INTERVAL_YEARLY = 3;
    private static final UsageEvents sEmptyResults = new UsageEvents();
    private final Context mContext;
    private final IUsageStatsManager mService;

    public UsageStatsManager(Context context, IUsageStatsManager iUsageStatsManager) {
        this.mContext = context;
        this.mService = iUsageStatsManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, UsageStats> queryAndAggregateUsageStats(long l, long l2) {
        List<UsageStats> list = this.queryUsageStats(4, l, l2);
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, UsageStats> map = new ArrayMap<String, UsageStats>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            UsageStats usageStats = list.get(n2);
            UsageStats usageStats2 = (UsageStats)((ArrayMap)map).get(usageStats.getPackageName());
            if (usageStats2 == null) {
                ((ArrayMap)map).put(usageStats.mPackageName, usageStats);
            } else {
                usageStats2.add(usageStats);
            }
            ++n2;
        }
        return map;
    }

    public List<ConfigurationStats> queryConfigurations(int n, long l, long l2) {
        block3: {
            ParceledListSlice parceledListSlice = this.mService.queryConfigurationStats(n, l, l2, this.mContext.getOpPackageName());
            if (parceledListSlice == null) break block3;
            try {
                List<ConfigurationStats> list = parceledListSlice.getList();
                return list;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public UsageEvents queryEvents(long l, long l2) {
        try {
            UsageEvents usageEvents = this.mService.queryEvents(l, l2, this.mContext.getOpPackageName());
            if (usageEvents != null) {
                return usageEvents;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    public List<UsageStats> queryUsageStats(int n, long l, long l2) {
        block3: {
            ParceledListSlice parceledListSlice = this.mService.queryUsageStats(n, l, l2, this.mContext.getOpPackageName());
            if (parceledListSlice == null) break block3;
            try {
                List<UsageStats> list = parceledListSlice.getList();
                return list;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

