/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothGattCharacteristic;
import java.util.UUID;

public class BluetoothGattDescriptor {
    public static final byte[] DISABLE_NOTIFICATION_VALUE;
    public static final byte[] ENABLE_INDICATION_VALUE;
    public static final byte[] ENABLE_NOTIFICATION_VALUE;
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_READ_ENCRYPTED = 2;
    public static final int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static final int PERMISSION_WRITE = 16;
    public static final int PERMISSION_WRITE_ENCRYPTED = 32;
    public static final int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static final int PERMISSION_WRITE_SIGNED = 128;
    public static final int PERMISSION_WRITE_SIGNED_MITM = 256;
    protected BluetoothGattCharacteristic mCharacteristic;
    protected int mInstance;
    protected int mPermissions;
    protected UUID mUuid;
    protected byte[] mValue;

    static {
        ENABLE_NOTIFICATION_VALUE = new byte[]{1, 0};
        ENABLE_INDICATION_VALUE = new byte[]{2, 0};
        DISABLE_NOTIFICATION_VALUE = new byte[]{0, 0};
    }

    BluetoothGattDescriptor(BluetoothGattCharacteristic bluetoothGattCharacteristic, UUID uUID, int n, int n2) {
        this.initDescriptor(bluetoothGattCharacteristic, uUID, n, n2);
    }

    public BluetoothGattDescriptor(UUID uUID, int n) {
        this.initDescriptor(null, uUID, 0, n);
    }

    private void initDescriptor(BluetoothGattCharacteristic bluetoothGattCharacteristic, UUID uUID, int n, int n2) {
        this.mCharacteristic = bluetoothGattCharacteristic;
        this.mUuid = uUID;
        this.mInstance = n;
        this.mPermissions = n2;
    }

    public BluetoothGattCharacteristic getCharacteristic() {
        return this.mCharacteristic;
    }

    public int getInstanceId() {
        return this.mInstance;
    }

    public int getPermissions() {
        return this.mPermissions;
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public byte[] getValue() {
        return this.mValue;
    }

    void setCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        this.mCharacteristic = bluetoothGattCharacteristic;
    }

    public boolean setValue(byte[] byArray) {
        this.mValue = byArray;
        return true;
    }
}

