/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;

public final class BluetoothHeadsetClientCall
implements Parcelable {
    public static final int CALL_STATE_ACTIVE = 0;
    public static final int CALL_STATE_ALERTING = 3;
    public static final int CALL_STATE_DIALING = 2;
    public static final int CALL_STATE_HELD = 1;
    public static final int CALL_STATE_HELD_BY_RESPONSE_AND_HOLD = 6;
    public static final int CALL_STATE_INCOMING = 4;
    public static final int CALL_STATE_TERMINATED = 7;
    public static final int CALL_STATE_WAITING = 5;
    public static final Parcelable.Creator<BluetoothHeadsetClientCall> CREATOR = new Parcelable.Creator<BluetoothHeadsetClientCall>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public BluetoothHeadsetClientCall createFromParcel(Parcel parcel) {
            int n = 1;
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            String string2 = parcel.readString();
            int n4 = parcel.readInt() == n ? n : 0;
            if (parcel.readInt() == n) {
                return new BluetoothHeadsetClientCall(n2, n3, string2, n4 != 0, n != 0);
            }
            n = 0;
            return new BluetoothHeadsetClientCall(n2, n3, string2, n4 != 0, n != 0);
        }

        public BluetoothHeadsetClientCall[] newArray(int n) {
            return new BluetoothHeadsetClientCall[n];
        }
    };
    private final int mId;
    private boolean mMultiParty;
    private String mNumber;
    private final boolean mOutgoing;
    private int mState;

    /*
     * Enabled aggressive block sorting
     */
    public BluetoothHeadsetClientCall(int n, int n2, String string2, boolean bl, boolean bl2) {
        this.mId = n;
        this.mState = n2;
        if (string2 == null) {
            string2 = "";
        }
        this.mNumber = string2;
        this.mMultiParty = bl;
        this.mOutgoing = bl2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getId() {
        return this.mId;
    }

    public String getNumber() {
        return this.mNumber;
    }

    public int getState() {
        return this.mState;
    }

    public boolean isMultiParty() {
        return this.mMultiParty;
    }

    public boolean isOutgoing() {
        return this.mOutgoing;
    }

    public void setMultiParty(boolean bl) {
        this.mMultiParty = bl;
    }

    public void setNumber(String string2) {
        this.mNumber = string2;
    }

    public void setState(int n) {
        this.mState = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("BluetoothHeadsetClientCall{mId: ");
        stringBuilder.append(this.mId);
        stringBuilder.append(", mState: ");
        switch (this.mState) {
            default: {
                stringBuilder.append(this.mState);
                break;
            }
            case 0: {
                stringBuilder.append("ACTIVE");
                break;
            }
            case 1: {
                stringBuilder.append("HELD");
                break;
            }
            case 2: {
                stringBuilder.append("DIALING");
                break;
            }
            case 3: {
                stringBuilder.append("ALERTING");
                break;
            }
            case 4: {
                stringBuilder.append("INCOMING");
                break;
            }
            case 5: {
                stringBuilder.append("WAITING");
                break;
            }
            case 6: {
                stringBuilder.append("HELD_BY_RESPONSE_AND_HOLD");
                break;
            }
            case 7: {
                stringBuilder.append("TERMINATED");
            }
        }
        stringBuilder.append(", mNumber: ");
        stringBuilder.append(this.mNumber);
        stringBuilder.append(", mMultiParty: ");
        stringBuilder.append(this.mMultiParty);
        stringBuilder.append(", mOutgoing: ");
        stringBuilder.append(this.mOutgoing);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mState);
        parcel.writeString(this.mNumber);
        int n3 = this.mMultiParty ? n2 : 0;
        parcel.writeInt(n3);
        if (!this.mOutgoing) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

