/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Context;
import android.content.IRestrictionsManager;
import android.content.Intent;
import android.content.RestrictionEntry;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class RestrictionsManager {
    public static final String ACTION_PERMISSION_RESPONSE_RECEIVED = "android.content.action.PERMISSION_RESPONSE_RECEIVED";
    public static final String ACTION_REQUEST_LOCAL_APPROVAL = "android.content.action.REQUEST_LOCAL_APPROVAL";
    public static final String ACTION_REQUEST_PERMISSION = "android.content.action.REQUEST_PERMISSION";
    public static final String EXTRA_PACKAGE_NAME = "android.content.extra.PACKAGE_NAME";
    public static final String EXTRA_REQUEST_BUNDLE = "android.content.extra.REQUEST_BUNDLE";
    public static final String EXTRA_REQUEST_ID = "android.content.extra.REQUEST_ID";
    public static final String EXTRA_REQUEST_TYPE = "android.content.extra.REQUEST_TYPE";
    public static final String EXTRA_RESPONSE_BUNDLE = "android.content.extra.RESPONSE_BUNDLE";
    public static final String META_DATA_APP_RESTRICTIONS = "android.content.APP_RESTRICTIONS";
    public static final String REQUEST_KEY_APPROVE_LABEL = "android.request.approve_label";
    public static final String REQUEST_KEY_DATA = "android.request.data";
    public static final String REQUEST_KEY_DENY_LABEL = "android.request.deny_label";
    public static final String REQUEST_KEY_ICON = "android.request.icon";
    public static final String REQUEST_KEY_ID = "android.request.id";
    public static final String REQUEST_KEY_MESSAGE = "android.request.mesg";
    public static final String REQUEST_KEY_NEW_REQUEST = "android.request.new_request";
    public static final String REQUEST_KEY_TITLE = "android.request.title";
    public static final String REQUEST_TYPE_APPROVAL = "android.request.type.approval";
    public static final String RESPONSE_KEY_ERROR_CODE = "android.response.errorcode";
    public static final String RESPONSE_KEY_MESSAGE = "android.response.msg";
    public static final String RESPONSE_KEY_RESPONSE_TIMESTAMP = "android.response.timestamp";
    public static final String RESPONSE_KEY_RESULT = "android.response.result";
    public static final int RESULT_APPROVED = 1;
    public static final int RESULT_DENIED = 2;
    public static final int RESULT_ERROR = 5;
    public static final int RESULT_ERROR_BAD_REQUEST = 1;
    public static final int RESULT_ERROR_INTERNAL = 3;
    public static final int RESULT_ERROR_NETWORK = 2;
    public static final int RESULT_NO_RESPONSE = 3;
    public static final int RESULT_UNKNOWN_REQUEST = 4;
    private static final String TAG = "RestrictionsManager";
    private static final String TAG_RESTRICTION = "restriction";
    private final Context mContext;
    private final IRestrictionsManager mService;

    public RestrictionsManager(Context context, IRestrictionsManager iRestrictionsManager) {
        this.mContext = context;
        this.mService = iRestrictionsManager;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<RestrictionEntry> loadManifestRestrictions(String string2, XmlResourceParser xmlResourceParser) {
        Context context = this.mContext.createPackageContext(string2, 0);
        ArrayList<RestrictionEntry> arrayList = new ArrayList<RestrictionEntry>();
        int n = xmlResourceParser.next();
        while (n != 1) {
            int n2;
            RestrictionEntry restrictionEntry;
            AttributeSet attributeSet;
            if (n == 2 && xmlResourceParser.getName().equals(TAG_RESTRICTION) && (attributeSet = Xml.asAttributeSet(xmlResourceParser)) != null && (restrictionEntry = this.loadRestriction(context, context.obtainStyledAttributes(attributeSet, R.styleable.RestrictionEntry))) != null) {
                arrayList.add(restrictionEntry);
            }
            n = n2 = xmlResourceParser.next();
        }
        return arrayList;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.w(TAG, "Reading restriction metadata for " + string2, xmlPullParserException);
            return null;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Reading restriction metadata for " + string2, iOException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private RestrictionEntry loadRestriction(Context context, TypedArray typedArray) {
        RestrictionEntry restrictionEntry = null;
        String string2 = typedArray.getString(3);
        int n = typedArray.getInt(6, -1);
        String string3 = typedArray.getString(2);
        String string4 = typedArray.getString(0);
        int n2 = typedArray.getResourceId(1, 0);
        int n3 = typedArray.getResourceId(5, 0);
        if (n == -1) {
            Log.w(TAG, "restrictionType cannot be omitted");
            return restrictionEntry;
        }
        if (string2 == null) {
            Log.w(TAG, "key cannot be omitted");
            return null;
        }
        restrictionEntry = new RestrictionEntry(n, string2);
        restrictionEntry.setTitle(string3);
        restrictionEntry.setDescription(string4);
        if (n2 != 0) {
            restrictionEntry.setChoiceEntries(context, n2);
        }
        if (n3 != 0) {
            restrictionEntry.setChoiceValues(context, n3);
        }
        switch (n) {
            default: {
                Log.w(TAG, "Unknown restriction type " + n);
                return restrictionEntry;
            }
            case 0: 
            case 2: 
            case 6: {
                restrictionEntry.setSelectedString(typedArray.getString(4));
                return restrictionEntry;
            }
            case 5: {
                restrictionEntry.setIntValue(typedArray.getInt(4, 0));
                return restrictionEntry;
            }
            case 4: {
                int n4 = typedArray.getResourceId(4, 0);
                if (n4 == 0) return restrictionEntry;
                restrictionEntry.setAllSelectedStrings(context.getResources().getStringArray(n4));
                return restrictionEntry;
            }
            case 1: 
        }
        restrictionEntry.setSelectedState(typedArray.getBoolean(4, false));
        return restrictionEntry;
    }

    public Intent createLocalApprovalIntent() {
        try {
            if (this.mService != null) {
                Intent intent = this.mService.createLocalApprovalIntent();
                return intent;
            }
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Couldn't reach service");
        }
        return null;
    }

    public Bundle getApplicationRestrictions() {
        try {
            if (this.mService != null) {
                Bundle bundle = this.mService.getApplicationRestrictions(this.mContext.getPackageName());
                return bundle;
            }
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Couldn't reach service");
        }
        return null;
    }

    public List<RestrictionEntry> getManifestRestrictions(String string2) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = this.mContext.getPackageManager().getApplicationInfo(string2, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalArgumentException("No such package " + string2);
        }
        if (applicationInfo == null || !applicationInfo.metaData.containsKey(META_DATA_APP_RESTRICTIONS)) {
            return null;
        }
        return this.loadManifestRestrictions(string2, applicationInfo.loadXmlMetaData(this.mContext.getPackageManager(), META_DATA_APP_RESTRICTIONS));
    }

    public boolean hasRestrictionsProvider() {
        try {
            if (this.mService != null) {
                boolean bl = this.mService.hasRestrictionsProvider();
                return bl;
            }
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Couldn't reach service");
        }
        return false;
    }

    public void notifyPermissionResponse(String string2, PersistableBundle persistableBundle) {
        if (string2 == null) {
            throw new NullPointerException("packageName cannot be null");
        }
        if (persistableBundle == null) {
            throw new NullPointerException("request cannot be null");
        }
        if (!persistableBundle.containsKey(REQUEST_KEY_ID)) {
            throw new IllegalArgumentException("REQUEST_KEY_ID must be specified");
        }
        if (!persistableBundle.containsKey(RESPONSE_KEY_RESULT)) {
            throw new IllegalArgumentException("RESPONSE_KEY_RESULT must be specified");
        }
        try {
            if (this.mService != null) {
                this.mService.notifyPermissionResponse(string2, persistableBundle);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Couldn't reach service");
            return;
        }
    }

    public void requestPermission(String string2, String string3, PersistableBundle persistableBundle) {
        if (string2 == null) {
            throw new NullPointerException("requestType cannot be null");
        }
        if (string3 == null) {
            throw new NullPointerException("requestId cannot be null");
        }
        if (persistableBundle == null) {
            throw new NullPointerException("request cannot be null");
        }
        try {
            if (this.mService != null) {
                this.mService.requestPermission(this.mContext.getPackageName(), string2, string3, persistableBundle);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Couldn't reach service");
            return;
        }
    }
}

