/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.util.Printer;

public class ComponentInfo
extends PackageItemInfo {
    public ApplicationInfo applicationInfo;
    public int descriptionRes;
    public boolean enabled;
    public boolean exported;
    public String processName;

    public ComponentInfo() {
        this.enabled = true;
        this.exported = false;
    }

    public ComponentInfo(ComponentInfo componentInfo) {
        super(componentInfo);
        this.enabled = true;
        this.exported = false;
        this.applicationInfo = componentInfo.applicationInfo;
        this.processName = componentInfo.processName;
        this.descriptionRes = componentInfo.descriptionRes;
        this.enabled = componentInfo.enabled;
        this.exported = componentInfo.exported;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ComponentInfo(Parcel parcel) {
        boolean bl = true;
        super(parcel);
        this.enabled = bl;
        this.exported = false;
        this.applicationInfo = ApplicationInfo.CREATOR.createFromParcel(parcel);
        this.processName = parcel.readString();
        this.descriptionRes = parcel.readInt();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.enabled = bl2;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.exported = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dumpBack(Printer printer, String string2) {
        if (this.applicationInfo != null) {
            printer.println(string2 + "ApplicationInfo:");
            this.applicationInfo.dump(printer, string2 + "  ");
        } else {
            printer.println(string2 + "ApplicationInfo: null");
        }
        super.dumpBack(printer, string2);
    }

    @Override
    protected void dumpFront(Printer printer, String string2) {
        super.dumpFront(printer, string2);
        printer.println(string2 + "enabled=" + this.enabled + " exported=" + this.exported + " processName=" + this.processName);
        if (this.descriptionRes != 0) {
            printer.println(string2 + "description=" + this.descriptionRes);
        }
    }

    @Override
    protected ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public final int getBannerResource() {
        if (this.banner != 0) {
            return this.banner;
        }
        return this.applicationInfo.banner;
    }

    public final int getIconResource() {
        if (this.icon != 0) {
            return this.icon;
        }
        return this.applicationInfo.icon;
    }

    public final int getLogoResource() {
        if (this.logo != 0) {
            return this.logo;
        }
        return this.applicationInfo.logo;
    }

    public boolean isEnabled() {
        return this.enabled && this.applicationInfo.enabled;
    }

    @Override
    protected Drawable loadDefaultBanner(PackageManager packageManager) {
        return this.applicationInfo.loadBanner(packageManager);
    }

    @Override
    public Drawable loadDefaultIcon(PackageManager packageManager) {
        return this.applicationInfo.loadIcon(packageManager);
    }

    @Override
    protected Drawable loadDefaultLogo(PackageManager packageManager) {
        return this.applicationInfo.loadLogo(packageManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence loadLabel(PackageManager packageManager) {
        CharSequence charSequence;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        ApplicationInfo applicationInfo = this.applicationInfo;
        if (this.labelRes != 0) {
            charSequence = packageManager.getText(this.packageName, this.labelRes, applicationInfo);
            if (charSequence != null) return charSequence;
        }
        if (applicationInfo.nonLocalizedLabel != null) {
            return applicationInfo.nonLocalizedLabel;
        }
        if (applicationInfo.labelRes == 0) return this.name;
        charSequence = packageManager.getText(this.packageName, applicationInfo.labelRes, applicationInfo);
        if (charSequence != null) return charSequence;
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        super.writeToParcel(parcel, n);
        this.applicationInfo.writeToParcel(parcel, n);
        parcel.writeString(this.processName);
        parcel.writeInt(this.descriptionRes);
        int n3 = this.enabled ? n2 : 0;
        parcel.writeInt(n3);
        if (!this.exported) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

