/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPackageInstallerCallback
extends IInterface {
    public void onSessionActiveChanged(int var1, boolean var2) throws RemoteException;

    public void onSessionBadgingChanged(int var1) throws RemoteException;

    public void onSessionCreated(int var1) throws RemoteException;

    public void onSessionFinished(int var1, boolean var2) throws RemoteException;

    public void onSessionProgressChanged(int var1, float var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPackageInstallerCallback {
        private static final String DESCRIPTOR = "android.content.pm.IPackageInstallerCallback";
        static final int TRANSACTION_onSessionActiveChanged = 3;
        static final int TRANSACTION_onSessionBadgingChanged = 2;
        static final int TRANSACTION_onSessionCreated = 1;
        static final int TRANSACTION_onSessionFinished = 5;
        static final int TRANSACTION_onSessionProgressChanged = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPackageInstallerCallback asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IPackageInstallerCallback) {
                return (IPackageInstallerCallback)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onSessionCreated(parcel.readInt());
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onSessionBadgingChanged(parcel.readInt());
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    this.onSessionActiveChanged(n3, bl);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onSessionProgressChanged(parcel.readInt(), parcel.readFloat());
                    return true;
                }
                case 5: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            boolean bl = false;
            if (n6 != 0) {
                bl = true;
            }
            this.onSessionFinished(n5, bl);
            return true;
        }

        private static class Proxy
        implements IPackageInstallerCallback {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onSessionActiveChanged(int n, boolean bl) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (!bl) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(3, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void onSessionBadgingChanged(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onSessionCreated(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onSessionFinished(int n, boolean bl) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (!bl) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(5, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void onSessionProgressChanged(int n, float f) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeFloat(f);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

