/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class ParceledListSlice<T extends Parcelable>
implements Parcelable {
    public static final Parcelable.ClassLoaderCreator<ParceledListSlice> CREATOR;
    private static boolean DEBUG = false;
    private static final int MAX_FIRST_IPC_SIZE = 131072;
    private static final int MAX_IPC_SIZE = 262144;
    private static String TAG;
    private final List<T> mList;

    static {
        TAG = "ParceledListSlice";
        DEBUG = false;
        CREATOR = new Parcelable.ClassLoaderCreator<ParceledListSlice>(){

            @Override
            public ParceledListSlice createFromParcel(Parcel parcel) {
                return new ParceledListSlice(parcel, null);
            }

            @Override
            public ParceledListSlice createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new ParceledListSlice(parcel, classLoader);
            }

            public ParceledListSlice[] newArray(int n) {
                return new ParceledListSlice[n];
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParceledListSlice(Parcel parcel, ClassLoader classLoader) {
        IBinder iBinder;
        int n = parcel.readInt();
        this.mList = new ArrayList<T>(n);
        if (DEBUG) {
            Log.d(TAG, "Retrieving " + n + " items");
        }
        if (n <= 0) return;
        Parcelable.Creator creator = parcel.readParcelableCreator(classLoader);
        Class<?> clazz = null;
        int n2 = 0;
        while (true) {
            if (n2 >= n || parcel.readInt() == 0) {
                if (n2 >= n) return;
                iBinder = parcel.readStrongBinder();
                break;
            }
            Object t = parcel.readCreator(creator, classLoader);
            if (clazz == null) {
                clazz = t.getClass();
            } else {
                ParceledListSlice.verifySameType(clazz, t.getClass());
            }
            this.mList.add(t);
            if (DEBUG) {
                Log.d(TAG, "Read inline #" + n2 + ": " + this.mList.get(-1 + this.mList.size()));
            }
            ++n2;
        }
        while (n2 < n) {
            if (DEBUG) {
                Log.d(TAG, "Reading more @" + n2 + " of " + n + ": retriever=" + iBinder);
            }
            Parcel parcel2 = Parcel.obtain();
            Parcel parcel3 = Parcel.obtain();
            parcel2.writeInt(n2);
            try {
                iBinder.transact(1, parcel2, parcel3, 0);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failure retrieving array; only received " + n2 + " of " + n, remoteException);
                return;
            }
            while (n2 < n && parcel3.readInt() != 0) {
                Object t = parcel3.readCreator(creator, classLoader);
                ParceledListSlice.verifySameType(clazz, t.getClass());
                this.mList.add(t);
                if (DEBUG) {
                    Log.d(TAG, "Read extra #" + n2 + ": " + this.mList.get(-1 + this.mList.size()));
                }
                ++n2;
            }
            parcel3.recycle();
            parcel2.recycle();
        }
    }

    public ParceledListSlice(List<T> list) {
        this.mList = list;
    }

    private static void verifySameType(Class<?> clazz, Class<?> clazz2) {
        if (!clazz2.equals(clazz)) {
            throw new IllegalArgumentException("Can't unparcel type " + clazz2.getName() + " in list of type " + clazz.getName());
        }
    }

    @Override
    public int describeContents() {
        int n = 0;
        for (int i = 0; i < this.mList.size(); ++i) {
            n |= ((Parcelable)this.mList.get(i)).describeContents();
        }
        return n;
    }

    public List<T> getList() {
        return this.mList;
    }

    @Override
    public void writeToParcel(Parcel parcel, final int n) {
        final int n2 = this.mList.size();
        parcel.writeInt(n2);
        if (DEBUG) {
            Log.d(TAG, "Writing " + n2 + " items");
        }
        if (n2 > 0) {
            int n3;
            final Class<?> clazz = ((Parcelable)this.mList.get(0)).getClass();
            parcel.writeParcelableCreator((Parcelable)this.mList.get(0));
            for (n3 = 0; n3 < n2 && parcel.dataSize() < 131072; ++n3) {
                parcel.writeInt(1);
                Parcelable parcelable = (Parcelable)this.mList.get(n3);
                ParceledListSlice.verifySameType(clazz, parcelable.getClass());
                parcelable.writeToParcel(parcel, n);
                if (!DEBUG) continue;
                Log.d(TAG, "Wrote inline #" + n3 + ": " + this.mList.get(n3));
            }
            if (n3 < n2) {
                parcel.writeInt(0);
                Binder binder = new Binder(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    protected boolean onTransact(int n5, Parcel parcel, Parcel parcel2, int n22) throws RemoteException {
                        int n3 = 1;
                        if (n5 != n3) {
                            return super.onTransact(n5, parcel, parcel2, n22) ? 1 : 0;
                        }
                        int n4 = parcel.readInt();
                        if (DEBUG) {
                            Log.d(TAG, "Writing more @" + n4 + " of " + n2);
                        }
                        while (n4 < n2 && parcel2.dataSize() < 262144) {
                            parcel2.writeInt(n3);
                            Parcelable parcelable = (Parcelable)ParceledListSlice.this.mList.get(n4);
                            ParceledListSlice.verifySameType(clazz, parcelable.getClass());
                            parcelable.writeToParcel(parcel2, n);
                            if (DEBUG) {
                                Log.d(TAG, "Wrote extra #" + n4 + ": " + ParceledListSlice.this.mList.get(n4));
                            }
                            ++n4;
                        }
                        if (n4 >= n2) return n3;
                        if (DEBUG) {
                            Log.d(TAG, "Breaking @" + n4 + " of " + n2);
                        }
                        parcel2.writeInt(0);
                        return n3;
                    }
                };
                if (DEBUG) {
                    Log.d(TAG, "Breaking @" + n3 + " of " + n2 + ": retriever=" + binder);
                }
                parcel.writeStrongBinder(binder);
            }
        }
    }
}

