/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.os.UserHandle;

public class UserInfo
implements Parcelable {
    public static final Parcelable.Creator<UserInfo> CREATOR = new Parcelable.Creator<UserInfo>(){

        @Override
        public UserInfo createFromParcel(Parcel parcel) {
            return new UserInfo(parcel);
        }

        public UserInfo[] newArray(int n) {
            return new UserInfo[n];
        }
    };
    public static final int FLAG_ADMIN = 2;
    public static final int FLAG_DISABLED = 64;
    public static final int FLAG_GUEST = 4;
    public static final int FLAG_INITIALIZED = 16;
    public static final int FLAG_MANAGED_PROFILE = 32;
    public static final int FLAG_MASK_USER_TYPE = 255;
    public static final int FLAG_PRIMARY = 1;
    public static final int FLAG_RESTRICTED = 8;
    public static final int FLAG_SNAPVIEW = 128;
    public static final int NO_PROFILE_GROUP_ID = -1;
    public long creationTime;
    public int flags;
    public boolean guestToRemove;
    public String iconPath;
    public int id;
    public long lastLoggedInTime;
    public String name;
    public boolean partial;
    public int profileGroupId;
    public int serialNumber;

    public UserInfo() {
    }

    public UserInfo(int n, String string2, int n2) {
        this(n, string2, null, n2);
    }

    public UserInfo(int n, String string2, String string3, int n2) {
        this.id = n;
        this.name = string2;
        this.flags = n2;
        this.iconPath = string3;
        this.profileGroupId = -1;
    }

    public UserInfo(UserInfo userInfo) {
        this.name = userInfo.name;
        this.iconPath = userInfo.iconPath;
        this.id = userInfo.id;
        this.flags = userInfo.flags;
        this.serialNumber = userInfo.serialNumber;
        this.creationTime = userInfo.creationTime;
        this.lastLoggedInTime = userInfo.lastLoggedInTime;
        this.partial = userInfo.partial;
        this.profileGroupId = userInfo.profileGroupId;
        this.guestToRemove = userInfo.guestToRemove;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UserInfo(Parcel parcel) {
        boolean bl = true;
        this.id = parcel.readInt();
        this.name = parcel.readString();
        this.iconPath = parcel.readString();
        this.flags = parcel.readInt();
        this.serialNumber = parcel.readInt();
        this.creationTime = parcel.readLong();
        this.lastLoggedInTime = parcel.readLong();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.partial = bl2;
        this.profileGroupId = parcel.readInt();
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.guestToRemove = bl;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public UserHandle getUserHandle() {
        return new UserHandle(this.id);
    }

    public boolean isAdmin() {
        return (2 & this.flags) == 2;
    }

    public boolean isEnabled() {
        return (0x40 & this.flags) != 64;
    }

    public boolean isGuest() {
        return (4 & this.flags) == 4;
    }

    public boolean isManagedProfile() {
        return (0x20 & this.flags) == 32;
    }

    public boolean isPrimary() {
        return (1 & this.flags) == 1;
    }

    public boolean isRestricted() {
        return (8 & this.flags) == 8;
    }

    public boolean isSnapView() {
        return (0x80 & this.flags) == 128;
    }

    public boolean supportsSwitchTo() {
        boolean bl;
        block3: {
            block2: {
                if (!this.isManagedProfile()) break block2;
                boolean bl2 = SystemProperties.getBoolean("fw.show_hidden_users", false);
                bl = false;
                if (!bl2) break block3;
            }
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return "UserInfo{" + this.id + ":" + this.name + ":" + Integer.toHexString(this.flags) + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.id);
        parcel.writeString(this.name);
        parcel.writeString(this.iconPath);
        parcel.writeInt(this.flags);
        parcel.writeInt(this.serialNumber);
        parcel.writeLong(this.creationTime);
        parcel.writeLong(this.lastLoggedInTime);
        int n3 = this.partial ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeInt(this.profileGroupId);
        if (!this.guestToRemove) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

