/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;

public class MergeCursor
extends AbstractCursor {
    private Cursor mCursor;
    private Cursor[] mCursors;
    private DataSetObserver mObserver = new DataSetObserver(){

        @Override
        public void onChanged() {
            MergeCursor.this.mPos = -1;
        }

        @Override
        public void onInvalidated() {
            MergeCursor.this.mPos = -1;
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    public MergeCursor(Cursor[] cursorArray) {
        this.mCursors = cursorArray;
        this.mCursor = cursorArray[0];
        int n = 0;
        while (n < this.mCursors.length) {
            if (this.mCursors[n] != null) {
                this.mCursors[n].registerDataSetObserver(this.mObserver);
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void close() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                super.close();
                return;
            }
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].close();
            }
            ++n2;
        }
    }

    @Override
    public void deactivate() {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].deactivate();
        }
        super.deactivate();
    }

    @Override
    public byte[] getBlob(int n) {
        return this.mCursor.getBlob(n);
    }

    @Override
    public String[] getColumnNames() {
        if (this.mCursor != null) {
            return this.mCursor.getColumnNames();
        }
        return new String[0];
    }

    @Override
    public int getCount() {
        int n = 0;
        int n2 = this.mCursors.length;
        for (int i = 0; i < n2; ++i) {
            if (this.mCursors[i] == null) continue;
            n += this.mCursors[i].getCount();
        }
        return n;
    }

    @Override
    public double getDouble(int n) {
        return this.mCursor.getDouble(n);
    }

    @Override
    public float getFloat(int n) {
        return this.mCursor.getFloat(n);
    }

    @Override
    public int getInt(int n) {
        return this.mCursor.getInt(n);
    }

    @Override
    public long getLong(int n) {
        return this.mCursor.getLong(n);
    }

    @Override
    public short getShort(int n) {
        return this.mCursor.getShort(n);
    }

    @Override
    public String getString(int n) {
        return this.mCursor.getString(n);
    }

    @Override
    public int getType(int n) {
        return this.mCursor.getType(n);
    }

    @Override
    public boolean isNull(int n) {
        return this.mCursor.isNull(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onMove(int n, int n2) {
        this.mCursor = null;
        int n3 = 0;
        int n4 = this.mCursors.length;
        for (int i = 0; i < n4; ++i) {
            if (this.mCursors[i] == null) continue;
            if (n2 < n3 + this.mCursors[i].getCount()) {
                this.mCursor = this.mCursors[i];
                break;
            }
            n3 += this.mCursors[i].getCount();
        }
        if (this.mCursor != null) {
            return this.mCursor.moveToPosition(n2 - n3);
        }
        return false;
    }

    @Override
    public void registerContentObserver(ContentObserver contentObserver) {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerContentObserver(contentObserver);
        }
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerDataSetObserver(dataSetObserver);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requery() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null && !this.mCursors[n2].requery()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void unregisterContentObserver(ContentObserver contentObserver) {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].unregisterContentObserver(contentObserver);
        }
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].unregisterDataSetObserver(dataSetObserver);
        }
    }
}

