/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.util.Log;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleNativeHeap
extends ChunkHandler {
    public static final int CHUNK_NHGT = DdmHandleNativeHeap.type((String)"NHGT");
    private static DdmHandleNativeHeap mInstance = new DdmHandleNativeHeap();

    private DdmHandleNativeHeap() {
    }

    private native byte[] getLeakInfo();

    private Chunk handleNHGT(Chunk chunk) {
        byte[] byArray = this.getLeakInfo();
        if (byArray != null) {
            Log.i("ddm-nativeheap", "Sending " + byArray.length + " bytes");
            return new Chunk(ChunkHandler.type((String)"NHGT"), byArray, 0, byArray.length);
        }
        return DdmHandleNativeHeap.createFailChunk((int)1, (String)"Something went wrong");
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_NHGT, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk chunk) {
        Log.i("ddm-nativeheap", "Handling " + DdmHandleNativeHeap.name((int)chunk.type) + " chunk");
        int n = chunk.type;
        if (n == CHUNK_NHGT) {
            return this.handleNHGT(chunk);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)n));
    }
}

