/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FieldPort;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterPort;
import android.filterfw.core.FinalPort;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.GenerateProgramPort;
import android.filterfw.core.GenerateProgramPorts;
import android.filterfw.core.InputPort;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.OutputPort;
import android.filterfw.core.Program;
import android.filterfw.core.ProgramPort;
import android.filterfw.core.ProtocolException;
import android.filterfw.core.SerializedFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.StreamPort;
import android.filterfw.format.ObjectFormat;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.TextGraphReader;
import android.util.Log;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Filter {
    static final int STATUS_ERROR = 6;
    static final int STATUS_FINISHED = 5;
    static final int STATUS_PREINIT = 0;
    static final int STATUS_PREPARED = 2;
    static final int STATUS_PROCESSING = 3;
    static final int STATUS_RELEASED = 7;
    static final int STATUS_SLEEPING = 4;
    static final int STATUS_UNPREPARED = 1;
    private static final String TAG = "Filter";
    private long mCurrentTimestamp;
    private HashSet<Frame> mFramesToRelease;
    private HashMap<String, Frame> mFramesToSet;
    private int mInputCount = -1;
    private HashMap<String, InputPort> mInputPorts;
    private boolean mIsOpen = false;
    private boolean mLogVerbose;
    private String mName;
    private int mOutputCount = -1;
    private HashMap<String, OutputPort> mOutputPorts;
    private int mSleepDelay;
    private int mStatus = 0;

    public Filter(String string2) {
        this.mName = string2;
        this.mFramesToRelease = new HashSet();
        this.mFramesToSet = new HashMap();
        this.mStatus = 0;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void addAndSetFinalPorts(KeyValueMap keyValueMap) {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            GenerateFinalPort generateFinalPort = field.getAnnotation(GenerateFinalPort.class);
            if (generateFinalPort != null) {
                GenerateFinalPort generateFinalPort2 = generateFinalPort;
                String string2 = generateFinalPort2.name().isEmpty() ? field.getName() : generateFinalPort2.name();
                this.addFieldPort(string2, field, generateFinalPort2.hasDefault(), true);
                if (keyValueMap.containsKey(string2)) {
                    this.setImmediateInputValue(string2, keyValueMap.get(string2));
                    keyValueMap.remove(string2);
                } else if (!generateFinalPort2.hasDefault()) {
                    throw new RuntimeException("No value specified for final input port '" + string2 + "' of filter " + this + "!");
                }
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void addAnnotatedPorts() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            GenerateFieldPort generateFieldPort = field.getAnnotation(GenerateFieldPort.class);
            if (generateFieldPort != null) {
                this.addFieldGenerator(generateFieldPort, field);
            } else {
                GenerateProgramPort generateProgramPort = field.getAnnotation(GenerateProgramPort.class);
                if (generateProgramPort != null) {
                    this.addProgramGenerator(generateProgramPort, field);
                } else {
                    GenerateProgramPorts generateProgramPorts = field.getAnnotation(GenerateProgramPorts.class);
                    if (generateProgramPorts != null) {
                        GenerateProgramPort[] generateProgramPortArray = generateProgramPorts.value();
                        int n3 = generateProgramPortArray.length;
                        for (int i = 0; i < n3; ++i) {
                            this.addProgramGenerator(generateProgramPortArray[i], field);
                        }
                    }
                }
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void addFieldGenerator(GenerateFieldPort generateFieldPort, Field field) {
        String string2 = generateFieldPort.name().isEmpty() ? field.getName() : generateFieldPort.name();
        this.addFieldPort(string2, field, generateFieldPort.hasDefault(), false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void addProgramGenerator(GenerateProgramPort generateProgramPort, Field field) {
        String string2 = generateProgramPort.name();
        String string3 = generateProgramPort.variableName().isEmpty() ? string2 : generateProgramPort.variableName();
        this.addProgramPort(string2, string3, field, generateProgramPort.type(), generateProgramPort.hasDefault());
    }

    private final void closePorts() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Closing all ports on " + this + "!");
        }
        Iterator<InputPort> iterator = this.mInputPorts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
        }
        Iterator<OutputPort> iterator2 = this.mOutputPorts.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean filterMustClose() {
        OutputPort outputPort;
        for (InputPort inputPort : this.mInputPorts.values()) {
            if (!inputPort.filterMustClose()) continue;
            if (!this.mLogVerbose) return true;
            Log.v(TAG, "Filter " + this + " must close due to port " + inputPort);
            return true;
        }
        Iterator<OutputPort> iterator = this.mOutputPorts.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(outputPort = iterator.next()).filterMustClose());
        if (!this.mLogVerbose) return true;
        Log.v(TAG, "Filter " + this + " must close due to port " + outputPort);
        return true;
    }

    private final void initFinalPorts(KeyValueMap keyValueMap) {
        this.mInputPorts = new HashMap();
        this.mOutputPorts = new HashMap();
        this.addAndSetFinalPorts(keyValueMap);
    }

    private final void initRemainingPorts(KeyValueMap keyValueMap) {
        this.addAnnotatedPorts();
        this.setupPorts();
        this.setInitialInputValues(keyValueMap);
    }

    private final boolean inputConditionsMet() {
        for (FilterPort filterPort : this.mInputPorts.values()) {
            if (filterPort.isReady()) continue;
            if (this.mLogVerbose) {
                Log.v(TAG, "Input condition not met: " + filterPort + "!");
            }
            return false;
        }
        return true;
    }

    public static final boolean isAvailable(String string2) {
        Class<?> clazz;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            clazz = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        try {
            clazz.asSubclass(Filter.class);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private final boolean outputConditionsMet() {
        for (FilterPort filterPort : this.mOutputPorts.values()) {
            if (filterPort.isReady()) continue;
            if (this.mLogVerbose) {
                Log.v(TAG, "Output condition not met: " + filterPort + "!");
            }
            return false;
        }
        return true;
    }

    private final void releasePulledFrames(FilterContext filterContext) {
        for (Frame frame : this.mFramesToRelease) {
            filterContext.getFrameManager().releaseFrame(frame);
        }
        this.mFramesToRelease.clear();
    }

    private final void setImmediateInputValue(String string2, Object object) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Setting immediate value " + object + " for port " + string2 + "!");
        }
        InputPort inputPort = this.getInputPort(string2);
        ((FilterPort)inputPort).open();
        inputPort.setFrame(SimpleFrame.wrapObject(object, null));
    }

    private final void setInitialInputValues(KeyValueMap keyValueMap) {
        for (Map.Entry entry : keyValueMap.entrySet()) {
            this.setInputValue((String)entry.getKey(), entry.getValue());
        }
    }

    private final void transferInputFrames(FilterContext filterContext) {
        Iterator<InputPort> iterator = this.mInputPorts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().transfer(filterContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Frame wrapInputValue(String string2, Object object) {
        int n = 1;
        MutableFrameFormat mutableFrameFormat = ObjectFormat.fromObject(object, n);
        if (object == null) {
            FrameFormat frameFormat = this.getInputPort(string2).getPortFormat();
            Class clazz = frameFormat == null ? null : frameFormat.getObjectClass();
            mutableFrameFormat.setObjectClass(clazz);
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof String || !(object instanceof Serializable)) {
            n = 0;
        }
        Frame frame = n != 0 ? new SerializedFrame(mutableFrameFormat, null) : new SimpleFrame(mutableFrameFormat, null);
        frame.setObjectValue(object);
        return frame;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addFieldPort(String string2, Field field, boolean bl, boolean bl2) {
        field.setAccessible(true);
        FieldPort fieldPort = bl2 ? new FinalPort(this, string2, field, bl) : new FieldPort(this, string2, field, bl);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + fieldPort);
        }
        fieldPort.setPortFormat(ObjectFormat.fromClass(field.getType(), 1));
        this.mInputPorts.put(string2, fieldPort);
    }

    protected void addInputPort(String string2) {
        this.addMaskedInputPort(string2, null);
    }

    protected void addMaskedInputPort(String string2, FrameFormat frameFormat) {
        StreamPort streamPort = new StreamPort(this, string2);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + streamPort);
        }
        this.mInputPorts.put(string2, streamPort);
        streamPort.setPortFormat(frameFormat);
    }

    protected void addOutputBasedOnInput(String string2, String string3) {
        OutputPort outputPort = new OutputPort(this, string2);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + outputPort);
        }
        outputPort.setBasePort(this.getInputPort(string3));
        this.mOutputPorts.put(string2, outputPort);
    }

    protected void addOutputPort(String string2, FrameFormat frameFormat) {
        OutputPort outputPort = new OutputPort(this, string2);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + outputPort);
        }
        outputPort.setPortFormat(frameFormat);
        this.mOutputPorts.put(string2, outputPort);
    }

    protected void addProgramPort(String string2, String string3, Field field, Class clazz, boolean bl) {
        field.setAccessible(true);
        ProgramPort programPort = new ProgramPort(this, string2, string3, field, bl);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + programPort);
        }
        programPort.setPortFormat(ObjectFormat.fromClass(clazz, 1));
        this.mInputPorts.put(string2, programPort);
    }

    final boolean canProcess() {
        synchronized (this) {
            boolean bl;
            block6: {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Checking if can process: " + this + " (" + this.mStatus + ").");
                }
                int n = this.mStatus;
                bl = false;
                if (n > 3) break block6;
                boolean bl2 = this.inputConditionsMet();
                bl = false;
                if (!bl2) break block6;
                boolean bl3 = this.outputConditionsMet();
                bl = false;
                if (!bl3) break block6;
                bl = true;
            }
            return bl;
        }
    }

    final void clearInputs() {
        Iterator<InputPort> iterator = this.mInputPorts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    final void clearOutputs() {
        Iterator<OutputPort> iterator = this.mOutputPorts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    public void close(FilterContext filterContext) {
    }

    protected void closeOutputPort(String string2) {
        this.getOutputPort(string2).close();
    }

    protected void delayNextProcess(int n) {
        this.mSleepDelay = n;
        this.mStatus = 4;
    }

    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
    }

    public String getFilterClassName() {
        return this.getClass().getSimpleName();
    }

    public final FrameFormat getInputFormat(String string2) {
        return this.getInputPort(string2).getSourceFormat();
    }

    public final InputPort getInputPort(String string2) {
        if (this.mInputPorts == null) {
            throw new NullPointerException("Attempting to access input port '" + string2 + "' of " + this + " before Filter has been initialized!");
        }
        InputPort inputPort = this.mInputPorts.get(string2);
        if (inputPort == null) {
            throw new IllegalArgumentException("Unknown input port '" + string2 + "' on filter " + this + "!");
        }
        return inputPort;
    }

    final Collection<InputPort> getInputPorts() {
        return this.mInputPorts.values();
    }

    public final String getName() {
        return this.mName;
    }

    public final int getNumberOfConnectedInputs() {
        int n = 0;
        Iterator<InputPort> iterator = this.mInputPorts.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isConnected()) continue;
            ++n;
        }
        return n;
    }

    public final int getNumberOfConnectedOutputs() {
        int n = 0;
        Iterator<OutputPort> iterator = this.mOutputPorts.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isConnected()) continue;
            ++n;
        }
        return n;
    }

    public final int getNumberOfInputs() {
        if (this.mOutputPorts == null) {
            return 0;
        }
        return this.mInputPorts.size();
    }

    public final int getNumberOfOutputs() {
        if (this.mInputPorts == null) {
            return 0;
        }
        return this.mOutputPorts.size();
    }

    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return null;
    }

    public final OutputPort getOutputPort(String string2) {
        if (this.mInputPorts == null) {
            throw new NullPointerException("Attempting to access output port '" + string2 + "' of " + this + " before Filter has been initialized!");
        }
        OutputPort outputPort = this.mOutputPorts.get(string2);
        if (outputPort == null) {
            throw new IllegalArgumentException("Unknown output port '" + string2 + "' on filter " + this + "!");
        }
        return outputPort;
    }

    final Collection<OutputPort> getOutputPorts() {
        return this.mOutputPorts.values();
    }

    public final int getSleepDelay() {
        return 250;
    }

    final int getStatus() {
        synchronized (this) {
            int n = this.mStatus;
            return n;
        }
    }

    public final void init() throws ProtocolException {
        this.initWithValueMap(new KeyValueMap());
    }

    protected void initProgramInputs(Program program, FilterContext filterContext) {
        if (program != null) {
            for (InputPort inputPort : this.mInputPorts.values()) {
                if (inputPort.getTarget() != program) continue;
                inputPort.transfer(filterContext);
            }
        }
    }

    public final void initWithAssignmentList(Object ... objectArray) {
        KeyValueMap keyValueMap = new KeyValueMap();
        keyValueMap.setKeyValues(objectArray);
        this.initWithValueMap(keyValueMap);
    }

    public final void initWithAssignmentString(String string2) {
        try {
            this.initWithValueMap(new TextGraphReader().readKeyValueAssignments(string2));
            return;
        }
        catch (GraphIOException graphIOException) {
            throw new IllegalArgumentException(graphIOException.getMessage());
        }
    }

    public final void initWithValueMap(KeyValueMap keyValueMap) {
        this.initFinalPorts(keyValueMap);
        this.initRemainingPorts(keyValueMap);
        this.mStatus = 1;
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    final void notifyFieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mStatus == 3 || this.mStatus == 2) {
            this.fieldPortValueUpdated(string2, filterContext);
        }
    }

    public void open(FilterContext filterContext) {
    }

    final void openOutputs() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Opening all output ports on " + this + "!");
        }
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            if (outputPort.isOpen()) continue;
            outputPort.open();
        }
    }

    protected void parametersUpdated(Set<String> set) {
    }

    final void performClose(FilterContext filterContext) {
        synchronized (this) {
            if (this.mIsOpen) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Closing " + this);
                }
                this.mIsOpen = false;
                this.mStatus = 2;
                this.close(filterContext);
                this.closePorts();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void performOpen(FilterContext filterContext) {
        synchronized (this) {
            if (!this.mIsOpen) {
                if (this.mStatus == 1) {
                    if (this.mLogVerbose) {
                        Log.v(TAG, "Preparing " + this);
                    }
                    this.prepare(filterContext);
                    this.mStatus = 2;
                }
                if (this.mStatus == 2) {
                    if (this.mLogVerbose) {
                        Log.v(TAG, "Opening " + this);
                    }
                    this.open(filterContext);
                    this.mStatus = 3;
                }
                if (this.mStatus != 3) {
                    throw new RuntimeException("Filter " + this + " was brought into invalid state during " + "opening (state: " + this.mStatus + ")!");
                }
                this.mIsOpen = true;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void performProcess(FilterContext filterContext) {
        synchronized (this) {
            if (this.mStatus == 7) {
                throw new RuntimeException("Filter " + this + " is already torn down!");
            }
            this.transferInputFrames(filterContext);
            if (this.mStatus < 3) {
                this.performOpen(filterContext);
            }
            if (this.mLogVerbose) {
                Log.v(TAG, "Processing " + this);
            }
            this.mCurrentTimestamp = -1L;
            this.process(filterContext);
            this.releasePulledFrames(filterContext);
            if (this.filterMustClose()) {
                this.performClose(filterContext);
            }
            return;
        }
    }

    final void performTearDown(FilterContext filterContext) {
        synchronized (this) {
            this.performClose(filterContext);
            if (this.mStatus != 7) {
                this.tearDown(filterContext);
                this.mStatus = 7;
            }
            return;
        }
    }

    protected void prepare(FilterContext filterContext) {
    }

    public abstract void process(FilterContext var1);

    protected final Frame pullInput(String string2) {
        Frame frame = this.getInputPort(string2).pullFrame();
        if (this.mCurrentTimestamp == -1L) {
            this.mCurrentTimestamp = frame.getTimestamp();
            if (this.mLogVerbose) {
                Log.v(TAG, "Default-setting current timestamp from input port " + string2 + " to " + this.mCurrentTimestamp);
            }
        }
        this.mFramesToRelease.add(frame);
        return frame;
    }

    final void pushInputFrame(String string2, Frame frame) {
        synchronized (this) {
            InputPort inputPort = this.getInputPort(string2);
            if (!inputPort.isOpen()) {
                ((FilterPort)inputPort).open();
            }
            inputPort.pushFrame(frame);
            return;
        }
    }

    final void pushInputValue(String string2, Object object) {
        synchronized (this) {
            this.pushInputFrame(string2, this.wrapInputValue(string2, object));
            return;
        }
    }

    protected final void pushOutput(String string2, Frame frame) {
        if (frame.getTimestamp() == -2L) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Default-setting output Frame timestamp on port " + string2 + " to " + this.mCurrentTimestamp);
            }
            frame.setTimestamp(this.mCurrentTimestamp);
        }
        this.getOutputPort(string2).pushFrame(frame);
    }

    public void setInputFrame(String string2, Frame frame) {
        InputPort inputPort = this.getInputPort(string2);
        if (!inputPort.isOpen()) {
            ((FilterPort)inputPort).open();
        }
        inputPort.setFrame(frame);
    }

    public final void setInputValue(String string2, Object object) {
        this.setInputFrame(string2, this.wrapInputValue(string2, object));
    }

    protected void setWaitsOnInputPort(String string2, boolean bl) {
        this.getInputPort(string2).setBlocking(bl);
    }

    protected void setWaitsOnOutputPort(String string2, boolean bl) {
        this.getOutputPort(string2).setBlocking(bl);
    }

    public abstract void setupPorts();

    public void tearDown(FilterContext filterContext) {
    }

    public String toString() {
        return "'" + this.getName() + "' (" + this.getFilterClassName() + ")";
    }

    protected void transferInputPortFrame(String string2, FilterContext filterContext) {
        this.getInputPort(string2).transfer(filterContext);
    }

    final void unsetStatus(int n) {
        synchronized (this) {
            this.mStatus &= ~n;
            return;
        }
    }
}

