/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.OutputPort;
import android.filterfw.core.StreamPort;
import java.util.Map;

public class FilterFunction {
    private Filter mFilter;
    private FilterContext mFilterContext;
    private boolean mFilterIsSetup = false;
    private FrameHolderPort[] mResultHolders;

    public FilterFunction(FilterContext filterContext, Filter filter) {
        this.mFilterContext = filterContext;
        this.mFilter = filter;
    }

    private void connectFilterOutputs() {
        int n = 0;
        this.mResultHolders = new FrameHolderPort[this.mFilter.getNumberOfOutputs()];
        for (OutputPort outputPort : this.mFilter.getOutputPorts()) {
            this.mResultHolders[n] = new FrameHolderPort();
            outputPort.connectTo(this.mResultHolders[n]);
            ++n;
        }
    }

    public void close() {
        this.mFilter.performClose(this.mFilterContext);
    }

    public Frame execute(KeyValueMap keyValueMap) {
        int n = this.mFilter.getNumberOfOutputs();
        if (n > 1) {
            throw new RuntimeException("Calling execute on filter " + this.mFilter + " with multiple " + "outputs! Use executeMulti() instead!");
        }
        if (!this.mFilterIsSetup) {
            this.connectFilterOutputs();
            this.mFilterIsSetup = true;
        }
        GLEnvironment gLEnvironment = this.mFilterContext.getGLEnvironment();
        boolean bl = false;
        if (gLEnvironment != null) {
            boolean bl2 = gLEnvironment.isActive();
            bl = false;
            if (!bl2) {
                gLEnvironment.activate();
                bl = true;
            }
        }
        for (Map.Entry entry : keyValueMap.entrySet()) {
            if (entry.getValue() instanceof Frame) {
                this.mFilter.pushInputFrame((String)entry.getKey(), (Frame)entry.getValue());
                continue;
            }
            this.mFilter.pushInputValue((String)entry.getKey(), entry.getValue());
        }
        if (this.mFilter.getStatus() != 3) {
            this.mFilter.openOutputs();
        }
        this.mFilter.performProcess(this.mFilterContext);
        Frame frame = null;
        if (n == 1) {
            boolean bl3 = this.mResultHolders[0].hasFrame();
            frame = null;
            if (bl3) {
                frame = this.mResultHolders[0].pullFrame();
            }
        }
        if (bl) {
            gLEnvironment.deactivate();
        }
        return frame;
    }

    public Frame executeWithArgList(Object ... objectArray) {
        return this.execute(KeyValueMap.fromKeyValues(objectArray));
    }

    public FilterContext getContext() {
        return this.mFilterContext;
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public void setInputFrame(String string2, Frame frame) {
        this.mFilter.setInputFrame(string2, frame);
    }

    public void setInputValue(String string2, Object object) {
        this.mFilter.setInputValue(string2, object);
    }

    public void tearDown() {
        this.mFilter.performTearDown(this.mFilterContext);
        this.mFilter = null;
    }

    public String toString() {
        return this.mFilter.getName();
    }

    private class FrameHolderPort
    extends StreamPort {
        public FrameHolderPort() {
            super(null, "holder");
        }
    }
}

