/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterPort;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.OutputPort;

public abstract class InputPort
extends FilterPort {
    protected OutputPort mSourcePort;

    public InputPort(Filter filter, String string2) {
        super(filter, string2);
    }

    public boolean acceptsFrame() {
        return !this.hasFrame();
    }

    @Override
    public void close() {
        if (this.mSourcePort != null && this.mSourcePort.isOpen()) {
            this.mSourcePort.close();
        }
        super.close();
    }

    @Override
    public boolean filterMustClose() {
        return !this.isOpen() && this.isBlocking() && !this.hasFrame();
    }

    public Filter getSourceFilter() {
        if (this.mSourcePort == null) {
            return null;
        }
        return this.mSourcePort.getFilter();
    }

    public FrameFormat getSourceFormat() {
        if (this.mSourcePort != null) {
            return this.mSourcePort.getPortFormat();
        }
        return this.getPortFormat();
    }

    public OutputPort getSourcePort() {
        return this.mSourcePort;
    }

    public Object getTarget() {
        return null;
    }

    public boolean isConnected() {
        return this.mSourcePort != null;
    }

    @Override
    public boolean isReady() {
        return this.hasFrame() || !this.isBlocking();
    }

    @Override
    public void open() {
        super.open();
        if (this.mSourcePort != null && !this.mSourcePort.isOpen()) {
            this.mSourcePort.open();
        }
    }

    public void setSourcePort(OutputPort outputPort) {
        if (this.mSourcePort != null) {
            throw new RuntimeException(this + " already connected to " + this.mSourcePort + "!");
        }
        this.mSourcePort = outputPort;
    }

    public abstract void transfer(FilterContext var1);
}

