/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;

public class RotateFilter
extends Filter {
    @GenerateFieldPort(name="angle")
    private int mAngle;
    private int mHeight = 0;
    private int mOutputHeight;
    private int mOutputWidth;
    private Program mProgram;
    private int mTarget = 0;
    @GenerateFieldPort(hasDefault=true, name="tile_size")
    private int mTileSize = 640;
    private int mWidth = 0;

    public RotateFilter(String string2) {
        super(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateParameters() {
        float f;
        float f2;
        if (this.mAngle % 90 != 0) {
            throw new RuntimeException("degree has to be multiply of 90.");
        }
        if (this.mAngle % 180 == 0) {
            f2 = 0.0f;
            if (this.mAngle % 360 == 0) {
                f = 1.0f;
            } else {
                f = -1.0f;
                f2 = 0.0f;
            }
        } else {
            f2 = (90 + this.mAngle) % 360 == 0 ? -1.0f : 1.0f;
            this.mOutputWidth = this.mHeight;
            this.mOutputHeight = this.mWidth;
            f = 0.0f;
        }
        Quad quad = new Quad(new Point(0.5f * (1.0f + (f2 + -f)), 0.5f * (1.0f + (-f2 - f))), new Point(0.5f * (1.0f + (f + f2)), 0.5f * (1.0f + (f2 - f))), new Point(0.5f * (1.0f + (-f - f2)), 0.5f * (1.0f + (f + -f2))), new Point(0.5f * (1.0f + (f - f2)), 0.5f * (1.0f + (f2 + f))));
        ((ShaderProgram)this.mProgram).setTargetRegion(quad);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    public void initProgram(FilterContext filterContext, int n) {
        switch (n) {
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + n + "!");
            }
            case 3: 
        }
        ShaderProgram shaderProgram = ShaderProgram.createIdentity(filterContext);
        shaderProgram.setMaximumTileSize(this.mTileSize);
        shaderProgram.setClearsOutput(true);
        this.mProgram = shaderProgram;
        this.mTarget = n;
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        FrameFormat frameFormat = frame.getFormat();
        if (this.mProgram == null || frameFormat.getTarget() != this.mTarget) {
            this.initProgram(filterContext, frameFormat.getTarget());
        }
        if (frameFormat.getWidth() != this.mWidth || frameFormat.getHeight() != this.mHeight) {
            this.mWidth = frameFormat.getWidth();
            this.mHeight = frameFormat.getHeight();
            this.mOutputWidth = this.mWidth;
            this.mOutputHeight = this.mHeight;
            this.updateParameters();
        }
        MutableFrameFormat mutableFrameFormat = ImageFormat.create(this.mOutputWidth, this.mOutputHeight, 3, 3);
        Frame frame2 = filterContext.getFrameManager().newFrame(mutableFrameFormat);
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }
}

