/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.NativeProgram;
import android.filterfw.core.Program;

public class ToRGBFilter
extends Filter {
    private int mInputBPP;
    private FrameFormat mLastFormat = null;
    private Program mProgram;

    public ToRGBFilter(String string2) {
        super(string2);
    }

    public void createProgram(FilterContext filterContext, FrameFormat frameFormat) {
        this.mInputBPP = frameFormat.getBytesPerSample();
        if (this.mLastFormat != null && this.mLastFormat.getBytesPerSample() == this.mInputBPP) {
            return;
        }
        this.mLastFormat = frameFormat;
        switch (this.mInputBPP) {
            default: {
                throw new RuntimeException("Unsupported BytesPerPixel: " + this.mInputBPP + "!");
            }
            case 1: {
                this.mProgram = new NativeProgram("filterpack_imageproc", "gray_to_rgb");
                return;
            }
            case 4: 
        }
        this.mProgram = new NativeProgram("filterpack_imageproc", "rgba_to_rgb");
    }

    public FrameFormat getConvertedFormat(FrameFormat frameFormat) {
        MutableFrameFormat mutableFrameFormat = frameFormat.mutableCopy();
        mutableFrameFormat.setMetaValue("colorspace", 2);
        mutableFrameFormat.setBytesPerSample(3);
        return mutableFrameFormat;
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return this.getConvertedFormat(frameFormat);
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        this.createProgram(filterContext, frame.getFormat());
        Frame frame2 = filterContext.getFrameManager().newFrame(this.getConvertedFormat(frame.getFormat()));
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        MutableFrameFormat mutableFrameFormat = new MutableFrameFormat(2, 2);
        mutableFrameFormat.setDimensionCount(2);
        this.addMaskedInputPort("image", mutableFrameFormat);
        this.addOutputBasedOnInput("image", "image");
    }
}

