/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GesturePoint;
import android.gesture.GestureUtils;
import android.gesture.OrientedBoundingBox;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class GestureStroke {
    static final float TOUCH_TOLERANCE = 3.0f;
    public final RectF boundingBox;
    public final float length;
    private Path mCachedPath;
    public final float[] points;
    private final long[] timestamps;

    private GestureStroke(RectF rectF, float f, float[] fArray, long[] lArray) {
        this.boundingBox = new RectF(rectF.left, rectF.top, rectF.right, rectF.bottom);
        this.length = f;
        this.points = (float[])fArray.clone();
        this.timestamps = (long[])lArray.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    public GestureStroke(ArrayList<GesturePoint> arrayList) {
        int n = arrayList.size();
        float[] fArray = new float[n * 2];
        long[] lArray = new long[n];
        RectF rectF = null;
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                this.timestamps = lArray;
                this.points = fArray;
                this.boundingBox = rectF;
                this.length = f;
                return;
            }
            GesturePoint gesturePoint = arrayList.get(n3);
            fArray[n3 * 2] = gesturePoint.x;
            fArray[1 + n3 * 2] = gesturePoint.y;
            lArray[n2] = gesturePoint.timestamp;
            if (rectF == null) {
                rectF = new RectF();
                rectF.top = gesturePoint.y;
                rectF.left = gesturePoint.x;
                rectF.right = gesturePoint.x;
                rectF.bottom = gesturePoint.y;
                f = 0.0f;
            } else {
                f = (float)((double)f + Math.sqrt(Math.pow(gesturePoint.x - fArray[2 * (n3 - 1)], 2.0) + Math.pow(gesturePoint.y - fArray[1 + 2 * (n3 - 1)], 2.0)));
                rectF.union(gesturePoint.x, gesturePoint.y);
            }
            ++n2;
            ++n3;
        }
    }

    static GestureStroke deserialize(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        ArrayList<GesturePoint> arrayList = new ArrayList<GesturePoint>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(GesturePoint.deserialize(dataInputStream));
        }
        return new GestureStroke(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void makePath() {
        float[] fArray = this.points;
        int n = fArray.length;
        Path path = null;
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mCachedPath = path;
                return;
            }
            float f3 = fArray[n2];
            float f4 = fArray[n2 + 1];
            if (path == null) {
                path = new Path();
                path.moveTo(f3, f4);
                f = f3;
                f2 = f4;
            } else {
                float f5 = Math.abs(f3 - f);
                float f6 = Math.abs(f4 - f2);
                if (f5 >= 3.0f || f6 >= 3.0f) {
                    path.quadTo(f, f2, (f3 + f) / 2.0f, (f4 + f2) / 2.0f);
                    f = f3;
                    f2 = f4;
                }
            }
            n2 += 2;
        }
    }

    public void clearPath() {
        if (this.mCachedPath != null) {
            this.mCachedPath.rewind();
        }
    }

    public Object clone() {
        return new GestureStroke(this.boundingBox, this.length, this.points, this.timestamps);
    }

    public OrientedBoundingBox computeOrientedBoundingBox() {
        return GestureUtils.computeOrientedBoundingBox(this.points);
    }

    void draw(Canvas canvas, Paint paint) {
        if (this.mCachedPath == null) {
            this.makePath();
        }
        canvas.drawPath(this.mCachedPath, paint);
    }

    public Path getPath() {
        if (this.mCachedPath == null) {
            this.makePath();
        }
        return this.mCachedPath;
    }

    void serialize(DataOutputStream dataOutputStream) throws IOException {
        float[] fArray = this.points;
        long[] lArray = this.timestamps;
        int n = this.points.length;
        dataOutputStream.writeInt(n / 2);
        for (int i = 0; i < n; i += 2) {
            dataOutputStream.writeFloat(fArray[i]);
            dataOutputStream.writeFloat(fArray[i + 1]);
            dataOutputStream.writeLong(lArray[i / 2]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Path toPath(float f, float f2, int n) {
        float[] fArray = GestureUtils.temporalSampling(this, n);
        RectF rectF = this.boundingBox;
        GestureUtils.translate(fArray, -rectF.left, -rectF.top);
        float f3 = f / rectF.width();
        float f4 = f2 / rectF.height();
        float f5 = f3 > f4 ? f4 : f3;
        GestureUtils.scale(fArray, f5, f5);
        float f6 = 0.0f;
        float f7 = 0.0f;
        Path path = null;
        int n2 = fArray.length;
        int n3 = 0;
        while (n3 < n2) {
            float f8 = fArray[n3];
            float f9 = fArray[n3 + 1];
            if (path == null) {
                path = new Path();
                path.moveTo(f8, f9);
                f6 = f8;
                f7 = f9;
            } else {
                float f10 = Math.abs(f8 - f6);
                float f11 = Math.abs(f9 - f7);
                if (f10 >= 3.0f || f11 >= 3.0f) {
                    path.quadTo(f6, f7, (f8 + f6) / 2.0f, (f9 + f7) / 2.0f);
                    f6 = f8;
                    f7 = f9;
                }
            }
            n3 += 2;
        }
        return path;
    }
}

