/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.OrientedBoundingBox;
import android.graphics.RectF;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public final class GestureUtils {
    private static final float NONUNIFORM_SCALE = 0.0f;
    private static final float SCALING_THRESHOLD = 0.26f;

    static {
        NONUNIFORM_SCALE = (float)Math.sqrt(2.0);
    }

    private GestureUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void closeStream(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.e("Gestures", "Could not close stream", iOException);
            return;
        }
    }

    static float[] computeCentroid(float[] fArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            f += fArray[n2];
            int n3 = n2 + 1;
            f2 += fArray[n3];
            n2 = n3 + 1;
        }
        float[] fArray2 = new float[]{2.0f * f / (float)n, 2.0f * f2 / (float)n};
        return fArray2;
    }

    private static float[][] computeCoVariance(float[] fArray) {
        int[] nArray = new int[]{2, 2};
        float[][] fArray2 = (float[][])Array.newInstance(Float.TYPE, nArray);
        fArray2[0][0] = 0.0f;
        fArray2[0][1] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 0.0f;
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            int n3 = n2 + 1;
            float f2 = fArray[n3];
            float[] fArray3 = fArray2[0];
            fArray3[0] = fArray3[0] + f * f;
            float[] fArray4 = fArray2[0];
            fArray4[1] = fArray4[1] + f * f2;
            fArray2[1][0] = fArray2[0][1];
            float[] fArray5 = fArray2[1];
            fArray5[1] = fArray5[1] + f2 * f2;
            n2 = n3 + 1;
        }
        float[] fArray6 = fArray2[0];
        fArray6[0] = fArray6[0] / (float)(n / 2);
        float[] fArray7 = fArray2[0];
        fArray7[1] = fArray7[1] / (float)(n / 2);
        float[] fArray8 = fArray2[1];
        fArray8[0] = fArray8[0] / (float)(n / 2);
        float[] fArray9 = fArray2[1];
        fArray9[1] = fArray9[1] / (float)(n / 2);
        return fArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static float[] computeOrientation(float[][] fArray) {
        float f;
        float[] fArray2 = new float[2];
        if (fArray[0][1] == 0.0f || fArray[1][0] == 0.0f) {
            fArray2[0] = 1.0f;
            fArray2[1] = 0.0f;
        }
        float f2 = -fArray[0][0] - fArray[1][1];
        float f3 = fArray[0][0] * fArray[1][1] - fArray[0][1] * fArray[1][0];
        float f4 = f2 / 2.0f;
        float f5 = (float)Math.sqrt(Math.pow(f4, 2.0) - (double)f3);
        float f6 = f5 + -f4;
        if (f6 == (f = -f4 - f5)) {
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            return fArray2;
        }
        float f7 = f6 > f ? f6 : f;
        fArray2[0] = 1.0f;
        fArray2[1] = (f7 - fArray[0][0]) / fArray[0][1];
        return fArray2;
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(ArrayList<GesturePoint> arrayList) {
        int n = arrayList.size();
        float[] fArray = new float[n * 2];
        for (int i = 0; i < n; ++i) {
            GesturePoint gesturePoint = arrayList.get(i);
            int n2 = i * 2;
            fArray[n2] = gesturePoint.x;
            fArray[n2 + 1] = gesturePoint.y;
        }
        return GestureUtils.computeOrientedBoundingBox(fArray, GestureUtils.computeCentroid(fArray));
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = fArray[i];
        }
        return GestureUtils.computeOrientedBoundingBox(fArray2, GestureUtils.computeCentroid(fArray2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static OrientedBoundingBox computeOrientedBoundingBox(float[] fArray, float[] fArray2) {
        float f;
        GestureUtils.translate(fArray, -fArray2[0], -fArray2[1]);
        float[] fArray3 = GestureUtils.computeOrientation(GestureUtils.computeCoVariance(fArray));
        if (fArray3[0] == 0.0f && fArray3[1] == 0.0f) {
            f = -1.5707964f;
        } else {
            f = (float)Math.atan2(fArray3[1], fArray3[0]);
            GestureUtils.rotate(fArray, -f);
        }
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        float f5 = Float.MIN_VALUE;
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (fArray[n2] < f2) {
                f2 = fArray[n2];
            }
            if (fArray[n2] > f4) {
                f4 = fArray[n2];
            }
            if (fArray[n3 = n2 + 1] < f3) {
                f3 = fArray[n3];
            }
            if (fArray[n3] > f5) {
                f5 = fArray[n3];
            }
            n2 = n3 + 1;
        }
        return new OrientedBoundingBox((float)((double)(180.0f * f) / Math.PI), fArray2[0], fArray2[1], f4 - f2, f5 - f3);
    }

    static float computeStraightness(float[] fArray) {
        float f = GestureUtils.computeTotalLength(fArray);
        float f2 = fArray[2] - fArray[0];
        float f3 = fArray[3] - fArray[1];
        return (float)Math.sqrt(f2 * f2 + f3 * f3) / f;
    }

    static float computeStraightness(float[] fArray, float f) {
        float f2 = fArray[2] - fArray[0];
        float f3 = fArray[3] - fArray[1];
        return (float)Math.sqrt(f2 * f2 + f3 * f3) / f;
    }

    static float computeTotalLength(float[] fArray) {
        float f = 0.0f;
        int n = -4 + fArray.length;
        for (int i = 0; i < n; i += 2) {
            float f2 = fArray[i + 2] - fArray[i];
            float f3 = fArray[i + 3] - fArray[i + 1];
            f = (float)((double)f + Math.sqrt(f2 * f2 + f3 * f3));
        }
        return f;
    }

    static float cosineDistance(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            f += fArray[i] * fArray2[i];
        }
        return (float)Math.acos(f);
    }

    static float minimumCosineDistance(float[] fArray, float[] fArray2, int n) {
        int n2 = fArray.length;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n2; i += 2) {
            f += fArray[i] * fArray2[i] + fArray[i + 1] * fArray2[i + 1];
            f2 += fArray[i] * fArray2[i + 1] - fArray[i + 1] * fArray2[i];
        }
        if (f != 0.0f) {
            float f3 = f2 / f;
            double d = Math.atan(f3);
            if (n > 2 && Math.abs(d) >= Math.PI / (double)n) {
                return (float)Math.acos(f);
            }
            double d2 = Math.cos(d);
            double d3 = d2 * (double)f3;
            return (float)Math.acos(d2 * (double)f + d3 * (double)f2);
        }
        return 1.5707964f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void plot(float f, float f2, float[] fArray, int n) {
        int n2;
        float f3;
        int n3;
        float f4;
        int n4;
        float f5;
        int n5;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        int n6 = (int)Math.floor(f);
        int n7 = (int)Math.ceil(f);
        int n8 = (int)Math.floor(f2);
        int n9 = (int)Math.ceil(f2);
        if (f == (float)n6 && f2 == (float)n8) {
            int n10 = n7 + n9 * n;
            if (!(fArray[n10] < 1.0f)) return;
            fArray[n10] = 1.0f;
            return;
        }
        double d = Math.pow((float)n6 - f, 2.0);
        double d2 = Math.pow((float)n8 - f2, 2.0);
        double d3 = Math.pow((float)n7 - f, 2.0);
        double d4 = Math.pow((float)n9 - f2, 2.0);
        float f6 = (float)Math.sqrt(d + d2);
        float f7 = (float)Math.sqrt(d3 + d2);
        float f8 = (float)Math.sqrt(d + d4);
        float f9 = (float)Math.sqrt(d3 + d4);
        float f10 = f9 + (f8 + (f6 + f7));
        float f11 = f6 / f10;
        if (f11 > fArray[n5 = n6 + n8 * n]) {
            fArray[n5] = f11;
        }
        if ((f5 = f7 / f10) > fArray[n4 = n7 + n8 * n]) {
            fArray[n4] = f5;
        }
        if ((f4 = f8 / f10) > fArray[n3 = n6 + n9 * n]) {
            fArray[n3] = f4;
        }
        if (!((f3 = f9 / f10) > fArray[n2 = n7 + n9 * n])) return;
        fArray[n2] = f3;
    }

    static float[] rotate(float[] fArray, float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        int n = fArray.length;
        for (int i = 0; i < n; i += 2) {
            float f4 = f2 * fArray[i] - f3 * fArray[i + 1];
            float f5 = f3 * fArray[i] + f2 * fArray[i + 1];
            fArray[i] = f4;
            fArray[i + 1] = f5;
        }
        return fArray;
    }

    static float[] scale(float[] fArray, float f, float f2) {
        int n = fArray.length;
        for (int i = 0; i < n; i += 2) {
            fArray[i] = f * fArray[i];
            int n2 = i + 1;
            fArray[n2] = f2 * fArray[n2];
        }
        return fArray;
    }

    public static float[] spatialSampling(Gesture gesture, int n) {
        return GestureUtils.spatialSampling(gesture, n, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float[] spatialSampling(Gesture gesture, int n, boolean bl) {
        float f = n - 1;
        float[] fArray = new float[n * n];
        Arrays.fill(fArray, 0.0f);
        RectF rectF = gesture.getBoundingBox();
        float f2 = rectF.width();
        float f3 = rectF.height();
        float f4 = f / f2;
        float f5 = f / f3;
        if (bl) {
            float f6 = f4 < f5 ? f4 : f5;
            f4 = f6;
            f5 = f6;
        } else {
            float f7 = f2 / f3;
            if (f7 > 1.0f) {
                f7 = 1.0f / f7;
            }
            if (f7 < 0.26f) {
                float f8 = f4 < f5 ? f4 : f5;
                f4 = f8;
                f5 = f8;
            } else if (f4 > f5) {
                float f9 = f5 * NONUNIFORM_SCALE;
                if (f9 < f4) {
                    f4 = f9;
                }
            } else {
                float f10 = f4 * NONUNIFORM_SCALE;
                if (f10 < f5) {
                    f5 = f10;
                }
            }
        }
        float f11 = -rectF.centerX();
        float f12 = -rectF.centerY();
        float f13 = f / 2.0f;
        float f14 = f / 2.0f;
        ArrayList<GestureStroke> arrayList = gesture.getStrokes();
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            float[] fArray2 = arrayList.get((int)n3).points;
            int n4 = fArray2.length;
            float[] fArray3 = new float[n4];
            for (int i = 0; i < n4; i += 2) {
                fArray3[i] = f13 + f4 * (f11 + fArray2[i]);
                fArray3[i + 1] = f14 + f5 * (f12 + fArray2[i + 1]);
            }
            float f15 = -1.0f;
            float f16 = -1.0f;
            for (int i = 0; i < n4; i += 2) {
                float f17 = fArray3[i] < 0.0f ? 0.0f : fArray3[i];
                float f18 = fArray3[i + 1] < 0.0f ? 0.0f : fArray3[i + 1];
                if (f17 > f) {
                    f17 = f;
                }
                if (f18 > f) {
                    f18 = f;
                }
                GestureUtils.plot(f17, f18, fArray, n);
                if (f15 != -1.0f) {
                    if (f15 > f17) {
                        float f19 = (f16 - f18) / (f15 - f17);
                        for (float f20 = (float)Math.ceil(f17); f20 < f15; f20 += 1.0f) {
                            float f21 = f18 + f19 * (f20 - f17);
                            GestureUtils.plot(f20, f21, fArray, n);
                        }
                    } else if (f15 < f17) {
                        float f22 = (f16 - f18) / (f15 - f17);
                        for (float f23 = (float)Math.ceil(f15); f23 < f17; f23 += 1.0f) {
                            float f24 = f18 + f22 * (f23 - f17);
                            GestureUtils.plot(f23, f24, fArray, n);
                        }
                    }
                    if (f16 > f18) {
                        float f25 = (f15 - f17) / (f16 - f18);
                        for (float f26 = (float)Math.ceil(f18); f26 < f16; f26 += 1.0f) {
                            GestureUtils.plot(f17 + f25 * (f26 - f18), f26, fArray, n);
                        }
                    } else if (f16 < f18) {
                        float f27 = (f15 - f17) / (f16 - f18);
                        for (float f28 = (float)Math.ceil(f16); f28 < f18; f28 += 1.0f) {
                            GestureUtils.plot(f17 + f27 * (f28 - f18), f28, fArray, n);
                        }
                    }
                }
                f15 = f17;
                f16 = f18;
            }
            ++n3;
        }
        return fArray;
    }

    static float squaredEuclideanDistance(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f2 = fArray[i] - fArray2[i];
            f += f2 * f2;
        }
        return f / (float)n;
    }

    public static float[] temporalSampling(GestureStroke gestureStroke, int n) {
        float f = gestureStroke.length / (float)(n - 1);
        int n2 = n * 2;
        float[] fArray = new float[n2];
        float f2 = 0.0f;
        float[] fArray2 = gestureStroke.points;
        float f3 = fArray2[0];
        float f4 = fArray2[1];
        float f5 = Float.MIN_VALUE;
        float f6 = Float.MIN_VALUE;
        fArray[0] = f3;
        int n3 = 0 + 1;
        fArray[n3] = f4;
        int n4 = n3 + 1;
        int n5 = 0;
        int n6 = fArray2.length / 2;
        while (true) {
            float f7;
            float f8;
            float f9;
            block5: {
                block6: {
                    block4: {
                        if (n5 >= n6) break block4;
                        if (f5 != Float.MIN_VALUE) break block5;
                        if (++n5 < n6) break block6;
                    }
                    for (int i = n4; i < n2; i += 2) {
                        fArray[i] = f3;
                        fArray[i + 1] = f4;
                    }
                    break;
                }
                f5 = fArray2[n5 * 2];
                f6 = fArray2[1 + n5 * 2];
            }
            if (f2 + (f9 = (float)Math.sqrt((f8 = f5 - f3) * f8 + (f7 = f6 - f4) * f7)) >= f) {
                float f10 = (f - f2) / f9;
                float f11 = f3 + f10 * f8;
                float f12 = f4 + f10 * f7;
                fArray[n4] = f11;
                int n7 = n4 + 1;
                fArray[n7] = f12;
                n4 = n7 + 1;
                f3 = f11;
                f4 = f12;
                f2 = 0.0f;
                continue;
            }
            f3 = f5;
            f4 = f6;
            f5 = Float.MIN_VALUE;
            f6 = Float.MIN_VALUE;
            f2 += f9;
        }
        return fArray;
    }

    static float[] translate(float[] fArray, float f, float f2) {
        int n = fArray.length;
        for (int i = 0; i < n; i += 2) {
            fArray[i] = f + fArray[i];
            int n2 = i + 1;
            fArray[n2] = f2 + fArray[n2];
        }
        return fArray;
    }
}

