/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import java.util.Locale;

public class Paint {
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int AUTO_HINTING_TEXT_FLAG = 2048;
    public static final int BIDI_DEFAULT_LTR = 2;
    public static final int BIDI_DEFAULT_RTL = 3;
    private static final int BIDI_FLAG_MASK = 7;
    public static final int BIDI_FORCE_LTR = 4;
    public static final int BIDI_FORCE_RTL = 5;
    public static final int BIDI_LTR = 0;
    private static final int BIDI_MAX_FLAG_VALUE = 5;
    public static final int BIDI_RTL = 1;
    public static final int CURSOR_AFTER = 0;
    public static final int CURSOR_AT = 4;
    public static final int CURSOR_AT_OR_AFTER = 1;
    public static final int CURSOR_AT_OR_BEFORE = 3;
    public static final int CURSOR_BEFORE = 2;
    private static final int CURSOR_OPT_MAX_VALUE = 4;
    private static final boolean DEBUG = false;
    static final int DEFAULT_PAINT_FLAGS = 1280;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    public static final int DIRECTION_LTR = 0;
    public static final int DIRECTION_RTL = 1;
    public static final int DITHER_FLAG = 4;
    public static final int EMBEDDED_BITMAP_TEXT_FLAG = 1024;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int HINTING_OFF = 0;
    public static final int HINTING_ON = 1;
    public static final int LCD_RENDER_TEXT_FLAG = 512;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    private static final String TAG = "Paint";
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int VERTICAL_TEXT_FLAG = 4096;
    static final Align[] sAlignArray;
    static final Cap[] sCapArray;
    static final Join[] sJoinArray;
    static final Style[] sStyleArray;
    public int mBidiFlags = 2;
    private ColorFilter mColorFilter;
    private float mCompatScaling;
    private String mFontFeatureSettings;
    private boolean mHasCompatScaling;
    private float mInvCompatScaling;
    private Locale mLocale;
    private MaskFilter mMaskFilter;
    public long mNativePaint;
    public long mNativeTypeface;
    private PathEffect mPathEffect;
    private Rasterizer mRasterizer;
    private Shader mShader;
    private Typeface mTypeface;
    private Xfermode mXfermode;

    static {
        Style[] styleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
        sStyleArray = styleArray;
        Cap[] capArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
        sCapArray = capArray;
        Join[] joinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
        sJoinArray = joinArray;
        Align[] alignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
        sAlignArray = alignArray;
    }

    public Paint() {
        this(0);
    }

    public Paint(int n) {
        this.mNativePaint = Paint.native_init();
        this.setFlags(n | 0x500);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
        this.setTextLocale(Locale.getDefault());
    }

    public Paint(Paint paint) {
        this.mNativePaint = Paint.native_initWithPaint(paint.mNativePaint);
        this.setClassVariablesFrom(paint);
    }

    private static native void finalizer(long var0);

    private static native void nativeGetCharArrayBounds(long var0, long var2, char[] var4, int var5, int var6, int var7, Rect var8);

    private static native void nativeGetStringBounds(long var0, long var2, String var4, int var5, int var6, int var7, Rect var8);

    private static native int native_breakText(long var0, long var2, String var4, boolean var5, float var6, int var7, float[] var8);

    private static native int native_breakText(long var0, long var2, char[] var4, int var5, int var6, float var7, int var8, float[] var9);

    private static native boolean native_getFillPath(long var0, long var2, long var4);

    private static native float native_getLetterSpacing(long var0);

    private static native int native_getStrokeCap(long var0);

    private static native int native_getStrokeJoin(long var0);

    private static native int native_getStyle(long var0);

    private static native int native_getTextAlign(long var0);

    private static native int native_getTextGlyphs(long var0, String var2, int var3, int var4, int var5, int var6, int var7, char[] var8);

    private static native void native_getTextPath(long var0, long var2, int var4, String var5, int var6, int var7, float var8, float var9, long var10);

    private static native void native_getTextPath(long var0, long var2, int var4, char[] var5, int var6, int var7, float var8, float var9, long var10);

    private static native float native_getTextRunAdvances(long var0, long var2, String var4, int var5, int var6, int var7, int var8, boolean var9, float[] var10, int var11);

    private static native float native_getTextRunAdvances(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, float[] var10, int var11);

    private native int native_getTextRunCursor(long var1, String var3, int var4, int var5, int var6, int var7, int var8);

    private native int native_getTextRunCursor(long var1, char[] var3, int var4, int var5, int var6, int var7, int var8);

    private static native int native_getTextWidths(long var0, long var2, String var4, int var5, int var6, int var7, float[] var8);

    private static native int native_getTextWidths(long var0, long var2, char[] var4, int var5, int var6, int var7, float[] var8);

    private static native boolean native_hasShadowLayer(long var0);

    private static native long native_init();

    private static native long native_initWithPaint(long var0);

    private native float native_measureText(String var1, int var2);

    private native float native_measureText(String var1, int var2, int var3, int var4);

    private native float native_measureText(char[] var1, int var2, int var3, int var4);

    private static native void native_reset(long var0);

    private static native void native_set(long var0, long var2);

    private static native long native_setColorFilter(long var0, long var2);

    private static native void native_setFontFeatureSettings(long var0, String var2);

    private static native void native_setLetterSpacing(long var0, float var2);

    private static native long native_setMaskFilter(long var0, long var2);

    private static native long native_setPathEffect(long var0, long var2);

    private static native long native_setRasterizer(long var0, long var2);

    private static native long native_setShader(long var0, long var2);

    private static native void native_setShadowLayer(long var0, float var2, float var3, float var4, int var5);

    private static native void native_setStrokeCap(long var0, int var2);

    private static native void native_setStrokeJoin(long var0, int var2);

    private static native void native_setStyle(long var0, int var2);

    private static native void native_setTextAlign(long var0, int var2);

    private static native void native_setTextLocale(long var0, String var2);

    private static native long native_setTypeface(long var0, long var2);

    private static native long native_setXfermode(long var0, long var2);

    /*
     * Enabled aggressive block sorting
     */
    private void setClassVariablesFrom(Paint paint) {
        this.mColorFilter = paint.mColorFilter;
        this.mMaskFilter = paint.mMaskFilter;
        this.mPathEffect = paint.mPathEffect;
        this.mRasterizer = paint.mRasterizer;
        this.mShader = paint.mShader != null ? paint.mShader.copy() : null;
        this.mTypeface = paint.mTypeface;
        this.mNativeTypeface = paint.mNativeTypeface;
        if (Typeface.isFlipFontUsed && this.mTypeface != null && this.mTypeface.isLikeDefault) {
            this.mNativeTypeface = Typeface.DEFAULT.native_instance;
        }
        this.mXfermode = paint.mXfermode;
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
        this.mBidiFlags = paint.mBidiFlags;
        this.mLocale = paint.mLocale;
        this.mFontFeatureSettings = paint.mFontFeatureSettings;
    }

    public native float ascent();

    /*
     * Enabled aggressive block sorting
     */
    public int breakText(CharSequence charSequence, int n, int n2, boolean bl, float f, float[] fArray) {
        if (charSequence == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((n | n2 | n2 - n | charSequence.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (charSequence.length() == 0 || n == n2) {
            return 0;
        }
        if (n == 0 && charSequence instanceof String && n2 == charSequence.length()) {
            return this.breakText((String)charSequence, bl, f, fArray);
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        int n3 = bl ? this.breakText(cArray, 0, n2 - n, f, fArray) : this.breakText(cArray, 0, -(n2 - n), f, fArray);
        TemporaryBuffer.recycle(cArray);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int breakText(String string2, boolean bl, float f, float[] fArray) {
        if (string2 == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (string2.length() == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, string2, bl, f, this.mBidiFlags, fArray);
        }
        float f2 = this.getTextSize();
        this.setTextSize(f2 * this.mCompatScaling);
        int n = Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, string2, bl, f * this.mCompatScaling, this.mBidiFlags, fArray);
        this.setTextSize(f2);
        if (fArray == null) return n;
        fArray[0] = fArray[0] * this.mInvCompatScaling;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int breakText(char[] cArray, int n, int n2, float f, float[] fArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (n < 0) throw new ArrayIndexOutOfBoundsException();
        if (cArray.length - n < Math.abs(n2)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (cArray.length == 0) return 0;
        if (n2 == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, cArray, n, n2, f, this.mBidiFlags, fArray);
        }
        float f2 = this.getTextSize();
        this.setTextSize(f2 * this.mCompatScaling);
        int n3 = Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, cArray, n, n2, f * this.mCompatScaling, this.mBidiFlags, fArray);
        this.setTextSize(f2);
        if (fArray == null) return n3;
        fArray[0] = fArray[0] * this.mInvCompatScaling;
        return n3;
    }

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public native float descent();

    protected void finalize() throws Throwable {
        try {
            Paint.finalizer(this.mNativePaint);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public native int getAlpha();

    public int getBidiFlags() {
        return this.mBidiFlags;
    }

    public native int getColor();

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public boolean getFillPath(Path path, Path path2) {
        return Paint.native_getFillPath(this.mNativePaint, path.ni(), path2.ni());
    }

    public native int getFlags();

    public String getFontFeatureSettings() {
        return this.mFontFeatureSettings;
    }

    public native float getFontMetrics(FontMetrics var1);

    public FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = new FontMetrics();
        this.getFontMetrics(fontMetrics);
        return fontMetrics;
    }

    public native int getFontMetricsInt(FontMetricsInt var1);

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fontMetricsInt = new FontMetricsInt();
        this.getFontMetricsInt(fontMetricsInt);
        return fontMetricsInt;
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public native int getHinting();

    public float getLetterSpacing() {
        return Paint.native_getLetterSpacing(this.mNativePaint);
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    @Deprecated
    public Rasterizer getRasterizer() {
        return this.mRasterizer;
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Cap getStrokeCap() {
        return sCapArray[Paint.native_getStrokeCap(this.mNativePaint)];
    }

    public Join getStrokeJoin() {
        return sJoinArray[Paint.native_getStrokeJoin(this.mNativePaint)];
    }

    public native float getStrokeMiter();

    public native float getStrokeWidth();

    public Style getStyle() {
        return sStyleArray[Paint.native_getStyle(this.mNativePaint)];
    }

    public Align getTextAlign() {
        return sAlignArray[Paint.native_getTextAlign(this.mNativePaint)];
    }

    public void getTextBounds(String string2, int n, int n2, Rect rect) {
        if ((n | n2 | n2 - n | string2.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (rect == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetStringBounds(this.mNativePaint, this.mNativeTypeface, string2, n, n2, this.mBidiFlags, rect);
    }

    public void getTextBounds(char[] cArray, int n, int n2, Rect rect) {
        if ((n | n2) < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (rect == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetCharArrayBounds(this.mNativePaint, this.mNativeTypeface, cArray, n, n2, this.mBidiFlags, rect);
    }

    public Locale getTextLocale() {
        return this.mLocale;
    }

    public void getTextPath(String string2, int n, int n2, float f, float f2, Path path) {
        if ((n | n2 | n2 - n | string2.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, string2, n, n2, f, f2, path.ni());
    }

    public void getTextPath(char[] cArray, int n, int n2, float f, float f2, Path path) {
        if ((n | n2) < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, cArray, n, n2, f, f2, path.ni());
    }

    /*
     * Enabled aggressive block sorting
     */
    public float getTextRunAdvances(CharSequence charSequence, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        int n6;
        if (charSequence == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        int n7 = fArray == null ? 0 : fArray.length - n5 - (n2 - n);
        if ((n7 | (n6 = n5 | (n4 | (n3 | (n | n2))) | n2 - n | n - n3 | n4 - n2 | charSequence.length() - n4)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (charSequence instanceof String) {
            return this.getTextRunAdvances((String)charSequence, n, n2, n3, n4, bl, fArray, n5);
        }
        if (charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            return this.getTextRunAdvances(charSequence.toString(), n, n2, n3, n4, bl, fArray, n5);
        }
        if (charSequence instanceof GraphicsOperations) {
            return ((GraphicsOperations)charSequence).getTextRunAdvances(n, n2, n3, n4, bl, fArray, n5, this);
        }
        if (charSequence.length() != 0 && n2 != n) {
            int n8 = n4 - n3;
            int n9 = n2 - n;
            char[] cArray = TemporaryBuffer.obtain(n8);
            TextUtils.getChars(charSequence, n3, n4, cArray, 0);
            float f = this.getTextRunAdvances(cArray, n - n3, n9, 0, n8, bl, fArray, n5);
            TemporaryBuffer.recycle(cArray);
            return f;
        }
        return 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float getTextRunAdvances(String string2, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        int n6;
        if (string2 == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        int n7 = fArray == null ? 0 : fArray.length - n5 - (n2 - n);
        if ((n7 | (n6 = n5 | (n4 | (n3 | (n | n2))) | n2 - n | n - n3 | n4 - n2 | string2.length() - n4)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (string2.length() == 0 || n == n2) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, string2, n, n2, n3, n4, bl, fArray, n5);
        }
        float f = this.getTextSize();
        this.setTextSize(f * this.mCompatScaling);
        float f2 = Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, string2, n, n2, n3, n4, bl, fArray, n5);
        this.setTextSize(f);
        if (fArray != null) {
            int n8;
            int n9 = n8 + (n2 - n);
            for (n8 = n5; n8 < n9; ++n8) {
                fArray[n8] = fArray[n8] * this.mInvCompatScaling;
            }
        }
        return f2 * this.mInvCompatScaling;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float getTextRunAdvances(char[] cArray, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        int n6;
        if (cArray == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        int n7 = fArray == null ? 0 : fArray.length - (n5 + n2);
        if ((n7 | (n6 = n5 | (n4 | (n3 | (n | n2))) | n - n3 | n4 - n2 | n3 + n4 - (n + n2) | cArray.length - (n3 + n4))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (cArray.length == 0 || n2 == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, cArray, n, n2, n3, n4, bl, fArray, n5);
        }
        float f = this.getTextSize();
        this.setTextSize(f * this.mCompatScaling);
        float f2 = Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, cArray, n, n2, n3, n4, bl, fArray, n5);
        this.setTextSize(f);
        if (fArray != null) {
            int n8;
            int n9 = n8 + n2;
            for (n8 = n5; n8 < n9; ++n8) {
                fArray[n8] = fArray[n8] * this.mInvCompatScaling;
            }
        }
        return f2 * this.mInvCompatScaling;
    }

    public int getTextRunCursor(CharSequence charSequence, int n, int n2, int n3, int n4, int n5) {
        if (charSequence instanceof String || charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            return this.getTextRunCursor(charSequence.toString(), n, n2, n3, n4, n5);
        }
        if (charSequence instanceof GraphicsOperations) {
            return ((GraphicsOperations)charSequence).getTextRunCursor(n, n2, n3, n4, n5, this);
        }
        int n6 = n2 - n;
        char[] cArray = TemporaryBuffer.obtain(n6);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        int n7 = this.getTextRunCursor(cArray, 0, n6, n3, n4 - n, n5);
        TemporaryBuffer.recycle(cArray);
        return n7;
    }

    public int getTextRunCursor(String string2, int n, int n2, int n3, int n4, int n5) {
        if ((n5 | (n4 | (n | n2) | n2 - n | n4 - n | n2 - n4 | string2.length() - n2)) < 0 || n5 > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.native_getTextRunCursor(this.mNativePaint, string2, n, n2, n3, n4, n5);
    }

    public int getTextRunCursor(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n + n2;
        if ((n5 | (n4 | (n | n6) | n6 - n | n4 - n | n6 - n4 | cArray.length - n6)) < 0 || n5 > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.native_getTextRunCursor(this.mNativePaint, cArray, n, n2, n3, n4, n5);
    }

    public native float getTextScaleX();

    public native float getTextSize();

    public native float getTextSkewX();

    public int getTextWidths(CharSequence charSequence, int n, int n2, float[] fArray) {
        if (charSequence == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((n | n2 | n2 - n | charSequence.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 - n > fArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (charSequence.length() == 0 || n == n2) {
            return 0;
        }
        if (charSequence instanceof String) {
            return this.getTextWidths((String)charSequence, n, n2, fArray);
        }
        if (charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            return this.getTextWidths(charSequence.toString(), n, n2, fArray);
        }
        if (charSequence instanceof GraphicsOperations) {
            return ((GraphicsOperations)charSequence).getTextWidths(n, n2, fArray, this);
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        int n3 = this.getTextWidths(cArray, 0, n2 - n, fArray);
        TemporaryBuffer.recycle(cArray);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTextWidths(String string2, int n, int n2, float[] fArray) {
        if (string2 == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((n | n2 | n2 - n | string2.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 - n > fArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (string2.length() == 0) return 0;
        if (n == n2) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, string2, n, n2, this.mBidiFlags, fArray);
        }
        float f = this.getTextSize();
        this.setTextSize(f * this.mCompatScaling);
        int n3 = Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, string2, n, n2, this.mBidiFlags, fArray);
        this.setTextSize(f);
        int n4 = 0;
        while (n4 < n3) {
            fArray[n4] = fArray[n4] * this.mInvCompatScaling;
            ++n4;
        }
        return n3;
    }

    public int getTextWidths(String string2, float[] fArray) {
        return this.getTextWidths(string2, 0, string2.length(), fArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTextWidths(char[] cArray, int n, int n2, float[] fArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((n | n2) < 0) throw new ArrayIndexOutOfBoundsException();
        if (n + n2 > cArray.length) throw new ArrayIndexOutOfBoundsException();
        if (n2 > fArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (cArray.length == 0) return 0;
        if (n2 == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, cArray, n, n2, this.mBidiFlags, fArray);
        }
        float f = this.getTextSize();
        this.setTextSize(f * this.mCompatScaling);
        int n3 = Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, cArray, n, n2, this.mBidiFlags, fArray);
        this.setTextSize(f);
        int n4 = 0;
        while (n4 < n3) {
            fArray[n4] = fArray[n4] * this.mInvCompatScaling;
            ++n4;
        }
        return n3;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    public boolean hasShadowLayer() {
        return Paint.native_hasShadowLayer(this.mNativePaint);
    }

    public final boolean isAntiAlias() {
        return (1 & this.getFlags()) != 0;
    }

    public final boolean isDither() {
        return (4 & this.getFlags()) != 0;
    }

    public native boolean isElegantTextHeight();

    public final boolean isFakeBoldText() {
        return (0x20 & this.getFlags()) != 0;
    }

    public final boolean isFilterBitmap() {
        return (2 & this.getFlags()) != 0;
    }

    public final boolean isLinearText() {
        return (0x40 & this.getFlags()) != 0;
    }

    public final boolean isStrikeThruText() {
        return (0x10 & this.getFlags()) != 0;
    }

    public final boolean isSubpixelText() {
        return (0x80 & this.getFlags()) != 0;
    }

    public final boolean isUnderlineText() {
        return (8 & this.getFlags()) != 0;
    }

    public float measureText(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((n | n2 | n2 - n | charSequence.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (charSequence.length() == 0 || n == n2) {
            return 0.0f;
        }
        if (charSequence instanceof String) {
            return this.measureText((String)charSequence, n, n2);
        }
        if (charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            return this.measureText(charSequence.toString(), n, n2);
        }
        if (charSequence instanceof GraphicsOperations) {
            return ((GraphicsOperations)charSequence).measureText(n, n2, this);
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        float f = this.measureText(cArray, 0, n2 - n);
        TemporaryBuffer.recycle(cArray);
        return f;
    }

    public float measureText(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (string2.length() == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(this.native_measureText(string2, this.mBidiFlags));
        }
        float f = this.getTextSize();
        this.setTextSize(f * this.mCompatScaling);
        float f2 = this.native_measureText(string2, this.mBidiFlags);
        this.setTextSize(f);
        return (float)Math.ceil(f2 * this.mInvCompatScaling);
    }

    public float measureText(String string2, int n, int n2) {
        if (string2 == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((n | n2 | n2 - n | string2.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (string2.length() == 0 || n == n2) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(this.native_measureText(string2, n, n2, this.mBidiFlags));
        }
        float f = this.getTextSize();
        this.setTextSize(f * this.mCompatScaling);
        float f2 = this.native_measureText(string2, n, n2, this.mBidiFlags);
        this.setTextSize(f);
        return (float)Math.ceil(f2 * this.mInvCompatScaling);
    }

    public float measureText(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((n | n2) < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (cArray.length == 0 || n2 == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(this.native_measureText(cArray, n, n2, this.mBidiFlags));
        }
        float f = this.getTextSize();
        this.setTextSize(f * this.mCompatScaling);
        float f2 = this.native_measureText(cArray, n, n2, this.mBidiFlags);
        this.setTextSize(f);
        return (float)Math.ceil(f2 * this.mInvCompatScaling);
    }

    public void reset() {
        Paint.native_reset(this.mNativePaint);
        this.setFlags(1280);
        this.mColorFilter = null;
        this.mMaskFilter = null;
        this.mPathEffect = null;
        this.mRasterizer = null;
        this.mShader = null;
        this.mTypeface = null;
        this.mNativeTypeface = 0L;
        this.mXfermode = null;
        this.mHasCompatScaling = false;
        this.mCompatScaling = 1.0f;
        this.mInvCompatScaling = 1.0f;
        this.mBidiFlags = 2;
        this.setTextLocale(Locale.getDefault());
        this.setElegantTextHeight(false);
        this.mFontFeatureSettings = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(Paint paint) {
        if (this != paint) {
            Paint.native_set(this.mNativePaint, paint.mNativePaint);
            this.setClassVariablesFrom(paint);
        }
        if (this.mTypeface != null) {
            this.mNativeTypeface = Typeface.isFlipFontUsed && this.mTypeface.isLikeDefault ? Typeface.DEFAULT.native_instance : this.mTypeface.native_instance;
        }
        if (this.mNativeTypeface == 0L || this.mTypeface == null) {
            this.mNativeTypeface = Typeface.isFlipFontUsed ? Typeface.DEFAULT.native_instance : 0L;
        }
        Paint.native_setTypeface(this.mNativePaint, this.mNativeTypeface);
    }

    public void setARGB(int n, int n2, int n3, int n4) {
        this.setColor(n4 | (n << 24 | n2 << 16 | n3 << 8));
    }

    public native void setAlpha(int var1);

    public native void setAntiAlias(boolean var1);

    public void setBidiFlags(int n) {
        int n2 = n & 7;
        if (n2 > 5) {
            throw new IllegalArgumentException("unknown bidi flag: " + n2);
        }
        this.mBidiFlags = n2;
    }

    public native void setColor(int var1);

    public ColorFilter setColorFilter(ColorFilter colorFilter) {
        long l = 0L;
        if (colorFilter != null) {
            l = colorFilter.native_instance;
        }
        Paint.native_setColorFilter(this.mNativePaint, l);
        this.mColorFilter = colorFilter;
        return colorFilter;
    }

    public void setCompatibilityScaling(float f) {
        if ((double)f == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
            return;
        }
        this.mHasCompatScaling = true;
        this.mCompatScaling = f;
        this.mInvCompatScaling = 1.0f / f;
    }

    public native void setDither(boolean var1);

    public native void setElegantTextHeight(boolean var1);

    public native void setFakeBoldText(boolean var1);

    public native void setFilterBitmap(boolean var1);

    public native void setFlags(int var1);

    public void setFontFeatureSettings(String string2) {
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        if (string2 == null && this.mFontFeatureSettings == null || string2 != null && string2.equals(this.mFontFeatureSettings)) {
            return;
        }
        this.mFontFeatureSettings = string2;
        Paint.native_setFontFeatureSettings(this.mNativePaint, string2);
    }

    public native void setHinting(int var1);

    public void setLetterSpacing(float f) {
        Paint.native_setLetterSpacing(this.mNativePaint, f);
    }

    public native void setLinearText(boolean var1);

    public MaskFilter setMaskFilter(MaskFilter maskFilter) {
        long l = 0L;
        if (maskFilter != null) {
            l = maskFilter.native_instance;
        }
        Paint.native_setMaskFilter(this.mNativePaint, l);
        this.mMaskFilter = maskFilter;
        return maskFilter;
    }

    public PathEffect setPathEffect(PathEffect pathEffect) {
        long l = 0L;
        if (pathEffect != null) {
            l = pathEffect.native_instance;
        }
        Paint.native_setPathEffect(this.mNativePaint, l);
        this.mPathEffect = pathEffect;
        return pathEffect;
    }

    @Deprecated
    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        long l = 0L;
        if (rasterizer != null) {
            l = rasterizer.native_instance;
        }
        Paint.native_setRasterizer(this.mNativePaint, l);
        this.mRasterizer = rasterizer;
        return rasterizer;
    }

    public Shader setShader(Shader shader) {
        long l = 0L;
        if (shader != null) {
            l = shader.getNativeInstance();
        }
        Paint.native_setShader(this.mNativePaint, l);
        this.mShader = shader;
        return shader;
    }

    public void setShadowLayer(float f, float f2, float f3, int n) {
        Paint.native_setShadowLayer(this.mNativePaint, f, f2, f3, n);
    }

    public native void setStrikeThruText(boolean var1);

    public void setStrokeCap(Cap cap) {
        Paint.native_setStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    public void setStrokeJoin(Join join) {
        Paint.native_setStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    public native void setStrokeMiter(float var1);

    public native void setStrokeWidth(float var1);

    public void setStyle(Style style2) {
        Paint.native_setStyle(this.mNativePaint, style2.nativeInt);
    }

    public native void setSubpixelText(boolean var1);

    public void setTextAlign(Align align) {
        Paint.native_setTextAlign(this.mNativePaint, align.nativeInt);
    }

    public void setTextLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        if (locale.equals(this.mLocale)) {
            return;
        }
        this.mLocale = locale;
        Paint.native_setTextLocale(this.mNativePaint, locale.toString());
    }

    public native void setTextScaleX(float var1);

    public native void setTextSize(float var1);

    public native void setTextSkewX(float var1);

    /*
     * Enabled aggressive block sorting
     */
    public Typeface setTypeface(Typeface typeface) {
        long l = 0L;
        if (typeface != null) {
            l = Typeface.isFlipFontUsed && typeface.isLikeDefault ? Typeface.DEFAULT.native_instance : typeface.native_instance;
        }
        if (l == 0L && Typeface.isFlipFontUsed) {
            l = Typeface.DEFAULT.native_instance;
        }
        Paint.native_setTypeface(this.mNativePaint, l);
        this.mTypeface = typeface;
        this.mNativeTypeface = l;
        return typeface;
    }

    public native void setUnderlineText(boolean var1);

    public Xfermode setXfermode(Xfermode xfermode) {
        long l = 0L;
        if (xfermode != null) {
            l = xfermode.native_instance;
        }
        Paint.native_setXfermode(this.mNativePaint, l);
        this.mXfermode = xfermode;
        return xfermode;
    }

    public static final class Align
    extends Enum<Align> {
        private static final /* synthetic */ Align[] $VALUES;
        public static final /* enum */ Align CENTER;
        public static final /* enum */ Align LEFT;
        public static final /* enum */ Align RIGHT;
        final int nativeInt;

        static {
            LEFT = new Align(0);
            CENTER = new Align(1);
            RIGHT = new Align(2);
            Align[] alignArray = new Align[]{LEFT, CENTER, RIGHT};
            $VALUES = alignArray;
        }

        private Align(int n2) {
            this.nativeInt = n2;
        }

        public static Align valueOf(String string2) {
            return Enum.valueOf(Align.class, string2);
        }

        public static Align[] values() {
            return (Align[])$VALUES.clone();
        }
    }

    public static final class Cap
    extends Enum<Cap> {
        private static final /* synthetic */ Cap[] $VALUES;
        public static final /* enum */ Cap BUTT = new Cap(0);
        public static final /* enum */ Cap ROUND = new Cap(1);
        public static final /* enum */ Cap SQUARE = new Cap(2);
        final int nativeInt;

        static {
            Cap[] capArray = new Cap[]{BUTT, ROUND, SQUARE};
            $VALUES = capArray;
        }

        private Cap(int n2) {
            this.nativeInt = n2;
        }

        public static Cap valueOf(String string2) {
            return Enum.valueOf(Cap.class, string2);
        }

        public static Cap[] values() {
            return (Cap[])$VALUES.clone();
        }
    }

    public static class FontMetrics {
        public float ascent;
        public float bottom;
        public float descent;
        public float leading;
        public float top;
    }

    public static class FontMetricsInt {
        public int ascent;
        public int bottom;
        public int descent;
        public int leading;
        public int top;

        public String toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }
    }

    public static final class Join
    extends Enum<Join> {
        private static final /* synthetic */ Join[] $VALUES;
        public static final /* enum */ Join BEVEL;
        public static final /* enum */ Join MITER;
        public static final /* enum */ Join ROUND;
        final int nativeInt;

        static {
            MITER = new Join(0);
            ROUND = new Join(1);
            BEVEL = new Join(2);
            Join[] joinArray = new Join[]{MITER, ROUND, BEVEL};
            $VALUES = joinArray;
        }

        private Join(int n2) {
            this.nativeInt = n2;
        }

        public static Join valueOf(String string2) {
            return Enum.valueOf(Join.class, string2);
        }

        public static Join[] values() {
            return (Join[])$VALUES.clone();
        }
    }

    public static final class Style
    extends Enum<Style> {
        private static final /* synthetic */ Style[] $VALUES;
        public static final /* enum */ Style FILL = new Style(0);
        public static final /* enum */ Style FILL_AND_STROKE;
        public static final /* enum */ Style STROKE;
        final int nativeInt;

        static {
            STROKE = new Style(1);
            FILL_AND_STROKE = new Style(2);
            Style[] styleArray = new Style[]{FILL, STROKE, FILL_AND_STROKE};
            $VALUES = styleArray;
        }

        private Style(int n2) {
            this.nativeInt = n2;
        }

        public static Style valueOf(String string2) {
            return Enum.valueOf(Style.class, string2);
        }

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }
    }
}

