/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseLongArray;
import android.util.SparseIntArray;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedStateListDrawable
extends StateListDrawable {
    private static final String ELEMENT_ITEM = "item";
    private static final String ELEMENT_TRANSITION = "transition";
    private static final String LOGTAG = AnimatedStateListDrawable.class.getSimpleName();
    private boolean mMutated;
    private AnimatedStateListState mState;
    private Transition mTransition;
    private int mTransitionFromIndex = -1;
    private int mTransitionToIndex = -1;

    public AnimatedStateListDrawable() {
        this(null, null);
    }

    private AnimatedStateListDrawable(AnimatedStateListState animatedStateListState, Resources resources) {
        super(null);
        this.setConstantState(new AnimatedStateListState(animatedStateListState, this, resources));
        this.onStateChange(this.getState());
        this.jumpToCurrentState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseItem(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        Drawable drawable2;
        int n2 = 0;
        int n3 = 0;
        int n4 = attributeSet.getAttributeCount();
        int[] nArray = new int[n4];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            block10: {
                int n7;
                block9: {
                    n7 = attributeSet.getAttributeNameResource(i);
                    switch (n7) {
                        default: {
                            boolean bl = attributeSet.getAttributeBooleanValue(i, false);
                            n6 = n5 + 1;
                            if (!bl) break;
                            break block9;
                        }
                        case 0: {
                            n6 = n5;
                            break block10;
                        }
                        case 0x10100D0: {
                            n3 = attributeSet.getAttributeResourceValue(i, 0);
                            n6 = n5;
                            break block10;
                        }
                        case 0x1010199: {
                            n2 = attributeSet.getAttributeResourceValue(i, 0);
                            n6 = n5;
                            break block10;
                        }
                    }
                    n7 = -n7;
                }
                nArray[n5] = n7;
            }
            n5 = n6;
        }
        int[] nArray2 = StateSet.trimStateSet(nArray, n5);
        if (n2 != 0) {
            drawable2 = resources.getDrawable(n2, theme);
            return this.mState.addStateSet(nArray2, drawable2, n3);
        }
        while ((n = xmlPullParser.next()) == 4) {
        }
        if (n != 2) {
            throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
        }
        drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
        return this.mState.addStateSet(nArray2, drawable2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseTransition(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        Drawable drawable2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = attributeSet.getAttributeCount();
        block6: for (int i = 0; i < n5; ++i) {
            switch (attributeSet.getAttributeNameResource(i)) {
                case 16843850: {
                    n3 = attributeSet.getAttributeResourceValue(i, 0);
                    continue block6;
                }
                case 16843849: {
                    n4 = attributeSet.getAttributeResourceValue(i, 0);
                    continue block6;
                }
                case 0x1010199: {
                    n2 = attributeSet.getAttributeResourceValue(i, 0);
                    continue block6;
                }
                case 16843851: {
                    bl = attributeSet.getAttributeBooleanValue(i, false);
                    continue block6;
                }
            }
        }
        if (n2 != 0) {
            drawable2 = resources.getDrawable(n2, theme);
            return this.mState.addTransition(n3, n4, drawable2, bl);
        }
        while ((n = xmlPullParser.next()) == 4) {
        }
        if (n != 2) {
            throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
        }
        drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
        return this.mState.addTransition(n3, n4, drawable2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean selectTransition(int n) {
        Transition transition2;
        int n2;
        Transition transition3 = this.mTransition;
        if (transition3 != null) {
            if (n == this.mTransitionToIndex) {
                return true;
            }
            if (n == this.mTransitionFromIndex && transition3.canReverse()) {
                transition3.reverse();
                this.mTransitionToIndex = this.mTransitionFromIndex;
                this.mTransitionFromIndex = n;
                return true;
            }
            n2 = this.mTransitionToIndex;
            transition3.stop();
        } else {
            n2 = this.getCurrentIndex();
        }
        this.mTransition = null;
        this.mTransitionFromIndex = -1;
        this.mTransitionToIndex = -1;
        AnimatedStateListState animatedStateListState = this.mState;
        int n3 = animatedStateListState.getKeyframeIdAt(n2);
        int n4 = animatedStateListState.getKeyframeIdAt(n);
        if (n4 == 0 || n3 == 0) {
            return false;
        }
        int n5 = animatedStateListState.indexOfTransition(n3, n4);
        if (n5 < 0) {
            return false;
        }
        this.selectDrawable(n5);
        Drawable drawable2 = this.getCurrent();
        if (drawable2 instanceof AnimationDrawable) {
            boolean bl = animatedStateListState.isTransitionReversed(n3, n4);
            transition2 = new AnimationDrawableTransition((AnimationDrawable)drawable2, bl);
        } else if (drawable2 instanceof AnimatedVectorDrawable) {
            boolean bl = animatedStateListState.isTransitionReversed(n3, n4);
            transition2 = new AnimatedVectorDrawableTransition((AnimatedVectorDrawable)drawable2, bl);
        } else {
            if (!(drawable2 instanceof Animatable)) {
                return false;
            }
            transition2 = new AnimatableTransition((Animatable)((Object)drawable2));
        }
        transition2.start();
        this.mTransition = transition2;
        this.mTransitionFromIndex = n2;
        this.mTransitionToIndex = n;
        return true;
    }

    public void addState(int[] nArray, Drawable drawable2, int n) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable must not be null");
        }
        this.mState.addStateSet(nArray, drawable2, n);
        this.onStateChange(this.getState());
    }

    public <T extends Drawable> void addTransition(int n, int n2, T t, boolean bl) {
        if (t == null) {
            throw new IllegalArgumentException("Transition drawable must not be null");
        }
        this.mState.addTransition(n, n2, t, bl);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        int n2;
        TypedArray typedArray = AnimatedStateListDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.AnimatedStateListDrawable);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 1);
        StateListDrawable.StateListState stateListState = this.getStateListState();
        stateListState.setVariablePadding(typedArray.getBoolean(2, false));
        stateListState.setConstantSize(typedArray.getBoolean(3, false));
        stateListState.setEnterFadeDuration(typedArray.getInt(4, 0));
        stateListState.setExitFadeDuration(typedArray.getInt(5, 0));
        this.setDither(typedArray.getBoolean(0, true));
        this.setAutoMirrored(typedArray.getBoolean(6, false));
        typedArray.recycle();
        int n3 = 1 + xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && ((n = xmlPullParser.getDepth()) >= n3 || n2 != 3)) {
            if (n2 != 2 || n > n3) continue;
            if (xmlPullParser.getName().equals(ELEMENT_ITEM)) {
                this.parseItem(resources, xmlPullParser, attributeSet, theme);
                continue;
            }
            if (!xmlPullParser.getName().equals(ELEMENT_TRANSITION)) continue;
            this.parseTransition(resources, xmlPullParser, attributeSet, theme);
        }
        this.onStateChange(this.getState());
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.stop();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToIndex);
            this.mTransitionToIndex = -1;
            this.mTransitionFromIndex = -1;
        }
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.setConstantState(new AnimatedStateListState(this.mState, this, null));
            this.mMutated = true;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = true;
        int n = this.mState.indexOfKeyframe(nArray);
        if (n == this.getCurrentIndex()) {
            Drawable drawable2 = this.getCurrent();
            if (drawable2 == null) return false;
            return drawable2.setState(nArray);
        }
        if (this.selectTransition(n)) return bl;
        if (this.selectDrawable(n)) return bl;
        return super.onStateChange(nArray);
    }

    void setConstantState(AnimatedStateListState animatedStateListState) {
        super.setConstantState(animatedStateListState);
        this.mState = animatedStateListState;
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3;
        block3: {
            block2: {
                bl3 = super.setVisible(bl, bl2);
                if (this.mTransition == null || !bl3 && !bl2) break block2;
                if (!bl) break block3;
                this.mTransition.start();
            }
            return bl3;
        }
        this.jumpToCurrentState();
        return bl3;
    }

    private static class AnimatableTransition
    extends Transition {
        private final Animatable mA;

        public AnimatableTransition(Animatable animatable) {
            this.mA = animatable;
        }

        @Override
        public void start() {
            this.mA.start();
        }

        @Override
        public void stop() {
            this.mA.stop();
        }
    }

    static class AnimatedStateListState
    extends StateListDrawable.StateListState {
        private static final int REVERSE_MASK = 1;
        private static final int REVERSE_SHIFT = 32;
        final SparseIntArray mStateIds;
        final LongSparseLongArray mTransitions;

        AnimatedStateListState(AnimatedStateListState animatedStateListState, AnimatedStateListDrawable animatedStateListDrawable, Resources resources) {
            super(animatedStateListState, animatedStateListDrawable, resources);
            if (animatedStateListState != null) {
                this.mTransitions = animatedStateListState.mTransitions.clone();
                this.mStateIds = animatedStateListState.mStateIds.clone();
                return;
            }
            this.mTransitions = new LongSparseLongArray();
            this.mStateIds = new SparseIntArray();
        }

        private static long generateTransitionKey(int n, int n2) {
            return (long)n << 32 | (long)n2;
        }

        int addStateSet(int[] nArray, Drawable drawable2, int n) {
            int n2 = super.addStateSet(nArray, drawable2);
            this.mStateIds.put(n2, n);
            return n2;
        }

        int addTransition(int n, int n2, Drawable drawable2, boolean bl) {
            int n3 = super.addChild(drawable2);
            long l = AnimatedStateListState.generateTransitionKey(n, n2);
            this.mTransitions.append(l, n3);
            if (bl) {
                long l2 = AnimatedStateListState.generateTransitionKey(n2, n);
                this.mTransitions.append(l2, 0x100000000L | (long)n3);
            }
            return this.addChild(drawable2);
        }

        int getKeyframeIdAt(int n) {
            if (n < 0) {
                return 0;
            }
            return this.mStateIds.get(n, 0);
        }

        int indexOfKeyframe(int[] nArray) {
            int n = super.indexOfStateSet(nArray);
            if (n >= 0) {
                return n;
            }
            return super.indexOfStateSet(StateSet.WILD_CARD);
        }

        int indexOfTransition(int n, int n2) {
            long l = AnimatedStateListState.generateTransitionKey(n, n2);
            return (int)this.mTransitions.get(l, -1L);
        }

        boolean isTransitionReversed(int n, int n2) {
            long l = AnimatedStateListState.generateTransitionKey(n, n2);
            return (1L & this.mTransitions.get(l, -1L) >> 32) == 1L;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedStateListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new AnimatedStateListDrawable(this, resources);
        }
    }

    private static class AnimatedVectorDrawableTransition
    extends Transition {
        private final AnimatedVectorDrawable mAvd;
        private final boolean mReversed;

        public AnimatedVectorDrawableTransition(AnimatedVectorDrawable animatedVectorDrawable, boolean bl) {
            this.mAvd = animatedVectorDrawable;
            this.mReversed = bl;
        }

        @Override
        public boolean canReverse() {
            return this.mAvd.canReverse();
        }

        @Override
        public void reverse() {
            if (this.canReverse()) {
                this.mAvd.reverse();
                return;
            }
            Log.w(LOGTAG, "Reverse() is called on a drawable can't reverse");
        }

        @Override
        public void start() {
            if (this.mReversed) {
                this.reverse();
                return;
            }
            this.mAvd.start();
        }

        @Override
        public void stop() {
            this.mAvd.stop();
        }
    }

    private static class AnimationDrawableTransition
    extends Transition {
        private final ObjectAnimator mAnim;

        /*
         * Enabled aggressive block sorting
         */
        public AnimationDrawableTransition(AnimationDrawable animationDrawable, boolean bl) {
            int n = animationDrawable.getNumberOfFrames();
            int n2 = bl ? n - 1 : 0;
            int n3 = bl ? 0 : n - 1;
            FrameInterpolator frameInterpolator = new FrameInterpolator(animationDrawable, bl);
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)animationDrawable, "currentIndex", n2, n3);
            objectAnimator.setAutoCancel(true);
            objectAnimator.setDuration(frameInterpolator.getTotalDuration());
            objectAnimator.setInterpolator(frameInterpolator);
            this.mAnim = objectAnimator;
        }

        @Override
        public boolean canReverse() {
            return true;
        }

        @Override
        public void reverse() {
            this.mAnim.reverse();
        }

        @Override
        public void start() {
            this.mAnim.start();
        }

        @Override
        public void stop() {
            this.mAnim.cancel();
        }
    }

    private static class FrameInterpolator
    implements TimeInterpolator {
        private int[] mFrameTimes;
        private int mFrames;
        private int mTotalDuration;

        public FrameInterpolator(AnimationDrawable animationDrawable, boolean bl) {
            this.updateFrames(animationDrawable, bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public float getInterpolation(float f) {
            float f2;
            int n;
            int n2 = (int)(0.5f + f * (float)this.mTotalDuration);
            int n3 = this.mFrames;
            int[] nArray = this.mFrameTimes;
            int n4 = n2;
            for (n = 0; n < n3 && n4 >= nArray[n]; n4 -= nArray[n], ++n) {
            }
            if (n < n3) {
                f2 = (float)n4 / (float)this.mTotalDuration;
                return f2 + (float)n / (float)n3;
            }
            f2 = 0.0f;
            return f2 + (float)n / (float)n3;
        }

        public int getTotalDuration() {
            return this.mTotalDuration;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int updateFrames(AnimationDrawable animationDrawable, boolean bl) {
            int n;
            this.mFrames = n = animationDrawable.getNumberOfFrames();
            if (this.mFrameTimes == null || this.mFrameTimes.length < n) {
                this.mFrameTimes = new int[n];
            }
            int[] nArray = this.mFrameTimes;
            int n2 = 0;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= n) {
                    this.mTotalDuration = n2;
                    return n2;
                }
                int n5 = bl ? -1 + (n - n3) : n3;
                nArray[n3] = n4 = animationDrawable.getDuration(n5);
                n2 += n4;
                ++n3;
            }
        }
    }

    private static abstract class Transition {
        private Transition() {
        }

        public boolean canReverse() {
            return false;
        }

        public void reverse() {
        }

        public abstract void start();

        public abstract void stop();
    }
}

