/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewDebug;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorDrawable
extends Drawable {
    @ViewDebug.ExportedProperty(deepExport=true, prefix="state_")
    private ColorState mColorState;
    private boolean mMutated;
    private final Paint mPaint = new Paint();
    private PorterDuffColorFilter mTintFilter;

    public ColorDrawable() {
        this.mColorState = new ColorState();
    }

    public ColorDrawable(int n) {
        this.mColorState = new ColorState();
        this.setColor(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ColorDrawable(ColorState colorState, Resources resources, Resources.Theme theme) {
        if (theme != null && colorState.canApplyTheme()) {
            this.mColorState = new ColorState(colorState);
            this.applyTheme(theme);
        } else {
            this.mColorState = colorState;
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, colorState.mTint, colorState.mTintMode);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        ColorState colorState = this.mColorState;
        colorState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        colorState.mThemeAttrs = typedArray.extractThemeAttrs();
        colorState.mUseColor = colorState.mBaseColor = typedArray.getColor(0, colorState.mBaseColor);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        ColorState colorState = this.mColorState;
        if (colorState == null || colorState.mThemeAttrs == null) {
            return;
        }
        TypedArray typedArray = theme.resolveAttributes(colorState.mThemeAttrs, R.styleable.ColorDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
    }

    @Override
    public void draw(Canvas canvas) {
        ColorFilter colorFilter = this.mPaint.getColorFilter();
        if (this.mColorState.mUseColor >>> 24 != 0 || colorFilter != null || this.mTintFilter != null) {
            if (colorFilter == null) {
                this.mPaint.setColorFilter(this.mTintFilter);
            }
            this.mPaint.setColor(this.mColorState.mUseColor);
            canvas.drawRect(this.getBounds(), this.mPaint);
            this.mPaint.setColorFilter(colorFilter);
        }
    }

    @Override
    public int getAlpha() {
        return this.mColorState.mUseColor >>> 24;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mColorState.mChangingConfigurations;
    }

    public int getColor() {
        return this.mColorState.mUseColor;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mColorState;
    }

    @Override
    public int getOpacity() {
        if (this.mTintFilter != null || this.mPaint.getColorFilter() != null) {
            return -3;
        }
        switch (this.mColorState.mUseColor >>> 24) {
            default: {
                return -3;
            }
            case 0: {
                return -2;
            }
            case 255: 
        }
        return -1;
    }

    @Override
    public void getOutline(Outline outline) {
        outline.setRect(this.getBounds());
        outline.setAlpha((float)this.getAlpha() / 255.0f);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        TypedArray typedArray = ColorDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.ColorDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
    }

    @Override
    public boolean isStateful() {
        return this.mColorState.mTint != null && this.mColorState.mTint.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mColorState = new ColorState(this.mColorState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        ColorState colorState = this.mColorState;
        if (colorState.mTint != null && colorState.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, colorState.mTint, colorState.mTintMode);
            return true;
        }
        return false;
    }

    @Override
    public void setAlpha(int n) {
        int n2 = (n + (n >> 7)) * (this.mColorState.mBaseColor >>> 24) >> 8;
        int n3 = this.mColorState.mBaseColor << 8 >>> 8 | n2 << 24;
        if (this.mColorState.mUseColor != n3) {
            this.mColorState.mUseColor = n3;
            this.invalidateSelf();
        }
    }

    public void setColor(int n) {
        if (this.mColorState.mBaseColor != n || this.mColorState.mUseColor != n) {
            ColorState colorState = this.mColorState;
            this.mColorState.mUseColor = n;
            colorState.mBaseColor = n;
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mColorState.mTint = colorStateList;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, colorStateList, this.mColorState.mTintMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mColorState.mTintMode = mode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mColorState.mTint, mode);
        this.invalidateSelf();
    }

    static final class ColorState
    extends Drawable.ConstantState {
        int mBaseColor;
        int mChangingConfigurations;
        int[] mThemeAttrs;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = Drawable.DEFAULT_TINT_MODE;
        @ViewDebug.ExportedProperty
        int mUseColor;

        ColorState() {
        }

        ColorState(ColorState colorState) {
            this.mThemeAttrs = colorState.mThemeAttrs;
            this.mBaseColor = colorState.mBaseColor;
            this.mUseColor = colorState.mUseColor;
            this.mChangingConfigurations = colorState.mChangingConfigurations;
            this.mTint = colorState.mTint;
            this.mTintMode = colorState.mTintMode;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ColorDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ColorDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new ColorDrawable(this, resources, theme);
        }
    }
}

