/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.SparseArray;

public class DrawableContainer
extends Drawable
implements Drawable.Callback {
    private static final boolean DEBUG = false;
    private static final boolean DEFAULT_DITHER = true;
    private static final String TAG = "DrawableContainer";
    private int mAlpha = 255;
    private Runnable mAnimationRunnable;
    private int mCurIndex = -1;
    private Drawable mCurrDrawable;
    private DrawableContainerState mDrawableContainerState;
    private long mEnterAnimationEnd;
    private long mExitAnimationEnd;
    private boolean mHasAlpha;
    private Rect mHotspotBounds;
    private Drawable mLastDrawable;
    private boolean mMutated;

    private boolean needsMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    void animate(boolean bl) {
        boolean bl2;
        this.mHasAlpha = true;
        long l = SystemClock.uptimeMillis();
        if (this.mCurrDrawable != null) {
            long l2 = this.mEnterAnimationEnd - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            bl2 = false;
            if (l3 != false) {
                if (this.mEnterAnimationEnd <= l) {
                    this.mCurrDrawable.mutate().setAlpha(this.mAlpha);
                    this.mEnterAnimationEnd = 0L;
                } else {
                    int n = (int)(255L * (this.mEnterAnimationEnd - l)) / this.mDrawableContainerState.mEnterFadeDuration;
                    this.mCurrDrawable.mutate().setAlpha((255 - n) * this.mAlpha / 255);
                    bl2 = true;
                }
            }
        } else {
            this.mEnterAnimationEnd = 0L;
            bl2 = false;
        }
        if (this.mLastDrawable != null) {
            if (this.mExitAnimationEnd != 0L) {
                if (this.mExitAnimationEnd <= l) {
                    this.mLastDrawable.setVisible(false, false);
                    this.mLastDrawable = null;
                    this.mExitAnimationEnd = 0L;
                } else {
                    int n = (int)(255L * (this.mExitAnimationEnd - l)) / this.mDrawableContainerState.mExitFadeDuration;
                    this.mLastDrawable.mutate().setAlpha(n * this.mAlpha / 255);
                    bl2 = true;
                }
            }
        } else {
            this.mExitAnimationEnd = 0L;
        }
        if (bl && bl2) {
            this.scheduleSelf(this.mAnimationRunnable, 16L + l);
        }
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        this.mDrawableContainerState.applyTheme(theme);
    }

    @Override
    public boolean canApplyTheme() {
        return this.mDrawableContainerState.canApplyTheme();
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.draw(canvas);
        }
        if (this.mLastDrawable != null) {
            this.mLastDrawable.draw(canvas);
        }
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mDrawableContainerState.mChangingConfigurations | this.mDrawableContainerState.mChildrenChangingConfigurations;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mDrawableContainerState.canConstantState()) {
            this.mDrawableContainerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mDrawableContainerState;
        }
        return null;
    }

    @Override
    public Drawable getCurrent() {
        return this.mCurrDrawable;
    }

    public int getCurrentIndex() {
        return this.mCurIndex;
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        if (this.mHotspotBounds != null) {
            rect.set(this.mHotspotBounds);
            return;
        }
        super.getHotspotBounds(rect);
    }

    @Override
    public int getIntrinsicHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantHeight();
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getIntrinsicHeight();
        }
        return -1;
    }

    @Override
    public int getIntrinsicWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantWidth();
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getIntrinsicWidth();
        }
        return -1;
    }

    @Override
    public int getMinimumHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumHeight();
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getMinimumHeight();
        }
        return 0;
    }

    @Override
    public int getMinimumWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumWidth();
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getMinimumWidth();
        }
        return 0;
    }

    @Override
    public int getOpacity() {
        if (this.mCurrDrawable == null || !this.mCurrDrawable.isVisible()) {
            return -2;
        }
        return this.mDrawableContainerState.getOpacity();
    }

    @Override
    public Insets getOpticalInsets() {
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getOpticalInsets();
        }
        return Insets.NONE;
    }

    @Override
    public void getOutline(Outline outline) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.getOutline(outline);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getPadding(Rect rect) {
        boolean bl;
        Rect rect2 = this.mDrawableContainerState.getConstantPadding();
        if (rect2 != null) {
            rect.set(rect2);
            bl = (rect2.left | rect2.top | rect2.bottom | rect2.right) != 0;
        } else {
            bl = this.mCurrDrawable != null ? this.mCurrDrawable.getPadding(rect) : super.getPadding(rect);
        }
        if (this.needsMirroring()) {
            int n = rect.left;
            rect.left = rect.right;
            rect.right = n;
        }
        return bl;
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (drawable2 == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mDrawableContainerState.mAutoMirrored;
    }

    @Override
    public boolean isStateful() {
        return this.mDrawableContainerState.isStateful();
    }

    @Override
    public void jumpToCurrentState() {
        Drawable drawable2 = this.mLastDrawable;
        boolean bl = false;
        if (drawable2 != null) {
            this.mLastDrawable.jumpToCurrentState();
            this.mLastDrawable = null;
            bl = true;
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.jumpToCurrentState();
            if (this.mHasAlpha) {
                this.mCurrDrawable.mutate().setAlpha(this.mAlpha);
            }
        }
        if (this.mExitAnimationEnd != 0L) {
            this.mExitAnimationEnd = 0L;
            bl = true;
        }
        if (this.mEnterAnimationEnd != 0L) {
            this.mEnterAnimationEnd = 0L;
            bl = true;
        }
        if (bl) {
            this.invalidateSelf();
        }
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mDrawableContainerState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setBounds(rect);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setBounds(rect);
        }
    }

    @Override
    protected boolean onLevelChange(int n) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setLevel(n);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setLevel(n);
        }
        return false;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setState(nArray);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setState(nArray);
        }
        return false;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        if (drawable2 == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, runnable, l);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean selectDrawable(int n) {
        block21: {
            block20: {
                Drawable drawable2;
                if (n == this.mCurIndex) {
                    return false;
                }
                long l = SystemClock.uptimeMillis();
                if (this.mDrawableContainerState.mExitFadeDuration > 0) {
                    if (this.mLastDrawable != null) {
                        this.mLastDrawable.setVisible(false, false);
                    }
                    if (this.mCurrDrawable != null) {
                        this.mLastDrawable = this.mCurrDrawable;
                        this.mExitAnimationEnd = l + (long)this.mDrawableContainerState.mExitFadeDuration;
                    } else {
                        this.mLastDrawable = null;
                        this.mExitAnimationEnd = 0L;
                    }
                } else if (this.mCurrDrawable != null) {
                    this.mCurrDrawable.setVisible(false, false);
                }
                if (n < 0 || n >= this.mDrawableContainerState.mNumChildren) break block20;
                this.mCurrDrawable = drawable2 = this.mDrawableContainerState.getChild(n);
                this.mCurIndex = n;
                if (drawable2 != null) {
                    drawable2.mutate();
                    if (this.mDrawableContainerState.mEnterFadeDuration > 0) {
                        this.mEnterAnimationEnd = l + (long)this.mDrawableContainerState.mEnterFadeDuration;
                    } else if (this.mHasAlpha) {
                        drawable2.setAlpha(this.mAlpha);
                    }
                    if (this.mDrawableContainerState.mHasColorFilter) {
                        drawable2.setColorFilter(this.mDrawableContainerState.mColorFilter);
                    } else {
                        if (this.mDrawableContainerState.mHasTintList) {
                            drawable2.setTintList(this.mDrawableContainerState.mTintList);
                        }
                        if (this.mDrawableContainerState.mHasTintMode) {
                            drawable2.setTintMode(this.mDrawableContainerState.mTintMode);
                        }
                    }
                    drawable2.setVisible(this.isVisible(), true);
                    drawable2.setDither(this.mDrawableContainerState.mDither);
                    drawable2.setState(this.getState());
                    drawable2.setLevel(this.getLevel());
                    drawable2.setBounds(this.getBounds());
                    drawable2.setLayoutDirection(this.getLayoutDirection());
                    drawable2.setAutoMirrored(this.mDrawableContainerState.mAutoMirrored);
                    Rect rect = this.mHotspotBounds;
                    if (rect != null) {
                        drawable2.setHotspotBounds(rect.left, rect.top, rect.right, rect.bottom);
                    }
                }
                break block21;
            }
            this.mCurrDrawable = null;
            this.mCurIndex = -1;
        }
        if (this.mEnterAnimationEnd != 0L || this.mExitAnimationEnd != 0L) {
            if (this.mAnimationRunnable == null) {
                this.mAnimationRunnable = new Runnable(){

                    @Override
                    public void run() {
                        DrawableContainer.this.animate(true);
                        DrawableContainer.this.invalidateSelf();
                    }
                };
            } else {
                this.unscheduleSelf(this.mAnimationRunnable);
            }
            this.animate(true);
        }
        this.invalidateSelf();
        return true;
    }

    @Override
    public void setAlpha(int n) {
        block3: {
            block2: {
                if (this.mHasAlpha && this.mAlpha == n) break block2;
                this.mHasAlpha = true;
                this.mAlpha = n;
                if (this.mCurrDrawable == null) break block2;
                if (this.mEnterAnimationEnd != 0L) break block3;
                this.mCurrDrawable.mutate().setAlpha(n);
            }
            return;
        }
        this.animate(false);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        if (this.mDrawableContainerState.mAutoMirrored != bl) {
            this.mDrawableContainerState.mAutoMirrored = bl;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.mutate().setAutoMirrored(this.mDrawableContainerState.mAutoMirrored);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        DrawableContainerState drawableContainerState = this.mDrawableContainerState;
        boolean bl = colorFilter != null;
        drawableContainerState.mHasColorFilter = bl;
        if (this.mDrawableContainerState.mColorFilter != colorFilter) {
            this.mDrawableContainerState.mColorFilter = colorFilter;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.mutate().setColorFilter(colorFilter);
            }
        }
    }

    protected void setConstantState(DrawableContainerState drawableContainerState) {
        this.mDrawableContainerState = drawableContainerState;
    }

    public void setCurrentIndex(int n) {
        this.selectDrawable(n);
    }

    @Override
    public void setDither(boolean bl) {
        if (this.mDrawableContainerState.mDither != bl) {
            this.mDrawableContainerState.mDither = bl;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.mutate().setDither(this.mDrawableContainerState.mDither);
            }
        }
    }

    public void setEnterFadeDuration(int n) {
        this.mDrawableContainerState.mEnterFadeDuration = n;
    }

    public void setExitFadeDuration(int n) {
        this.mDrawableContainerState.mExitFadeDuration = n;
    }

    @Override
    public void setHotspot(float f, float f2) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setHotspot(f, f2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(n, n2, n4, n3);
        } else {
            this.mHotspotBounds.set(n, n2, n4, n3);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setHotspotBounds(n, n2, n3, n4);
        }
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mDrawableContainerState.mHasTintList = true;
        if (this.mDrawableContainerState.mTintList != colorStateList) {
            this.mDrawableContainerState.mTintList = colorStateList;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.mutate().setTintList(colorStateList);
            }
        }
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mDrawableContainerState.mHasTintMode = true;
        if (this.mDrawableContainerState.mTintMode != mode) {
            this.mDrawableContainerState.mTintMode = mode;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.mutate().setTintMode(mode);
            }
        }
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setVisible(bl, bl2);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(bl, bl2);
        }
        return bl3;
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        if (drawable2 == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, runnable);
        }
    }

    public static abstract class DrawableContainerState
    extends Drawable.ConstantState {
        boolean mAutoMirrored;
        boolean mCanConstantState;
        int mChangingConfigurations;
        boolean mCheckedConstantState;
        boolean mCheckedOpacity;
        boolean mCheckedStateful;
        int mChildrenChangingConfigurations;
        ColorFilter mColorFilter;
        boolean mComputedConstantSize;
        int mConstantHeight;
        int mConstantMinimumHeight;
        int mConstantMinimumWidth;
        Rect mConstantPadding;
        boolean mConstantSize;
        int mConstantWidth;
        boolean mDither = true;
        SparseArray<ConstantStateFuture> mDrawableFutures;
        Drawable[] mDrawables;
        int mEnterFadeDuration;
        int mExitFadeDuration;
        boolean mHasColorFilter;
        boolean mHasTintList;
        boolean mHasTintMode;
        int mLayoutDirection;
        boolean mMutated;
        int mNumChildren;
        int mOpacity;
        final DrawableContainer mOwner;
        boolean mPaddingChecked;
        final Resources mRes;
        boolean mStateful;
        Resources.Theme mTheme;
        ColorStateList mTintList;
        PorterDuff.Mode mTintMode;
        boolean mVariablePadding;

        /*
         * Enabled aggressive block sorting
         */
        DrawableContainerState(DrawableContainerState drawableContainerState, DrawableContainer drawableContainer, Resources resources) {
            this.mOwner = drawableContainer;
            this.mRes = resources;
            if (drawableContainerState != null) {
                this.mChangingConfigurations = drawableContainerState.mChangingConfigurations;
                this.mChildrenChangingConfigurations = drawableContainerState.mChildrenChangingConfigurations;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
                this.mVariablePadding = drawableContainerState.mVariablePadding;
                this.mConstantSize = drawableContainerState.mConstantSize;
                this.mDither = drawableContainerState.mDither;
                this.mMutated = drawableContainerState.mMutated;
                this.mLayoutDirection = drawableContainerState.mLayoutDirection;
                this.mEnterFadeDuration = drawableContainerState.mEnterFadeDuration;
                this.mExitFadeDuration = drawableContainerState.mExitFadeDuration;
                this.mAutoMirrored = drawableContainerState.mAutoMirrored;
                this.mColorFilter = drawableContainerState.mColorFilter;
                this.mHasColorFilter = drawableContainerState.mHasColorFilter;
                this.mTintList = drawableContainerState.mTintList;
                this.mTintMode = drawableContainerState.mTintMode;
                this.mHasTintList = drawableContainerState.mHasTintList;
                this.mHasTintMode = drawableContainerState.mHasTintMode;
                this.mConstantPadding = drawableContainerState.getConstantPadding();
                this.mPaddingChecked = true;
                this.mConstantWidth = drawableContainerState.getConstantWidth();
                this.mConstantHeight = drawableContainerState.getConstantHeight();
                this.mConstantMinimumWidth = drawableContainerState.getConstantMinimumWidth();
                this.mConstantMinimumHeight = drawableContainerState.getConstantMinimumHeight();
                this.mComputedConstantSize = true;
                this.mOpacity = drawableContainerState.getOpacity();
                this.mCheckedOpacity = true;
                this.mStateful = drawableContainerState.isStateful();
                this.mCheckedStateful = true;
                Drawable[] drawableArray = drawableContainerState.mDrawables;
                this.mDrawables = new Drawable[drawableArray.length];
                this.mNumChildren = drawableContainerState.mNumChildren;
                SparseArray<ConstantStateFuture> sparseArray = drawableContainerState.mDrawableFutures;
                this.mDrawableFutures = sparseArray != null ? sparseArray.clone() : new SparseArray(this.mNumChildren);
                int n = this.mNumChildren;
                for (int i = 0; i < n; ++i) {
                    if (drawableArray[i] == null) continue;
                    this.mDrawableFutures.put(i, new ConstantStateFuture(drawableArray[i]));
                }
                return;
            } else {
                this.mDrawables = new Drawable[10];
                this.mNumChildren = 0;
            }
        }

        private final void createAllFutures() {
            if (this.mDrawableFutures != null) {
                int n = this.mDrawableFutures.size();
                for (int i = 0; i < n; ++i) {
                    int n2 = this.mDrawableFutures.keyAt(i);
                    this.mDrawables[n2] = this.mDrawableFutures.valueAt(i).get(this);
                }
                this.mDrawableFutures = null;
            }
        }

        public final int addChild(Drawable drawable2) {
            int n = this.mNumChildren;
            if (n >= this.mDrawables.length) {
                this.growArray(n, n + 10);
            }
            drawable2.setVisible(false, true);
            drawable2.setCallback(this.mOwner);
            this.mDrawables[n] = drawable2;
            this.mNumChildren = 1 + this.mNumChildren;
            this.mChildrenChangingConfigurations |= drawable2.getChangingConfigurations();
            this.mCheckedStateful = false;
            this.mCheckedOpacity = false;
            this.mConstantPadding = null;
            this.mPaddingChecked = false;
            this.mComputedConstantSize = false;
            return n;
        }

        final void applyTheme(Resources.Theme theme) {
            int n = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            for (int i = 0; i < n; ++i) {
                if (drawableArray[i] == null) continue;
                drawableArray[i].applyTheme(theme);
            }
            this.mTheme = theme;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean canApplyTheme() {
            int n = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            int n2 = 0;
            while (n2 < n) {
                ConstantStateFuture constantStateFuture;
                Drawable drawable2 = drawableArray[n2];
                if (drawable2 != null ? drawable2.canApplyTheme() : (constantStateFuture = this.mDrawableFutures.get(n2)) != null && constantStateFuture.canApplyTheme()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean canConstantState() {
            synchronized (this) {
                if (this.mCheckedConstantState) {
                    return this.mCanConstantState;
                }
                this.createAllFutures();
                this.mCheckedConstantState = true;
                int n = this.mNumChildren;
                Drawable[] drawableArray = this.mDrawables;
                for (int i = 0; i < n; ++i) {
                    if (drawableArray[i].getConstantState() != null) continue;
                    this.mCanConstantState = false;
                    return false;
                }
                this.mCanConstantState = true;
                return true;
            }
        }

        protected void computeConstantSize() {
            this.mComputedConstantSize = true;
            this.createAllFutures();
            int n = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            this.mConstantHeight = -1;
            this.mConstantWidth = -1;
            this.mConstantMinimumHeight = 0;
            this.mConstantMinimumWidth = 0;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                int n4;
                Drawable drawable2 = drawableArray[i];
                int n5 = drawable2.getIntrinsicWidth();
                if (n5 > this.mConstantWidth) {
                    this.mConstantWidth = n5;
                }
                if ((n4 = drawable2.getIntrinsicHeight()) > this.mConstantHeight) {
                    this.mConstantHeight = n4;
                }
                if ((n3 = drawable2.getMinimumWidth()) > this.mConstantMinimumWidth) {
                    this.mConstantMinimumWidth = n3;
                }
                if ((n2 = drawable2.getMinimumHeight()) <= this.mConstantMinimumHeight) continue;
                this.mConstantMinimumHeight = n2;
            }
        }

        final int getCapacity() {
            return this.mDrawables.length;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        public final Drawable getChild(int n) {
            int n2;
            Drawable drawable2 = this.mDrawables[n];
            if (drawable2 != null) {
                return drawable2;
            }
            if (this.mDrawableFutures != null && (n2 = this.mDrawableFutures.indexOfKey(n)) >= 0) {
                Drawable drawable3;
                this.mDrawables[n] = drawable3 = this.mDrawableFutures.valueAt(n2).get(this);
                this.mDrawableFutures.removeAt(n2);
                return drawable3;
            }
            return null;
        }

        public final int getChildCount() {
            return this.mNumChildren;
        }

        public final Drawable[] getChildren() {
            this.createAllFutures();
            return this.mDrawables;
        }

        public final int getConstantHeight() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantHeight;
        }

        public final int getConstantMinimumHeight() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumHeight;
        }

        public final int getConstantMinimumWidth() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumWidth;
        }

        public final Rect getConstantPadding() {
            if (this.mVariablePadding) {
                return null;
            }
            if (this.mConstantPadding != null || this.mPaddingChecked) {
                return this.mConstantPadding;
            }
            this.createAllFutures();
            Rect rect = null;
            Rect rect2 = new Rect();
            int n = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            for (int i = 0; i < n; ++i) {
                if (!drawableArray[i].getPadding(rect2)) continue;
                if (rect == null) {
                    rect = new Rect(0, 0, 0, 0);
                }
                if (rect2.left > rect.left) {
                    rect.left = rect2.left;
                }
                if (rect2.top > rect.top) {
                    rect.top = rect2.top;
                }
                if (rect2.right > rect.right) {
                    rect.right = rect2.right;
                }
                if (rect2.bottom <= rect.bottom) continue;
                rect.bottom = rect2.bottom;
            }
            this.mPaddingChecked = true;
            this.mConstantPadding = rect;
            return rect;
        }

        public final int getConstantWidth() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantWidth;
        }

        public final int getEnterFadeDuration() {
            return this.mEnterFadeDuration;
        }

        public final int getExitFadeDuration() {
            return this.mExitFadeDuration;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final int getOpacity() {
            if (this.mCheckedOpacity) {
                return this.mOpacity;
            }
            this.createAllFutures();
            this.mCheckedOpacity = true;
            int n = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            int n2 = n > 0 ? drawableArray[0].getOpacity() : -2;
            int n3 = 1;
            while (true) {
                if (n3 >= n) {
                    this.mOpacity = n2;
                    return n2;
                }
                n2 = Drawable.resolveOpacity(n2, drawableArray[n3].getOpacity());
                ++n3;
            }
        }

        public void growArray(int n, int n2) {
            Drawable[] drawableArray = new Drawable[n2];
            System.arraycopy(this.mDrawables, 0, drawableArray, 0, n);
            this.mDrawables = drawableArray;
        }

        public final boolean isConstantSize() {
            return this.mConstantSize;
        }

        public final boolean isStateful() {
            if (this.mCheckedStateful) {
                return this.mStateful;
            }
            this.createAllFutures();
            this.mCheckedStateful = true;
            int n = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            for (int i = 0; i < n; ++i) {
                if (!drawableArray[i].isStateful()) continue;
                this.mStateful = true;
                return true;
            }
            this.mStateful = false;
            return false;
        }

        final void mutate() {
            int n = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            for (int i = 0; i < n; ++i) {
                if (drawableArray[i] == null) continue;
                drawableArray[i].mutate();
            }
            this.mMutated = true;
        }

        public final void setConstantSize(boolean bl) {
            this.mConstantSize = bl;
        }

        public final void setEnterFadeDuration(int n) {
            this.mEnterFadeDuration = n;
        }

        public final void setExitFadeDuration(int n) {
            this.mExitFadeDuration = n;
        }

        final void setLayoutDirection(int n) {
            int n2 = this.mNumChildren;
            Drawable[] drawableArray = this.mDrawables;
            for (int i = 0; i < n2; ++i) {
                if (drawableArray[i] == null) continue;
                drawableArray[i].setLayoutDirection(n);
            }
            this.mLayoutDirection = n;
        }

        public final void setVariablePadding(boolean bl) {
            this.mVariablePadding = bl;
        }

        private static class ConstantStateFuture {
            private final Drawable.ConstantState mConstantState;

            private ConstantStateFuture(Drawable drawable2) {
                this.mConstantState = drawable2.getConstantState();
            }

            public boolean canApplyTheme() {
                return this.mConstantState.canApplyTheme();
            }

            /*
             * Enabled aggressive block sorting
             */
            public Drawable get(DrawableContainerState drawableContainerState) {
                Drawable drawable2 = drawableContainerState.mRes == null ? this.mConstantState.newDrawable() : (drawableContainerState.mTheme == null ? this.mConstantState.newDrawable(drawableContainerState.mRes) : this.mConstantState.newDrawable(drawableContainerState.mRes, drawableContainerState.mTheme));
                drawable2.setLayoutDirection(drawableContainerState.mLayoutDirection);
                drawable2.setCallback(drawableContainerState.mOwner);
                if (drawableContainerState.mMutated) {
                    drawable2.mutate();
                }
                return drawable2;
            }
        }
    }
}

