/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RotateDrawable
extends Drawable
implements Drawable.Callback {
    private static final float MAX_LEVEL = 10000.0f;
    private boolean mMutated;
    private final RotateState mState;

    public RotateDrawable() {
        this(null, null);
    }

    private RotateDrawable(RotateState rotateState, Resources resources) {
        this.mState = new RotateState(rotateState, this, resources);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        RotateState rotateState = this.mState;
        Drawable drawable2 = rotateState.mDrawable;
        Rect rect = drawable2.getBounds();
        int n = rect.right - rect.left;
        int n2 = rect.bottom - rect.top;
        float f = rotateState.mPivotXRel ? (float)n * rotateState.mPivotX : rotateState.mPivotX;
        float f2 = rotateState.mPivotYRel ? (float)n2 * rotateState.mPivotY : rotateState.mPivotY;
        int n3 = canvas.save();
        canvas.rotate(rotateState.mCurrentDegrees, f + (float)rect.left, f2 + (float)rect.top);
        drawable2.draw(canvas);
        canvas.restoreToCount(n3);
    }

    @Override
    public int getAlpha() {
        return this.mState.mDrawable.getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations | this.mState.mDrawable.getChangingConfigurations();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    public Drawable getDrawable() {
        return this.mState.mDrawable;
    }

    public float getFromDegrees() {
        return this.mState.mFromDegrees;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mState.mDrawable.getPadding(rect);
    }

    public float getPivotX() {
        return this.mState.mPivotX;
    }

    public float getPivotY() {
        return this.mState.mPivotY;
    }

    public float getToDegrees() {
        return this.mState.mToDegrees;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        float f;
        boolean bl;
        TypedValue typedValue;
        float f2;
        boolean bl2;
        TypedArray typedArray = RotateDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.RotateDrawable);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        TypedValue typedValue2 = typedArray.peekValue(4);
        if (typedValue2 == null) {
            bl2 = true;
            f2 = 0.5f;
        } else {
            bl2 = typedValue2.type == 6;
            f2 = bl2 ? typedValue2.getFraction(1.0f, 1.0f) : typedValue2.getFloat();
        }
        if ((typedValue = typedArray.peekValue(5)) == null) {
            bl = true;
            f = 0.5f;
        } else {
            bl = typedValue.type == 6;
            f = bl ? typedValue.getFraction(1.0f, 1.0f) : typedValue.getFloat();
        }
        float f3 = typedArray.getFloat(2, 0.0f);
        float f4 = typedArray.getFloat(3, 360.0f);
        int n2 = typedArray.getResourceId(1, 0);
        Drawable drawable2 = null;
        if (n2 > 0) {
            drawable2 = resources.getDrawable(n2, theme);
        }
        typedArray.recycle();
        int n3 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n3)) {
            if (n != 2 || (drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme)) != null) continue;
            Log.w("drawable", "Bad element under <rotate>: " + xmlPullParser.getName());
        }
        if (drawable2 == null) {
            Log.w("drawable", "No drawable specified for <rotate>");
        }
        RotateState rotateState = this.mState;
        rotateState.mDrawable = drawable2;
        rotateState.mPivotXRel = bl2;
        rotateState.mPivotX = f2;
        rotateState.mPivotYRel = bl;
        rotateState.mPivotY = f;
        rotateState.mFromDegrees = f3;
        rotateState.mCurrentDegrees = f3;
        rotateState.mToDegrees = f4;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    public boolean isPivotXRelative() {
        return this.mState.mPivotXRel;
    }

    public boolean isPivotYRelative() {
        return this.mState.mPivotYRel;
    }

    @Override
    public boolean isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        this.mState.mDrawable.setBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    @Override
    protected boolean onLevelChange(int n) {
        this.mState.mDrawable.setLevel(n);
        this.onBoundsChange(this.getBounds());
        this.mState.mCurrentDegrees = this.mState.mFromDegrees + (this.mState.mToDegrees - this.mState.mFromDegrees) * ((float)n / 10000.0f);
        this.invalidateSelf();
        return true;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = this.mState.mDrawable.setState(nArray);
        this.onBoundsChange(this.getBounds());
        return bl;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, runnable, l);
        }
    }

    @Override
    public void setAlpha(int n) {
        this.mState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mState.mDrawable.setColorFilter(colorFilter);
    }

    public void setDrawable(Drawable drawable2) {
        Drawable drawable3 = this.mState.mDrawable;
        if (drawable3 != drawable2) {
            if (drawable3 != null) {
                drawable3.setCallback(null);
            }
            this.mState.mDrawable = drawable2;
            if (drawable2 != null) {
                drawable2.setCallback(this);
            }
        }
    }

    public void setFromDegrees(float f) {
        if (this.mState.mFromDegrees != f) {
            this.mState.mFromDegrees = f;
            this.invalidateSelf();
        }
    }

    public void setPivotX(float f) {
        if (this.mState.mPivotX == f) {
            this.mState.mPivotX = f;
            this.invalidateSelf();
        }
    }

    public void setPivotXRelative(boolean bl) {
        if (this.mState.mPivotXRel == bl) {
            this.mState.mPivotXRel = bl;
            this.invalidateSelf();
        }
    }

    public void setPivotY(float f) {
        if (this.mState.mPivotY == f) {
            this.mState.mPivotY = f;
            this.invalidateSelf();
        }
    }

    public void setPivotYRelative(boolean bl) {
        if (this.mState.mPivotYRel == bl) {
            this.mState.mPivotYRel = bl;
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mState.mDrawable.setTintList(colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mState.mDrawable.setTintMode(mode);
    }

    public void setToDegrees(float f) {
        if (this.mState.mToDegrees != f) {
            this.mState.mToDegrees = f;
            this.invalidateSelf();
        }
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        this.mState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, runnable);
        }
    }

    static final class RotateState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        float mCurrentDegrees;
        Drawable mDrawable;
        float mFromDegrees;
        float mPivotX;
        boolean mPivotXRel;
        float mPivotY;
        boolean mPivotYRel;
        float mToDegrees;

        /*
         * Enabled aggressive block sorting
         */
        public RotateState(RotateState rotateState, RotateDrawable rotateDrawable, Resources resources) {
            if (rotateState != null) {
                float f;
                this.mDrawable = resources != null ? rotateState.mDrawable.getConstantState().newDrawable(resources) : rotateState.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(rotateDrawable);
                this.mDrawable.setLayoutDirection(rotateState.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(rotateState.mDrawable.getBounds());
                this.mDrawable.setLevel(rotateState.mDrawable.getLevel());
                this.mPivotXRel = rotateState.mPivotXRel;
                this.mPivotX = rotateState.mPivotX;
                this.mPivotYRel = rotateState.mPivotYRel;
                this.mPivotY = rotateState.mPivotY;
                this.mCurrentDegrees = f = rotateState.mFromDegrees;
                this.mFromDegrees = f;
                this.mToDegrees = rotateState.mToDegrees;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new RotateDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new RotateDrawable(this, resources);
        }
    }
}

