/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.util.PathParser;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawable
extends Drawable {
    private static final boolean DBG_VECTOR_DRAWABLE = false;
    private static final int LINECAP_BUTT = 0;
    private static final int LINECAP_ROUND = 1;
    private static final int LINECAP_SQUARE = 2;
    private static final int LINEJOIN_BEVEL = 2;
    private static final int LINEJOIN_MITER = 0;
    private static final int LINEJOIN_ROUND = 1;
    private static final String LOGTAG = VectorDrawable.class.getSimpleName();
    private static final String SHAPE_CLIP_PATH = "clip-path";
    private static final String SHAPE_GROUP = "group";
    private static final String SHAPE_PATH = "path";
    private static final String SHAPE_VECTOR = "vector";
    private boolean mAllowCaching = true;
    private ColorFilter mColorFilter;
    private boolean mMutated;
    private PorterDuffColorFilter mTintFilter;
    private VectorDrawableState mVectorState;

    public VectorDrawable() {
        this.mVectorState = new VectorDrawableState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private VectorDrawable(VectorDrawableState vectorDrawableState, Resources resources, Resources.Theme theme) {
        if (theme != null && vectorDrawableState.canApplyTheme()) {
            this.mVectorState = new VectorDrawableState(vectorDrawableState);
            this.applyTheme(theme);
        } else {
            this.mVectorState = vectorDrawableState;
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, vectorDrawableState.mTint, vectorDrawableState.mTintMode);
    }

    private static int applyAlpha(int n, float f) {
        int n2 = Color.alpha(n);
        return n & 0xFFFFFF | (int)(f * (float)n2) << 24;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VectorDrawable create(Resources resources, int n) {
        AttributeSet attributeSet;
        XmlResourceParser xmlResourceParser;
        try {
            int n2;
            xmlResourceParser = resources.getXml(n);
            attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n2 = xmlResourceParser.next()) != 2 && n2 != 1) {
            }
            if (n2 != 2) {
                throw new XmlPullParserException("No start tag found");
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.e(LOGTAG, "parser error", xmlPullParserException);
            return null;
        }
        catch (IOException iOException) {
            Log.e(LOGTAG, "parser error", iOException);
            return null;
        }
        {
            VectorDrawable vectorDrawable = new VectorDrawable();
            vectorDrawable.inflate(resources, xmlResourceParser, attributeSet);
            return vectorDrawable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void inflateInternal(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableState vectorDrawableState = this.mVectorState;
        VPathRenderer vPathRenderer = vectorDrawableState.mVPathRenderer;
        boolean bl = true;
        Stack<VGroup> stack = new Stack<VGroup>();
        stack.push(vPathRenderer.mRootGroup);
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            block12: {
                block10: {
                    VGroup vGroup;
                    String string2;
                    block11: {
                        if (n != 2) break block10;
                        string2 = xmlPullParser.getName();
                        vGroup = (VGroup)stack.peek();
                        if (!SHAPE_PATH.equals(string2)) break block11;
                        VFullPath vFullPath = new VFullPath();
                        vFullPath.inflate(resources, attributeSet, theme);
                        vGroup.mChildren.add(vFullPath);
                        if (vFullPath.getPathName() != null) {
                            vPathRenderer.mVGTargetsMap.put(vFullPath.getPathName(), vFullPath);
                        }
                        bl = false;
                        vectorDrawableState.mChangingConfigurations |= vFullPath.mChangingConfigurations;
                        break block12;
                    }
                    if (SHAPE_CLIP_PATH.equals(string2)) {
                        VClipPath vClipPath = new VClipPath();
                        vClipPath.inflate(resources, attributeSet, theme);
                        vGroup.mChildren.add(vClipPath);
                        if (vClipPath.getPathName() != null) {
                            vPathRenderer.mVGTargetsMap.put(vClipPath.getPathName(), vClipPath);
                        }
                        vectorDrawableState.mChangingConfigurations |= vClipPath.mChangingConfigurations;
                        break block12;
                    } else if (SHAPE_GROUP.equals(string2)) {
                        VGroup vGroup2 = new VGroup();
                        vGroup2.inflate(resources, attributeSet, theme);
                        vGroup.mChildren.add(vGroup2);
                        stack.push(vGroup2);
                        if (vGroup2.getGroupName() != null) {
                            vPathRenderer.mVGTargetsMap.put(vGroup2.getGroupName(), vGroup2);
                        }
                        vectorDrawableState.mChangingConfigurations |= vGroup2.mChangingConfigurations;
                    }
                    break block12;
                }
                if (n == 3 && SHAPE_GROUP.equals(xmlPullParser.getName())) {
                    stack.pop();
                }
            }
            n = xmlPullParser.next();
        }
        if (!bl) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (stringBuffer.length() > 0) {
            stringBuffer.append(" or ");
        }
        stringBuffer.append(SHAPE_PATH);
        throw new XmlPullParserException("no " + stringBuffer + " defined");
    }

    private boolean needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private void printGroupTree(VGroup vGroup, int n) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "    ";
        }
        Log.v(LOGTAG, string2 + "current group is :" + vGroup.getGroupName() + " rotation is " + vGroup.mRotate);
        Log.v(LOGTAG, string2 + "matrix is :" + vGroup.getLocalMatrix().toString());
        for (int i = 0; i < vGroup.mChildren.size(); ++i) {
            Object object = vGroup.mChildren.get(i);
            if (!(object instanceof VGroup)) continue;
            this.printGroupTree((VGroup)object, n + 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        ColorStateList colorStateList;
        VectorDrawableState vectorDrawableState = this.mVectorState;
        VPathRenderer vPathRenderer = vectorDrawableState.mVPathRenderer;
        vectorDrawableState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        vectorDrawableState.mThemeAttrs = typedArray.extractThemeAttrs();
        int n = typedArray.getInt(6, -1);
        if (n != -1) {
            vectorDrawableState.mTintMode = Drawable.parseTintMode(n, PorterDuff.Mode.SRC_IN);
        }
        if ((colorStateList = typedArray.getColorStateList(1)) != null) {
            vectorDrawableState.mTint = colorStateList;
        }
        vectorDrawableState.mAutoMirrored = typedArray.getBoolean(5, vectorDrawableState.mAutoMirrored);
        vPathRenderer.mViewportWidth = typedArray.getFloat(7, vPathRenderer.mViewportWidth);
        vPathRenderer.mViewportHeight = typedArray.getFloat(8, vPathRenderer.mViewportHeight);
        if (vPathRenderer.mViewportWidth <= 0.0f) {
            Log.e(LOGTAG, "illegal pathRenderer.mViewportWidth <=0. Temporary workaround by setting it to 1");
            vPathRenderer.mViewportWidth = 10.0f;
        } else if (vPathRenderer.mViewportHeight <= 0.0f) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + "<vector> tag requires viewportHeight > 0");
        }
        vPathRenderer.mBaseWidth = typedArray.getDimension(3, vPathRenderer.mBaseWidth);
        vPathRenderer.mBaseHeight = typedArray.getDimension(2, vPathRenderer.mBaseHeight);
        if (vPathRenderer.mBaseWidth <= 0.0f) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + "<vector> tag requires width > 0");
        }
        if (vPathRenderer.mBaseHeight <= 0.0f) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + "<vector> tag requires height > 0");
        }
        vPathRenderer.setAlpha(typedArray.getFloat(4, vPathRenderer.getAlpha()));
        String string2 = typedArray.getString(0);
        if (string2 != null) {
            vPathRenderer.mRootName = string2;
            vPathRenderer.mVGTargetsMap.put(string2, vPathRenderer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void applyTheme(Resources.Theme theme) {
        VPathRenderer vPathRenderer;
        TypedArray typedArray;
        super.applyTheme(theme);
        VectorDrawableState vectorDrawableState = this.mVectorState;
        if (vectorDrawableState != null && vectorDrawableState.mThemeAttrs != null) {
            typedArray = theme.resolveAttributes(vectorDrawableState.mThemeAttrs, R.styleable.VectorDrawable);
            try {
                vectorDrawableState.mCacheDirty = true;
                this.updateStateFromTypedArray(typedArray);
                this.mTintFilter = this.updateTintFilter(this.mTintFilter, vectorDrawableState.mTint, vectorDrawableState.mTintMode);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new RuntimeException(xmlPullParserException);
            }
        }
        if ((vPathRenderer = vectorDrawableState.mVPathRenderer) != null && vPathRenderer.canApplyTheme()) {
            vPathRenderer.applyTheme(theme);
        }
        return;
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return super.canApplyTheme() || this.mVectorState != null && this.mVectorState.canApplyTheme();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        void var5_6;
        Rect rect = this.getBounds();
        if (rect.width() == 0 || rect.height() == 0) {
            return;
        }
        int n = canvas.save();
        boolean bl = this.needMirroring();
        canvas.translate(rect.left, rect.top);
        if (bl) {
            canvas.translate(rect.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        if (this.mColorFilter == null) {
            PorterDuffColorFilter porterDuffColorFilter = this.mTintFilter;
        } else {
            ColorFilter colorFilter = this.mColorFilter;
        }
        if (!this.mAllowCaching) {
            if (!this.mVectorState.hasTranslucentRoot()) {
                this.mVectorState.mVPathRenderer.draw(canvas, rect.width(), rect.height(), (ColorFilter)var5_6);
            } else {
                this.mVectorState.createCachedBitmapIfNeeded(rect);
                this.mVectorState.updateCachedBitmap(rect);
                this.mVectorState.drawCachedBitmapWithRootAlpha(canvas, (ColorFilter)var5_6);
            }
        } else {
            this.mVectorState.createCachedBitmapIfNeeded(rect);
            if (!this.mVectorState.canReuseCache()) {
                this.mVectorState.updateCachedBitmap(rect);
                this.mVectorState.updateCacheStates();
            }
            this.mVectorState.drawCachedBitmapWithRootAlpha(canvas, (ColorFilter)var5_6);
        }
        canvas.restoreToCount(n);
    }

    @Override
    public int getAlpha() {
        return this.mVectorState.mVPathRenderer.getRootAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mVectorState.mChangingConfigurations;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mVectorState;
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)this.mVectorState.mVPathRenderer.mBaseHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)this.mVectorState.mVPathRenderer.mBaseWidth;
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    public float getPixelSize() {
        if (this.mVectorState == null && this.mVectorState.mVPathRenderer == null || this.mVectorState.mVPathRenderer.mBaseWidth == 0.0f || this.mVectorState.mVPathRenderer.mBaseHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportWidth == 0.0f) {
            return 1.0f;
        }
        float f = this.mVectorState.mVPathRenderer.mBaseWidth;
        float f2 = this.mVectorState.mVPathRenderer.mBaseHeight;
        float f3 = this.mVectorState.mVPathRenderer.mViewportWidth;
        float f4 = this.mVectorState.mVPathRenderer.mViewportHeight;
        return Math.min(f3 / f, f4 / f2);
    }

    Object getTargetByName(String string2) {
        return this.mVectorState.mVPathRenderer.mVGTargetsMap.get(string2);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableState vectorDrawableState = this.mVectorState;
        vectorDrawableState.mVPathRenderer = new VPathRenderer();
        TypedArray typedArray = VectorDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.VectorDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
        vectorDrawableState.mCacheDirty = true;
        this.inflateInternal(resources, xmlPullParser, attributeSet, theme);
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, vectorDrawableState.mTint, vectorDrawableState.mTintMode);
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mVectorState.mAutoMirrored;
    }

    @Override
    public boolean isStateful() {
        return super.isStateful() || this.mVectorState != null && this.mVectorState.mTint != null && this.mVectorState.mTint.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mVectorState = new VectorDrawableState(this.mVectorState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        VectorDrawableState vectorDrawableState = this.mVectorState;
        if (vectorDrawableState.mTint != null && vectorDrawableState.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, vectorDrawableState.mTint, vectorDrawableState.mTintMode);
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    void setAllowCaching(boolean bl) {
        this.mAllowCaching = bl;
    }

    @Override
    public void setAlpha(int n) {
        if (this.mVectorState.mVPathRenderer.getRootAlpha() != n) {
            this.mVectorState.mVPathRenderer.setRootAlpha(n);
            this.invalidateSelf();
        }
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        if (this.mVectorState.mAutoMirrored != bl) {
            this.mVectorState.mAutoMirrored = bl;
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        VectorDrawableState vectorDrawableState = this.mVectorState;
        if (vectorDrawableState.mTint != colorStateList) {
            vectorDrawableState.mTint = colorStateList;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, colorStateList, vectorDrawableState.mTintMode);
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        VectorDrawableState vectorDrawableState = this.mVectorState;
        if (vectorDrawableState.mTintMode != mode) {
            vectorDrawableState.mTintMode = mode;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, vectorDrawableState.mTint, mode);
            this.invalidateSelf();
        }
    }

    private static class VClipPath
    extends VPath {
        public VClipPath() {
        }

        public VClipPath(VClipPath vClipPath) {
            super(vClipPath);
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            String string2;
            this.mChangingConfigurations |= typedArray.getChangingConfigurations();
            String string3 = typedArray.getString(0);
            if (string3 != null) {
                this.mPathName = string3;
            }
            if ((string2 = typedArray.getString(1)) != null) {
                this.mNodes = PathParser.createNodesFromPathData(string2);
            }
        }

        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            TypedArray typedArray = Drawable.obtainAttributes(resources, theme, attributeSet, R.styleable.VectorDrawableClipPath);
            this.updateStateFromTypedArray(typedArray);
            typedArray.recycle();
        }

        @Override
        public boolean isClipPath() {
            return true;
        }
    }

    private static class VFullPath
    extends VPath {
        float mFillAlpha = 1.0f;
        int mFillColor = 0;
        int mFillRule;
        float mStrokeAlpha = 1.0f;
        int mStrokeColor = 0;
        Paint.Cap mStrokeLineCap = Paint.Cap.BUTT;
        Paint.Join mStrokeLineJoin = Paint.Join.MITER;
        float mStrokeMiterlimit = 4.0f;
        float mStrokeWidth = 0.0f;
        private int[] mThemeAttrs;
        float mTrimPathEnd = 1.0f;
        float mTrimPathOffset = 0.0f;
        float mTrimPathStart = 0.0f;

        public VFullPath() {
        }

        public VFullPath(VFullPath vFullPath) {
            super(vFullPath);
            this.mThemeAttrs = vFullPath.mThemeAttrs;
            this.mStrokeColor = vFullPath.mStrokeColor;
            this.mStrokeWidth = vFullPath.mStrokeWidth;
            this.mStrokeAlpha = vFullPath.mStrokeAlpha;
            this.mFillColor = vFullPath.mFillColor;
            this.mFillRule = vFullPath.mFillRule;
            this.mFillAlpha = vFullPath.mFillAlpha;
            this.mTrimPathStart = vFullPath.mTrimPathStart;
            this.mTrimPathEnd = vFullPath.mTrimPathEnd;
            this.mTrimPathOffset = vFullPath.mTrimPathOffset;
            this.mStrokeLineCap = vFullPath.mStrokeLineCap;
            this.mStrokeLineJoin = vFullPath.mStrokeLineJoin;
            this.mStrokeMiterlimit = vFullPath.mStrokeMiterlimit;
        }

        private Paint.Cap getStrokeLineCap(int n, Paint.Cap cap) {
            switch (n) {
                default: {
                    return cap;
                }
                case 0: {
                    return Paint.Cap.BUTT;
                }
                case 1: {
                    return Paint.Cap.ROUND;
                }
                case 2: 
            }
            return Paint.Cap.SQUARE;
        }

        private Paint.Join getStrokeLineJoin(int n, Paint.Join join) {
            switch (n) {
                default: {
                    return join;
                }
                case 0: {
                    return Paint.Join.MITER;
                }
                case 1: {
                    return Paint.Join.ROUND;
                }
                case 2: 
            }
            return Paint.Join.BEVEL;
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            String string2;
            this.mChangingConfigurations |= typedArray.getChangingConfigurations();
            this.mThemeAttrs = typedArray.extractThemeAttrs();
            String string3 = typedArray.getString(0);
            if (string3 != null) {
                this.mPathName = string3;
            }
            if ((string2 = typedArray.getString(2)) != null) {
                this.mNodes = PathParser.createNodesFromPathData(string2);
            }
            this.mFillColor = typedArray.getColor(1, this.mFillColor);
            this.mFillAlpha = typedArray.getFloat(12, this.mFillAlpha);
            this.mStrokeLineCap = this.getStrokeLineCap(typedArray.getInt(8, -1), this.mStrokeLineCap);
            this.mStrokeLineJoin = this.getStrokeLineJoin(typedArray.getInt(9, -1), this.mStrokeLineJoin);
            this.mStrokeMiterlimit = typedArray.getFloat(10, this.mStrokeMiterlimit);
            this.mStrokeColor = typedArray.getColor(3, this.mStrokeColor);
            this.mStrokeAlpha = typedArray.getFloat(11, this.mStrokeAlpha);
            this.mStrokeWidth = typedArray.getFloat(4, this.mStrokeWidth);
            this.mTrimPathEnd = typedArray.getFloat(6, this.mTrimPathEnd);
            this.mTrimPathOffset = typedArray.getFloat(7, this.mTrimPathOffset);
            this.mTrimPathStart = typedArray.getFloat(5, this.mTrimPathStart);
        }

        @Override
        public void applyTheme(Resources.Theme theme) {
            if (this.mThemeAttrs == null) {
                return;
            }
            TypedArray typedArray = theme.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(typedArray);
            typedArray.recycle();
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        float getFillAlpha() {
            return this.mFillAlpha;
        }

        int getFillColor() {
            return this.mFillColor;
        }

        float getStrokeAlpha() {
            return this.mStrokeAlpha;
        }

        int getStrokeColor() {
            return this.mStrokeColor;
        }

        float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        float getTrimPathEnd() {
            return this.mTrimPathEnd;
        }

        float getTrimPathOffset() {
            return this.mTrimPathOffset;
        }

        float getTrimPathStart() {
            return this.mTrimPathStart;
        }

        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            TypedArray typedArray = Drawable.obtainAttributes(resources, theme, attributeSet, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(typedArray);
            typedArray.recycle();
        }

        void setFillAlpha(float f) {
            this.mFillAlpha = f;
        }

        void setFillColor(int n) {
            this.mFillColor = n;
        }

        void setStrokeAlpha(float f) {
            this.mStrokeAlpha = f;
        }

        void setStrokeColor(int n) {
            this.mStrokeColor = n;
        }

        void setStrokeWidth(float f) {
            this.mStrokeWidth = f;
        }

        void setTrimPathEnd(float f) {
            this.mTrimPathEnd = f;
        }

        void setTrimPathOffset(float f) {
            this.mTrimPathOffset = f;
        }

        void setTrimPathStart(float f) {
            this.mTrimPathStart = f;
        }
    }

    private static class VGroup {
        private int mChangingConfigurations;
        final ArrayList<Object> mChildren;
        private String mGroupName = null;
        private final Matrix mLocalMatrix;
        private float mPivotX = 0.0f;
        private float mPivotY = 0.0f;
        private float mRotate = 0.0f;
        private float mScaleX = 1.0f;
        private float mScaleY = 1.0f;
        private final Matrix mStackedMatrix = new Matrix();
        private int[] mThemeAttrs;
        private float mTranslateX = 0.0f;
        private float mTranslateY = 0.0f;

        public VGroup() {
            this.mChildren = new ArrayList();
            this.mLocalMatrix = new Matrix();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public VGroup(VGroup vGroup, ArrayMap<String, Object> arrayMap) {
            this.mChildren = new ArrayList();
            this.mLocalMatrix = new Matrix();
            this.mRotate = vGroup.mRotate;
            this.mPivotX = vGroup.mPivotX;
            this.mPivotY = vGroup.mPivotY;
            this.mScaleX = vGroup.mScaleX;
            this.mScaleY = vGroup.mScaleY;
            this.mTranslateX = vGroup.mTranslateX;
            this.mTranslateY = vGroup.mTranslateY;
            this.mThemeAttrs = vGroup.mThemeAttrs;
            this.mGroupName = vGroup.mGroupName;
            this.mChangingConfigurations = vGroup.mChangingConfigurations;
            if (this.mGroupName != null) {
                arrayMap.put(this.mGroupName, this);
            }
            this.mLocalMatrix.set(vGroup.mLocalMatrix);
            ArrayList<Object> arrayList = vGroup.mChildren;
            int n = 0;
            while (n < arrayList.size()) {
                Object object = arrayList.get(n);
                if (object instanceof VGroup) {
                    VGroup vGroup2 = (VGroup)object;
                    this.mChildren.add(new VGroup(vGroup2, arrayMap));
                } else {
                    void var6_6;
                    if (object instanceof VFullPath) {
                        VFullPath vFullPath = new VFullPath((VFullPath)object);
                    } else {
                        if (!(object instanceof VClipPath)) {
                            throw new IllegalStateException("Unknown object in the tree!");
                        }
                        VClipPath vClipPath = new VClipPath((VClipPath)object);
                    }
                    this.mChildren.add(var6_6);
                    if (var6_6.mPathName != null) {
                        arrayMap.put(var6_6.mPathName, var6_6);
                    }
                }
                ++n;
            }
            return;
        }

        private void updateLocalMatrix() {
            this.mLocalMatrix.reset();
            this.mLocalMatrix.postTranslate(-this.mPivotX, -this.mPivotY);
            this.mLocalMatrix.postScale(this.mScaleX, this.mScaleY);
            this.mLocalMatrix.postRotate(this.mRotate, 0.0f, 0.0f);
            this.mLocalMatrix.postTranslate(this.mTranslateX + this.mPivotX, this.mTranslateY + this.mPivotY);
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            this.mChangingConfigurations |= typedArray.getChangingConfigurations();
            this.mThemeAttrs = typedArray.extractThemeAttrs();
            this.mRotate = typedArray.getFloat(5, this.mRotate);
            this.mPivotX = typedArray.getFloat(1, this.mPivotX);
            this.mPivotY = typedArray.getFloat(2, this.mPivotY);
            this.mScaleX = typedArray.getFloat(3, this.mScaleX);
            this.mScaleY = typedArray.getFloat(4, this.mScaleY);
            this.mTranslateX = typedArray.getFloat(6, this.mTranslateX);
            this.mTranslateY = typedArray.getFloat(7, this.mTranslateY);
            String string2 = typedArray.getString(0);
            if (string2 != null) {
                this.mGroupName = string2;
            }
            this.updateLocalMatrix();
        }

        public void applyTheme(Resources.Theme theme) {
            if (this.mThemeAttrs == null) {
                return;
            }
            TypedArray typedArray = theme.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(typedArray);
            typedArray.recycle();
        }

        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        public String getGroupName() {
            return this.mGroupName;
        }

        public Matrix getLocalMatrix() {
            return this.mLocalMatrix;
        }

        public float getPivotX() {
            return this.mPivotX;
        }

        public float getPivotY() {
            return this.mPivotY;
        }

        public float getRotation() {
            return this.mRotate;
        }

        public float getScaleX() {
            return this.mScaleX;
        }

        public float getScaleY() {
            return this.mScaleY;
        }

        public float getTranslateX() {
            return this.mTranslateX;
        }

        public float getTranslateY() {
            return this.mTranslateY;
        }

        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            TypedArray typedArray = Drawable.obtainAttributes(resources, theme, attributeSet, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(typedArray);
            typedArray.recycle();
        }

        public void setPivotX(float f) {
            if (f != this.mPivotX) {
                this.mPivotX = f;
                this.updateLocalMatrix();
            }
        }

        public void setPivotY(float f) {
            if (f != this.mPivotY) {
                this.mPivotY = f;
                this.updateLocalMatrix();
            }
        }

        public void setRotation(float f) {
            if (f != this.mRotate) {
                this.mRotate = f;
                this.updateLocalMatrix();
            }
        }

        public void setScaleX(float f) {
            if (f != this.mScaleX) {
                this.mScaleX = f;
                this.updateLocalMatrix();
            }
        }

        public void setScaleY(float f) {
            if (f != this.mScaleY) {
                this.mScaleY = f;
                this.updateLocalMatrix();
            }
        }

        public void setTranslateX(float f) {
            if (f != this.mTranslateX) {
                this.mTranslateX = f;
                this.updateLocalMatrix();
            }
        }

        public void setTranslateY(float f) {
            if (f != this.mTranslateY) {
                this.mTranslateY = f;
                this.updateLocalMatrix();
            }
        }
    }

    private static class VPath {
        int mChangingConfigurations;
        protected PathParser.PathDataNode[] mNodes = null;
        String mPathName;

        public VPath() {
        }

        public VPath(VPath vPath) {
            this.mPathName = vPath.mPathName;
            this.mChangingConfigurations = vPath.mChangingConfigurations;
            this.mNodes = PathParser.deepCopyNodes(vPath.mNodes);
        }

        public void applyTheme(Resources.Theme theme) {
        }

        public boolean canApplyTheme() {
            return false;
        }

        public PathParser.PathDataNode[] getPathData() {
            return this.mNodes;
        }

        public String getPathName() {
            return this.mPathName;
        }

        public boolean isClipPath() {
            return false;
        }

        public void setPathData(PathParser.PathDataNode[] pathDataNodeArray) {
            if (!PathParser.canMorph(this.mNodes, pathDataNodeArray)) {
                this.mNodes = PathParser.deepCopyNodes(pathDataNodeArray);
                return;
            }
            PathParser.updateNodes(this.mNodes, pathDataNodeArray);
        }

        public void toPath(Path path) {
            path.reset();
            if (this.mNodes != null) {
                PathParser.PathDataNode.nodesToPath(this.mNodes, path);
            }
        }
    }

    private static class VPathRenderer {
        private static final Matrix IDENTITY_MATRIX = new Matrix();
        float mBaseHeight = 0.0f;
        float mBaseWidth = 0.0f;
        private int mChangingConfigurations;
        private Paint mFillPaint;
        private final Matrix mFinalPathMatrix = new Matrix();
        private final Path mPath;
        private PathMeasure mPathMeasure;
        private final Path mRenderPath;
        int mRootAlpha = 255;
        private final VGroup mRootGroup;
        String mRootName = null;
        private Paint mStrokePaint;
        final ArrayMap<String, Object> mVGTargetsMap = new ArrayMap();
        float mViewportHeight = 0.0f;
        float mViewportWidth = 0.0f;

        public VPathRenderer() {
            this.mRootGroup = new VGroup();
            this.mPath = new Path();
            this.mRenderPath = new Path();
        }

        public VPathRenderer(VPathRenderer vPathRenderer) {
            this.mRootGroup = new VGroup(vPathRenderer.mRootGroup, this.mVGTargetsMap);
            this.mPath = new Path(vPathRenderer.mPath);
            this.mRenderPath = new Path(vPathRenderer.mRenderPath);
            this.mBaseWidth = vPathRenderer.mBaseWidth;
            this.mBaseHeight = vPathRenderer.mBaseHeight;
            this.mViewportWidth = vPathRenderer.mViewportWidth;
            this.mViewportHeight = vPathRenderer.mViewportHeight;
            this.mChangingConfigurations = vPathRenderer.mChangingConfigurations;
            this.mRootAlpha = vPathRenderer.mRootAlpha;
            this.mRootName = vPathRenderer.mRootName;
            if (vPathRenderer.mRootName != null) {
                this.mVGTargetsMap.put(vPathRenderer.mRootName, this);
            }
        }

        static /* synthetic */ Paint access$302(VPathRenderer vPathRenderer, Paint paint) {
            vPathRenderer.mFillPaint = paint;
            return paint;
        }

        static /* synthetic */ Paint access$402(VPathRenderer vPathRenderer, Paint paint) {
            vPathRenderer.mStrokePaint = paint;
            return paint;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void drawGroupTree(VGroup vGroup, Matrix matrix, Canvas canvas, int n, int n2, ColorFilter colorFilter) {
            vGroup.mStackedMatrix.set(matrix);
            vGroup.mStackedMatrix.preConcat(vGroup.mLocalMatrix);
            int n3 = 0;
            while (n3 < vGroup.mChildren.size()) {
                Object object = vGroup.mChildren.get(n3);
                if (object instanceof VGroup) {
                    this.drawGroupTree((VGroup)object, vGroup.mStackedMatrix, canvas, n, n2, colorFilter);
                } else if (object instanceof VPath) {
                    this.drawPath(vGroup, (VPath)object, canvas, n, n2, colorFilter);
                }
                ++n3;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void drawPath(VGroup vGroup, VPath vPath, Canvas canvas, int n, int n2, ColorFilter colorFilter) {
            float f = (float)n / this.mViewportWidth;
            float f2 = (float)n2 / this.mViewportHeight;
            float f3 = Math.min(f, f2);
            this.mFinalPathMatrix.set(vGroup.mStackedMatrix);
            this.mFinalPathMatrix.postScale(f, f2);
            vPath.toPath(this.mPath);
            Path path = this.mPath;
            this.mRenderPath.reset();
            if (vPath.isClipPath()) {
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                canvas.clipPath(this.mRenderPath, Region.Op.REPLACE);
                return;
            } else {
                VFullPath vFullPath = (VFullPath)vPath;
                if (vFullPath.mTrimPathStart != 0.0f || vFullPath.mTrimPathEnd != 1.0f) {
                    float f4 = (vFullPath.mTrimPathStart + vFullPath.mTrimPathOffset) % 1.0f;
                    float f5 = (vFullPath.mTrimPathEnd + vFullPath.mTrimPathOffset) % 1.0f;
                    if (this.mPathMeasure == null) {
                        this.mPathMeasure = new PathMeasure();
                    }
                    this.mPathMeasure.setPath(this.mPath, false);
                    float f6 = this.mPathMeasure.getLength();
                    float f7 = f4 * f6;
                    float f8 = f5 * f6;
                    path.reset();
                    if (f7 > f8) {
                        this.mPathMeasure.getSegment(f7, f6, path, true);
                        this.mPathMeasure.getSegment(0.0f, f8, path, true);
                    } else {
                        this.mPathMeasure.getSegment(f7, f8, path, true);
                    }
                    path.rLineTo(0.0f, 0.0f);
                }
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                if (vFullPath.mFillColor != 0) {
                    if (this.mFillPaint == null) {
                        this.mFillPaint = new Paint();
                        this.mFillPaint.setStyle(Paint.Style.FILL);
                        this.mFillPaint.setAntiAlias(true);
                    }
                    Paint paint = this.mFillPaint;
                    paint.setColor(VectorDrawable.applyAlpha(vFullPath.mFillColor, vFullPath.mFillAlpha));
                    paint.setColorFilter(colorFilter);
                    canvas.drawPath(this.mRenderPath, paint);
                }
                if (vFullPath.mStrokeColor == 0) return;
                if (this.mStrokePaint == null) {
                    this.mStrokePaint = new Paint();
                    this.mStrokePaint.setStyle(Paint.Style.STROKE);
                    this.mStrokePaint.setAntiAlias(true);
                }
                Paint paint = this.mStrokePaint;
                if (vFullPath.mStrokeLineJoin != null) {
                    paint.setStrokeJoin(vFullPath.mStrokeLineJoin);
                }
                if (vFullPath.mStrokeLineCap != null) {
                    paint.setStrokeCap(vFullPath.mStrokeLineCap);
                }
                paint.setStrokeMiter(vFullPath.mStrokeMiterlimit);
                paint.setColor(VectorDrawable.applyAlpha(vFullPath.mStrokeColor, vFullPath.mStrokeAlpha));
                paint.setColorFilter(colorFilter);
                paint.setStrokeWidth(f3 * vFullPath.mStrokeWidth);
                canvas.drawPath(this.mRenderPath, paint);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void recursiveApplyTheme(VGroup vGroup, Resources.Theme theme) {
            ArrayList<Object> arrayList = vGroup.mChildren;
            int n = 0;
            while (n < arrayList.size()) {
                VPath vPath;
                Object object = arrayList.get(n);
                if (object instanceof VGroup) {
                    VGroup vGroup2 = (VGroup)object;
                    if (vGroup2.canApplyTheme()) {
                        vGroup2.applyTheme(theme);
                    }
                    this.recursiveApplyTheme(vGroup2, theme);
                } else if (object instanceof VPath && (vPath = (VPath)object).canApplyTheme()) {
                    vPath.applyTheme(theme);
                }
                ++n;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean recursiveCanApplyTheme(VGroup vGroup) {
            ArrayList<Object> arrayList = vGroup.mChildren;
            int n = 0;
            while (n < arrayList.size()) {
                VGroup vGroup2;
                Object object = arrayList.get(n);
                if (object instanceof VGroup ? (vGroup2 = (VGroup)object).canApplyTheme() || this.recursiveCanApplyTheme(vGroup2) : object instanceof VPath && ((VPath)object).canApplyTheme()) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void applyTheme(Resources.Theme theme) {
            this.recursiveApplyTheme(this.mRootGroup, theme);
        }

        public boolean canApplyTheme() {
            return this.recursiveCanApplyTheme(this.mRootGroup);
        }

        public void draw(Canvas canvas, int n, int n2, ColorFilter colorFilter) {
            this.drawGroupTree(this.mRootGroup, IDENTITY_MATRIX, canvas, n, n2, colorFilter);
        }

        public float getAlpha() {
            return (float)this.getRootAlpha() / 255.0f;
        }

        public int getRootAlpha() {
            return this.mRootAlpha;
        }

        public void setAlpha(float f) {
            this.setRootAlpha((int)(255.0f * f));
        }

        public void setRootAlpha(int n) {
            this.mRootAlpha = n;
        }
    }

    private static class VectorDrawableState
    extends Drawable.ConstantState {
        boolean mAutoMirrored;
        boolean mCacheDirty;
        boolean mCachedAutoMirrored;
        Bitmap mCachedBitmap;
        int mCachedRootAlpha;
        int[] mCachedThemeAttrs;
        ColorStateList mCachedTint;
        PorterDuff.Mode mCachedTintMode;
        int mChangingConfigurations;
        Paint mTempPaint;
        int[] mThemeAttrs;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = Drawable.DEFAULT_TINT_MODE;
        VPathRenderer mVPathRenderer;

        public VectorDrawableState() {
            this.mVPathRenderer = new VPathRenderer();
        }

        public VectorDrawableState(VectorDrawableState vectorDrawableState) {
            if (vectorDrawableState != null) {
                this.mThemeAttrs = vectorDrawableState.mThemeAttrs;
                this.mChangingConfigurations = vectorDrawableState.mChangingConfigurations;
                this.mVPathRenderer = new VPathRenderer(vectorDrawableState.mVPathRenderer);
                if (vectorDrawableState.mVPathRenderer.mFillPaint != null) {
                    VPathRenderer.access$302(this.mVPathRenderer, new Paint(vectorDrawableState.mVPathRenderer.mFillPaint));
                }
                if (vectorDrawableState.mVPathRenderer.mStrokePaint != null) {
                    VPathRenderer.access$402(this.mVPathRenderer, new Paint(vectorDrawableState.mVPathRenderer.mStrokePaint));
                }
                this.mTint = vectorDrawableState.mTint;
                this.mTintMode = vectorDrawableState.mTintMode;
                this.mAutoMirrored = vectorDrawableState.mAutoMirrored;
            }
        }

        @Override
        public boolean canApplyTheme() {
            return super.canApplyTheme() || this.mThemeAttrs != null || this.mVPathRenderer != null && this.mVPathRenderer.canApplyTheme();
        }

        public boolean canReuseBitmap(int n, int n2) {
            return n == this.mCachedBitmap.getWidth() && n2 == this.mCachedBitmap.getHeight();
        }

        public boolean canReuseCache() {
            return !this.mCacheDirty && this.mCachedThemeAttrs == this.mThemeAttrs && this.mCachedTint == this.mTint && this.mCachedTintMode == this.mTintMode && this.mCachedAutoMirrored == this.mAutoMirrored && this.mCachedRootAlpha == this.mVPathRenderer.getRootAlpha();
        }

        public void createCachedBitmapIfNeeded(Rect rect) {
            if (this.mCachedBitmap == null || !this.canReuseBitmap(rect.width(), rect.height())) {
                this.mCachedBitmap = Bitmap.createBitmap(rect.width(), rect.height(), Bitmap.Config.ARGB_8888);
                this.mCacheDirty = true;
            }
        }

        public void drawCachedBitmapWithRootAlpha(Canvas canvas, ColorFilter colorFilter) {
            Paint paint = this.getPaint(colorFilter);
            canvas.drawBitmap(this.mCachedBitmap, 0.0f, 0.0f, paint);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public Paint getPaint(ColorFilter colorFilter) {
            if (!this.hasTranslucentRoot() && colorFilter == null) {
                return null;
            }
            if (this.mTempPaint == null) {
                this.mTempPaint = new Paint();
                this.mTempPaint.setFilterBitmap(true);
            }
            this.mTempPaint.setAlpha(this.mVPathRenderer.getRootAlpha());
            this.mTempPaint.setColorFilter(colorFilter);
            return this.mTempPaint;
        }

        public boolean hasTranslucentRoot() {
            return this.mVPathRenderer.getRootAlpha() < 255;
        }

        @Override
        public Drawable newDrawable() {
            return new VectorDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new VectorDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new VectorDrawable(this, resources, theme);
        }

        public void updateCacheStates() {
            this.mCachedThemeAttrs = this.mThemeAttrs;
            this.mCachedTint = this.mTint;
            this.mCachedTintMode = this.mTintMode;
            this.mCachedRootAlpha = this.mVPathRenderer.getRootAlpha();
            this.mCachedAutoMirrored = this.mAutoMirrored;
            this.mCacheDirty = false;
        }

        public void updateCachedBitmap(Rect rect) {
            this.mCachedBitmap.eraseColor(0);
            Canvas canvas = new Canvas(this.mCachedBitmap);
            this.mVPathRenderer.draw(canvas, rect.width(), rect.height(), null);
        }
    }
}

