/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.Context;
import android.hardware.CameraInfo;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.CameraDeviceUserShim;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.utils.BinderHolder;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.CameraServiceBinderDecorator;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public final class CameraManager {
    private static final int API_VERSION_1 = 1;
    private static final int API_VERSION_2 = 2;
    private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    private static final String TAG = "CameraManager";
    private static final int USE_CALLING_UID = -1;
    private final boolean DEBUG;
    private final ArrayMap<AvailabilityCallback, Handler> mCallbackMap = new ArrayMap();
    private ICameraService mCameraService;
    private final Context mContext;
    private ArrayList<String> mDeviceIdList;
    private final Object mLock = new Object();
    private final CameraServiceListener mServiceListener = new CameraServiceListener();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CameraManager(Context context) {
        this.DEBUG = Log.isLoggable(TAG, 3);
        Object object = this.mLock;
        synchronized (object) {
            this.mContext = context;
            this.connectCameraServiceLocked();
            return;
        }
    }

    static /* synthetic */ ICameraService access$302(CameraManager cameraManager, ICameraService iCameraService) {
        cameraManager.mCameraService = iCameraService;
        return iCameraService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectCameraServiceLocked() {
        this.mCameraService = null;
        IBinder iBinder = ServiceManager.getService(CAMERA_SERVICE_BINDER_NAME);
        if (iBinder == null) {
            return;
        }
        try {
            iBinder.linkToDeath(new CameraServiceDeathListener(), 0);
        }
        catch (RemoteException remoteException) {
            return;
        }
        ICameraService iCameraService = CameraServiceBinderDecorator.newInstance(ICameraService.Stub.asInterface(iBinder));
        try {
            CameraServiceBinderDecorator.throwOnError(CameraMetadataNative.nativeSetupGlobalVendorTagDescriptor());
        }
        catch (CameraRuntimeException cameraRuntimeException) {
            this.handleRecoverableSetupErrors(cameraRuntimeException, "Failed to set up vendor tags");
        }
        try {
            iCameraService.addListener(this.mServiceListener);
            this.mCameraService = iCameraService;
            return;
        }
        catch (CameraRuntimeException cameraRuntimeException) {
            throw new IllegalStateException("Failed to register a camera service listener", cameraRuntimeException.asChecked());
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private ICameraService getCameraServiceLocked() {
        if (this.mCameraService == null) {
            Log.i(TAG, "getCameraServiceLocked: Reconnecting to camera service");
            this.connectCameraServiceLocked();
            if (this.mCameraService == null) {
                Log.e(TAG, "Camera service is unavailable");
            }
        }
        return this.mCameraService;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<String> getOrCreateDeviceIdListLocked() throws CameraAccessException {
        block14: {
            block15: {
                block13: {
                    block12: {
                        if (this.mDeviceIdList != null) break block14;
                        var1_1 = this.getCameraServiceLocked();
                        var2_2 = new ArrayList<String>();
                        if (var1_1 == null) {
                            return var2_2;
                        }
                        try {
                            var5_3 = var1_1.getNumberOfCameras();
                        }
                        catch (CameraRuntimeException var4_11) {
                            throw var4_11.asChecked();
                        }
                        catch (RemoteException var3_12) {
                            return var2_2;
                        }
                        var6_4 = new CameraMetadataNative();
                        block8: for (var7_5 = 0; var7_5 < var5_3; ++var7_5) {
                            var1_1.getCameraCharacteristics(var7_5, var6_4);
                            var16_6 = var6_4.isEmpty();
                            if (var16_6) break block12;
                            var11_9 = true;
lbl16:
                            // 3 sources

                            ** while (var11_9)
lbl-1000:
                            // 1 sources

                            {
                                var2_2.add(String.valueOf(var7_5));
lbl19:
                                // 2 sources

                                continue block8;
lbl21:
                                // 1 sources

                                break block13;
                            }
                        }
                        break block15;
                    }
                    try {
                        throw new AssertionError((Object)"Expected to get non-empty characteristics");
                    }
                    catch (IllegalArgumentException var14_10) {
                        var11_9 = false;
                        ** GOTO lbl16
                    }
                    catch (CameraRuntimeException var9_7) {
                        var10_8 = var9_7.getReason();
                        var11_9 = false;
                        if (var10_8 == 2) ** GOTO lbl16
                        throw var9_7.asChecked();
                    }
                    catch (RemoteException var8_13) {
                        var2_2.clear();
                        return var2_2;
                    }
                }
                Log.w("CameraManager", "Error querying camera device " + var7_5 + " for listing.");
                ** while (true)
            }
            this.mDeviceIdList = var2_2;
        }
        return this.mDeviceIdList;
    }

    private void handleRecoverableSetupErrors(CameraRuntimeException cameraRuntimeException, String string2) {
        int n = cameraRuntimeException.getReason();
        switch (n) {
            default: {
                throw new IllegalStateException(string2, cameraRuntimeException.asChecked());
            }
            case 2: 
        }
        String string3 = CameraAccessException.getDefaultMessage(n);
        Log.w(TAG, string2 + ": " + string3);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private CameraDevice openCameraDeviceUserAsync(String string2, CameraDevice.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        CameraRuntimeException cameraRuntimeException22;
        ICameraDeviceUser iCameraDeviceUser;
        CameraDeviceImpl cameraDeviceImpl;
        block17: {
            int n;
            CameraDeviceImpl.CameraDeviceCallbacks cameraDeviceCallbacks;
            block15: {
                ICameraService iCameraService;
                BinderHolder binderHolder;
                block16: {
                    CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string2);
                    Object object = this.mLock;
                    // MONITORENTER : object
                    cameraDeviceImpl = new CameraDeviceImpl(string2, stateCallback, handler, cameraCharacteristics);
                    binderHolder = new BinderHolder();
                    cameraDeviceCallbacks = cameraDeviceImpl.getCallbacks();
                    n = Integer.parseInt(string2);
                    if (!this.supportsCamera2ApiLocked(string2)) break block15;
                    iCameraService = this.getCameraServiceLocked();
                    if (iCameraService == null) {
                        throw new CameraRuntimeException(2, "Camera service is currently unavailable");
                    }
                    break block16;
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Expected cameraId to be numeric, but it was: " + string2);
                    }
                }
                iCameraService.connectDevice(cameraDeviceCallbacks, n, this.mContext.getPackageName(), -1, binderHolder);
                ICameraDeviceUser iCameraDeviceUser2 = ICameraDeviceUser.Stub.asInterface(binderHolder.getBinder());
                iCameraDeviceUser = iCameraDeviceUser2;
            }
            try {
                CameraDeviceUserShim cameraDeviceUserShim;
                Log.i(TAG, "Using legacy camera HAL.");
                iCameraDeviceUser = cameraDeviceUserShim = CameraDeviceUserShim.connectBinderShim(cameraDeviceCallbacks, n);
            }
            catch (CameraRuntimeException cameraRuntimeException22) {
                if (cameraRuntimeException22.getReason() != 1000) break block17;
                throw new AssertionError((Object)"Should've gone down the shim path");
            }
        }
        if (cameraRuntimeException22.getReason() != 4 && cameraRuntimeException22.getReason() != 5 && cameraRuntimeException22.getReason() != 1 && cameraRuntimeException22.getReason() != 2) {
            if (cameraRuntimeException22.getReason() != 3) throw cameraRuntimeException22;
        }
        cameraDeviceImpl.setRemoteFailure(cameraRuntimeException22);
        if (cameraRuntimeException22.getReason() == 1) throw cameraRuntimeException22.asChecked();
        int n = cameraRuntimeException22.getReason();
        iCameraDeviceUser = null;
        if (n == 2) {
            throw cameraRuntimeException22.asChecked();
        }
        cameraDeviceImpl.setRemoteDevice(iCameraDeviceUser);
        // MONITOREXIT : object
        return cameraDeviceImpl;
        catch (RemoteException remoteException) {
            CameraRuntimeException cameraRuntimeException3 = new CameraRuntimeException(2, "Camera service is currently unavailable", remoteException);
            cameraDeviceImpl.setRemoteFailure(cameraRuntimeException3);
            throw cameraRuntimeException3.asChecked();
        }
        catch (CameraRuntimeException cameraRuntimeException4) {
            throw cameraRuntimeException4.asChecked();
        }
    }

    private boolean supportsCamera2ApiLocked(String string2) {
        return this.supportsCameraApiLocked(string2, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean supportsCameraApiLocked(String string2, int n) {
        ICameraService iCameraService;
        int n2;
        block5: {
            n2 = Integer.parseInt(string2);
            iCameraService = this.getCameraServiceLocked();
            if (iCameraService != null) break block5;
            return false;
        }
        int n3 = iCameraService.supportsCameraApi(n2, n);
        if (n3 == 0) return true;
        try {
            throw new AssertionError((Object)("Unexpected value " + n3));
        }
        catch (CameraRuntimeException cameraRuntimeException) {
            if (cameraRuntimeException.getReason() == 1000) return false;
            throw cameraRuntimeException;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CameraCharacteristics getCameraCharacteristics(String string2) throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.getOrCreateDeviceIdListLocked().contains(string2)) {
                throw new IllegalArgumentException(String.format("Camera id %s does not match any currently connected camera device", string2));
            }
            int n = Integer.valueOf(string2);
            ICameraService iCameraService = this.getCameraServiceLocked();
            if (iCameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                if (!this.supportsCamera2ApiLocked(string2)) {
                    String[] stringArray = new String[1];
                    iCameraService.getLegacyParameters(n, stringArray);
                    String string3 = stringArray[0];
                    CameraInfo cameraInfo = new CameraInfo();
                    iCameraService.getCameraInfo(n, cameraInfo);
                    CameraCharacteristics cameraCharacteristics = LegacyMetadataMapper.createCharacteristics(string3, cameraInfo);
                    return cameraCharacteristics;
                }
            }
            catch (CameraRuntimeException cameraRuntimeException) {
                throw cameraRuntimeException.asChecked();
            }
            catch (RemoteException remoteException) {
                throw new CameraAccessException(2, "Camera service is currently unavailable", remoteException);
            }
            {
                CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
                iCameraService.getCameraCharacteristics(n, cameraMetadataNative);
                CameraCharacteristics cameraCharacteristics = new CameraCharacteristics(cameraMetadataNative);
                return cameraCharacteristics;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCameraIdList() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDeviceIdListLocked().toArray(new String[0]);
        }
    }

    public void openCamera(String string2, CameraDevice.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        block6: {
            block5: {
                if (string2 == null) {
                    throw new IllegalArgumentException("cameraId was null");
                }
                if (stateCallback == null) {
                    throw new IllegalArgumentException("callback was null");
                }
                if (handler != null) break block5;
                if (Looper.myLooper() == null) break block6;
                handler = new Handler();
            }
            this.openCameraDeviceUserAsync(string2, stateCallback, handler);
            return;
        }
        throw new IllegalArgumentException("Looper doesn't exist in the calling thread");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerAvailabilityCallback(AvailabilityCallback availabilityCallback, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbackMap.put(availabilityCallback, handler) == null) {
                this.mServiceListener.updateCallbackLocked(availabilityCallback, handler);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterAvailabilityCallback(AvailabilityCallback availabilityCallback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackMap.remove(availabilityCallback);
            return;
        }
    }

    public static abstract class AvailabilityCallback {
        public void onCameraAvailable(String string2) {
        }

        public void onCameraUnavailable(String string2) {
        }
    }

    public static abstract class AvailabilityListener
    extends AvailabilityCallback {
    }

    private class CameraServiceDeathListener
    implements IBinder.DeathRecipient {
        private CameraServiceDeathListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            Object object = CameraManager.this.mLock;
            synchronized (object) {
                CameraManager.access$302(CameraManager.this, null);
                Iterator iterator = CameraManager.this.mDeviceIdList.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    CameraManager.this.mServiceListener.onStatusChangedLocked(1, string2);
                }
                return;
            }
        }
    }

    private class CameraServiceListener
    extends ICameraServiceListener.Stub {
        public static final int STATUS_ENUMERATING = 2;
        public static final int STATUS_NOT_AVAILABLE = Integer.MIN_VALUE;
        public static final int STATUS_NOT_PRESENT = 0;
        public static final int STATUS_PRESENT = 1;
        private static final String TAG = "CameraServiceListener";
        private final ArrayMap<String, Integer> mDeviceStatus = new ArrayMap();

        private CameraServiceListener() {
        }

        private boolean isAvailable(int n) {
            switch (n) {
                default: {
                    return false;
                }
                case 1: 
            }
            return true;
        }

        private void postSingleUpdate(final AvailabilityCallback availabilityCallback, Handler handler, final String string2, int n) {
            if (this.isAvailable(n)) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        availabilityCallback.onCameraAvailable(string2);
                    }
                });
                return;
            }
            handler.post(new Runnable(){

                @Override
                public void run() {
                    availabilityCallback.onCameraUnavailable(string2);
                }
            });
        }

        private boolean validStatus(int n) {
            switch (n) {
                default: {
                    return false;
                }
                case -2147483648: 
                case 0: 
                case 1: 
                case 2: 
            }
            return true;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onStatusChanged(int n, int n2) throws RemoteException {
            Object object = CameraManager.this.mLock;
            synchronized (object) {
                this.onStatusChangedLocked(n, String.valueOf(n2));
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onStatusChangedLocked(int n, String string2) {
            if (CameraManager.this.DEBUG) {
                Object[] objectArray = new Object[]{string2, n};
                Log.v(TAG, String.format("Camera id %s has status changed to 0x%x", objectArray));
            }
            if (!this.validStatus(n)) {
                Object[] objectArray = new Object[]{string2, n};
                Log.e(TAG, String.format("Ignoring invalid device %s status 0x%x", objectArray));
                return;
            } else {
                Integer n2 = this.mDeviceStatus.put(string2, n);
                if (n2 != null && n2 == n) {
                    if (!CameraManager.this.DEBUG) return;
                    Object[] objectArray = new Object[]{n};
                    Log.v(TAG, String.format("Device status changed to 0x%x, which is what it already was", objectArray));
                    return;
                } else if (n2 != null && this.isAvailable(n) == this.isAvailable(n2)) {
                    if (!CameraManager.this.DEBUG) return;
                    Object[] objectArray = new Object[]{this.isAvailable(n), this.isAvailable(n)};
                    Log.v(TAG, String.format("Device status was previously available (%d),  and is now again available (%d)so no new client visible update will be sent", objectArray));
                    return;
                } else {
                    int n3 = CameraManager.this.mCallbackMap.size();
                    for (int i = 0; i < n3; ++i) {
                        Handler handler = (Handler)CameraManager.this.mCallbackMap.valueAt(i);
                        this.postSingleUpdate((AvailabilityCallback)CameraManager.this.mCallbackMap.keyAt(i), handler, string2, n);
                    }
                }
            }
        }

        public void updateCallbackLocked(AvailabilityCallback availabilityCallback, Handler handler) {
            for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                this.postSingleUpdate(availabilityCallback, handler, this.mDeviceStatus.keyAt(i), this.mDeviceStatus.valueAt(i));
            }
        }
    }
}

