/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class CameraDeviceImpl
extends CameraDevice {
    private static final int REQUEST_ID_NONE = -1;
    private final boolean DEBUG;
    private final String TAG;
    private final Runnable mCallOnActive;
    private final Runnable mCallOnBusy;
    private final Runnable mCallOnClosed;
    private final Runnable mCallOnDisconnected;
    private final Runnable mCallOnIdle;
    private final Runnable mCallOnOpened;
    private final Runnable mCallOnUnconfigured;
    private final CameraDeviceCallbacks mCallbacks;
    private final String mCameraId;
    private final SparseArray<CaptureCallbackHolder> mCaptureCallbackMap;
    private final CameraCharacteristics mCharacteristics;
    private volatile boolean mClosing = false;
    private final SparseArray<Surface> mConfiguredOutputs;
    private CameraCaptureSessionImpl mCurrentSession;
    private final CameraDevice.StateCallback mDeviceCallback;
    private final Handler mDeviceHandler;
    private final List<AbstractMap.SimpleEntry<Long, Integer>> mFrameNumberRequestPairs;
    private final FrameNumberTracker mFrameNumberTracker;
    private boolean mIdle = true;
    private boolean mInError = false;
    final Object mInterfaceLock = new Object();
    private int mNextSessionId = 0;
    private ICameraDeviceUser mRemoteDevice;
    private int mRepeatingRequestId = -1;
    private final ArrayList<Integer> mRepeatingRequestIdDeletedList;
    private volatile StateCallbackKK mSessionStateCallback;
    private final int mTotalPartialCount;

    public CameraDeviceImpl(String string2, CameraDevice.StateCallback stateCallback, Handler handler, CameraCharacteristics cameraCharacteristics) {
        this.mCallbacks = new CameraDeviceCallbacks();
        this.mCaptureCallbackMap = new SparseArray();
        this.mRepeatingRequestIdDeletedList = new ArrayList();
        this.mConfiguredOutputs = new SparseArray();
        this.mFrameNumberRequestPairs = new ArrayList<AbstractMap.SimpleEntry<Long, Integer>>();
        this.mFrameNumberTracker = new FrameNumberTracker();
        this.mCallOnOpened = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object = CameraDeviceImpl.this.mInterfaceLock;
                // MONITORENTER : object
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    // MONITOREXIT : object
                    return;
                }
                StateCallbackKK stateCallbackKK = CameraDeviceImpl.this.mSessionStateCallback;
                // MONITOREXIT : object
                if (stateCallbackKK != null) {
                    stateCallbackKK.onOpened(CameraDeviceImpl.this);
                }
                CameraDeviceImpl.this.mDeviceCallback.onOpened(CameraDeviceImpl.this);
            }
        };
        this.mCallOnUnconfigured = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object = CameraDeviceImpl.this.mInterfaceLock;
                // MONITORENTER : object
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    // MONITOREXIT : object
                    return;
                }
                StateCallbackKK stateCallbackKK = CameraDeviceImpl.this.mSessionStateCallback;
                // MONITOREXIT : object
                if (stateCallbackKK == null) return;
                stateCallbackKK.onUnconfigured(CameraDeviceImpl.this);
            }
        };
        this.mCallOnActive = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object = CameraDeviceImpl.this.mInterfaceLock;
                // MONITORENTER : object
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    // MONITOREXIT : object
                    return;
                }
                StateCallbackKK stateCallbackKK = CameraDeviceImpl.this.mSessionStateCallback;
                // MONITOREXIT : object
                if (stateCallbackKK == null) return;
                stateCallbackKK.onActive(CameraDeviceImpl.this);
            }
        };
        this.mCallOnBusy = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object = CameraDeviceImpl.this.mInterfaceLock;
                // MONITORENTER : object
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    // MONITOREXIT : object
                    return;
                }
                StateCallbackKK stateCallbackKK = CameraDeviceImpl.this.mSessionStateCallback;
                // MONITOREXIT : object
                if (stateCallbackKK == null) return;
                stateCallbackKK.onBusy(CameraDeviceImpl.this);
            }
        };
        this.mCallOnClosed = new Runnable(){
            private boolean mClosedOnce = false;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (this.mClosedOnce) {
                    throw new AssertionError((Object)"Don't post #onClosed more than once");
                }
                Object object = CameraDeviceImpl.this.mInterfaceLock;
                // MONITORENTER : object
                StateCallbackKK stateCallbackKK = CameraDeviceImpl.this.mSessionStateCallback;
                // MONITOREXIT : object
                if (stateCallbackKK != null) {
                    stateCallbackKK.onClosed(CameraDeviceImpl.this);
                }
                CameraDeviceImpl.this.mDeviceCallback.onClosed(CameraDeviceImpl.this);
                this.mClosedOnce = true;
            }
        };
        this.mCallOnIdle = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object = CameraDeviceImpl.this.mInterfaceLock;
                // MONITORENTER : object
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    // MONITOREXIT : object
                    return;
                }
                StateCallbackKK stateCallbackKK = CameraDeviceImpl.this.mSessionStateCallback;
                // MONITOREXIT : object
                if (stateCallbackKK == null) return;
                stateCallbackKK.onIdle(CameraDeviceImpl.this);
            }
        };
        this.mCallOnDisconnected = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object = CameraDeviceImpl.this.mInterfaceLock;
                // MONITORENTER : object
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    // MONITOREXIT : object
                    return;
                }
                StateCallbackKK stateCallbackKK = CameraDeviceImpl.this.mSessionStateCallback;
                // MONITOREXIT : object
                if (stateCallbackKK != null) {
                    stateCallbackKK.onDisconnected(CameraDeviceImpl.this);
                }
                CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
            }
        };
        if (string2 == null || stateCallback == null || handler == null || cameraCharacteristics == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = string2;
        this.mDeviceCallback = stateCallback;
        this.mDeviceHandler = handler;
        this.mCharacteristics = cameraCharacteristics;
        Object[] objectArray = new Object[]{this.mCameraId};
        String string3 = String.format("CameraDevice-JV-%s", objectArray);
        if (string3.length() > 23) {
            string3 = string3.substring(0, 23);
        }
        this.TAG = string3;
        this.DEBUG = Log.isLoggable(this.TAG, 3);
        Integer n = this.mCharacteristics.get(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT);
        if (n == null) {
            this.mTotalPartialCount = 1;
            return;
        }
        this.mTotalPartialCount = n;
    }

    static /* synthetic */ Runnable access$600(CameraDeviceImpl cameraDeviceImpl) {
        return cameraDeviceImpl.mCallOnDisconnected;
    }

    static /* synthetic */ boolean access$802(CameraDeviceImpl cameraDeviceImpl, boolean bl) {
        cameraDeviceImpl.mInError = bl;
        return bl;
    }

    static /* synthetic */ boolean access$902(CameraDeviceImpl cameraDeviceImpl, boolean bl) {
        cameraDeviceImpl.mIdle = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAndFireSequenceComplete() {
        long l = this.mFrameNumberTracker.getCompletedFrameNumber();
        Iterator<AbstractMap.SimpleEntry<Long, Integer>> iterator = this.mFrameNumberRequestPairs.iterator();
        while (iterator.hasNext()) {
            CaptureCallbackHolder captureCallbackHolder;
            final AbstractMap.SimpleEntry<Long, Integer> simpleEntry = iterator.next();
            if (simpleEntry.getKey() > l) continue;
            final int n = simpleEntry.getValue();
            Object object = this.mInterfaceLock;
            synchronized (object) {
                if (this.mRemoteDevice == null) {
                    Log.w(this.TAG, "Camera closed while checking sequences");
                    return;
                }
                int n2 = this.mCaptureCallbackMap.indexOfKey(n);
                captureCallbackHolder = n2 >= 0 ? this.mCaptureCallbackMap.valueAt(n2) : null;
                if (captureCallbackHolder != null) {
                    this.mCaptureCallbackMap.removeAt(n2);
                    if (this.DEBUG) {
                        String string2 = this.TAG;
                        Object[] objectArray = new Object[]{n, simpleEntry.getKey(), l};
                        Log.v(string2, String.format("remove holder for requestId %d, because lastFrame %d is <= %d", objectArray));
                    }
                }
            }
            iterator.remove();
            if (captureCallbackHolder == null) continue;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!CameraDeviceImpl.this.isClosed()) {
                        long l;
                        if (CameraDeviceImpl.this.DEBUG) {
                            String string2 = CameraDeviceImpl.this.TAG;
                            Object[] objectArray = new Object[]{n};
                            Log.d(string2, String.format("fire sequence complete for request %d", objectArray));
                        }
                        if ((l = ((Long)simpleEntry.getKey()).longValue()) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                            throw new AssertionError((Object)(l + " cannot be cast to int"));
                        }
                        captureCallbackHolder.getCallback().onCaptureSequenceCompleted(CameraDeviceImpl.this, n, l);
                    }
                }
            };
            captureCallbackHolder.getHandler().post(runnable);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkEarlyTriggerSequenceComplete(final int n, final long l) {
        if (l != -1L) {
            this.mFrameNumberRequestPairs.add(new AbstractMap.SimpleEntry<Long, Integer>(l, n));
            this.checkAndFireSequenceComplete();
            return;
        }
        int n2 = this.mCaptureCallbackMap.indexOfKey(n);
        final CaptureCallbackHolder captureCallbackHolder = n2 >= 0 ? this.mCaptureCallbackMap.valueAt(n2) : null;
        if (captureCallbackHolder != null) {
            this.mCaptureCallbackMap.removeAt(n2);
            if (this.DEBUG) {
                String string2 = this.TAG;
                Object[] objectArray = new Object[]{n, l};
                Log.v(string2, String.format("remove holder for requestId %d, because lastFrame is %d.", objectArray));
            }
        }
        if (captureCallbackHolder == null) {
            String string3 = this.TAG;
            Object[] objectArray = new Object[]{n};
            Log.w(string3, String.format("did not register callback to request %d", objectArray));
            return;
        }
        if (this.DEBUG) {
            Log.v(this.TAG, "immediately trigger onCaptureSequenceAborted because request did not reach HAL");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!CameraDeviceImpl.this.isClosed()) {
                    if (CameraDeviceImpl.this.DEBUG) {
                        String string2 = CameraDeviceImpl.this.TAG;
                        Object[] objectArray = new Object[]{n};
                        Log.d(string2, String.format("early trigger sequence complete for request %d", objectArray));
                    }
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw new AssertionError((Object)(l + " cannot be cast to int"));
                    }
                    captureCallbackHolder.getCallback().onCaptureSequenceAborted(CameraDeviceImpl.this, n);
                }
            }
        };
        captureCallbackHolder.getHandler().post(runnable);
    }

    static Handler checkHandler(Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        return handler;
    }

    static <T> Handler checkHandler(Handler handler, T t) {
        if (t != null) {
            handler = CameraDeviceImpl.checkHandler(handler);
        }
        return handler;
    }

    private void checkIfCameraClosedOrInError() throws CameraAccessException {
        if (this.mInError) {
            throw new CameraAccessException(3, "The camera device has encountered a serious error");
        }
        if (this.mRemoteDevice == null) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
    }

    private CameraCharacteristics getCharacteristics() {
        return this.mCharacteristics;
    }

    private boolean isClosed() {
        return this.mClosing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int submitCaptureRequest(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler, boolean bl) throws CameraAccessException {
        Handler handler2 = CameraDeviceImpl.checkHandler(handler, captureCallback);
        for (CaptureRequest captureRequest : list) {
            if (captureRequest.getTargets().isEmpty()) {
                throw new IllegalArgumentException("Each request must have at least one Surface target");
            }
            Iterator<Surface> iterator = captureRequest.getTargets().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                throw new IllegalArgumentException("Null Surface targets are not allowed");
            }
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int n;
            LongParcelable longParcelable;
            block17: {
                block16: {
                    this.checkIfCameraClosedOrInError();
                    if (bl) {
                        this.stopRepeating();
                    }
                    longParcelable = new LongParcelable();
                    try {
                        n = this.mRemoteDevice.submitRequestList(list, bl, longParcelable);
                        if (this.DEBUG) {
                            Log.v(this.TAG, "last frame number " + longParcelable.getNumber());
                        }
                        if (captureCallback == null) break block16;
                    }
                    catch (CameraRuntimeException cameraRuntimeException) {
                        throw cameraRuntimeException.asChecked();
                    }
                    catch (RemoteException remoteException) {
                        return -1;
                    }
                    this.mCaptureCallbackMap.put(n, new CaptureCallbackHolder(captureCallback, list, handler2, bl));
                    break block17;
                }
                if (this.DEBUG) {
                    Log.d(this.TAG, "Listen for request " + n + " is null");
                }
            }
            long l = longParcelable.getNumber();
            if (bl) {
                if (this.mRepeatingRequestId != -1) {
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, l);
                }
                this.mRepeatingRequestId = n;
            } else {
                this.mFrameNumberRequestPairs.add(new AbstractMap.SimpleEntry<Long, Integer>(l, n));
            }
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnActive);
            }
            this.mIdle = false;
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilIdle() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                throw new IllegalStateException("Active repeating request ongoing");
            }
            try {
                this.mRemoteDevice.waitUntilIdle();
                return;
            }
            catch (CameraRuntimeException cameraRuntimeException) {
                throw cameraRuntimeException.asChecked();
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    public int capture(CaptureRequest captureRequest, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        if (this.DEBUG) {
            Log.d(this.TAG, "calling capture");
        }
        ArrayList<CaptureRequest> arrayList = new ArrayList<CaptureRequest>();
        arrayList.add(captureRequest);
        return this.submitCaptureRequest(arrayList, captureCallback, handler, false);
    }

    public int captureBurst(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(list, captureCallback, handler, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            try {
                if (this.mRemoteDevice != null) {
                    this.mRemoteDevice.disconnect();
                }
            }
            catch (CameraRuntimeException cameraRuntimeException) {
                Log.e(this.TAG, "Exception while closing: ", cameraRuntimeException.asChecked());
            }
            catch (RemoteException remoteException) {}
            if (this.mRemoteDevice != null || this.mInError) {
                this.mDeviceHandler.post(this.mCallOnClosed);
            }
            this.mRemoteDevice = null;
            this.mInError = false;
            return;
        }
    }

    public void configureOutputs(List<Surface> list) throws CameraAccessException {
        this.configureOutputsChecked(list);
    }

    /*
     * Exception decompiling
     */
    public boolean configureOutputsChecked(List<Surface> var1_1) throws CameraAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 121->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CaptureRequest.Builder createCaptureRequest(int n) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
            try {
                this.mRemoteDevice.createDefaultRequest(n, cameraMetadataNative);
                return new CaptureRequest.Builder(cameraMetadataNative);
            }
            catch (CameraRuntimeException cameraRuntimeException) {
                throw cameraRuntimeException.asChecked();
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createCaptureSession(List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            boolean bl;
            CameraAccessException cameraAccessException;
            block8: {
                if (this.DEBUG) {
                    Log.d(this.TAG, "createCaptureSession");
                }
                this.checkIfCameraClosedOrInError();
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.replaceSessionClose();
                }
                cameraAccessException = null;
                try {
                    boolean bl2;
                    bl = bl2 = this.configureOutputsChecked(list);
                }
                catch (CameraAccessException cameraAccessException2) {
                    cameraAccessException = cameraAccessException2;
                    boolean bl3 = this.DEBUG;
                    bl = false;
                    if (!bl3) break block8;
                    Log.v(this.TAG, "createCaptureSession - failed with exception ", cameraAccessException2);
                    bl = false;
                }
            }
            int n = this.mNextSessionId;
            this.mNextSessionId = n + 1;
            this.mCurrentSession = new CameraCaptureSessionImpl(n, list, stateCallback, handler, this, this.mDeviceHandler, bl);
            if (cameraAccessException != null) {
                throw cameraAccessException;
            }
            this.mSessionStateCallback = this.mCurrentSession.getDeviceStateCallback();
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            this.mDeviceHandler.post(this.mCallOnBusy);
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnIdle);
                return;
            }
            try {
                LongParcelable longParcelable = new LongParcelable();
                this.mRemoteDevice.flush(longParcelable);
                if (this.mRepeatingRequestId != -1) {
                    long l = longParcelable.getNumber();
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, l);
                    this.mRepeatingRequestId = -1;
                }
                return;
            }
            catch (CameraRuntimeException cameraRuntimeException) {
                throw cameraRuntimeException.asChecked();
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    public CameraDeviceCallbacks getCallbacks() {
        return this.mCallbacks;
    }

    @Override
    public String getId() {
        return this.mCameraId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRemoteDevice(ICameraDeviceUser iCameraDeviceUser) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInError) {
                return;
            }
            this.mRemoteDevice = CameraBinderDecorator.newInstance(iCameraDeviceUser);
            this.mDeviceHandler.post(this.mCallOnOpened);
            this.mDeviceHandler.post(this.mCallOnUnconfigured);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRemoteFailure(CameraRuntimeException cameraRuntimeException) {
        int n = 4;
        boolean bl = true;
        switch (cameraRuntimeException.getReason()) {
            default: {
                Log.wtf(this.TAG, "Unknown failure in opening camera device: " + cameraRuntimeException.getReason());
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                n = 4;
            }
        }
        final int n2 = n;
        final boolean bl2 = bl;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInError = true;
            this.mDeviceHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (bl2) {
                        CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, n2);
                        return;
                    }
                    CameraDeviceImpl.this.mDeviceCallback.onDisconnected(CameraDeviceImpl.this);
                }
            });
            return;
        }
    }

    public int setRepeatingBurst(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(list, captureCallback, handler, true);
    }

    public int setRepeatingRequest(CaptureRequest captureRequest, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        ArrayList<CaptureRequest> arrayList = new ArrayList<CaptureRequest>();
        arrayList.add(captureRequest);
        return this.submitCaptureRequest(arrayList, captureCallback, handler, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSessionListener(StateCallbackKK stateCallbackKK) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mSessionStateCallback = stateCallbackKK;
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopRepeating() throws CameraAccessException {
        var1_1 = this.mInterfaceLock;
        synchronized (var1_1) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId == -1) ** GOTO lbl15
            var3_2 = this.mRepeatingRequestId;
            this.mRepeatingRequestId = -1;
            if (this.mCaptureCallbackMap.get(var3_2) != null) {
                this.mRepeatingRequestIdDeletedList.add(var3_2);
            }
            try {
                var4_3 = new LongParcelable();
                this.mRemoteDevice.cancelRequest(var3_2, var4_3);
                this.checkEarlyTriggerSequenceComplete(var3_2, var4_3.getNumber());
lbl15:
                // 2 sources

                return;
            }
            catch (CameraRuntimeException var6_4) {
                throw var6_4.asChecked();
            }
            catch (RemoteException var5_5) {
                return;
            }
        }
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub {
        public static final int ERROR_CAMERA_BUFFER = 5;
        public static final int ERROR_CAMERA_DEVICE = 1;
        public static final int ERROR_CAMERA_DISCONNECTED = 0;
        public static final int ERROR_CAMERA_REQUEST = 3;
        public static final int ERROR_CAMERA_RESULT = 4;
        public static final int ERROR_CAMERA_SERVICE = 2;

        /*
         * Enabled aggressive block sorting
         */
        private void onCaptureErrorLocked(int n, CaptureResultExtras captureResultExtras) {
            int n2 = captureResultExtras.getRequestId();
            int n3 = captureResultExtras.getSubsequenceId();
            long l = captureResultExtras.getFrameNumber();
            final CaptureCallbackHolder captureCallbackHolder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(n2);
            final CaptureRequest captureRequest = captureCallbackHolder.getRequest(n3);
            if (n == 5) {
                String string2 = CameraDeviceImpl.this.TAG;
                Object[] objectArray = new Object[]{l};
                Log.e(string2, String.format("Lost output buffer reported for frame %d", objectArray));
                return;
            }
            boolean bl = n == 4;
            int n4 = CameraDeviceImpl.this.mCurrentSession != null && CameraDeviceImpl.this.mCurrentSession.isAborting() ? 1 : 0;
            Runnable runnable = new Runnable(new CaptureFailure(captureRequest, n4, bl, n2, l)){
                final /* synthetic */ CaptureFailure val$failure;
                {
                    this.val$failure = captureFailure;
                }

                @Override
                public void run() {
                    if (!CameraDeviceImpl.this.isClosed()) {
                        captureCallbackHolder.getCallback().onCaptureFailed(CameraDeviceImpl.this, captureRequest, this.val$failure);
                    }
                }
            };
            captureCallbackHolder.getHandler().post(runnable);
            if (CameraDeviceImpl.this.DEBUG) {
                String string3 = CameraDeviceImpl.this.TAG;
                Object[] objectArray = new Object[]{l};
                Log.v(string3, String.format("got error frame %d", objectArray));
            }
            CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(l, true);
            CameraDeviceImpl.this.checkAndFireSequenceComplete();
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCaptureStarted(final CaptureResultExtras captureResultExtras, final long l) {
            int n = captureResultExtras.getRequestId();
            final long l2 = captureResultExtras.getFrameNumber();
            if (CameraDeviceImpl.this.DEBUG) {
                Log.d(CameraDeviceImpl.this.TAG, "Capture started for id " + n + " frame number " + l2);
            }
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                final CaptureCallbackHolder captureCallbackHolder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(n);
                if (captureCallbackHolder == null) {
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    return;
                }
                captureCallbackHolder.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (!CameraDeviceImpl.this.isClosed()) {
                            captureCallbackHolder.getCallback().onCaptureStarted(CameraDeviceImpl.this, captureCallbackHolder.getRequest(captureResultExtras.getSubsequenceId()), l, l2);
                        }
                    }
                });
                return;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onDeviceError(final int var1_1, CaptureResultExtras var2_2) {
            if (CameraDeviceImpl.access$400(CameraDeviceImpl.this)) {
                var10_3 = CameraDeviceImpl.access$500(CameraDeviceImpl.this);
                var11_4 = new Object[]{var1_1, var2_2.getFrameNumber(), var2_2.getRequestId(), var2_2.getSubsequenceId()};
                Log.d(var10_3, String.format("Device error received, code %d, frame number %d, request ID %d, subseq ID %d", var11_4));
            }
            var3_5 = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (var3_5) {
                block10: {
                    if (CameraDeviceImpl.access$000(CameraDeviceImpl.this) == null) {
                        return;
                    }
                    switch (var1_1) {
                        default: {
                            Log.e(CameraDeviceImpl.access$500(CameraDeviceImpl.this), "Unknown error from camera device: " + var1_1);
                            ** GOTO lbl-1000
                        }
                        case 1: 
                        case 2: lbl-1000:
                        // 2 sources

                        {
                            CameraDeviceImpl.access$802(CameraDeviceImpl.this, true);
                            var7_6 = new Runnable(){

                                @Override
                                public void run() {
                                    if (!CameraDeviceImpl.this.isClosed()) {
                                        CameraDeviceImpl.this.mDeviceCallback.onError(CameraDeviceImpl.this, var1_1);
                                    }
                                }
                            };
                            CameraDeviceImpl.access$700(CameraDeviceImpl.this).post(var7_6);
                            break block10;
                        }
                        case 0: {
                            CameraDeviceImpl.access$700(CameraDeviceImpl.this).post(CameraDeviceImpl.access$600(CameraDeviceImpl.this));
                            break block10;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                    }
                    this.onCaptureErrorLocked(var1_1, var2_2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onDeviceIdle() {
            if (CameraDeviceImpl.this.DEBUG) {
                Log.d(CameraDeviceImpl.this.TAG, "Camera now idle");
            }
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                if (!CameraDeviceImpl.this.mIdle) {
                    CameraDeviceImpl.this.mDeviceHandler.post(CameraDeviceImpl.this.mCallOnIdle);
                }
                CameraDeviceImpl.access$902(CameraDeviceImpl.this, true);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onResultReceived(CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) throws RemoteException {
            int n = captureResultExtras.getRequestId();
            long l = captureResultExtras.getFrameNumber();
            if (CameraDeviceImpl.this.DEBUG) {
                Log.v(CameraDeviceImpl.this.TAG, "Received result frame " + l + " for id " + n);
            }
            Object object = CameraDeviceImpl.this.mInterfaceLock;
            synchronized (object) {
                CaptureResult captureResult;
                Runnable runnable;
                if (CameraDeviceImpl.this.mRemoteDevice == null) {
                    return;
                }
                cameraMetadataNative.set(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE, CameraDeviceImpl.this.getCharacteristics().get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE));
                final CaptureCallbackHolder captureCallbackHolder = (CaptureCallbackHolder)CameraDeviceImpl.this.mCaptureCallbackMap.get(n);
                boolean bl = captureResultExtras.getPartialResultCount() < CameraDeviceImpl.this.mTotalPartialCount;
                if (captureCallbackHolder == null) {
                    if (CameraDeviceImpl.this.DEBUG) {
                        Log.d(CameraDeviceImpl.this.TAG, "holder is null, early return at frame " + l);
                    }
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(l, null, bl);
                    return;
                }
                if (CameraDeviceImpl.this.isClosed()) {
                    if (CameraDeviceImpl.this.DEBUG) {
                        Log.d(CameraDeviceImpl.this.TAG, "camera is closed, early return at frame " + l);
                    }
                    CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(l, null, bl);
                    return;
                }
                final CaptureRequest captureRequest = captureCallbackHolder.getRequest(captureResultExtras.getSubsequenceId());
                if (bl) {
                    final CaptureResult captureResult2 = new CaptureResult(cameraMetadataNative, captureRequest, captureResultExtras);
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                captureCallbackHolder.getCallback().onCaptureProgressed(CameraDeviceImpl.this, captureRequest, captureResult2);
                            }
                        }
                    };
                    captureResult = captureResult2;
                } else {
                    final TotalCaptureResult totalCaptureResult = new TotalCaptureResult(cameraMetadataNative, captureRequest, captureResultExtras, CameraDeviceImpl.this.mFrameNumberTracker.popPartialResults(l));
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!CameraDeviceImpl.this.isClosed()) {
                                captureCallbackHolder.getCallback().onCaptureCompleted(CameraDeviceImpl.this, captureRequest, totalCaptureResult);
                            }
                        }
                    };
                    captureResult = totalCaptureResult;
                }
                captureCallbackHolder.getHandler().post(runnable);
                CameraDeviceImpl.this.mFrameNumberTracker.updateTracker(l, captureResult, bl);
                if (!bl) {
                    CameraDeviceImpl.this.checkAndFireSequenceComplete();
                }
                return;
            }
        }
    }

    public static abstract class CaptureCallback {
        public static final int NO_FRAMES_CAPTURED = -1;

        public void onCaptureCompleted(CameraDevice cameraDevice, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
        }

        public void onCaptureFailed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureFailure captureFailure) {
        }

        public void onCapturePartial(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
        }

        public void onCaptureProgressed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
        }

        public void onCaptureSequenceAborted(CameraDevice cameraDevice, int n) {
        }

        public void onCaptureSequenceCompleted(CameraDevice cameraDevice, int n, long l) {
        }

        public void onCaptureStarted(CameraDevice cameraDevice, CaptureRequest captureRequest, long l, long l2) {
        }
    }

    static class CaptureCallbackHolder {
        private final CaptureCallback mCallback;
        private final Handler mHandler;
        private final boolean mRepeating;
        private final List<CaptureRequest> mRequestList;

        CaptureCallbackHolder(CaptureCallback captureCallback, List<CaptureRequest> list, Handler handler, boolean bl) {
            if (captureCallback == null || handler == null) {
                throw new UnsupportedOperationException("Must have a valid handler and a valid callback");
            }
            this.mRepeating = bl;
            this.mHandler = handler;
            this.mRequestList = new ArrayList<CaptureRequest>(list);
            this.mCallback = captureCallback;
        }

        public CaptureCallback getCallback() {
            return this.mCallback;
        }

        public Handler getHandler() {
            return this.mHandler;
        }

        public CaptureRequest getRequest() {
            return this.getRequest(0);
        }

        public CaptureRequest getRequest(int n) {
            if (n >= this.mRequestList.size()) {
                Object[] objectArray = new Object[]{n, this.mRequestList.size()};
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is larger than request list size %d.", objectArray));
            }
            if (n < 0) {
                Object[] objectArray = new Object[]{n};
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is negative", objectArray));
            }
            return this.mRequestList.get(n);
        }

        public boolean isRepeating() {
            return this.mRepeating;
        }
    }

    public class FrameNumberTracker {
        private long mCompletedFrameNumber = -1L;
        private final TreeSet<Long> mFutureErrorSet = new TreeSet();
        private final HashMap<Long, List<CaptureResult>> mPartialResults = new HashMap();

        private void update() {
            Iterator<Long> iterator = this.mFutureErrorSet.iterator();
            while (iterator.hasNext() && iterator.next() == 1L + this.mCompletedFrameNumber) {
                this.mCompletedFrameNumber = 1L + this.mCompletedFrameNumber;
                iterator.remove();
            }
        }

        public long getCompletedFrameNumber() {
            return this.mCompletedFrameNumber;
        }

        public List<CaptureResult> popPartialResults(long l) {
            return this.mPartialResults.remove(l);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void updateTracker(long l, CaptureResult captureResult, boolean bl) {
            if (!bl) {
                this.updateTracker(l, false);
                return;
            } else {
                if (captureResult == null) return;
                List<CaptureResult> list = this.mPartialResults.get(l);
                if (list == null) {
                    list = new ArrayList<CaptureResult>();
                    this.mPartialResults.put(l, list);
                }
                list.add(captureResult);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void updateTracker(long l, boolean bl) {
            if (bl) {
                this.mFutureErrorSet.add(l);
            } else {
                if (l != 1L + this.mCompletedFrameNumber) {
                    String string2 = CameraDeviceImpl.this.TAG;
                    Object[] objectArray = new Object[]{l, this.mCompletedFrameNumber};
                    Log.e(string2, String.format("result frame number %d comes out of order, should be %d + 1", objectArray));
                }
                this.mCompletedFrameNumber = l;
            }
            this.update();
        }
    }

    public static abstract class StateCallbackKK
    extends CameraDevice.StateCallback {
        public void onActive(CameraDevice cameraDevice) {
        }

        public void onBusy(CameraDevice cameraDevice) {
        }

        public void onIdle(CameraDevice cameraDevice) {
        }

        public void onUnconfigured(CameraDevice cameraDevice) {
        }
    }
}

