/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.RequestHolder;
import android.util.Log;
import android.util.MutableLong;
import android.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CaptureCollector {
    private static final boolean DEBUG = false;
    private static final int FLAG_RECEIVED_ALL_JPEG = 3;
    private static final int FLAG_RECEIVED_ALL_PREVIEW = 12;
    private static final int FLAG_RECEIVED_JPEG = 1;
    private static final int FLAG_RECEIVED_JPEG_TS = 2;
    private static final int FLAG_RECEIVED_PREVIEW = 4;
    private static final int FLAG_RECEIVED_PREVIEW_TS = 8;
    private static final int MAX_JPEGS_IN_FLIGHT = 1;
    private static final String TAG = "CaptureCollector";
    private final TreeSet<CaptureHolder> mActiveRequests;
    private final ArrayList<CaptureHolder> mCompletedRequests = new ArrayList();
    private final CameraDeviceState mDeviceState;
    private int mInFlight = 0;
    private int mInFlightPreviews = 0;
    private final Condition mIsEmpty;
    private final ArrayDeque<CaptureHolder> mJpegCaptureQueue;
    private final ArrayDeque<CaptureHolder> mJpegProduceQueue;
    private final ReentrantLock mLock = new ReentrantLock();
    private final int mMaxInFlight;
    private final Condition mNotFull;
    private final ArrayDeque<CaptureHolder> mPreviewCaptureQueue;
    private final ArrayDeque<CaptureHolder> mPreviewProduceQueue;
    private final Condition mPreviewsEmpty;

    static {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
    }

    public CaptureCollector(int n, CameraDeviceState cameraDeviceState) {
        this.mMaxInFlight = n;
        this.mJpegCaptureQueue = new ArrayDeque(1);
        this.mJpegProduceQueue = new ArrayDeque(1);
        this.mPreviewCaptureQueue = new ArrayDeque(this.mMaxInFlight);
        this.mPreviewProduceQueue = new ArrayDeque(this.mMaxInFlight);
        this.mActiveRequests = new TreeSet();
        this.mIsEmpty = this.mLock.newCondition();
        this.mNotFull = this.mLock.newCondition();
        this.mPreviewsEmpty = this.mLock.newCondition();
        this.mDeviceState = cameraDeviceState;
    }

    private void onPreviewCompleted() {
        this.mInFlightPreviews = -1 + this.mInFlightPreviews;
        if (this.mInFlightPreviews < 0) {
            throw new IllegalStateException("More preview captures completed than requests queued.");
        }
        if (this.mInFlightPreviews == 0) {
            this.mPreviewsEmpty.signalAll();
        }
    }

    private void onRequestCompleted(CaptureHolder captureHolder) {
        RequestHolder requestHolder = captureHolder.mRequest;
        this.mInFlight = -1 + this.mInFlight;
        if (DEBUG) {
            Log.d(TAG, "Completed request " + requestHolder.getRequestId() + ", " + this.mInFlight + " requests remain in flight.");
        }
        if (this.mInFlight < 0) {
            throw new IllegalStateException("More captures completed than requests queued.");
        }
        this.mCompletedRequests.add(captureHolder);
        this.mActiveRequests.remove(captureHolder);
        this.mNotFull.signalAll();
        if (this.mInFlight == 0) {
            this.mIsEmpty.signalAll();
        }
    }

    private boolean removeRequestIfCompleted(RequestHolder requestHolder, MutableLong mutableLong) {
        int n = 0;
        for (CaptureHolder captureHolder : this.mCompletedRequests) {
            if (captureHolder.mRequest.equals(requestHolder)) {
                mutableLong.value = captureHolder.mTimestamp;
                this.mCompletedRequests.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void failAll() {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            CaptureHolder captureHolder;
            while ((captureHolder = this.mActiveRequests.pollFirst()) != null) {
                captureHolder.setPreviewFailed();
                captureHolder.setJpegFailed();
            }
            this.mPreviewCaptureQueue.clear();
            this.mPreviewProduceQueue.clear();
            this.mJpegCaptureQueue.clear();
            this.mJpegProduceQueue.clear();
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void failNextJpeg() {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            int n;
            CaptureHolder captureHolder = this.mJpegCaptureQueue.peek();
            CaptureHolder captureHolder2 = this.mJpegProduceQueue.peek();
            CaptureHolder captureHolder3 = captureHolder == null ? captureHolder2 : (captureHolder2 == null ? captureHolder : ((n = captureHolder.compareTo(captureHolder2)) <= 0 ? captureHolder : captureHolder2));
            if (captureHolder3 != null) {
                this.mJpegCaptureQueue.remove(captureHolder3);
                this.mJpegProduceQueue.remove(captureHolder3);
                this.mActiveRequests.remove(captureHolder3);
                captureHolder3.setJpegFailed();
            }
            reentrantLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void failNextPreview() {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            int n;
            CaptureHolder captureHolder = this.mPreviewCaptureQueue.peek();
            CaptureHolder captureHolder2 = this.mPreviewProduceQueue.peek();
            CaptureHolder captureHolder3 = captureHolder == null ? captureHolder2 : (captureHolder2 == null ? captureHolder : ((n = captureHolder.compareTo(captureHolder2)) <= 0 ? captureHolder : captureHolder2));
            if (captureHolder3 != null) {
                this.mPreviewCaptureQueue.remove(captureHolder3);
                this.mPreviewProduceQueue.remove(captureHolder3);
                this.mActiveRequests.remove(captureHolder3);
                captureHolder3.setPreviewFailed();
            }
            reentrantLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPendingPreviewCaptures() {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            boolean bl = this.mPreviewCaptureQueue.isEmpty();
            boolean bl2 = !bl;
            return bl2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public RequestHolder jpegCaptured(long l) {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            CaptureHolder captureHolder = this.mJpegCaptureQueue.poll();
            if (captureHolder == null) {
                Log.w(TAG, "jpegCaptured called with no jpeg request on queue!");
                return null;
            }
            captureHolder.setJpegTimestamp(l);
            RequestHolder requestHolder = captureHolder.mRequest;
            return requestHolder;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public Pair<RequestHolder, Long> jpegProduced() {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            CaptureHolder captureHolder = this.mJpegProduceQueue.poll();
            if (captureHolder == null) {
                Log.w(TAG, "jpegProduced called with no jpeg request on queue!");
                return null;
            }
            captureHolder.setJpegProduced();
            Pair<RequestHolder, Long> pair = new Pair<RequestHolder, Long>(captureHolder.mRequest, captureHolder.mTimestamp);
            return pair;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public Pair<RequestHolder, Long> previewCaptured(long l) {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            CaptureHolder captureHolder = this.mPreviewCaptureQueue.poll();
            if (captureHolder == null) {
                if (DEBUG) {
                    Log.d(TAG, "previewCaptured called with no preview request on queue!");
                }
                return null;
            }
            captureHolder.setPreviewTimestamp(l);
            Pair<RequestHolder, Long> pair = new Pair<RequestHolder, Long>(captureHolder.mRequest, captureHolder.mTimestamp);
            return pair;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public RequestHolder previewProduced() {
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        try {
            CaptureHolder captureHolder = this.mPreviewProduceQueue.poll();
            if (captureHolder == null) {
                Log.w(TAG, "previewProduced called with no preview request on queue!");
                return null;
            }
            captureHolder.setPreviewProduced();
            RequestHolder requestHolder = captureHolder.mRequest;
            return requestHolder;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean queueRequest(RequestHolder var1_1, LegacyRequest var2_2, long var3_3, TimeUnit var5_4) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 121->135)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForEmpty(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        while (true) {
            try {
                int n = this.mInFlight;
                if (n <= 0) break;
                if (l2 <= 0L) {
                    reentrantLock.unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                long l3;
                l2 = l3 = this.mIsEmpty.awaitNanos(l2);
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForPreviewsEmpty(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        while (true) {
            try {
                int n = this.mInFlightPreviews;
                if (n <= 0) break;
                if (l2 <= 0L) {
                    reentrantLock.unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                long l3;
                l2 = l3 = this.mPreviewsEmpty.awaitNanos(l2);
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForRequestCompleted(RequestHolder requestHolder, long l, TimeUnit timeUnit, MutableLong mutableLong) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mLock;
        reentrantLock.lock();
        while (true) {
            try {
                boolean bl = this.removeRequestIfCompleted(requestHolder, mutableLong);
                if (bl) break;
                if (l2 <= 0L) {
                    reentrantLock.unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                long l3;
                l2 = l3 = this.mNotFull.awaitNanos(l2);
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return true;
    }

    private class CaptureHolder
    implements Comparable<CaptureHolder> {
        private boolean mCompleted = false;
        private boolean mFailedJpeg = false;
        private boolean mFailedPreview = false;
        private boolean mHasStarted = false;
        private final LegacyRequest mLegacy;
        private boolean mPreviewCompleted = false;
        private int mReceivedFlags = 0;
        private final RequestHolder mRequest;
        private long mTimestamp = 0L;
        public final boolean needsJpeg;
        public final boolean needsPreview;

        public CaptureHolder(RequestHolder requestHolder, LegacyRequest legacyRequest) {
            this.mRequest = requestHolder;
            this.mLegacy = legacyRequest;
            this.needsJpeg = requestHolder.hasJpegTargets();
            this.needsPreview = requestHolder.hasPreviewTargets();
        }

        @Override
        public int compareTo(CaptureHolder captureHolder) {
            if (this.mRequest.getFrameNumber() > captureHolder.mRequest.getFrameNumber()) {
                return 1;
            }
            if (this.mRequest.getFrameNumber() == captureHolder.mRequest.getFrameNumber()) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object object) {
            return object instanceof CaptureHolder && this.compareTo((CaptureHolder)object) == 0;
        }

        public boolean isCompleted() {
            return this.needsJpeg == this.isJpegCompleted() && this.needsPreview == this.isPreviewCompleted();
        }

        public boolean isJpegCompleted() {
            return (3 & this.mReceivedFlags) == 3;
        }

        public boolean isPreviewCompleted() {
            return (0xC & this.mReceivedFlags) == 12;
        }

        public void setJpegFailed() {
            if (DEBUG) {
                Log.d(CaptureCollector.TAG, "setJpegFailed - called for request " + this.mRequest.getRequestId());
            }
            if (!this.needsJpeg || this.isJpegCompleted()) {
                return;
            }
            this.mFailedJpeg = true;
            this.mReceivedFlags = 1 | this.mReceivedFlags;
            this.mReceivedFlags = 2 | this.mReceivedFlags;
            this.tryComplete();
        }

        public void setJpegProduced() {
            if (DEBUG) {
                Log.d(CaptureCollector.TAG, "setJpegProduced - called for request " + this.mRequest.getRequestId());
            }
            if (!this.needsJpeg) {
                throw new IllegalStateException("setJpegProduced called for capture with no jpeg targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setJpegProduced called on already completed request.");
            }
            this.mReceivedFlags = 1 | this.mReceivedFlags;
            this.tryComplete();
        }

        public void setJpegTimestamp(long l) {
            if (DEBUG) {
                Log.d(CaptureCollector.TAG, "setJpegTimestamp - called for request " + this.mRequest.getRequestId());
            }
            if (!this.needsJpeg) {
                throw new IllegalStateException("setJpegTimestamp called for capture with no jpeg targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setJpegTimestamp called on already completed request.");
            }
            this.mReceivedFlags = 2 | this.mReceivedFlags;
            if (this.mTimestamp == 0L) {
                this.mTimestamp = l;
            }
            if (!this.mHasStarted) {
                this.mHasStarted = true;
                CaptureCollector.this.mDeviceState.setCaptureStart(this.mRequest, this.mTimestamp, -1);
            }
            this.tryComplete();
        }

        public void setPreviewFailed() {
            if (DEBUG) {
                Log.d(CaptureCollector.TAG, "setPreviewFailed - called for request " + this.mRequest.getRequestId());
            }
            if (!this.needsPreview || this.isPreviewCompleted()) {
                return;
            }
            this.mFailedPreview = true;
            this.mReceivedFlags = 4 | this.mReceivedFlags;
            this.mReceivedFlags = 8 | this.mReceivedFlags;
            this.tryComplete();
        }

        public void setPreviewProduced() {
            if (DEBUG) {
                Log.d(CaptureCollector.TAG, "setPreviewProduced - called for request " + this.mRequest.getRequestId());
            }
            if (!this.needsPreview) {
                throw new IllegalStateException("setPreviewProduced called for capture with no preview targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setPreviewProduced called on already completed request.");
            }
            this.mReceivedFlags = 4 | this.mReceivedFlags;
            this.tryComplete();
        }

        public void setPreviewTimestamp(long l) {
            if (DEBUG) {
                Log.d(CaptureCollector.TAG, "setPreviewTimestamp - called for request " + this.mRequest.getRequestId());
            }
            if (!this.needsPreview) {
                throw new IllegalStateException("setPreviewTimestamp called for capture with no preview targets.");
            }
            if (this.isCompleted()) {
                throw new IllegalStateException("setPreviewTimestamp called on already completed request.");
            }
            this.mReceivedFlags = 8 | this.mReceivedFlags;
            if (this.mTimestamp == 0L) {
                this.mTimestamp = l;
            }
            if (!this.needsJpeg && !this.mHasStarted) {
                this.mHasStarted = true;
                CaptureCollector.this.mDeviceState.setCaptureStart(this.mRequest, this.mTimestamp, -1);
            }
            this.tryComplete();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void tryComplete() {
            if (!this.mPreviewCompleted && this.needsPreview && this.isPreviewCompleted()) {
                CaptureCollector.this.onPreviewCompleted();
                this.mPreviewCompleted = true;
            }
            if (this.isCompleted() && !this.mCompleted) {
                if (this.mFailedPreview || this.mFailedJpeg) {
                    if (!this.mHasStarted) {
                        this.mRequest.failRequest();
                        CaptureCollector.this.mDeviceState.setCaptureStart(this.mRequest, this.mTimestamp, 3);
                    } else {
                        if (this.mFailedPreview) {
                            Log.w(CaptureCollector.TAG, "Preview buffers dropped for request: " + this.mRequest.getRequestId());
                            for (int i = 0; i < this.mRequest.numPreviewTargets(); ++i) {
                                CaptureCollector.this.mDeviceState.setCaptureResult(this.mRequest, null, 5);
                            }
                        }
                        if (this.mFailedJpeg) {
                            Log.w(CaptureCollector.TAG, "Jpeg buffers dropped for request: " + this.mRequest.getRequestId());
                            for (int i = 0; i < this.mRequest.numJpegTargets(); ++i) {
                                CaptureCollector.this.mDeviceState.setCaptureResult(this.mRequest, null, 5);
                            }
                        }
                    }
                }
                CaptureCollector.this.onRequestCompleted(this);
                this.mCompleted = true;
            }
        }
    }
}

