/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.utils.TypeReference;
import com.android.internal.util.Preconditions;
import java.nio.ByteBuffer;

public abstract class Marshaler<T> {
    public static int NATIVE_SIZE_DYNAMIC = -1;
    protected final int mNativeType;
    protected final TypeReference<T> mTypeReference;

    protected Marshaler(MarshalQueryable<T> marshalQueryable, TypeReference<T> typeReference, int n) {
        this.mTypeReference = Preconditions.checkNotNull(typeReference, "typeReference must not be null");
        this.mNativeType = MarshalHelpers.checkNativeType(n);
        if (!marshalQueryable.isTypeMappingSupported(typeReference, n)) {
            throw new UnsupportedOperationException("Unsupported type marshaling for managed type " + typeReference + " and native type " + MarshalHelpers.toStringNativeType(n));
        }
    }

    public int calculateMarshalSize(T t) {
        int n = this.getNativeSize();
        if (n == NATIVE_SIZE_DYNAMIC) {
            throw new AssertionError((Object)"Override this function for dynamically-sized objects");
        }
        return n;
    }

    public abstract int getNativeSize();

    public int getNativeType() {
        return this.mNativeType;
    }

    public TypeReference<T> getTypeReference() {
        return this.mTypeReference;
    }

    public abstract void marshal(T var1, ByteBuffer var2);

    public abstract T unmarshal(ByteBuffer var1);
}

