/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;

public class MarshalQueryablePair<T1, T2>
implements MarshalQueryable<Pair<T1, T2>> {
    @Override
    public Marshaler<Pair<T1, T2>> createMarshaler(TypeReference<Pair<T1, T2>> typeReference, int n) {
        return new MarshalerPair(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<Pair<T1, T2>> typeReference, int n) {
        return Pair.class.equals(typeReference.getRawType());
    }

    private class MarshalerPair
    extends Marshaler<Pair<T1, T2>> {
        private final Class<? super Pair<T1, T2>> mClass;
        private final Constructor<Pair<T1, T2>> mConstructor;
        private final Marshaler<T1> mNestedTypeMarshalerFirst;
        private final Marshaler<T2> mNestedTypeMarshalerSecond;

        protected MarshalerPair(TypeReference<Pair<T1, T2>> typeReference, int n) {
            ParameterizedType parameterizedType;
            super(MarshalQueryablePair.this, typeReference, n);
            this.mClass = typeReference.getRawType();
            try {
                parameterizedType = (ParameterizedType)typeReference.getType();
            }
            catch (ClassCastException classCastException) {
                throw new AssertionError("Raw use of Pair is not supported", classCastException);
            }
            this.mNestedTypeMarshalerFirst = MarshalRegistry.getMarshaler(TypeReference.createSpecializedTypeReference(parameterizedType.getActualTypeArguments()[0]), this.mNativeType);
            this.mNestedTypeMarshalerSecond = MarshalRegistry.getMarshaler(TypeReference.createSpecializedTypeReference(parameterizedType.getActualTypeArguments()[1]), this.mNativeType);
            try {
                this.mConstructor = this.mClass.getConstructor(Object.class, Object.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        @Override
        public int calculateMarshalSize(Pair<T1, T2> pair) {
            int n = this.getNativeSize();
            if (n != NATIVE_SIZE_DYNAMIC) {
                return n;
            }
            return this.mNestedTypeMarshalerFirst.calculateMarshalSize(pair.first) + this.mNestedTypeMarshalerSecond.calculateMarshalSize(pair.second);
        }

        @Override
        public int getNativeSize() {
            int n = this.mNestedTypeMarshalerFirst.getNativeSize();
            int n2 = this.mNestedTypeMarshalerSecond.getNativeSize();
            if (n != NATIVE_SIZE_DYNAMIC && n2 != NATIVE_SIZE_DYNAMIC) {
                return n + n2;
            }
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public void marshal(Pair<T1, T2> pair, ByteBuffer byteBuffer) {
            if (pair.first == null) {
                throw new UnsupportedOperationException("Pair#first must not be null");
            }
            if (pair.second == null) {
                throw new UnsupportedOperationException("Pair#second must not be null");
            }
            this.mNestedTypeMarshalerFirst.marshal(pair.first, byteBuffer);
            this.mNestedTypeMarshalerSecond.marshal(pair.second, byteBuffer);
        }

        @Override
        public Pair<T1, T2> unmarshal(ByteBuffer byteBuffer) {
            Object T1 = this.mNestedTypeMarshalerFirst.unmarshal(byteBuffer);
            Object T2 = this.mNestedTypeMarshalerSecond.unmarshal(byteBuffer);
            try {
                Pair pair = this.mConstructor.newInstance(T1, T2);
                return pair;
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException);
            }
        }
    }
}

