/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.util.Log;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CloseableLock
implements AutoCloseable {
    private static final boolean VERBOSE;
    private final String TAG;
    private volatile boolean mClosed = false;
    private final Condition mCondition;
    private boolean mExclusive = false;
    private final ReentrantLock mLock = new ReentrantLock();
    private final ThreadLocal<Integer> mLockCount;
    private final String mName;
    private int mSharedLocks = 0;

    public CloseableLock() {
        this.TAG = "CloseableLock";
        this.mCondition = this.mLock.newCondition();
        this.mLockCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        this.mName = "";
    }

    public CloseableLock(String string2) {
        this.TAG = "CloseableLock";
        this.mCondition = this.mLock.newCondition();
        this.mLockCount = new /* invalid duplicate definition of identical inner class */;
        this.mName = string2;
    }

    private void log(String string2) {
        Log.v("CloseableLock[" + this.mName + "]", string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScopedLock acquireExclusiveLock() {
        int n;
        try {
            this.mLock.lock();
            boolean bl = this.mClosed;
            if (bl) {
                this.mLock.unlock();
                return null;
            }
            n = this.mLockCount.get();
            if (!this.mExclusive && n > 0) {
                throw new IllegalStateException("Cannot acquire exclusive lock while holding shared lock");
            }
        }
        catch (Throwable throwable) {
            this.mLock.unlock();
            throw throwable;
        }
        {
            while (n == 0 && (this.mExclusive || this.mSharedLocks > 0)) {
                this.mCondition.awaitUninterruptibly();
                boolean bl = this.mClosed;
                if (!bl) continue;
                this.mLock.unlock();
                return null;
            }
        }
        {
            this.mExclusive = true;
            int n2 = 1 + this.mLockCount.get();
            this.mLockCount.set(n2);
            this.mLock.unlock();
            return new ScopedLock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScopedLock acquireLock() {
        try {
            this.mLock.lock();
            boolean bl = this.mClosed;
            if (bl) {
                this.mLock.unlock();
                return null;
            }
            int n = this.mLockCount.get();
            if (this.mExclusive && n > 0) {
                throw new IllegalStateException("Cannot acquire shared lock while holding exclusive lock");
            }
        }
        catch (Throwable throwable) {
            this.mLock.unlock();
            throw throwable;
        }
        {
            while (this.mExclusive) {
                this.mCondition.awaitUninterruptibly();
                boolean bl = this.mClosed;
                if (!bl) continue;
                this.mLock.unlock();
                return null;
            }
        }
        {
            this.mSharedLocks = 1 + this.mSharedLocks;
            int n = 1 + this.mLockCount.get();
            this.mLockCount.set(n);
            this.mLock.unlock();
            return new ScopedLock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        if (this.mClosed) {
            return;
        }
        if (this.acquireExclusiveLock() == null) return;
        if (this.mLockCount.get() != 1) {
            throw new IllegalStateException("Cannot close while one or more acquired locks are being held by this thread; release all other locks first");
        }
        try {
            this.mLock.lock();
            this.mClosed = true;
            this.mExclusive = false;
            this.mSharedLocks = 0;
            this.mLockCount.remove();
            this.mCondition.signalAll();
            return;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseLock() {
        if (this.mLockCount.get() <= 0) {
            throw new IllegalStateException("Cannot release lock that was not acquired by this thread");
        }
        try {
            this.mLock.lock();
            if (this.mClosed) {
                throw new IllegalStateException("Do not release after the lock has been closed");
            }
            if (!this.mExclusive) {
                this.mSharedLocks = -1 + this.mSharedLocks;
            } else if (this.mSharedLocks != 0) {
                throw new AssertionError((Object)("Too many shared locks " + this.mSharedLocks));
            }
            int n = -1 + this.mLockCount.get();
            this.mLockCount.set(n);
            if (n == 0 && this.mExclusive) {
                this.mExclusive = false;
                this.mCondition.signalAll();
                return;
            }
            if (n != 0) return;
            if (this.mSharedLocks != 0) return;
            this.mCondition.signalAll();
            return;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public class ScopedLock
    implements AutoCloseable {
        private ScopedLock() {
        }

        @Override
        public void close() {
            CloseableLock.this.releaseLock();
        }
    }
}

