/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import java.util.Iterator;
import java.util.List;

public class ListUtils {
    private ListUtils() {
        throw new AssertionError();
    }

    public static <T> boolean listContains(List<T> list, T t) {
        if (list == null) {
            return false;
        }
        return list.contains(t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> boolean listElementsEqualTo(List<T> list, T t) {
        boolean bl = true;
        if (list == null) {
            return false;
        }
        if (list.size() != bl) return false;
        if (!list.contains(t)) return false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T listSelectFirstFrom(List<T> list, T[] TArray) {
        T t;
        if (list == null) {
            t = null;
            return t;
        } else {
            int n = TArray.length;
            int n2 = 0;
            while (n2 < n) {
                t = TArray[n2];
                if (list.contains(t)) return t;
                ++n2;
            }
            return null;
        }
    }

    public static <T> String listToString(List<T> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = list.size();
        int n2 = 0;
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (n2 != n - 1) {
                stringBuilder.append(',');
            }
            ++n2;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

