/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.util.Size;
import com.android.internal.util.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SizeAreaComparator
implements Comparator<Size> {
    public static Size findLargestByArea(List<Size> list) {
        Preconditions.checkNotNull(list, "sizes must not be null");
        return Collections.max(list, new SizeAreaComparator());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(Size size, Size size2) {
        long l;
        int n = 1;
        Preconditions.checkNotNull(size, "size must not be null");
        Preconditions.checkNotNull(size2, "size2 must not be null");
        if (size.equals(size2)) {
            return 0;
        }
        long l2 = size.getWidth();
        long l3 = size2.getWidth();
        long l4 = l2 * (long)size.getHeight();
        if (l4 == (l = l3 * (long)size2.getHeight())) {
            if (l2 > l3) return n;
            return -1;
        }
        if (l4 > l) return n;
        return -1;
    }
}

