/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.content.Context;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputManager;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.media.AudioAttributes;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.InputEvent;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;

public final class InputManager {
    public static final String ACTION_QUERY_KEYBOARD_LAYOUTS = "android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS";
    private static final boolean DEBUG = false;
    public static final int DEFAULT_POINTER_SPEED = 0;
    public static final int INJECT_INPUT_EVENT_MODE_ASYNC = 0;
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH = 2;
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_RESULT = 1;
    public static final int MAX_POINTER_SPEED = 7;
    public static final String META_DATA_KEYBOARD_LAYOUTS = "android.hardware.input.metadata.KEYBOARD_LAYOUTS";
    public static final int MIN_POINTER_SPEED = -7;
    private static final int MSG_DEVICE_ADDED = 1;
    private static final int MSG_DEVICE_CHANGED = 3;
    private static final int MSG_DEVICE_REMOVED = 2;
    private static final String TAG = "InputManager";
    private static InputManager sInstance;
    private final IInputManager mIm;
    private final ArrayList<InputDeviceListenerDelegate> mInputDeviceListeners;
    private SparseArray<InputDevice> mInputDevices;
    private InputDevicesChangedListener mInputDevicesChangedListener;
    private final Object mInputDevicesLock = new Object();

    private InputManager(IInputManager iInputManager) {
        this.mInputDeviceListeners = new ArrayList();
        this.mIm = iInputManager;
    }

    private static boolean containsDeviceId(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private int findInputDeviceListenerLocked(InputDeviceListener inputDeviceListener) {
        int n = this.mInputDeviceListeners.size();
        for (int i = 0; i < n; ++i) {
            if (this.mInputDeviceListeners.get((int)i).mListener != inputDeviceListener) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputManager getInstance() {
        synchronized (InputManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new InputManager(IInputManager.Stub.asInterface(ServiceManager.getService("input")));
            return sInstance;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onInputDevicesChanged(int[] nArray) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int n = this.mInputDevices.size();
            while (--n > 0) {
                int n2 = this.mInputDevices.keyAt(n);
                if (InputManager.containsDeviceId(nArray, n2)) continue;
                this.mInputDevices.removeAt(n);
                this.sendMessageToInputDeviceListenersLocked(2, n2);
            }
            int n3 = 0;
            while (true) {
                block10: {
                    int n4;
                    block9: {
                        if (n3 >= nArray.length) {
                            return;
                        }
                        n4 = nArray[n3];
                        int n5 = this.mInputDevices.indexOfKey(n4);
                        if (n5 < 0) break block9;
                        InputDevice inputDevice = this.mInputDevices.valueAt(n5);
                        if (inputDevice != null) {
                            int n6 = nArray[n3 + 1];
                            if (inputDevice.getGeneration() != n6) {
                                this.mInputDevices.setValueAt(n5, null);
                                this.sendMessageToInputDeviceListenersLocked(3, n4);
                            }
                        }
                        break block10;
                    }
                    this.mInputDevices.put(n4, null);
                    this.sendMessageToInputDeviceListenersLocked(1, n4);
                }
                n3 += 2;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void populateInputDevicesLocked() {
        block7: {
            if (this.mInputDevicesChangedListener == null) {
                InputDevicesChangedListener inputDevicesChangedListener = new InputDevicesChangedListener();
                this.mIm.registerInputDevicesChangedListener(inputDevicesChangedListener);
                this.mInputDevicesChangedListener = inputDevicesChangedListener;
            }
            if (this.mInputDevices == null) {
                int[] nArray = this.mIm.getInputDeviceIds();
                this.mInputDevices = new SparseArray();
                for (int i = 0; i < nArray.length; ++i) {
                    this.mInputDevices.put(nArray[i], null);
                }
            }
            break block7;
            catch (RemoteException remoteException) {
                throw new RuntimeException("Could not get register input device changed listener", remoteException);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("Could not get input device ids.", remoteException);
            }
        }
    }

    private void sendMessageToInputDeviceListenersLocked(int n, int n2) {
        int n3 = this.mInputDeviceListeners.size();
        for (int i = 0; i < n3; ++i) {
            InputDeviceListenerDelegate inputDeviceListenerDelegate = this.mInputDeviceListeners.get(i);
            inputDeviceListenerDelegate.sendMessage(inputDeviceListenerDelegate.obtainMessage(n, n2, 0));
        }
    }

    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        if (inputDeviceIdentifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.addKeyboardLayoutForInputDevice(inputDeviceIdentifier, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not add keyboard layout for input device.", remoteException);
            return;
        }
    }

    public boolean[] deviceHasKeys(int n, int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        try {
            this.mIm.hasKeys(n, -256, nArray, blArray);
            return blArray;
        }
        catch (RemoteException remoteException) {
            return blArray;
        }
    }

    public boolean[] deviceHasKeys(int[] nArray) {
        return this.deviceHasKeys(-1, nArray);
    }

    public String getAlternateKeyboardLayoutForInputDevice(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            String string3 = this.mIm.getAlternateKeyboardLayoutForInputDevice(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get alternate keyboard layout for input device.", remoteException);
            return null;
        }
    }

    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier) {
        try {
            String string2 = this.mIm.getCurrentKeyboardLayoutForInputDevice(inputDeviceIdentifier);
            return string2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get current keyboard layout for input device.", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputDevice getInputDevice(int n) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int n2 = this.mInputDevices.indexOfKey(n);
            if (n2 < 0) {
                return null;
            }
            InputDevice inputDevice = this.mInputDevices.valueAt(n2);
            if (inputDevice == null) {
                try {
                    InputDevice inputDevice2;
                    inputDevice = inputDevice2 = this.mIm.getInputDevice(n);
                    if (inputDevice != null) {
                        this.mInputDevices.setValueAt(n2, inputDevice);
                    }
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeException("Could not get input device information.", remoteException);
                }
            }
            return inputDevice;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputDevice getInputDeviceByDescriptor(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("descriptor must not be null.");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int n = this.mInputDevices.size();
            int n2 = 0;
            while (true) {
                block13: {
                    InputDevice inputDevice;
                    block12: {
                        if (n2 >= n) {
                            return null;
                        }
                        inputDevice = this.mInputDevices.valueAt(n2);
                        if (inputDevice != null) break block12;
                        int n3 = this.mInputDevices.keyAt(n2);
                        try {
                            InputDevice inputDevice2;
                            inputDevice = inputDevice2 = this.mIm.getInputDevice(n3);
                        }
                        catch (RemoteException remoteException) {}
                        if (inputDevice == null) break block13;
                        this.mInputDevices.setValueAt(n2, inputDevice);
                    }
                    if (string2.equals(inputDevice.getDescriptor())) {
                        return inputDevice;
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] getInputDeviceIds() {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int n = this.mInputDevices.size();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.mInputDevices.keyAt(n2);
                ++n2;
            }
            return nArray;
        }
    }

    public Vibrator getInputDeviceVibrator(int n) {
        return new InputDeviceVibrator(n);
    }

    public KeyboardLayout getKeyboardLayout(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            KeyboardLayout keyboardLayout = this.mIm.getKeyboardLayout(string2);
            return keyboardLayout;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get keyboard layout information.", remoteException);
            return null;
        }
    }

    public KeyboardLayout[] getKeyboardLayouts() {
        try {
            KeyboardLayout[] keyboardLayoutArray = this.mIm.getKeyboardLayouts();
            return keyboardLayoutArray;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get list of keyboard layout informations.", remoteException);
            return new KeyboardLayout[0];
        }
    }

    public String[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier inputDeviceIdentifier) {
        if (inputDeviceIdentifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            String[] stringArray = this.mIm.getKeyboardLayoutsForInputDevice(inputDeviceIdentifier);
            return stringArray;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get keyboard layouts for input device.", remoteException);
            return ArrayUtils.emptyArray(String.class);
        }
    }

    public int getPointerSpeed(Context context) {
        try {
            int n = Settings.System.getInt(context.getContentResolver(), "pointer_speed");
            return n;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0;
        }
    }

    public TouchCalibration getTouchCalibration(String string2, int n) {
        try {
            TouchCalibration touchCalibration = this.mIm.getTouchCalibrationForInputDevice(string2, n);
            return touchCalibration;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not get calibration matrix for input device.", remoteException);
            return TouchCalibration.IDENTITY;
        }
    }

    public boolean injectInputEvent(InputEvent inputEvent, int n) {
        if (inputEvent == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (n != 0 && n != 2 && n != 1) {
            throw new IllegalArgumentException("mode is invalid");
        }
        try {
            boolean bl = this.mIm.injectInputEvent(inputEvent, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerInputDeviceListener(InputDeviceListener inputDeviceListener, Handler handler) {
        if (inputDeviceListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            if (this.findInputDeviceListenerLocked(inputDeviceListener) < 0) {
                this.mInputDeviceListeners.add(new InputDeviceListenerDelegate(inputDeviceListener, handler));
            }
            return;
        }
    }

    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        if (inputDeviceIdentifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.removeKeyboardLayoutForInputDevice(inputDeviceIdentifier, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not remove keyboard layout for input device.", remoteException);
            return;
        }
    }

    public void setAlternateKeyboardLayoutForInputDevice(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            this.mIm.setAlternateKeyboardLayoutForInputDevice(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not add keyboard layout for input device.", remoteException);
            return;
        }
    }

    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        if (inputDeviceIdentifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.setCurrentKeyboardLayoutForInputDevice(inputDeviceIdentifier, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set current keyboard layout for input device.", remoteException);
            return;
        }
    }

    public void setPointerSpeed(Context context, int n) {
        if (n < -7 || n > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putInt(context.getContentResolver(), "pointer_speed", n);
    }

    public void setTouchCalibration(String string2, int n, TouchCalibration touchCalibration) {
        try {
            this.mIm.setTouchCalibrationForInputDevice(string2, n, touchCalibration);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set calibration matrix for input device.", remoteException);
            return;
        }
    }

    public void tryPointerSpeed(int n) {
        if (n < -7 || n > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        try {
            this.mIm.tryPointerSpeed(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not set temporary pointer speed.", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterInputDeviceListener(InputDeviceListener inputDeviceListener) {
        if (inputDeviceListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int n = this.findInputDeviceListenerLocked(inputDeviceListener);
            if (n >= 0) {
                this.mInputDeviceListeners.get(n).removeCallbacksAndMessages(null);
                this.mInputDeviceListeners.remove(n);
            }
            return;
        }
    }

    public static interface InputDeviceListener {
        public void onInputDeviceAdded(int var1);

        public void onInputDeviceChanged(int var1);

        public void onInputDeviceRemoved(int var1);
    }

    private static final class InputDeviceListenerDelegate
    extends Handler {
        public final InputDeviceListener mListener;

        /*
         * Enabled aggressive block sorting
         */
        public InputDeviceListenerDelegate(InputDeviceListener inputDeviceListener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.myLooper();
            super(looper);
            this.mListener = inputDeviceListener;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    this.mListener.onInputDeviceAdded(message.arg1);
                    return;
                }
                case 2: {
                    this.mListener.onInputDeviceRemoved(message.arg1);
                    return;
                }
                case 3: 
            }
            this.mListener.onInputDeviceChanged(message.arg1);
        }
    }

    private final class InputDeviceVibrator
    extends Vibrator {
        private final int mDeviceId;
        private final Binder mToken;

        public InputDeviceVibrator(int n) {
            this.mDeviceId = n;
            this.mToken = new Binder();
        }

        @Override
        public void cancel() {
            try {
                InputManager.this.mIm.cancelVibrate(this.mDeviceId, this.mToken);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(InputManager.TAG, "Failed to cancel vibration.", remoteException);
                return;
            }
        }

        @Override
        public boolean hasVibrator() {
            return true;
        }

        @Override
        public void vibrate(int n, String string2, long l, AudioAttributes audioAttributes) {
            this.vibrate(new long[]{0L, l}, -1);
        }

        @Override
        public void vibrate(int n, String string2, long[] lArray, int n2, AudioAttributes audioAttributes) {
            if (n2 >= lArray.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            try {
                InputManager.this.mIm.vibrate(this.mDeviceId, lArray, n2, this.mToken);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(InputManager.TAG, "Failed to vibrate.", remoteException);
                return;
            }
        }
    }

    private final class InputDevicesChangedListener
    extends IInputDevicesChangedListener.Stub {
        private InputDevicesChangedListener() {
        }

        @Override
        public void onInputDevicesChanged(int[] nArray) throws RemoteException {
            InputManager.this.onInputDevicesChanged(nArray);
        }
    }
}

