/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.app.PendingIntent;
import android.content.Context;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import java.util.HashMap;

public class UsbManager {
    public static final String ACTION_USB_ACCESSORY_ATTACHED = "android.hardware.usb.action.USB_ACCESSORY_ATTACHED";
    public static final String ACTION_USB_ACCESSORY_DETACHED = "android.hardware.usb.action.USB_ACCESSORY_DETACHED";
    public static final String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    public static final String ACTION_USB_DEVICE_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    public static final String ACTION_USB_STATE = "android.hardware.usb.action.USB_STATE";
    public static final String EXTRA_ACCESSORY = "accessory";
    public static final String EXTRA_DEVICE = "device";
    public static final String EXTRA_PERMISSION_GRANTED = "permission";
    private static final String TAG = "UsbManager";
    public static final String USB_CONFIGURED = "configured";
    public static final String USB_CONNECTED = "connected";
    public static final String USB_FUNCTION_ACCESSORY = "accessory";
    public static final String USB_FUNCTION_ADB = "adb";
    public static final String USB_FUNCTION_AUDIO_SOURCE = "audio_source";
    public static final String USB_FUNCTION_MASS_STORAGE = "mass_storage";
    public static final String USB_FUNCTION_MTP = "mtp";
    public static final String USB_FUNCTION_PCLINK = "pclink";
    public static final String USB_FUNCTION_PTP = "ptp";
    public static final String USB_FUNCTION_RNDIS = "rndis";
    private final Context mContext;
    private final IUsbManager mService;

    public UsbManager(Context context, IUsbManager iUsbManager) {
        this.mContext = context;
        this.mService = iUsbManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean propertyContainsFunction(String string2, String string3) {
        int n;
        String string4 = SystemProperties.get(string2, "");
        int n2 = string4.indexOf(string3);
        return n2 >= 0 && (n2 <= 0 || string4.charAt(n2 - 1) == ',') && ((n = n2 + string3.length()) >= string4.length() || string4.charAt(n) == ',');
    }

    public UsbAccessory[] getAccessoryList() {
        UsbAccessory usbAccessory;
        block3: {
            try {
                usbAccessory = this.mService.getCurrentAccessory();
                if (usbAccessory != null) break block3;
                return null;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in getAccessoryList", remoteException);
                return null;
            }
        }
        UsbAccessory[] usbAccessoryArray = new UsbAccessory[]{usbAccessory};
        return usbAccessoryArray;
    }

    public String getDefaultFunction() {
        String string2 = SystemProperties.get("persist.sys.usb.config", "");
        int n = string2.indexOf(44);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public HashMap<String, UsbDevice> getDeviceList() {
        HashMap<String, UsbDevice> hashMap;
        Bundle bundle = new Bundle();
        try {
            this.mService.getDeviceList(bundle);
            hashMap = new HashMap<String, UsbDevice>();
            for (String string2 : bundle.keySet()) {
                hashMap.put(string2, (UsbDevice)bundle.get(string2));
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getDeviceList", remoteException);
            hashMap = null;
        }
        return hashMap;
    }

    public boolean hasPermission(UsbAccessory usbAccessory) {
        try {
            boolean bl = this.mService.hasAccessoryPermission(usbAccessory);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in hasPermission", remoteException);
            return false;
        }
    }

    public boolean hasPermission(UsbDevice usbDevice) {
        try {
            boolean bl = this.mService.hasDevicePermission(usbDevice);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in hasPermission", remoteException);
            return false;
        }
    }

    public boolean isFunctionEnabled(String string2) {
        return UsbManager.propertyContainsFunction("sys.usb.config", string2);
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory usbAccessory) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.mService.openAccessory(usbAccessory);
            return parcelFileDescriptor;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in openAccessory", remoteException);
            return null;
        }
    }

    public UsbDeviceConnection openDevice(UsbDevice usbDevice) {
        block4: {
            String string2 = usbDevice.getDeviceName();
            ParcelFileDescriptor parcelFileDescriptor = this.mService.openDevice(string2);
            if (parcelFileDescriptor == null) break block4;
            try {
                UsbDeviceConnection usbDeviceConnection = new UsbDeviceConnection(usbDevice);
                boolean bl = usbDeviceConnection.open(string2, parcelFileDescriptor);
                parcelFileDescriptor.close();
                if (bl) {
                    return usbDeviceConnection;
                }
            }
            catch (Exception exception) {
                Log.e(TAG, "exception in UsbManager.openDevice", exception);
            }
        }
        return null;
    }

    public void requestPermission(UsbAccessory usbAccessory, PendingIntent pendingIntent) {
        try {
            this.mService.requestAccessoryPermission(usbAccessory, this.mContext.getPackageName(), pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in requestPermission", remoteException);
            return;
        }
    }

    public void requestPermission(UsbDevice usbDevice, PendingIntent pendingIntent) {
        try {
            this.mService.requestDevicePermission(usbDevice, this.mContext.getPackageName(), pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in requestPermission", remoteException);
            return;
        }
    }

    public void setCurrentFunction(String string2, boolean bl) {
        try {
            this.mService.setCurrentFunction(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in setCurrentFunction", remoteException);
            return;
        }
    }

    public void setMassStorageBackingFile(String string2) {
        try {
            this.mService.setMassStorageBackingFile(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in setDefaultFunction", remoteException);
            return;
        }
    }

    public void setPCLinkDriverEnabled(boolean bl) {
        try {
            this.mService.setPCLinkDriverEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in setPCLinkDriverEnabled", remoteException);
            return;
        }
    }
}

