/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Criteria;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.WorkSource;
import android.util.TimeUtils;

public final class LocationRequest
implements Parcelable {
    public static final int ACCURACY_BLOCK = 102;
    public static final int ACCURACY_CITY = 104;
    public static final int ACCURACY_FINE = 100;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new Parcelable.Creator<LocationRequest>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public LocationRequest createFromParcel(Parcel parcel) {
            WorkSource workSource;
            LocationRequest locationRequest = new LocationRequest();
            locationRequest.setQuality(parcel.readInt());
            locationRequest.setFastestInterval(parcel.readLong());
            locationRequest.setInterval(parcel.readLong());
            locationRequest.setExpireAt(parcel.readLong());
            locationRequest.setNumUpdates(parcel.readInt());
            locationRequest.setSmallestDisplacement(parcel.readFloat());
            boolean bl = parcel.readInt() != 0;
            locationRequest.setHideFromAppOps(bl);
            String string2 = parcel.readString();
            if (string2 != null) {
                locationRequest.setProvider(string2);
            }
            if ((workSource = (WorkSource)parcel.readParcelable(null)) != null) {
                locationRequest.setWorkSource(workSource);
            }
            return locationRequest;
        }

        public LocationRequest[] newArray(int n) {
            return new LocationRequest[n];
        }
    };
    private static final double FASTEST_INTERVAL_FACTOR = 6.0;
    public static final int POWER_HIGH = 203;
    public static final int POWER_LOW = 201;
    public static final int POWER_NONE = 200;
    private long mExpireAt;
    private boolean mExplicitFastestInterval = false;
    private long mFastestInterval = (long)((double)this.mInterval / 6.0);
    private boolean mHideFromAppOps = false;
    private long mInterval = 3600000L;
    private int mNumUpdates;
    private String mProvider = "fused";
    private int mQuality = 201;
    private float mSmallestDisplacement = 0.0f;
    private WorkSource mWorkSource = null;

    public LocationRequest() {
        this.mExpireAt = Long.MAX_VALUE;
        this.mNumUpdates = Integer.MAX_VALUE;
    }

    public LocationRequest(LocationRequest locationRequest) {
        this.mExpireAt = Long.MAX_VALUE;
        this.mNumUpdates = Integer.MAX_VALUE;
        this.mQuality = locationRequest.mQuality;
        this.mInterval = locationRequest.mInterval;
        this.mFastestInterval = locationRequest.mFastestInterval;
        this.mExplicitFastestInterval = locationRequest.mExplicitFastestInterval;
        this.mExpireAt = locationRequest.mExpireAt;
        this.mNumUpdates = locationRequest.mNumUpdates;
        this.mSmallestDisplacement = locationRequest.mSmallestDisplacement;
        this.mProvider = locationRequest.mProvider;
        this.mWorkSource = locationRequest.mWorkSource;
        this.mHideFromAppOps = locationRequest.mHideFromAppOps;
    }

    private static void checkDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f);
        }
    }

    private static void checkInterval(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l);
        }
    }

    private static void checkProvider(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("invalid provider: " + string2);
        }
    }

    private static void checkQuality(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("invalid quality: " + n);
            }
            case 100: 
            case 102: 
            case 104: 
            case 200: 
            case 201: 
            case 203: 
        }
    }

    public static LocationRequest create() {
        return new LocationRequest();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static LocationRequest createFromDeprecatedCriteria(Criteria criteria, long l, float f, boolean bl) {
        int n;
        if (l < 0L) {
            l = 0L;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        switch (criteria.getAccuracy()) {
            default: {
                switch (criteria.getPowerRequirement()) {
                    case 3: 
                }
                n = 201;
                break;
            }
            case 2: {
                n = 102;
                break;
            }
            case 1: {
                n = 100;
            }
        }
        LocationRequest locationRequest = new LocationRequest().setQuality(n).setInterval(l).setFastestInterval(l).setSmallestDisplacement(f);
        if (bl) {
            locationRequest.setNumUpdates(1);
        }
        return locationRequest;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static LocationRequest createFromDeprecatedProvider(String string2, long l, float f, boolean bl) {
        if (l < 0L) {
            l = 0L;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        int n = "passive".equals(string2) ? 200 : ("gps".equals(string2) ? 100 : 201);
        LocationRequest locationRequest = new LocationRequest().setProvider(string2).setQuality(n).setInterval(l).setFastestInterval(l).setSmallestDisplacement(f);
        if (bl) {
            locationRequest.setNumUpdates(1);
        }
        return locationRequest;
    }

    public static String qualityToString(int n) {
        switch (n) {
            default: {
                return "???";
            }
            case 100: {
                return "ACCURACY_FINE";
            }
            case 102: {
                return "ACCURACY_BLOCK";
            }
            case 104: {
                return "ACCURACY_CITY";
            }
            case 200: {
                return "POWER_NONE";
            }
            case 201: {
                return "POWER_LOW";
            }
            case 203: 
        }
        return "POWER_HIGH";
    }

    public void decrementNumUpdates() {
        if (this.mNumUpdates != Integer.MAX_VALUE) {
            this.mNumUpdates = -1 + this.mNumUpdates;
        }
        if (this.mNumUpdates < 0) {
            this.mNumUpdates = 0;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public long getExpireAt() {
        return this.mExpireAt;
    }

    public long getFastestInterval() {
        return this.mFastestInterval;
    }

    public boolean getHideFromAppOps() {
        return this.mHideFromAppOps;
    }

    public long getInterval() {
        return this.mInterval;
    }

    public int getNumUpdates() {
        return this.mNumUpdates;
    }

    public String getProvider() {
        return this.mProvider;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public float getSmallestDisplacement() {
        return this.mSmallestDisplacement;
    }

    public WorkSource getWorkSource() {
        return this.mWorkSource;
    }

    public LocationRequest setExpireAt(long l) {
        this.mExpireAt = l;
        if (this.mExpireAt < 0L) {
            this.mExpireAt = 0L;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public LocationRequest setExpireIn(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.mExpireAt = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.mExpireAt < 0L) {
            this.mExpireAt = 0L;
        }
        return this;
    }

    public LocationRequest setFastestInterval(long l) {
        LocationRequest.checkInterval(l);
        this.mExplicitFastestInterval = true;
        this.mFastestInterval = l;
        return this;
    }

    public void setHideFromAppOps(boolean bl) {
        this.mHideFromAppOps = bl;
    }

    public LocationRequest setInterval(long l) {
        LocationRequest.checkInterval(l);
        this.mInterval = l;
        if (!this.mExplicitFastestInterval) {
            this.mFastestInterval = (long)((double)this.mInterval / 6.0);
        }
        return this;
    }

    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + n);
        }
        this.mNumUpdates = n;
        return this;
    }

    public LocationRequest setProvider(String string2) {
        LocationRequest.checkProvider(string2);
        this.mProvider = string2;
        return this;
    }

    public LocationRequest setQuality(int n) {
        LocationRequest.checkQuality(n);
        this.mQuality = n;
        return this;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        LocationRequest.checkDisplacement(f);
        this.mSmallestDisplacement = f;
        return this;
    }

    public void setWorkSource(WorkSource workSource) {
        this.mWorkSource = workSource;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.qualityToString(this.mQuality));
        if (this.mProvider != null) {
            stringBuilder.append(' ').append(this.mProvider);
        }
        if (this.mQuality != 200) {
            stringBuilder.append(" requested=");
            TimeUtils.formatDuration(this.mInterval, stringBuilder);
        }
        stringBuilder.append(" fastest=");
        TimeUtils.formatDuration(this.mFastestInterval, stringBuilder);
        if (this.mExpireAt != Long.MAX_VALUE) {
            long l = this.mExpireAt - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            TimeUtils.formatDuration(l, stringBuilder);
        }
        if (this.mNumUpdates != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.mNumUpdates);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mQuality);
        parcel.writeLong(this.mFastestInterval);
        parcel.writeLong(this.mInterval);
        parcel.writeLong(this.mExpireAt);
        parcel.writeInt(this.mNumUpdates);
        parcel.writeFloat(this.mSmallestDisplacement);
        int n2 = this.mHideFromAppOps ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeString(this.mProvider);
        parcel.writeParcelable(this.mWorkSource, 0);
    }
}

