/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiTvClient;
import android.media.AudioAttributes;
import android.media.AudioDevicePort;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.AudioPort;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IRemoteControlDisplay;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.MediaFocusControl;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.media.audiopolicy.AudioPolicyConfig;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.Vibrator;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.MathUtils;
import android.util.Slog;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import com.android.server.LocalServices;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class AudioService
extends IAudioService.Stub {
    private static final String ASSET_FILE_VERSION = "1.0";
    private static final String ATTR_ASSET_FILE = "file";
    private static final String ATTR_ASSET_ID = "id";
    private static final String ATTR_GROUP_NAME = "name";
    private static final String ATTR_VERSION = "version";
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static final int BT_HEADSET_CNCT_TIMEOUT_MS = 3000;
    private static final boolean DEBUG_CERTS = false;
    protected static final boolean DEBUG_MODE = false;
    private static final boolean DEBUG_SESSIONS = false;
    protected static final boolean DEBUG_VOL = false;
    private static final int FLAG_ADJUST_VOLUME = 1;
    private static final String GROUP_TOUCH_SOUNDS = "touch_sounds";
    private static final int MAX_BATCH_VOLUME_ADJUST_STEPS = 4;
    private static final int MAX_MASTER_VOLUME = 100;
    private static final int[] MAX_STREAM_VOLUME;
    private static final int MSG_BROADCAST_AUDIO_BECOMING_NOISY = 15;
    private static final int MSG_BROADCAST_BT_CONNECTION_STATE = 19;
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 6;
    private static final int MSG_BT_HEADSET_CNCT_FAILED = 9;
    private static final int MSG_CHECK_MUSIC_ACTIVE = 14;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME = 16;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME_FORCED = 17;
    private static final int MSG_LOAD_SOUND_EFFECTS = 7;
    private static final int MSG_MEDIA_SERVER_DIED = 4;
    private static final int MSG_PERSIST_MASTER_VOLUME = 2;
    private static final int MSG_PERSIST_MASTER_VOLUME_MUTE = 11;
    private static final int MSG_PERSIST_MICROPHONE_MUTE = 23;
    private static final int MSG_PERSIST_MUSIC_ACTIVE_MS = 22;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_PERSIST_SAFE_VOLUME_STATE = 18;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PLAY_SOUND_EFFECT = 5;
    private static final int MSG_REPORT_NEW_ROUTES = 12;
    private static final int MSG_SET_A2DP_SINK_CONNECTION_STATE = 102;
    private static final int MSG_SET_A2DP_SRC_CONNECTION_STATE = 101;
    private static final int MSG_SET_ALL_VOLUMES = 10;
    private static final int MSG_SET_DEVICE_VOLUME = 0;
    private static final int MSG_SET_FORCE_BT_A2DP_USE = 13;
    private static final int MSG_SET_FORCE_USE = 8;
    private static final int MSG_SET_WIRED_DEVICE_CONNECTION_STATE = 100;
    private static final int MSG_SYSTEM_READY = 21;
    private static final int MSG_UNLOAD_SOUND_EFFECTS = 20;
    private static final int MUSIC_ACTIVE_POLL_PERIOD_MS = 60000;
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final int PERSIST_DELAY = 500;
    private static final int PLATFORM_DEFAULT = 0;
    private static final int PLATFORM_TELEVISION = 2;
    private static final int PLATFORM_VOICE = 1;
    public static final int PLAY_SOUND_DELAY = 300;
    private static final boolean PREVENT_VOLUME_ADJUSTMENT_IF_SILENT = false;
    private static final String[] RINGER_MODE_NAMES;
    private static final int SAFE_MEDIA_VOLUME_ACTIVE = 3;
    private static final int SAFE_MEDIA_VOLUME_DISABLED = 1;
    private static final int SAFE_MEDIA_VOLUME_INACTIVE = 2;
    private static final int SAFE_MEDIA_VOLUME_NOT_CONFIGURED = 0;
    private static final int SAFE_VOLUME_CONFIGURE_TIMEOUT_MS = 30000;
    private static final int SCO_MODE_MAX = 2;
    private static final int SCO_MODE_RAW = 1;
    private static final int SCO_MODE_UNDEFINED = -1;
    private static final int SCO_MODE_VIRTUAL_CALL = 0;
    private static final int SCO_MODE_VR = 2;
    private static final int SCO_STATE_ACTIVATE_REQ = 1;
    private static final int SCO_STATE_ACTIVE_EXTERNAL = 2;
    private static final int SCO_STATE_ACTIVE_INTERNAL = 3;
    private static final int SCO_STATE_DEACTIVATE_EXT_REQ = 4;
    private static final int SCO_STATE_DEACTIVATE_REQ = 5;
    private static final int SCO_STATE_INACTIVE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SOUND_EFFECTS_LOAD_TIMEOUT_MS = 5000;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final List<String> SOUND_EFFECT_FILES;
    private static final int[] STEAM_VOLUME_OPS;
    private static final String[] STREAM_NAMES;
    private static final String TAG = "AudioService";
    private static final String TAG_ASSET = "asset";
    private static final String TAG_AUDIO_ASSETS = "audio_assets";
    private static final String TAG_GROUP = "group";
    private static final int UNSAFE_VOLUME_MUSIC_ACTIVE_MS_MAX = 72000000;
    private static final boolean VOLUME_SETS_RINGER_MODE_SILENT = true;
    private static int sSoundEffectVolumeDb;
    private final int[][] SOUND_EFFECT_FILES_MAP;
    private final int[] STREAM_VOLUME_ALIAS_DEFAULT;
    private final int[] STREAM_VOLUME_ALIAS_TELEVISION;
    private final int[] STREAM_VOLUME_ALIAS_VOICE;
    private BluetoothA2dp mA2dp;
    private final Object mA2dpAvrcpLock;
    private final AppOpsManager mAppOps;
    private PowerManager.WakeLock mAudioEventWakeLock;
    private AudioHandler mAudioHandler;
    private HashMap<IBinder, AudioPolicyProxy> mAudioPolicies;
    private final AudioSystem.ErrorCallback mAudioSystemCallback;
    private AudioSystemThread mAudioSystemThread;
    private boolean mAvrcpAbsVolSupported;
    int mBecomingNoisyIntentDevices;
    private boolean mBluetoothA2dpEnabled;
    private final Object mBluetoothA2dpEnabledLock;
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothHeadsetDevice;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener;
    private Boolean mCameraSoundForced;
    private final HashMap<Integer, String> mConnectedDevices;
    private final ContentResolver mContentResolver;
    private final Context mContext;
    final AudioRoutesInfo mCurAudioRoutes;
    private int mDeviceOrientation;
    private int mDeviceRotation;
    private String mDockAddress;
    private boolean mDockAudioMediaEnabled;
    private int mDockState;
    int mFixedVolumeDevices;
    private ForceControlStreamClient mForceControlStreamClient;
    private final Object mForceControlStreamLock;
    private int mForcedUseForComm;
    int mFullVolumeDevices;
    private final boolean mHasVibrator;
    private boolean mHdmiCecSink;
    private MyDisplayStatusCallback mHdmiDisplayStatusCallback;
    private HdmiControlManager mHdmiManager;
    private HdmiPlaybackClient mHdmiPlaybackClient;
    private boolean mHdmiSystemAudioSupported;
    private HdmiTvClient mHdmiTvClient;
    private KeyguardManager mKeyguardManager;
    private final int[] mMasterVolumeRamp;
    private int mMcc;
    private final MediaFocusControl mMediaFocusControl;
    private int mMode = 0;
    private final boolean mMonitorOrientation;
    private final boolean mMonitorRotation;
    private int mMusicActiveMs;
    private int mMuteAffectedStreams;
    private AudioOrientationEventListener mOrientationListener;
    private StreamVolumeCommand mPendingVolumeCommand;
    private final int mPlatformType;
    private int mPrevVolDirection;
    private final BroadcastReceiver mReceiver;
    private int mRingerMode;
    private int mRingerModeAffectedStreams;
    private int mRingerModeMutedStreams;
    private volatile IRingtonePlayer mRingtonePlayer;
    private ArrayList<RmtSbmxFullVolDeathHandler> mRmtSbmxFullVolDeathHandlers;
    private int mRmtSbmxFullVolRefCount;
    final RemoteCallbackList<IAudioRoutesObserver> mRoutesObservers;
    private final int mSafeMediaVolumeDevices;
    private int mSafeMediaVolumeIndex;
    private Integer mSafeMediaVolumeState;
    private int mScoAudioMode;
    private int mScoAudioState;
    private final ArrayList<ScoClient> mScoClients;
    private int mScoConnectionState;
    private final ArrayList<SetModeDeathHandler> mSetModeDeathHandlers;
    private final Object mSettingsLock;
    private SettingsObserver mSettingsObserver;
    private final Object mSoundEffectsLock;
    private SoundPool mSoundPool;
    private SoundPoolCallback mSoundPoolCallBack;
    private SoundPoolListenerThread mSoundPoolListenerThread;
    private Looper mSoundPoolLooper;
    private VolumeStreamState[] mStreamStates;
    private int[] mStreamVolumeAlias;
    private boolean mSystemReady;
    private final boolean mUseFixedVolume;
    private final boolean mUseMasterVolume;
    private int mVibrateSetting;
    private int mVolumeControlStream;
    private final VolumeController mVolumeController = new VolumeController();

    static {
        DEBUG_MODE = Log.isLoggable("AudioService.MOD", 3);
        DEBUG_VOL = Log.isLoggable("AudioService.VOL", 3);
        DEBUG_SESSIONS = Log.isLoggable("AudioService.SESSIONS", 3);
        SOUND_EFFECT_FILES = new ArrayList<String>();
        MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
        STEAM_VOLUME_OPS = new int[]{34, 36, 35, 36, 37, 38, 39, 36, 36, 36};
        STREAM_NAMES = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_BLUETOOTH_SCO", "STREAM_SYSTEM_ENFORCED", "STREAM_DTMF", "STREAM_TTS"};
        RINGER_MODE_NAMES = new String[]{"SILENT", "VIBRATE", "NORMAL"};
    }

    /*
     * Enabled aggressive block sorting
     */
    public AudioService(Context context) {
        this.mSettingsLock = new Object();
        this.mSoundEffectsLock = new Object();
        int[] nArray = new int[]{10, 2};
        this.SOUND_EFFECT_FILES_MAP = (int[][])Array.newInstance(Integer.TYPE, nArray);
        this.STREAM_VOLUME_ALIAS_VOICE = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3};
        this.STREAM_VOLUME_ALIAS_TELEVISION = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        this.STREAM_VOLUME_ALIAS_DEFAULT = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3};
        this.mAudioSystemCallback = new AudioSystem.ErrorCallback(){

            @Override
            public void onError(int n) {
                switch (n) {
                    default: {
                        return;
                    }
                    case 100: 
                }
                AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 0);
            }
        };
        this.mRingerModeAffectedStreams = 0;
        this.mReceiver = new AudioServiceBroadcastReceiver();
        this.mConnectedDevices = new HashMap();
        this.mSetModeDeathHandlers = new ArrayList();
        this.mScoClients = new ArrayList();
        this.mSoundPoolLooper = null;
        this.mPrevVolDirection = 0;
        this.mVolumeControlStream = -1;
        this.mForceControlStreamLock = new Object();
        this.mForceControlStreamClient = null;
        this.mDeviceOrientation = 0;
        this.mDeviceRotation = 0;
        this.mBluetoothA2dpEnabledLock = new Object();
        this.mCurAudioRoutes = new AudioRoutesInfo();
        this.mRoutesObservers = new RemoteCallbackList();
        this.mFixedVolumeDevices = 2890752;
        this.mFullVolumeDevices = 0;
        this.mDockAudioMediaEnabled = true;
        this.mDockState = 0;
        this.mA2dpAvrcpLock = new Object();
        this.mAvrcpAbsVolSupported = false;
        this.mRmtSbmxFullVolRefCount = 0;
        this.mRmtSbmxFullVolDeathHandlers = new ArrayList();
        this.mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onServiceConnected(int n, BluetoothProfile bluetoothProfile) {
                switch (n) {
                    case 2: {
                        Object object = AudioService.this.mA2dpAvrcpLock;
                        synchronized (object) {
                            AudioService.access$3402(AudioService.this, (BluetoothA2dp)bluetoothProfile);
                            List<BluetoothDevice> list = AudioService.this.mA2dp.getConnectedDevices();
                            if (list.size() > 0) {
                                BluetoothDevice bluetoothDevice = list.get(0);
                                HashMap hashMap = AudioService.this.mConnectedDevices;
                                synchronized (hashMap) {
                                    int n2 = AudioService.this.mA2dp.getConnectionState(bluetoothDevice);
                                    AudioService audioService = AudioService.this;
                                    int n3 = n2 == 2 ? 1 : 0;
                                    int n4 = audioService.checkSendBecomingNoisyIntent(128, n3);
                                    AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 102, n2, 0, bluetoothDevice, n4);
                                }
                            }
                            return;
                        }
                    }
                    case 10: {
                        List<BluetoothDevice> list = bluetoothProfile.getConnectedDevices();
                        if (list.size() > 0) {
                            BluetoothDevice bluetoothDevice = list.get(0);
                            HashMap hashMap = AudioService.this.mConnectedDevices;
                            synchronized (hashMap) {
                                int n5 = bluetoothProfile.getConnectionState(bluetoothDevice);
                                AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 101, n5, 0, bluetoothDevice, 0);
                                return;
                            }
                        }
                    }
                    default: {
                        return;
                    }
                    case 1: 
                }
                ArrayList arrayList = AudioService.this.mScoClients;
                synchronized (arrayList) {
                    AudioService.this.mAudioHandler.removeMessages(9);
                    AudioService.access$3102(AudioService.this, (BluetoothHeadset)bluetoothProfile);
                    List<BluetoothDevice> list = AudioService.this.mBluetoothHeadset.getConnectedDevices();
                    if (list.size() > 0) {
                        AudioService.access$3002(AudioService.this, list.get(0));
                    } else {
                        AudioService.access$3002(AudioService.this, null);
                    }
                    AudioService.this.checkScoAudioState();
                    if (AudioService.this.mScoAudioState == 1 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) {
                        BluetoothDevice bluetoothDevice = AudioService.this.mBluetoothHeadsetDevice;
                        boolean bl = false;
                        if (bluetoothDevice != null) {
                            int n6 = AudioService.this.mScoAudioState;
                            bl = false;
                            switch (n6) {
                                case 1: {
                                    AudioService.access$2702(AudioService.this, 3);
                                    if (AudioService.this.mScoAudioMode == 1) {
                                        bl = AudioService.this.mBluetoothHeadset.connectAudio();
                                        break;
                                    }
                                    if (AudioService.this.mScoAudioMode == 0) {
                                        bl = AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    int n7 = AudioService.this.mScoAudioMode;
                                    bl = false;
                                    if (n7 != 2) break;
                                    bl = AudioService.this.mBluetoothHeadset.startVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                    break;
                                }
                                case 5: {
                                    if (AudioService.this.mScoAudioMode == 1) {
                                        bl = AudioService.this.mBluetoothHeadset.disconnectAudio();
                                        break;
                                    }
                                    if (AudioService.this.mScoAudioMode == 0) {
                                        bl = AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    int n8 = AudioService.this.mScoAudioMode;
                                    bl = false;
                                    if (n8 != 2) break;
                                    bl = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                    break;
                                }
                                case 4: {
                                    boolean bl2;
                                    bl = bl2 = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                    break;
                                }
                            }
                        }
                        if (!bl) {
                            AudioService.sendMsg(AudioService.this.mAudioHandler, 9, 0, 0, 0, null, 0);
                        }
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onServiceDisconnected(int n) {
                switch (n) {
                    default: {
                        return;
                    }
                    case 2: {
                        Object object = AudioService.this.mA2dpAvrcpLock;
                        synchronized (object) {
                            AudioService.access$3402(AudioService.this, null);
                            HashMap hashMap = AudioService.this.mConnectedDevices;
                            synchronized (hashMap) {
                                if (AudioService.this.mConnectedDevices.containsKey(128)) {
                                    AudioService.this.makeA2dpDeviceUnavailableNow((String)AudioService.this.mConnectedDevices.get(128));
                                }
                                return;
                            }
                        }
                    }
                    case 10: {
                        HashMap hashMap = AudioService.this.mConnectedDevices;
                        synchronized (hashMap) {
                            if (AudioService.this.mConnectedDevices.containsKey(-2147352576)) {
                                AudioService.this.makeA2dpSrcUnavailable((String)AudioService.this.mConnectedDevices.get(-2147352576));
                            }
                            return;
                        }
                    }
                    case 1: 
                }
                ArrayList arrayList = AudioService.this.mScoClients;
                synchronized (arrayList) {
                    AudioService.access$3102(AudioService.this, null);
                    return;
                }
            }
        };
        this.mBecomingNoisyIntentDevices = 163724;
        this.mMcc = 0;
        this.mSafeMediaVolumeDevices = 12;
        this.mHdmiSystemAudioSupported = false;
        this.mHdmiDisplayStatusCallback = new MyDisplayStatusCallback();
        this.mAudioPolicies = new HashMap();
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mPlatformType = this.mContext.getResources().getBoolean(17956931) ? 1 : (context.getPackageManager().hasSystemFeature("android.hardware.type.television") ? 2 : 0);
        this.mAudioEventWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "handleAudioEvent");
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        boolean bl = vibrator == null ? false : vibrator.hasVibrator();
        this.mHasVibrator = bl;
        AudioService.MAX_STREAM_VOLUME[0] = SystemProperties.getInt("ro.config.vc_call_vol_steps", MAX_STREAM_VOLUME[0]);
        AudioService.MAX_STREAM_VOLUME[3] = SystemProperties.getInt("ro.config.media_vol_steps", MAX_STREAM_VOLUME[3]);
        sSoundEffectVolumeDb = context.getResources().getInteger(17694724);
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.mMediaFocusControl = new MediaFocusControl(this.mAudioHandler.getLooper(), this.mContext, this.mVolumeController, this);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        boolean bl2 = this.mContext.getResources().getBoolean(17956964);
        this.mCameraSoundForced = new Boolean(bl2);
        AudioHandler audioHandler = this.mAudioHandler;
        int n = bl2 ? 11 : 0;
        AudioService.sendMsg(audioHandler, 8, 2, 4, n, null, 0);
        this.mSafeMediaVolumeState = new Integer(Settings.Global.getInt(this.mContentResolver, "audio_safe_volume_state", 0));
        this.mSafeMediaVolumeIndex = 10 * this.mContext.getResources().getInteger(17694832);
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17956969);
        this.updateStreamVolumeAlias(false);
        this.readPersistedSettings();
        this.mSettingsObserver = new SettingsObserver();
        this.createStreamStates();
        AudioService.readAndSetLowRamDevice();
        this.mRingerModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerMode(), false);
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.media.action.USB_AUDIO_ACCESSORY_PLUG");
        intentFilter.addAction("android.media.action.USB_AUDIO_DEVICE_PLUG");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mMonitorOrientation = SystemProperties.getBoolean("ro.audio.monitorOrientation", false);
        if (this.mMonitorOrientation) {
            Log.v(TAG, "monitoring device orientation");
            this.setOrientationForAudioSystem();
        }
        this.mMonitorRotation = SystemProperties.getBoolean("ro.audio.monitorRotation", false);
        if (this.mMonitorRotation) {
            this.mDeviceRotation = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
            Log.v(TAG, "monitoring device rotation, initial=" + this.mDeviceRotation);
            this.mOrientationListener = new AudioOrientationEventListener(this.mContext);
            this.mOrientationListener.enable();
            this.setRotationForAudioSystem();
        }
        context.registerReceiver(this.mReceiver, intentFilter);
        this.mUseMasterVolume = context.getResources().getBoolean(0x1120010);
        this.restoreMasterVolume();
        this.mMasterVolumeRamp = context.getResources().getIntArray(17235979);
        LocalServices.addService(AudioManagerInternal.class, new AudioServiceInternal());
    }

    static /* synthetic */ AudioHandler access$002(AudioService audioService, AudioHandler audioHandler) {
        audioService.mAudioHandler = audioHandler;
        return audioHandler;
    }

    static /* synthetic */ ForceControlStreamClient access$1002(AudioService audioService, ForceControlStreamClient forceControlStreamClient) {
        audioService.mForceControlStreamClient = forceControlStreamClient;
        return forceControlStreamClient;
    }

    static /* synthetic */ int access$1102(AudioService audioService, int n) {
        audioService.mVolumeControlStream = n;
        return n;
    }

    static /* synthetic */ Looper access$1700(AudioService audioService) {
        return audioService.mSoundPoolLooper;
    }

    static /* synthetic */ Looper access$1702(AudioService audioService, Looper looper) {
        audioService.mSoundPoolLooper = looper;
        return looper;
    }

    static /* synthetic */ SoundPool access$1902(AudioService audioService, SoundPool soundPool) {
        audioService.mSoundPool = soundPool;
        return soundPool;
    }

    static /* synthetic */ SoundPoolCallback access$2002(AudioService audioService, SoundPoolCallback soundPoolCallback) {
        audioService.mSoundPoolCallBack = soundPoolCallback;
        return soundPoolCallback;
    }

    static /* synthetic */ int access$2702(AudioService audioService, int n) {
        audioService.mScoAudioState = n;
        return n;
    }

    static /* synthetic */ int access$2802(AudioService audioService, int n) {
        audioService.mScoAudioMode = n;
        return n;
    }

    static /* synthetic */ BluetoothDevice access$3002(AudioService audioService, BluetoothDevice bluetoothDevice) {
        audioService.mBluetoothHeadsetDevice = bluetoothDevice;
        return bluetoothDevice;
    }

    static /* synthetic */ BluetoothHeadset access$3102(AudioService audioService, BluetoothHeadset bluetoothHeadset) {
        audioService.mBluetoothHeadset = bluetoothHeadset;
        return bluetoothHeadset;
    }

    static /* synthetic */ BluetoothA2dp access$3402(AudioService audioService, BluetoothA2dp bluetoothA2dp) {
        audioService.mA2dp = bluetoothA2dp;
        return bluetoothA2dp;
    }

    static /* synthetic */ void access$5300(AudioService audioService) {
        audioService.loadTouchSoundAssets();
    }

    static /* synthetic */ SoundPoolListenerThread access$5400(AudioService audioService) {
        return audioService.mSoundPoolListenerThread;
    }

    static /* synthetic */ SoundPoolListenerThread access$5402(AudioService audioService, SoundPoolListenerThread soundPoolListenerThread) {
        audioService.mSoundPoolListenerThread = soundPoolListenerThread;
        return soundPoolListenerThread;
    }

    static /* synthetic */ int access$702(AudioService audioService, int n) {
        audioService.mDeviceRotation = n;
        return n;
    }

    static /* synthetic */ int access$8502(AudioService audioService, int n) {
        audioService.mDockState = n;
        return n;
    }

    static /* synthetic */ boolean access$9202(AudioService audioService, boolean bl) {
        audioService.mHdmiCecSink = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustStreamVolume(int n, int n2, int n3, String string2, int n4) {
        int n5;
        boolean bl;
        int n6;
        int n7;
        VolumeStreamState volumeStreamState;
        int n8;
        block40: {
            block39: {
                if (this.mUseFixedVolume) break block39;
                if (DEBUG_VOL) {
                    Log.d(TAG, "adjustStreamVolume() stream=" + n + ", dir=" + n2 + ", flags=" + n3);
                }
                this.ensureValidDirection(n2);
                this.ensureValidStreamType(n);
                n8 = this.mStreamVolumeAlias[n];
                volumeStreamState = this.mStreamStates[n8];
                n7 = this.getDeviceForStream(n8);
                n6 = volumeStreamState.getIndex(n7);
                bl = true;
                if (((n7 & 0x380) != 0 || (n3 & 0x40) == 0) && this.mAppOps.noteOp(STEAM_VOLUME_OPS[n8], n4, string2) == 0) break block40;
            }
            return;
        }
        Integer n9 = this.mSafeMediaVolumeState;
        synchronized (n9) {
            this.mPendingVolumeCommand = null;
        }
        int n10 = n3 & 0xFFFFFFDF;
        if (n8 == 3 && (n7 & this.mFixedVolumeDevices) != 0) {
            n10 |= 0x20;
            n5 = this.mSafeMediaVolumeState == 3 && (n7 & 0xC) != 0 ? this.mSafeMediaVolumeIndex : volumeStreamState.getMaxIndex();
            if (n6 != 0) {
                n6 = n5;
            }
        } else {
            n5 = this.rescaleIndex(10, n, n8);
        }
        if ((n10 & 2) != 0 || n8 == this.getMasterStreamType()) {
            int n11;
            if (this.getRingerMode() == 1) {
                n10 &= 0xFFFFFFEF;
            }
            bl = ((n11 = this.checkForRingerModeChange(n6, n2, n5)) & 1) != 0;
            if ((n11 & 0x80) != 0) {
                n10 = 0x80 | n10;
            }
        }
        int n12 = this.mStreamStates[n].getIndex(n7);
        if (bl && n2 != 0) {
            if (n8 == 3 && (n7 & 0x380) != 0 && (n10 & 0x40) == 0) {
                Object object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.adjustAvrcpAbsoluteVolume(n2);
                    }
                }
            }
            if (n2 == 1 && !this.checkSafeMediaVolume(n8, n6 + n5, n7)) {
                Log.e(TAG, "adjustStreamVolume() safe volume index = " + n12);
                this.mVolumeController.postDisplaySafeVolumeWarning(n10);
            } else if (volumeStreamState.adjustIndex(n2 * n5, n7)) {
                AudioService.sendMsg(this.mAudioHandler, 0, 2, n7, 0, volumeStreamState, 0);
            }
            int n13 = this.mStreamStates[n].getIndex(n7);
            if (this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    if (this.mHdmiTvClient != null && n8 == 3 && (0x100 & n10) == 0 && n12 != n13) {
                        int n14 = this.getStreamMaxVolume(n);
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioVolume((n12 + 5) / 10, (n13 + 5) / 10, n14);
                            }
                        }
                    }
                    if (this.mHdmiCecSink && n8 == 3 && n12 != n13) {
                        HdmiPlaybackClient hdmiPlaybackClient = this.mHdmiPlaybackClient;
                        synchronized (hdmiPlaybackClient) {
                            int n15 = n2 == -1 ? 25 : 24;
                            this.mHdmiPlaybackClient.sendKeyEvent(n15, true);
                            this.mHdmiPlaybackClient.sendKeyEvent(n15, false);
                        }
                    }
                }
            }
        }
        this.sendVolumeUpdate(n, n12, this.mStreamStates[n].getIndex(n7), n10);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustSuggestedStreamVolume(int n, int n2, int n3, String string2, int n4) {
        if (DEBUG_VOL) {
            Log.d(TAG, "adjustSuggestedStreamVolume() stream=" + n2 + ", flags=" + n3);
        }
        int n5 = this.mVolumeControlStream != -1 ? this.mVolumeControlStream : this.getActiveStreamType(n2);
        int n6 = this.mStreamVolumeAlias[n5];
        if ((n3 & 4) != 0 && n6 != 2) {
            n3 &= 0xFFFFFFFB;
        }
        if (this.mVolumeController.suppressAdjustment(n6, n3)) {
            n3 = 0xFFFFFFEF & (n3 & 0xFFFFFFFB);
            boolean bl = DEBUG_VOL;
            n = 0;
            if (bl) {
                Log.d(TAG, "Volume controller suppressed adjustment");
            }
        }
        this.adjustStreamVolume(n5, n, n3, string2, n4);
    }

    private void broadcastMasterMuteStatus(boolean bl) {
        Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", bl);
        intent.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(intent);
    }

    private void broadcastRingerMode(int n) {
        Intent intent = new Intent("android.media.RINGER_MODE_CHANGED");
        intent.putExtra("android.media.EXTRA_RINGER_MODE", n);
        intent.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(intent);
    }

    private void broadcastScoConnectionState(int n) {
        AudioService.sendMsg(this.mAudioHandler, 19, 2, n, 0, null, 0);
    }

    private void broadcastVibrateSetting(int n) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            intent.putExtra("android.media.EXTRA_VIBRATE_TYPE", n);
            intent.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(n));
            this.sendBroadcastToAll(intent);
        }
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(6);
    }

    private void checkAllAliasStreamVolumes() {
        int n = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < n; ++i) {
            if (i != this.mStreamVolumeAlias[i]) {
                this.mStreamStates[i].setAllIndexes(this.mStreamStates[this.mStreamVolumeAlias[i]]);
            }
            if (this.mStreamStates[i].isMuted()) continue;
            this.mStreamStates[i].applyAllVolumes();
        }
    }

    private void checkAllFixedVolumeDevices() {
        int n = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < n; ++i) {
            this.mStreamStates[i].checkFixedVolumeDevices();
        }
    }

    private void checkAllFixedVolumeDevices(int n) {
        this.mStreamStates[n].checkFixedVolumeDevices();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int checkForRingerModeChange(int n, int n2, int n3) {
        int n4 = 1;
        int n5 = this.getRingerMode();
        boolean bl = false;
        switch (n5) {
            default: {
                Log.e(TAG, "checkForRingerModeChange() wrong ringer mode: " + n5);
                break;
            }
            case 2: {
                bl = false;
                if (n2 != -1) break;
                if (this.mHasVibrator) {
                    bl = false;
                    if (n3 > n) break;
                    int n6 = n3 * 2;
                    bl = false;
                    if (n >= n6) break;
                    n5 = 1;
                    bl = false;
                    break;
                }
                bl = false;
                if (n >= n3) break;
                int n7 = this.mPrevVolDirection;
                bl = false;
                if (n7 == -1) break;
                bl = false;
                n5 = 0;
                break;
            }
            case 1: {
                if (!this.mHasVibrator) {
                    Log.e(TAG, "checkForRingerModeChange() current ringer mode is vibratebut no vibrator is present");
                    bl = false;
                    break;
                }
                if (n2 == -1) {
                    if (this.mPrevVolDirection != -1) {
                        n5 = 0;
                    }
                } else if (n2 == 1) {
                    n5 = 2;
                }
                n4 &= 0xFFFFFFFE;
                bl = false;
                break;
            }
            case 0: {
                if (n2 == 1) {
                    n5 = this.mHasVibrator ? 1 : 2;
                }
                bl = true;
                n4 &= 0xFFFFFFFE;
            }
        }
        this.setRingerMode(n5, bl);
        this.mPrevVolDirection = n2;
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkSafeMediaVolume(int n, int n2, int n3) {
        Integer n4 = this.mSafeMediaVolumeState;
        synchronized (n4) {
            return this.mSafeMediaVolumeState != 3 || this.mStreamVolumeAlias[n] != 3 || (n3 & 0xC) == 0 || n2 <= this.mSafeMediaVolumeIndex;
            {
            }
        }
    }

    private void checkScoAudioState() {
        if (this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && this.mScoAudioState == 0 && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 10) {
            this.mScoAudioState = 2;
        }
    }

    private int checkSendBecomingNoisyIntent(int n, int n2) {
        int n3 = 0;
        if (n2 == 0) {
            int n4 = n & this.mBecomingNoisyIntentDevices;
            n3 = 0;
            if (n4 != 0) {
                int n5 = 0;
                for (int n6 : this.mConnectedDevices.keySet()) {
                    if ((Integer.MIN_VALUE & n6) != 0 || (n6 & this.mBecomingNoisyIntentDevices) == 0) continue;
                    n5 |= n6;
                }
                n3 = 0;
                if (n5 == n) {
                    AudioService.sendMsg(this.mAudioHandler, 15, 0, 0, 0, null, 0);
                    n3 = 1000;
                }
            }
        }
        if (this.mAudioHandler.hasMessages(101) || this.mAudioHandler.hasMessages(102) || this.mAudioHandler.hasMessages(100)) {
            n3 = 1000;
        }
        return n3;
    }

    private void checkZen(int n) {
        long l;
        long l2;
        int n2 = Settings.Global.getInt(this.mContentResolver, "zen_mode", 0);
        if (n != 0 && n2 != 0) {
            l2 = Binder.clearCallingIdentity();
            Settings.Global.putInt(this.mContentResolver, "zen_mode", 0);
        }
        if (n == 0 && n2 != 2) {
            l = Binder.clearCallingIdentity();
            Settings.Global.putInt(this.mContentResolver, "zen_mode", 2);
        }
        return;
        finally {
            Binder.restoreCallingIdentity(l2);
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    private void configureHdmiPlugIntent(Intent intent, int n) {
        ArrayList<AudioPort> arrayList;
        intent.setAction("android.media.action.HDMI_AUDIO_PLUG");
        intent.putExtra("android.media.extra.AUDIO_PLUG_STATE", n);
        if (n == 1 && AudioSystem.listAudioPorts(arrayList = new ArrayList<AudioPort>(), new int[1]) == 0) {
            for (AudioPort audioPort : arrayList) {
                AudioDevicePort audioDevicePort;
                if (!(audioPort instanceof AudioDevicePort) || (audioDevicePort = (AudioDevicePort)audioPort).type() != 1024) continue;
                int[] nArray = audioDevicePort.formats();
                if (nArray.length > 0) {
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
                    for (int n2 : nArray) {
                        if (n2 == 0) continue;
                        arrayList2.add(n2);
                    }
                    int[] nArray2 = new int[arrayList2.size()];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = (Integer)arrayList2.get(i);
                    }
                    intent.putExtra("android.media.extra.ENCODINGS", nArray2);
                }
                int n3 = 0;
                int[] nArray3 = audioDevicePort.channelMasks();
                int n4 = nArray3.length;
                for (int i = 0; i < n4; ++i) {
                    int n5 = AudioFormat.channelCountFromOutChannelMask(nArray3[i]);
                    if (n5 <= n3) continue;
                    n3 = n5;
                }
                intent.putExtra("android.media.extra.MAX_CHANNEL_COUNT", n3);
            }
        }
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    private void createStreamStates() {
        int n = AudioSystem.getNumStreamTypes();
        VolumeStreamState[] volumeStreamStateArray = new VolumeStreamState[n];
        this.mStreamStates = volumeStreamStateArray;
        for (int i = 0; i < n; ++i) {
            volumeStreamStateArray[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS[this.mStreamVolumeAlias[i]], i);
        }
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
    }

    private boolean discardRmtSbmxFullVolDeathHandlerFor(IBinder iBinder) {
        for (RmtSbmxFullVolDeathHandler rmtSbmxFullVolDeathHandler : this.mRmtSbmxFullVolDeathHandlers) {
            if (!rmtSbmxFullVolDeathHandler.isHandlerFor(iBinder)) continue;
            rmtSbmxFullVolDeathHandler.forget();
            this.mRmtSbmxFullVolDeathHandlers.remove(rmtSbmxFullVolDeathHandler);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void disconnectBluetoothSco(int n) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            block9: {
                block8: {
                    this.checkScoAudioState();
                    if (this.mScoAudioState != 2 && this.mScoAudioState != 4) break block8;
                    if (this.mBluetoothHeadsetDevice != null) {
                        if (this.mBluetoothHeadset != null) {
                            if (!this.mBluetoothHeadset.stopVoiceRecognition(this.mBluetoothHeadsetDevice)) {
                                AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, 0);
                            }
                            break block9;
                        } else if (this.mScoAudioState == 2 && this.getBluetoothHeadset()) {
                            this.mScoAudioState = 4;
                        }
                    }
                    break block9;
                }
                this.clearAllScoClients(n, true);
            }
            return;
        }
    }

    private void doSetMasterVolume(float f, int n) {
        if (!AudioSystem.getMasterMute()) {
            int n2 = this.getMasterVolume();
            AudioSystem.setMasterVolume(f);
            int n3 = this.getMasterVolume();
            if (n3 != n2) {
                AudioService.sendMsg(this.mAudioHandler, 2, 0, Math.round(1000.0f * f), 0, null, 500);
            }
            this.sendMasterVolumeUpdate(n, n2, n3);
        }
    }

    private void dumpRingerMode(PrintWriter printWriter) {
        printWriter.println("\nRinger mode: ");
        printWriter.println("- mode: " + RINGER_MODE_NAMES[this.mRingerMode]);
        printWriter.print("- ringer mode affected streams = 0x");
        printWriter.println(Integer.toHexString(this.mRingerModeAffectedStreams));
        printWriter.print("- ringer mode muted streams = 0x");
        printWriter.println(Integer.toHexString(this.mRingerModeMutedStreams));
    }

    private void dumpStreamStates(PrintWriter printWriter) {
        printWriter.println("\nStream volumes (device: index)");
        int n = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < n; ++i) {
            printWriter.println("- " + STREAM_NAMES[i] + ":");
            this.mStreamStates[i].dump(printWriter);
            printWriter.println("");
        }
        printWriter.print("\n- mute affected streams = 0x");
        printWriter.println(Integer.toHexString(this.mMuteAffectedStreams));
    }

    private void enforceSafeMediaVolume() {
        VolumeStreamState volumeStreamState = this.mStreamStates[3];
        int n = 12;
        int n2 = 0;
        while (n != 0) {
            int n3 = n2 + 1;
            int n4 = 1 << n2;
            if ((n4 & n) == 0) {
                n2 = n3;
                continue;
            }
            if (volumeStreamState.getIndex(n4) > this.mSafeMediaVolumeIndex) {
                volumeStreamState.setIndex(this.mSafeMediaVolumeIndex, n4);
                AudioService.sendMsg(this.mAudioHandler, 0, 2, n4, 0, volumeStreamState, 0);
            }
            n &= ~n4;
            n2 = n3;
        }
    }

    private void enforceSelfOrSystemUI(String string2) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "Only SystemUI can " + string2);
    }

    private void ensureValidDirection(int n) {
        if (n < -1 || n > 1) {
            throw new IllegalArgumentException("Bad direction " + n);
        }
    }

    private void ensureValidRingerMode(int n) {
        if (!AudioManager.isValidRingerMode(n)) {
            throw new IllegalArgumentException("Bad ringer mode " + n);
        }
    }

    private void ensureValidSteps(int n) {
        if (Math.abs(n) > 4) {
            throw new IllegalArgumentException("Bad volume adjust steps " + n);
        }
    }

    private void ensureValidStreamType(int n) {
        if (n < 0 || n >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int findVolumeDelta(int n, int n2) {
        int n3;
        if (n == 1) {
            if (n2 == 100) {
                return 0;
            }
            n3 = this.mMasterVolumeRamp[1];
            int n4 = -1 + this.mMasterVolumeRamp.length;
            while (n4 > 1) {
                if (n2 >= this.mMasterVolumeRamp[n4 - 1]) {
                    return this.mMasterVolumeRamp[n4];
                }
                n4 -= 2;
            }
            return n3;
        }
        n3 = 0;
        if (n != -1) return n3;
        if (n2 == 0) return 0;
        int n5 = this.mMasterVolumeRamp.length;
        n3 = -this.mMasterVolumeRamp[n5 - 1];
        int n6 = 2;
        while (n6 < n5) {
            if (n2 <= this.mMasterVolumeRamp[n6]) {
                return -this.mMasterVolumeRamp[n6 - 1];
            }
            n6 += 2;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getActiveStreamType(int n) {
        block14: {
            block13: {
                switch (this.mPlatformType) {
                    default: {
                        if (this.isInCommunication()) {
                            if (AudioSystem.getForceUse(0) != 3) break;
                            if (!DEBUG_VOL) return 6;
                            Log.v(TAG, "getActiveStreamType: Forcing STREAM_BLUETOOTH_SCO");
                            return 6;
                        }
                        break block13;
                    }
                    case 1: {
                        if (this.isInCommunication()) {
                            if (AudioSystem.getForceUse(0) != 3) return 0;
                            return 6;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (this.isAfMusicActiveRecently(StreamOverride.sDelayMs)) {
                                if (!DEBUG_VOL) return 3;
                                Log.v(TAG, "getActiveStreamType: Forcing STREAM_MUSIC stream active");
                                return 3;
                            }
                            if (!DEBUG_VOL) return 2;
                            Log.v(TAG, "getActiveStreamType: Forcing STREAM_RING b/c default");
                            return 2;
                        }
                        if (this.isAfMusicActiveRecently(0)) {
                            if (!DEBUG_VOL) return 3;
                            Log.v(TAG, "getActiveStreamType: Forcing STREAM_MUSIC stream active");
                            return 3;
                        }
                        break block14;
                    }
                    case 2: {
                        if (n == Integer.MIN_VALUE) {
                            return 3;
                        }
                        break block14;
                    }
                }
                if (!DEBUG_VOL) return 0;
                Log.v(TAG, "getActiveStreamType: Forcing STREAM_VOICE_CALL");
                return 0;
            }
            if (AudioSystem.isStreamActive(5, StreamOverride.sDelayMs) || AudioSystem.isStreamActive(2, StreamOverride.sDelayMs)) {
                if (!DEBUG_VOL) return 5;
                Log.v(TAG, "getActiveStreamType: Forcing STREAM_NOTIFICATION");
                return 5;
            }
            if (n == Integer.MIN_VALUE) {
                if (this.isAfMusicActiveRecently(StreamOverride.sDelayMs)) {
                    if (!DEBUG_VOL) return 3;
                    Log.v(TAG, "getActiveStreamType: forcing STREAM_MUSIC");
                    return 3;
                }
                if (!DEBUG_VOL) return 5;
                Log.v(TAG, "getActiveStreamType: using STREAM_NOTIFICATION as default");
                return 5;
            }
        }
        if (!DEBUG_VOL) return n;
        Log.v(TAG, "getActiveStreamType: Returning suggested type " + n);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean getBluetoothHeadset() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        boolean bl = false;
        if (bluetoothAdapter != null) {
            bl = bluetoothAdapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        AudioHandler audioHandler = this.mAudioHandler;
        int n = bl ? 3000 : 0;
        AudioService.sendMsg(audioHandler, 9, 0, 0, 0, null, n);
        return bl;
    }

    private int getDeviceForStream(int n) {
        int n2;
        block7: {
            block6: {
                n2 = AudioSystem.getDevicesForStream(n);
                if ((n2 & n2 - 1) == 0) break block6;
                if ((n2 & 2) == 0) break block7;
                n2 = 2;
            }
            return n2;
        }
        if ((0x40000 & n2) != 0) {
            return 262144;
        }
        if ((0x80000 & n2) != 0) {
            return 524288;
        }
        if ((0x200000 & n2) != 0) {
            return 0x200000;
        }
        return n2 & 0x380;
    }

    protected static int getMaxStreamVolume(int n) {
        return MAX_STREAM_VOLUME[n];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ScoClient getScoClient(IBinder iBinder, boolean bl) {
        void var4_9;
        ScoClient scoClient;
        ArrayList<ScoClient> arrayList = this.mScoClients;
        // MONITORENTER : arrayList
        int n = this.mScoClients.size();
        ScoClient scoClient2 = null;
        for (int i = 0; i < n; ++i) {
            ScoClient scoClient3 = this.mScoClients.get(i);
            if (scoClient3.getBinder() == iBinder) {
                // MONITOREXIT : arrayList
                return scoClient3;
            }
            scoClient2 = scoClient3;
            continue;
        }
        if (!bl) {
            return scoClient2;
        }
        try {
            scoClient = new ScoClient(iBinder);
        }
        catch (Throwable throwable) {
            throw var4_9;
        }
        try {
            this.mScoClients.add(scoClient);
            // MONITOREXIT : arrayList
            return scoClient;
        }
        catch (Throwable throwable) {
            throw var4_9;
        }
    }

    public static int getValueForVibrateSetting(int n, int n2, int n3) {
        return n & (0xFFFFFFFF ^ 3 << n2 * 2) | (n3 & 3) << n2 * 2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleConfigurationChanged(Context context) {
        Boolean bl;
        boolean bl2;
        Configuration configuration;
        try {
            int n;
            configuration = context.getResources().getConfiguration();
            if (this.mMonitorOrientation && (n = configuration.orientation) != this.mDeviceOrientation) {
                this.mDeviceOrientation = n;
                this.setOrientationForAudioSystem();
            }
            AudioService.sendMsg(this.mAudioHandler, 16, 0, 0, 0, null, 0);
            bl2 = this.mContext.getResources().getBoolean(17956964);
            Object object = this.mSettingsLock;
            synchronized (object) {
                bl = this.mCameraSoundForced;
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "Error handling configuration change: ", exception);
            return;
        }
        {
            synchronized (bl) {
                if (bl2 != this.mCameraSoundForced) {
                    this.mCameraSoundForced = bl2;
                    if (!this.isPlatformTelevision()) {
                        VolumeStreamState volumeStreamState = this.mStreamStates[7];
                        if (bl2) {
                            volumeStreamState.setAllIndexesToMax();
                            this.mRingerModeAffectedStreams = 0xFFFFFF7F & this.mRingerModeAffectedStreams;
                        } else {
                            volumeStreamState.setAllIndexes(this.mStreamStates[1]);
                            this.mRingerModeAffectedStreams = 0x80 | this.mRingerModeAffectedStreams;
                        }
                        this.setRingerModeInt(this.getRingerMode(), false);
                    }
                    AudioHandler audioHandler = this.mAudioHandler;
                    int n = bl2 ? 11 : 0;
                    AudioService.sendMsg(audioHandler, 8, 2, 4, n, null, 0);
                    AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[7], 0);
                }
            }
        }
        {
            this.mVolumeController.setLayoutDirection(configuration.getLayoutDirection());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDeviceConnection(boolean bl, int n, String string2) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean bl2 = this.mConnectedDevices.containsKey(n) && (string2.isEmpty() || this.mConnectedDevices.get(n).equals(string2));
            if (bl2 && !bl) {
                AudioSystem.setDeviceConnectionState(n, 0, this.mConnectedDevices.get(n));
                this.mConnectedDevices.remove(n);
                return true;
            }
            if (!bl2 && bl) {
                AudioSystem.setDeviceConnectionState(n, 1, string2);
                this.mConnectedDevices.put(new Integer(n), string2);
                return true;
            }
            return false;
        }
    }

    private boolean hasRmtSbmxFullVolDeathHandlerFor(IBinder iBinder) {
        Iterator<RmtSbmxFullVolDeathHandler> iterator = this.mRmtSbmxFullVolDeathHandlers.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isHandlerFor(iBinder)) continue;
            return true;
        }
        return false;
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(6);
    }

    private boolean isAfMusicActiveRecently(int n) {
        return AudioSystem.isStreamActive(3, n) || AudioSystem.isStreamActiveRemotely(3, n);
    }

    private boolean isInCommunication() {
        return ((TelecomManager)this.mContext.getSystemService("telecom")).isInCall() || this.getMode() == 3;
    }

    private boolean isPlatformTelevision() {
        return this.mPlatformType == 2;
    }

    private boolean isPlatformVoice() {
        return this.mPlatformType == 1;
    }

    private boolean isStreamMutedByRingerMode(int n) {
        return (this.mRingerModeMutedStreams & 1 << n) != 0;
    }

    private void loadTouchSoundAssetDefaults() {
        SOUND_EFFECT_FILES.add("Effect_Tick.ogg");
        for (int i = 0; i < 10; ++i) {
            this.SOUND_EFFECT_FILES_MAP[i][0] = 0;
            this.SOUND_EFFECT_FILES_MAP[i][1] = -1;
        }
    }

    /*
     * Exception decompiling
     */
    private void loadTouchSoundAssets() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [38, 39, 40, 41 : 266->296)] android.content.res.Resources$NotFoundException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void makeA2dpDeviceAvailable(String string2) {
        VolumeStreamState volumeStreamState = this.mStreamStates[3];
        AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, volumeStreamState, 0);
        this.setBluetoothA2dpOnInt(true);
        AudioSystem.setDeviceConnectionState(128, 1, string2);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(new Integer(128), string2);
    }

    private void makeA2dpDeviceUnavailableLater(String string2) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(128);
        Message message = this.mAudioHandler.obtainMessage(6, string2);
        this.mAudioHandler.sendMessageDelayed(message, 8000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeA2dpDeviceUnavailableNow(String string2) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = false;
        }
        AudioSystem.setDeviceConnectionState(128, 0, string2);
        this.mConnectedDevices.remove(128);
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (this.mCurAudioRoutes.mBluetoothName != null) {
                this.mCurAudioRoutes.mBluetoothName = null;
                AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
            }
            return;
        }
    }

    private void makeA2dpSrcAvailable(String string2) {
        AudioSystem.setDeviceConnectionState(-2147352576, 1, string2);
        this.mConnectedDevices.put(new Integer(-2147352576), string2);
    }

    private void makeA2dpSrcUnavailable(String string2) {
        AudioSystem.setDeviceConnectionState(-2147352576, 0, string2);
        this.mConnectedDevices.remove(-2147352576);
    }

    private void onBroadcastScoConnectionState(int n) {
        if (n != this.mScoConnectionState) {
            Intent intent = new Intent("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            intent.putExtra("android.media.extra.SCO_AUDIO_STATE", n);
            intent.putExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", this.mScoConnectionState);
            this.sendStickyBroadcastToAll(intent);
            this.mScoConnectionState = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onCheckMusicActive() {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int n2;
            if (this.mSafeMediaVolumeState == 2 && ((n2 = this.getDeviceForStream(3)) & 0xC) != 0) {
                AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                int n3 = this.mStreamStates[3].getIndex(n2);
                if (AudioSystem.isStreamActive(3, 0) && n3 > this.mSafeMediaVolumeIndex) {
                    this.mMusicActiveMs = 60000 + this.mMusicActiveMs;
                    if (this.mMusicActiveMs > 72000000) {
                        this.setSafeMediaVolumeEnabled(true);
                        this.mMusicActiveMs = 0;
                    }
                    this.saveMusicActiveMs();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onConfigureSafeVolume(boolean bl) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            block14: {
                int n2;
                boolean bl2;
                int n3;
                block16: {
                    block15: {
                        n3 = this.mContext.getResources().getConfiguration().mcc;
                        if (this.mMcc == n3 && (this.mMcc != 0 || !bl)) break block14;
                        this.mSafeMediaVolumeIndex = 10 * this.mContext.getResources().getInteger(17694832);
                        if (SystemProperties.getBoolean("audio.safemedia.force", false)) break block15;
                        boolean bl3 = this.mContext.getResources().getBoolean(17956962);
                        bl2 = false;
                        if (!bl3) break block16;
                    }
                    bl2 = true;
                }
                if (bl2) {
                    n2 = 3;
                    if (this.mSafeMediaVolumeState != 2) {
                        if (this.mMusicActiveMs == 0) {
                            this.mSafeMediaVolumeState = 3;
                            this.enforceSafeMediaVolume();
                        } else {
                            this.mSafeMediaVolumeState = 2;
                        }
                    }
                } else {
                    n2 = 1;
                    this.mSafeMediaVolumeState = 1;
                }
                this.mMcc = n3;
                AudioService.sendMsg(this.mAudioHandler, 18, 2, n2, 0, null, 0);
            }
            return;
        }
    }

    private void onSendBecomingNoisyIntent() {
        this.sendBroadcastToAll(new Intent("android.media.AUDIO_BECOMING_NOISY"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSetA2dpSinkConnectionState(BluetoothDevice bluetoothDevice, int n) {
        boolean bl = true;
        if (DEBUG_VOL) {
            Log.d(TAG, "onSetA2dpSinkConnectionState btDevice=" + bluetoothDevice + "state=" + n);
        }
        if (bluetoothDevice == null) {
            return;
        }
        String string2 = bluetoothDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            string2 = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            if (!this.mConnectedDevices.containsKey(128) || !this.mConnectedDevices.get(128).equals(string2)) {
                bl = false;
            }
            if (bl && n != 2) {
                if (bluetoothDevice.isBluetoothDock()) {
                    if (n == 0) {
                        this.makeA2dpDeviceUnavailableLater(string2);
                    }
                } else {
                    this.makeA2dpDeviceUnavailableNow(string2);
                }
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    if (this.mCurAudioRoutes.mBluetoothName != null) {
                        this.mCurAudioRoutes.mBluetoothName = null;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            } else if (!bl && n == 2) {
                if (bluetoothDevice.isBluetoothDock()) {
                    this.cancelA2dpDeviceTimeout();
                    this.mDockAddress = string2;
                } else if (this.hasScheduledA2dpDockTimeout()) {
                    this.cancelA2dpDeviceTimeout();
                    this.makeA2dpDeviceUnavailableNow(this.mDockAddress);
                }
                this.makeA2dpDeviceAvailable(string2);
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    String string3 = bluetoothDevice.getAliasName();
                    if (!TextUtils.equals(this.mCurAudioRoutes.mBluetoothName, string3)) {
                        this.mCurAudioRoutes.mBluetoothName = string3;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSetA2dpSourceConnectionState(BluetoothDevice bluetoothDevice, int n) {
        if (DEBUG_VOL) {
            Log.d(TAG, "onSetA2dpSourceConnectionState btDevice=" + bluetoothDevice + " state=" + n);
        }
        if (bluetoothDevice == null) {
            return;
        }
        String string2 = bluetoothDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            string2 = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean bl = this.mConnectedDevices.containsKey(-2147352576) && this.mConnectedDevices.get(-2147352576).equals(string2);
            if (bl && n != 2) {
                this.makeA2dpSrcUnavailable(string2);
            } else if (!bl && n == 2) {
                this.makeA2dpSrcAvailable(string2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSetStreamVolume(int n, int n2, int n3, int n4) {
        block3: {
            int n5;
            block5: {
                block4: {
                    this.setStreamVolumeInt(this.mStreamVolumeAlias[n], n2, n4, false);
                    if ((n3 & 2) == 0 && this.mStreamVolumeAlias[n] != this.getMasterStreamType()) break block3;
                    if (n2 != 0) break block4;
                    int n6 = this.getRingerMode();
                    if (n6 == 2) {
                        boolean bl = this.mHasVibrator;
                        n5 = 0;
                        if (bl) {
                            n5 = 1;
                        }
                        break block5;
                    } else {
                        n5 = n6;
                    }
                    break block5;
                }
                n5 = 2;
            }
            this.setRingerMode(n5, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSetWiredDeviceConnectionState(int n, int n2, String string2) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean bl;
            block21: {
                block20: {
                    if (n2 == 0 && (n == 4 || n == 8 || n == 131072)) {
                        this.setBluetoothA2dpOnInt(true);
                    }
                    bl = (n & 0xFFFF9FFF) == 0 || (Integer.MIN_VALUE & n) != 0 && (0x7FFFE7FF & n) == 0;
                    boolean bl2 = false;
                    if (n2 == 1) {
                        bl2 = true;
                    }
                    String string3 = bl ? string2 : "";
                    this.handleDeviceConnection(bl2, n, string3);
                    if (n2 == 0) break block20;
                    if (n == 4 || n == 8 || n == 131072) {
                        this.setBluetoothA2dpOnInt(false);
                    }
                    if ((n & 0xC) != 0) {
                        AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                    }
                    if (this.isPlatformTelevision() && (n & 0x400) != 0) {
                        this.mFixedVolumeDevices = 0x400 | this.mFixedVolumeDevices;
                        this.checkAllFixedVolumeDevices();
                        if (this.mHdmiManager != null) {
                            HdmiControlManager hdmiControlManager = this.mHdmiManager;
                            synchronized (hdmiControlManager) {
                                if (this.mHdmiPlaybackClient != null) {
                                    this.mHdmiCecSink = false;
                                    this.mHdmiPlaybackClient.queryDisplayStatus(this.mHdmiDisplayStatusCallback);
                                }
                            }
                        }
                    }
                    break block21;
                }
                if (this.isPlatformTelevision() && (n & 0x400) != 0 && this.mHdmiManager != null) {
                    HdmiControlManager hdmiControlManager = this.mHdmiManager;
                    synchronized (hdmiControlManager) {
                        this.mHdmiCecSink = false;
                    }
                }
            }
            if (!bl && n != -2147483632) {
                this.sendDeviceConnectionIntent(n, n2, string2);
            }
            return;
        }
    }

    private void queueMsgUnderWakeLock(Handler handler, int n, int n2, int n3, Object object, int n4) {
        long l = Binder.clearCallingIdentity();
        this.mAudioEventWakeLock.acquire();
        Binder.restoreCallingIdentity(l);
        AudioService.sendMsg(handler, n, 2, n2, n3, object, n4);
    }

    private static void readAndSetLowRamDevice() {
        int n = AudioSystem.setLowRamDevice(ActivityManager.isLowRamDeviceStatic());
        if (n != 0) {
            Log.w(TAG, "AudioFlinger informed of device's low RAM attribute; status " + n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAudioSettings(boolean bl) {
        this.readPersistedSettings();
        int n = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < n; ++i) {
            VolumeStreamState volumeStreamState = this.mStreamStates[i];
            if (bl && this.mStreamVolumeAlias[i] == 3) continue;
            synchronized (volumeStreamState) {
                volumeStreamState.readSettings();
                if (volumeStreamState.isMuted() && (!this.isStreamAffectedByMute(i) && !this.isStreamMutedByRingerMode(i) || this.mUseFixedVolume)) {
                    int n2 = volumeStreamState.mDeathHandlers.size();
                    for (int j = 0; j < n2; ++j) {
                        VolumeStreamState.VolumeDeathHandler.access$2302((VolumeStreamState.VolumeDeathHandler)volumeStreamState.mDeathHandlers.get(j), 1);
                        ((VolumeStreamState.VolumeDeathHandler)volumeStreamState.mDeathHandlers.get(j)).mute(false);
                    }
                }
                continue;
            }
        }
        this.setRingerModeInt(this.getRingerMode(), false);
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
        Integer n3 = this.mSafeMediaVolumeState;
        synchronized (n3) {
            this.mMusicActiveMs = MathUtils.constrain(Settings.Secure.getIntForUser(this.mContentResolver, "unsafe_volume_music_active_ms", 0, -2), 0, 72000000);
            if (this.mSafeMediaVolumeState == 3) {
                this.enforceSafeMediaVolume();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readDockAudioSettings(ContentResolver contentResolver) {
        int n = 1;
        if (Settings.Global.getInt(contentResolver, "dock_audio_media_enabled", 0) != n) {
            n = 0;
        }
        this.mDockAudioMediaEnabled = n;
        this.mBecomingNoisyIntentDevices = this.mDockAudioMediaEnabled ? 0x800 | this.mBecomingNoisyIntentDevices : 0xFFFFF7FF & this.mBecomingNoisyIntentDevices;
        AudioHandler audioHandler = this.mAudioHandler;
        int n2 = this.mDockAudioMediaEnabled ? 8 : 0;
        AudioService.sendMsg(audioHandler, 8, 2, 3, n2, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPersistedSettings() {
        ContentResolver contentResolver = this.mContentResolver;
        int n = 2;
        int n2 = Settings.Global.getInt(contentResolver, "mode_ringer", n);
        int n3 = n2;
        if (!AudioManager.isValidRingerMode(n3)) {
            n3 = 2;
        }
        if (n3 == 1 && !this.mHasVibrator) {
            n3 = 0;
        }
        if (n3 != n2) {
            Settings.Global.putInt(contentResolver, "mode_ringer", n3);
        }
        if (this.mUseFixedVolume || this.isPlatformTelevision()) {
            n3 = 2;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = n3;
            int n4 = this.mHasVibrator ? n : 0;
            int n5 = this.mVibrateSetting = AudioService.getValueForVibrateSetting(0, 1, n4);
            if (!this.mHasVibrator) {
                n = 0;
            }
            this.mVibrateSetting = AudioService.getValueForVibrateSetting(n5, 0, n);
            this.updateRingerModeAffectedStreams();
            this.readDockAudioSettings(contentResolver);
        }
        this.mMuteAffectedStreams = Settings.System.getIntForUser(contentResolver, "mute_streams_affected", 14, -2);
        boolean bl = Settings.System.getIntForUser(contentResolver, "volume_master_mute", 0, -2) == 1;
        if (this.mUseFixedVolume) {
            bl = false;
            AudioSystem.setMasterVolume(1.0f);
        }
        AudioSystem.setMasterMute(bl);
        this.broadcastMasterMuteStatus(bl);
        boolean bl2 = Settings.System.getIntForUser(contentResolver, "microphone_mute", 0, -2) == 1;
        AudioSystem.muteMicrophone(bl2);
        this.broadcastRingerMode(n3);
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
        this.mVolumeController.loadSettings(contentResolver);
    }

    private int rescaleIndex(int n, int n2, int n3) {
        return (n * this.mStreamStates[n3].getMaxIndex() + this.mStreamStates[n2].getMaxIndex() / 2) / this.mStreamStates[n2].getMaxIndex();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetBluetoothSco() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.clearAllScoClients(0, false);
            this.mScoAudioState = 0;
            this.broadcastScoConnectionState(0);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void restoreMasterVolume() {
        if (this.mUseFixedVolume) {
            AudioSystem.setMasterVolume(1.0f);
            return;
        } else {
            float f;
            if (!this.mUseMasterVolume || !((f = Settings.System.getFloatForUser(this.mContentResolver, "volume_master", -1.0f, -2)) >= 0.0f)) return;
            AudioSystem.setMasterVolume(f);
            return;
        }
    }

    private static String safeMediaVolumeStateToString(Integer n) {
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return "SAFE_MEDIA_VOLUME_NOT_CONFIGURED";
            }
            case 1: {
                return "SAFE_MEDIA_VOLUME_DISABLED";
            }
            case 2: {
                return "SAFE_MEDIA_VOLUME_INACTIVE";
            }
            case 3: 
        }
        return "SAFE_MEDIA_VOLUME_ACTIVE";
    }

    private void saveMusicActiveMs() {
        this.mAudioHandler.obtainMessage(22, this.mMusicActiveMs, 0).sendToTarget();
    }

    private void sendBroadcastToAll(Intent intent) {
        long l = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            return;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendDeviceConnectionIntent(int n, int n2, String string2) {
        int n3;
        Intent intent = new Intent();
        intent.putExtra("state", n2);
        intent.putExtra(ATTR_GROUP_NAME, string2);
        intent.addFlags(0x40000000);
        if (n == 4) {
            n3 = 1;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 1);
        } else if (n == 8 || n == 131072) {
            n3 = 2;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 0);
        } else if (n == 2048) {
            n3 = 4;
            intent.setAction("android.media.action.ANALOG_AUDIO_DOCK_PLUG");
        } else if (n == 4096) {
            n3 = 4;
            intent.setAction("android.media.action.DIGITAL_AUDIO_DOCK_PLUG");
        } else {
            n3 = 0;
            if (n == 1024) {
                n3 = 8;
                this.configureHdmiPlugIntent(intent, n2);
            }
        }
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (n3 != 0) {
                int n4 = this.mCurAudioRoutes.mMainType;
                int n5 = n2 != 0 ? n4 | n3 : n4 & ~n3;
                if (n5 != this.mCurAudioRoutes.mMainType) {
                    this.mCurAudioRoutes.mMainType = n5;
                    AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                }
            }
        }
        long l = Binder.clearCallingIdentity();
        try {
            ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
            return;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    private void sendMasterMuteUpdate(boolean bl, int n) {
        this.mVolumeController.postMasterMuteChanged(n);
        this.broadcastMasterMuteStatus(bl);
    }

    private void sendMasterVolumeUpdate(int n, int n2, int n3) {
        this.mVolumeController.postMasterVolumeChanged(n);
        Intent intent = new Intent("android.media.MASTER_VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_PREV_MASTER_VOLUME_VALUE", n2);
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_VALUE", n3);
        this.sendBroadcastToAll(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, Object object, int n5) {
        if (n2 == 0) {
            handler.removeMessages(n);
        } else if (n2 == 1 && handler.hasMessages(n)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(n, n3, n4, object), n5);
    }

    private void sendStickyBroadcastToAll(Intent intent) {
        long l = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            return;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendVolumeUpdate(int n, int n2, int n3, int n4) {
        if (!this.isPlatformVoice() && n == 2) {
            n = 5;
        }
        if (this.mHdmiTvClient != null && n == 3) {
            HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
            synchronized (hdmiTvClient) {
                if (this.mHdmiSystemAudioSupported && (n4 & 0x100) == 0) {
                    n4 &= 0xFFFFFFFE;
                }
            }
        }
        this.mVolumeController.postVolumeChanged(n, n4);
        if ((n4 & 0x20) == 0) {
            int n5 = (n2 + 5) / 10;
            int n6 = (n3 + 5) / 10;
            Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", n);
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", n6);
            intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", n5);
            this.sendBroadcastToAll(intent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int setModeInt(int n, IBinder iBinder, int n2) {
        int n3;
        SetModeDeathHandler setModeDeathHandler;
        block18: {
            SetModeDeathHandler setModeDeathHandler2;
            if (DEBUG_MODE) {
                Log.v(TAG, "setModeInt(mode=" + n + ", pid=" + n2 + ")");
            }
            if (iBinder == null) {
                Log.e(TAG, "setModeInt() called with null binder");
                return 0;
            }
            Iterator<SetModeDeathHandler> iterator = this.mSetModeDeathHandlers.iterator();
            do {
                boolean bl = iterator.hasNext();
                setModeDeathHandler = null;
                if (!bl) break block18;
            } while ((setModeDeathHandler2 = iterator.next()).getPid() != n2);
            setModeDeathHandler = setModeDeathHandler2;
            iterator.remove();
            setModeDeathHandler.getBinder().unlinkToDeath(setModeDeathHandler, 0);
        }
        do {
            int n4;
            block20: {
                block19: {
                    if (n != 0) break block19;
                    if (!this.mSetModeDeathHandlers.isEmpty()) {
                        setModeDeathHandler = this.mSetModeDeathHandlers.get(0);
                        iBinder = setModeDeathHandler.getBinder();
                        n = setModeDeathHandler.getMode();
                        if (DEBUG_MODE) {
                            Log.w(TAG, " using mode=" + n + " instead due to death hdlr at pid=" + setModeDeathHandler.mPid);
                        }
                    }
                    break block20;
                }
                if (setModeDeathHandler == null) {
                    setModeDeathHandler = new SetModeDeathHandler(iBinder, n2);
                }
                try {
                    iBinder.linkToDeath(setModeDeathHandler, 0);
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "setMode() could not link to " + iBinder + " binder death");
                }
                this.mSetModeDeathHandlers.add(0, setModeDeathHandler);
                setModeDeathHandler.setMode(n);
            }
            if (n != (n4 = this.mMode)) {
                n3 = AudioSystem.setPhoneState(n);
                if (n3 == 0) {
                    if (DEBUG_MODE) {
                        Log.v(TAG, " mode successfully set to " + n);
                    }
                    this.mMode = n;
                    continue;
                }
                if (setModeDeathHandler != null) {
                    this.mSetModeDeathHandlers.remove(setModeDeathHandler);
                    iBinder.unlinkToDeath(setModeDeathHandler, 0);
                }
                if (DEBUG_MODE) {
                    Log.w(TAG, " mode set to MODE_NORMAL after phoneState pb");
                }
                n = 0;
                continue;
            }
            n3 = 0;
        } while (n3 != 0 && !this.mSetModeDeathHandlers.isEmpty());
        int n5 = 0;
        if (n3 == 0) {
            n5 = 0;
            if (n != 0) {
                if (this.mSetModeDeathHandlers.isEmpty()) {
                    Log.e(TAG, "setMode() different from MODE_NORMAL with empty mode client stack");
                } else {
                    n5 = this.mSetModeDeathHandlers.get(0).getPid();
                }
            }
            int n6 = this.getActiveStreamType(Integer.MIN_VALUE);
            int n7 = this.getDeviceForStream(n6);
            int n8 = this.mStreamStates[this.mStreamVolumeAlias[n6]].getIndex(n7);
            this.setStreamVolumeInt(this.mStreamVolumeAlias[n6], n8, n7, true);
            this.updateStreamVolumeAlias(true);
        }
        return n5;
    }

    private void setOrientationForAudioSystem() {
        switch (this.mDeviceOrientation) {
            default: {
                Log.e(TAG, "Unknown orientation");
                return;
            }
            case 2: {
                AudioSystem.setParameters("orientation=landscape");
                return;
            }
            case 1: {
                AudioSystem.setParameters("orientation=portrait");
                return;
            }
            case 3: {
                AudioSystem.setParameters("orientation=square");
                return;
            }
            case 0: 
        }
        AudioSystem.setParameters("orientation=undefined");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setRingerModeInt(int n, boolean bl) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = n;
        }
        for (int i = -1 + AudioSystem.getNumStreamTypes(); i >= 0; --i) {
            if (this.isStreamMutedByRingerMode(i)) {
                if (this.isStreamAffectedByRingerMode(i) && n != 2) continue;
                if (this.isPlatformVoice() && this.mStreamVolumeAlias[i] == 2) {
                    VolumeStreamState volumeStreamState = this.mStreamStates[i];
                    synchronized (volumeStreamState) {
                        for (Map.Entry entry : this.mStreamStates[i].mIndex.entrySet()) {
                            if ((Integer)entry.getValue() != 0) continue;
                            entry.setValue(10);
                        }
                    }
                }
                this.mStreamStates[i].mute(null, false);
                this.mRingerModeMutedStreams &= 0xFFFFFFFF ^ 1 << i;
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(i) || n == 2) continue;
            this.mStreamStates[i].mute(null, true);
            this.mRingerModeMutedStreams |= 1 << i;
        }
        if (bl) {
            AudioService.sendMsg(this.mAudioHandler, 3, 0, 0, 0, null, 500);
        }
    }

    private void setRotationForAudioSystem() {
        switch (this.mDeviceRotation) {
            default: {
                Log.e(TAG, "Unknown device rotation");
                return;
            }
            case 0: {
                AudioSystem.setParameters("rotation=0");
                return;
            }
            case 1: {
                AudioSystem.setParameters("rotation=90");
                return;
            }
            case 2: {
                AudioSystem.setParameters("rotation=180");
                return;
            }
            case 3: 
        }
        AudioSystem.setParameters("rotation=270");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSafeMediaVolumeEnabled(boolean bl) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            if (this.mSafeMediaVolumeState != 0 && this.mSafeMediaVolumeState != 1) {
                if (bl && this.mSafeMediaVolumeState == 2) {
                    this.mSafeMediaVolumeState = 3;
                    this.enforceSafeMediaVolume();
                } else if (!bl && this.mSafeMediaVolumeState == 3) {
                    this.mSafeMediaVolumeState = 2;
                    this.mMusicActiveMs = 1;
                    this.saveMusicActiveMs();
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setStreamVolume(int n, int n2, int n3, String string2, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        VolumeStreamState volumeStreamState;
        int n9;
        block28: {
            block27: {
                if (this.mUseFixedVolume) break block27;
                this.ensureValidStreamType(n);
                n9 = this.mStreamVolumeAlias[n];
                volumeStreamState = this.mStreamStates[n9];
                n8 = this.getDeviceForStream(n);
                if (((n8 & 0x380) != 0 || (n3 & 0x40) == 0) && this.mAppOps.noteOp(STEAM_VOLUME_OPS[n9], n4, string2) == 0) break block28;
            }
            return;
        }
        Integer n10 = this.mSafeMediaVolumeState;
        synchronized (n10) {
            this.mPendingVolumeCommand = null;
            n7 = volumeStreamState.getIndex(n8);
            n6 = this.rescaleIndex(n2 * 10, n, n9);
            if (n9 == 3 && (n8 & 0x380) != 0 && (n3 & 0x40) == 0) {
                Object object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.setAvrcpAbsoluteVolume(n6 / 10);
                    }
                }
            }
            if (this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    if (this.mHdmiTvClient != null && n9 == 3 && (n3 & 0x100) == 0 && n7 != n6) {
                        int n11 = this.getStreamMaxVolume(n);
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioVolume((n7 + 5) / 10, (n6 + 5) / 10, n11);
                            }
                        }
                    }
                }
            }
            n5 = n3 & 0xFFFFFFDF;
            if (n9 == 3 && (n8 & this.mFixedVolumeDevices) != 0) {
                n5 |= 0x20;
                if (n6 != 0) {
                    n6 = this.mSafeMediaVolumeState == 3 && (n8 & 0xC) != 0 ? this.mSafeMediaVolumeIndex : volumeStreamState.getMaxIndex();
                }
            }
            if (!this.checkSafeMediaVolume(n9, n6, n8)) {
                this.mVolumeController.postDisplaySafeVolumeWarning(n5);
                this.mPendingVolumeCommand = new StreamVolumeCommand(n, n6, n5, n8);
            } else {
                int n12;
                this.onSetStreamVolume(n, n6, n5, n8);
                n6 = n12 = this.mStreamStates[n].getIndex(n8);
            }
        }
        this.sendVolumeUpdate(n, n7, n6, n5);
    }

    private void setStreamVolumeInt(int n, int n2, int n3, boolean bl) {
        VolumeStreamState volumeStreamState = this.mStreamStates[n];
        if (volumeStreamState.setIndex(n2, n3) || bl) {
            AudioService.sendMsg(this.mAudioHandler, 0, 2, n3, 0, volumeStreamState, 0);
        }
    }

    public static String streamToString(int n) {
        if (n >= 0 && n < STREAM_NAMES.length) {
            return STREAM_NAMES[n];
        }
        if (n == Integer.MIN_VALUE) {
            return "USE_DEFAULT_STREAM_TYPE";
        }
        return "UNKNOWN_STREAM_" + n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateStreamVolumeAlias(boolean bl) {
        int n;
        switch (this.mPlatformType) {
            default: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_DEFAULT;
                n = 3;
                break;
            }
            case 1: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_VOICE;
                n = 2;
                break;
            }
            case 2: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_TELEVISION;
                n = 3;
            }
        }
        if (this.isPlatformTelevision()) {
            this.mRingerModeAffectedStreams = 0;
        } else if (this.isInCommunication()) {
            this.mRingerModeAffectedStreams = 0xFFFFFEFF & this.mRingerModeAffectedStreams;
            n = 0;
        } else {
            this.mRingerModeAffectedStreams = 0x100 | this.mRingerModeAffectedStreams;
        }
        this.mStreamVolumeAlias[8] = n;
        if (bl) {
            this.mStreamStates[8].setAllIndexes(this.mStreamStates[n]);
            this.setRingerModeInt(this.getRingerMode(), false);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[8], 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForAudioHandlerCreation() {
        synchronized (this) {
            AudioHandler audioHandler;
            while ((audioHandler = this.mAudioHandler) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                    continue;
                }
                break;
            }
            return;
        }
    }

    @Override
    public int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        return this.mMediaFocusControl.abandonAudioFocus(iAudioFocusDispatcher, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void adjustMasterVolume(int n, int n2, String string2) {
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidSteps(n);
        int n3 = Math.round(100.0f * AudioSystem.getMasterVolume());
        int n4 = Math.abs(n);
        int n5 = n > 0 ? 1 : -1;
        int n6 = 0;
        while (true) {
            if (n6 >= n4) {
                this.setMasterVolume(n3, n2, string2);
                return;
            }
            n3 += this.findVolumeDelta(n5, n3);
            ++n6;
        }
    }

    @Override
    public void adjustStreamVolume(int n, int n2, int n3, String string2) {
        this.adjustStreamVolume(n, n2, n3, string2, Binder.getCallingUid());
    }

    @Override
    public void adjustSuggestedStreamVolume(int n, int n2, int n3, String string2) {
        this.adjustSuggestedStreamVolume(n, n2, n3, string2, Binder.getCallingUid());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void avrcpSupportsAbsoluteVolume(String string2, boolean bl) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = bl;
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[3], 0);
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[2], 0);
            return;
        }
    }

    boolean checkAudioSettingsPermission(String string2) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        Log.w(TAG, "Audio Settings Permission Denial: " + string2 + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearAllScoClients(int n, boolean bl) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient scoClient = null;
            int n2 = this.mScoClients.size();
            int n3 = 0;
            while (true) {
                block6: {
                    ScoClient scoClient2;
                    block5: {
                        block4: {
                            if (n3 >= n2) break block4;
                            scoClient2 = this.mScoClients.get(n3);
                            if (scoClient2.getPid() == n) break block5;
                            scoClient2.clearCount(bl);
                            break block6;
                        }
                        this.mScoClients.clear();
                        if (scoClient != null) {
                            this.mScoClients.add(scoClient);
                        }
                        return;
                    }
                    scoClient = scoClient2;
                }
                ++n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disableSafeMediaVolume() {
        this.enforceSelfOrSystemUI("disable the safe media volume");
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.setSafeMediaVolumeEnabled(false);
            if (this.mPendingVolumeCommand != null) {
                this.onSetStreamVolume(this.mPendingVolumeCommand.mStreamType, this.mPendingVolumeCommand.mIndex, this.mPendingVolumeCommand.mFlags, this.mPendingVolumeCommand.mDevice);
                this.mPendingVolumeCommand = null;
            }
            return;
        }
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        this.mMediaFocusControl.dump(printWriter);
        this.dumpStreamStates(printWriter);
        this.dumpRingerMode(printWriter);
        printWriter.println("\nAudio routes:");
        printWriter.print("  mMainType=0x");
        printWriter.println(Integer.toHexString(this.mCurAudioRoutes.mMainType));
        printWriter.print("  mBluetoothName=");
        printWriter.println(this.mCurAudioRoutes.mBluetoothName);
        printWriter.println("\nOther state:");
        printWriter.print("  mVolumeController=");
        printWriter.println(this.mVolumeController);
        printWriter.print("  mSafeMediaVolumeState=");
        printWriter.println(AudioService.safeMediaVolumeStateToString(this.mSafeMediaVolumeState));
        printWriter.print("  mSafeMediaVolumeIndex=");
        printWriter.println(this.mSafeMediaVolumeIndex);
        printWriter.print("  mPendingVolumeCommand=");
        printWriter.println(this.mPendingVolumeCommand);
        printWriter.print("  mMusicActiveMs=");
        printWriter.println(this.mMusicActiveMs);
        printWriter.print("  mMcc=");
        printWriter.println(this.mMcc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void forceRemoteSubmixFullVolume(boolean bl, IBinder iBinder) {
        if (iBinder == null) {
            return;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.CAPTURE_AUDIO_OUTPUT") != 0) {
            Log.w(TAG, "Trying to call forceRemoteSubmixFullVolume() without CAPTURE_AUDIO_OUTPUT");
            return;
        }
        ArrayList<RmtSbmxFullVolDeathHandler> arrayList = this.mRmtSbmxFullVolDeathHandlers;
        synchronized (arrayList) {
            boolean bl2;
            if (bl) {
                boolean bl3 = this.hasRmtSbmxFullVolDeathHandlerFor(iBinder);
                bl2 = false;
                if (!bl3) {
                    this.mRmtSbmxFullVolDeathHandlers.add(new RmtSbmxFullVolDeathHandler(iBinder));
                    int n = this.mRmtSbmxFullVolRefCount;
                    bl2 = false;
                    if (n == 0) {
                        this.mFullVolumeDevices = 0x8000 | this.mFullVolumeDevices;
                        this.mFixedVolumeDevices = 0x8000 | this.mFixedVolumeDevices;
                        bl2 = true;
                    }
                    this.mRmtSbmxFullVolRefCount = 1 + this.mRmtSbmxFullVolRefCount;
                }
            } else {
                boolean bl4 = this.discardRmtSbmxFullVolDeathHandlerFor(iBinder);
                bl2 = false;
                if (bl4) {
                    int n = this.mRmtSbmxFullVolRefCount;
                    bl2 = false;
                    if (n > 0) {
                        int n2 = this.mRmtSbmxFullVolRefCount = -1 + this.mRmtSbmxFullVolRefCount;
                        bl2 = false;
                        if (n2 == 0) {
                            this.mFullVolumeDevices = 0xFFFF7FFF & this.mFullVolumeDevices;
                            this.mFixedVolumeDevices = 0xFFFF7FFF & this.mFixedVolumeDevices;
                            bl2 = true;
                        }
                    }
                }
            }
            if (bl2) {
                this.checkAllFixedVolumeDevices(3);
                this.mStreamStates[3].applyAllVolumes();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void forceVolumeControlStream(int n, IBinder iBinder) {
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            this.mVolumeControlStream = n;
            if (this.mVolumeControlStream == -1) {
                if (this.mForceControlStreamClient != null) {
                    this.mForceControlStreamClient.release();
                    this.mForceControlStreamClient = null;
                }
            } else {
                this.mForceControlStreamClient = new ForceControlStreamClient(iBinder);
            }
            return;
        }
    }

    @Override
    public int getCurrentAudioFocus() {
        return this.mMediaFocusControl.getCurrentAudioFocus();
    }

    @Override
    public int getLastAudibleMasterVolume() {
        return Math.round(100.0f * AudioSystem.getMasterVolume());
    }

    @Override
    public int getLastAudibleStreamVolume(int n) {
        this.ensureValidStreamType(n);
        int n2 = this.getDeviceForStream(n);
        return (5 + this.mStreamStates[n].getIndex(n2)) / 10;
    }

    @Override
    public int getMasterMaxVolume() {
        return 100;
    }

    @Override
    public int getMasterStreamType() {
        return this.mStreamVolumeAlias[1];
    }

    @Override
    public int getMasterVolume() {
        if (this.isMasterMute()) {
            return 0;
        }
        return this.getLastAudibleMasterVolume();
    }

    @Override
    public int getMode() {
        return this.mMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRingerMode() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerMode;
        }
    }

    @Override
    public IRingtonePlayer getRingtonePlayer() {
        return this.mRingtonePlayer;
    }

    @Override
    public int getStreamMaxVolume(int n) {
        this.ensureValidStreamType(n);
        return (5 + this.mStreamStates[n].getMaxIndex()) / 10;
    }

    @Override
    public int getStreamVolume(int n) {
        this.ensureValidStreamType(n);
        int n2 = this.getDeviceForStream(n);
        int n3 = this.mStreamStates[n].getIndex(n2);
        if (this.mStreamStates[n].isMuted()) {
            n3 = 0;
        }
        if (n3 != 0 && this.mStreamVolumeAlias[n] == 3 && (n2 & this.mFixedVolumeDevices) != 0) {
            n3 = this.mStreamStates[n].getMaxIndex();
        }
        return (n3 + 5) / 10;
    }

    @Override
    public int getVibrateSetting(int n) {
        if (!this.mHasVibrator) {
            return 0;
        }
        return 3 & this.mVibrateSetting >> n * 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isBluetoothA2dpOn() {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            return this.mBluetoothA2dpEnabled;
        }
    }

    @Override
    public boolean isBluetoothScoOn() {
        return this.mForcedUseForComm == 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCameraSoundForced() {
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            return this.mCameraSoundForced;
        }
    }

    @Override
    public boolean isHdmiSystemAudioSupported() {
        return this.mHdmiSystemAudioSupported;
    }

    @Override
    public boolean isMasterMute() {
        return AudioSystem.getMasterMute();
    }

    @Override
    public boolean isSpeakerphoneOn() {
        return this.mForcedUseForComm == 1;
    }

    public boolean isStreamAffectedByMute(int n) {
        return (this.mMuteAffectedStreams & 1 << n) != 0;
    }

    @Override
    public boolean isStreamAffectedByRingerMode(int n) {
        return (this.mRingerModeAffectedStreams & 1 << n) != 0;
    }

    @Override
    public boolean isStreamMute(int n) {
        return this.mStreamStates[n].isMuted();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadSoundEffects() {
        LoadSoundEffectReply loadSoundEffectReply = new LoadSoundEffectReply();
        synchronized (loadSoundEffectReply) {
            Throwable throwable2;
            AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, loadSoundEffectReply, 0);
            int n = 3;
            while (true) {
                int n2;
                block11: {
                    block10: {
                        try {
                            int n3 = loadSoundEffectReply.mStatus;
                            if (n3 != 1) break block10;
                            n2 = n - 1;
                            if (n > 0) break block11;
                        }
                        catch (Throwable throwable2) {
                            break;
                        }
                    }
                    return loadSoundEffectReply.mStatus == 0;
                }
                try {
                    loadSoundEffectReply.wait(5000L);
                    n = n2;
                }
                catch (InterruptedException interruptedException) {
                    Log.w(TAG, "loadSoundEffects Interrupted while waiting sound pool loaded.");
                    n = n2;
                }
            }
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyVolumeControllerVisible(IVolumeController iVolumeController, boolean bl) {
        block3: {
            block2: {
                this.enforceSelfOrSystemUI("notify about volume controller visibility");
                if (!this.mVolumeController.isSameBinder(iVolumeController)) break block2;
                this.mVolumeController.setVisible(bl);
                if (DEBUG_VOL) break block3;
            }
            return;
        }
        Log.d(TAG, "Volume controller visible: " + bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSystemReady() {
        this.mSystemReady = true;
        AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, null, 0);
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mScoConnectionState = -1;
        this.resetBluetoothSco();
        this.getBluetoothHeadset();
        Intent intent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
        intent.putExtra("android.media.extra.SCO_AUDIO_STATE", 0);
        this.sendStickyBroadcastToAll(intent);
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null) {
            bluetoothAdapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 2);
        }
        this.mHdmiManager = (HdmiControlManager)this.mContext.getSystemService("hdmi_control");
        if (this.mHdmiManager != null) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager;
            synchronized (hdmiControlManager) {
                this.mHdmiTvClient = this.mHdmiManager.getTvClient();
                if (this.mHdmiTvClient != null) {
                    this.mFixedVolumeDevices = 0xFFD3FFFD & this.mFixedVolumeDevices;
                }
                this.mHdmiPlaybackClient = this.mHdmiManager.getPlaybackClient();
                this.mHdmiCecSink = false;
            }
        }
        AudioService.sendMsg(this.mAudioHandler, 17, 0, 0, 0, null, 30000);
        StreamOverride.init(this.mContext);
    }

    @Override
    public void playSoundEffect(int n) {
        this.playSoundEffectVolume(n, -1.0f);
    }

    @Override
    public void playSoundEffectVolume(int n, float f) {
        if (n >= 10 || n < 0) {
            Log.w(TAG, "AudioService effectType value " + n + " out of range");
            return;
        }
        AudioService.sendMsg(this.mAudioHandler, 5, 2, n, (int)(1000.0f * f), null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean registerAudioPolicy(AudioPolicyConfig audioPolicyConfig, IBinder iBinder) {
        boolean bl = this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING") == 0;
        if (!bl) {
            Slog.w(TAG, "Can't register audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", need MODIFY_AUDIO_ROUTING");
            return false;
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy audioPolicyProxy = new AudioPolicyProxy(audioPolicyConfig, iBinder);
            try {
                iBinder.linkToDeath(audioPolicyProxy, 0);
                this.mAudioPolicies.put(iBinder, audioPolicyProxy);
                return true;
            }
            catch (RemoteException remoteException) {
                Slog.w(TAG, "Audio policy registration failed, could not link to " + iBinder + " binder death", remoteException);
                return false;
            }
        }
    }

    @Override
    public boolean registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        return this.mMediaFocusControl.registerRemoteControlDisplay(iRemoteControlDisplay, n, n2);
    }

    @Override
    public boolean registerRemoteController(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2, ComponentName componentName) {
        return this.mMediaFocusControl.registerRemoteController(iRemoteControlDisplay, n, n2, componentName);
    }

    @Override
    public void reloadAudioSettings() {
        this.readAudioSettings(false);
    }

    @Override
    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        this.mMediaFocusControl.remoteControlDisplayUsesBitmapSize(iRemoteControlDisplay, n, n2);
    }

    @Override
    public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        this.mMediaFocusControl.remoteControlDisplayWantsPlaybackPositionSync(iRemoteControlDisplay, bl);
    }

    @Override
    public int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2, String string3) {
        return this.mMediaFocusControl.requestAudioFocus(n, n2, iBinder, iAudioFocusDispatcher, string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice bluetoothDevice, int n, int n2) {
        if (n2 != 2 && n2 != 10) {
            throw new IllegalArgumentException("invalid profile " + n2);
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            int n3;
            if (n2 == 2) {
                int n4 = 0;
                if (n == 2) {
                    n4 = 1;
                }
                n3 = this.checkSendBecomingNoisyIntent(128, n4);
            } else {
                n3 = 0;
            }
            AudioHandler audioHandler = this.mAudioHandler;
            int n5 = n2 == 2 ? 102 : 101;
            this.queueMsgUnderWakeLock(audioHandler, n5, n, 0, bluetoothDevice, n3);
            return n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setBluetoothA2dpOn(boolean bl) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = bl;
            AudioHandler audioHandler = this.mAudioHandler;
            boolean bl2 = this.mBluetoothA2dpEnabled;
            int n = 0;
            if (!bl2) {
                n = 10;
            }
            AudioService.sendMsg(audioHandler, 13, 2, 1, n, null, 0);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBluetoothA2dpOnInt(boolean bl) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = bl;
            this.mAudioHandler.removeMessages(13);
            int n = this.mBluetoothA2dpEnabled ? 0 : 10;
            AudioSystem.setForceUse(1, n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setBluetoothScoOn(boolean bl) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (bl) {
            this.mForcedUseForComm = 3;
        } else if (this.mForcedUseForComm == 3) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, this.mForcedUseForComm, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setHdmiSystemAudioSupported(boolean bl) {
        HdmiControlManager hdmiControlManager = this.mHdmiManager;
        int n = 0;
        if (hdmiControlManager == null) return n;
        HdmiControlManager hdmiControlManager2 = this.mHdmiManager;
        synchronized (hdmiControlManager2) {
            if (this.mHdmiTvClient == null) {
                Log.w(TAG, "Only Hdmi-Cec enabled TV device supports system audio mode.");
                return 0;
            }
            HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
            synchronized (hdmiTvClient) {
                if (this.mHdmiSystemAudioSupported == bl) return AudioSystem.getDevicesForStream(3);
                this.mHdmiSystemAudioSupported = bl;
                int n2 = bl ? 12 : 0;
                AudioSystem.setForceUse(5, n2);
                return AudioSystem.getDevicesForStream(3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setMasterMute(boolean bl, int n, String string2, IBinder iBinder) {
        if (this.mUseFixedVolume || this.mAppOps.noteOp(33, Binder.getCallingUid(), string2) != 0 || bl == AudioSystem.getMasterMute()) {
            return;
        }
        AudioSystem.setMasterMute(bl);
        AudioHandler audioHandler = this.mAudioHandler;
        int n2 = bl ? 1 : 0;
        AudioService.sendMsg(audioHandler, 11, 0, n2, UserHandle.getCallingUserId(), null, 500);
        this.sendMasterMuteUpdate(bl, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setMasterVolume(int n, int n2, String string2) {
        if (this.mUseFixedVolume || this.mAppOps.noteOp(33, Binder.getCallingUid(), string2) != 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.doSetMasterVolume((float)n / 100.0f, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setMicrophoneMute(boolean bl, String string2) {
        if (this.mAppOps.noteOp(45, Binder.getCallingUid(), string2) != 0 || !this.checkAudioSettingsPermission("setMicrophoneMute()")) {
            return;
        }
        AudioSystem.muteMicrophone(bl);
        AudioHandler audioHandler = this.mAudioHandler;
        int n = bl ? 1 : 0;
        AudioService.sendMsg(audioHandler, 23, 0, n, UserHandle.getCallingUserId(), null, 500);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMode(int n, IBinder iBinder) {
        int n2;
        block10: {
            block9: {
                if (DEBUG_MODE) {
                    Log.v(TAG, "setMode(mode=" + n + ")");
                }
                if (!this.checkAudioSettingsPermission("setMode()")) break block9;
                if (n == 2 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
                    Log.w(TAG, "MODIFY_PHONE_STATE Permission Denial: setMode(MODE_IN_CALL) from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                    return;
                }
                if (n < -1 || n >= 4) break block9;
                ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
                synchronized (arrayList) {
                    if (n == -1) {
                        n = this.mMode;
                    }
                    n2 = this.setModeInt(n, iBinder, Binder.getCallingPid());
                    if (n2 != 0) break block10;
                }
            }
            return;
        }
        this.disconnectBluetoothSco(n2);
    }

    @Override
    public void setRemoteStreamVolume(int n) {
        this.enforceSelfOrSystemUI("set the remote stream volume");
        this.mMediaFocusControl.setRemoteStreamVolume(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setRingerMode(int n, boolean bl) {
        block6: {
            block5: {
                if (this.mUseFixedVolume || this.isPlatformTelevision()) break block5;
                if (n == 1 && !this.mHasVibrator) {
                    n = 0;
                }
                if (bl) {
                    this.checkZen(n);
                }
                if (n != this.getRingerMode()) break block6;
            }
            return;
        }
        this.setRingerModeInt(n, true);
        this.broadcastRingerMode(n);
    }

    @Override
    public void setRingtonePlayer(IRingtonePlayer iRingtonePlayer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REMOTE_AUDIO_PLAYBACK", null);
        this.mRingtonePlayer = iRingtonePlayer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSpeakerphoneOn(boolean bl) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (bl) {
            if (this.mForcedUseForComm == 3) {
                AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, 0, null, 0);
            }
            this.mForcedUseForComm = 1;
        } else if (this.mForcedUseForComm == 1) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setStreamMute(int n, boolean bl, IBinder iBinder) {
        if (this.mUseFixedVolume || !this.isStreamAffectedByMute(n)) {
            return;
        }
        if (this.mHdmiManager != null) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager;
            synchronized (hdmiControlManager) {
                if (n == 3 && this.mHdmiTvClient != null) {
                    HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                    synchronized (hdmiTvClient) {
                        if (this.mHdmiSystemAudioSupported) {
                            this.mHdmiTvClient.setSystemAudioMute(bl);
                        }
                    }
                }
            }
        }
        this.mStreamStates[n].mute(iBinder, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setStreamSolo(int n, boolean bl, IBinder iBinder) {
        if (!this.mUseFixedVolume) {
            for (int i = 0; i < this.mStreamStates.length; ++i) {
                if (!this.isStreamAffectedByMute(i) || i == n) continue;
                this.mStreamStates[i].mute(iBinder, bl);
            }
        }
    }

    @Override
    public void setStreamVolume(int n, int n2, int n3, String string2) {
        this.setStreamVolume(n, n2, n3, string2, Binder.getCallingUid());
    }

    @Override
    public void setVibrateSetting(int n, int n2) {
        if (!this.mHasVibrator) {
            return;
        }
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, n, n2);
        this.broadcastVibrateSetting(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setVolumeController(final IVolumeController iVolumeController) {
        block7: {
            block6: {
                this.enforceSelfOrSystemUI("set the volume controller");
                if (this.mVolumeController.isSameBinder(iVolumeController)) break block6;
                this.mVolumeController.postDismiss();
                if (iVolumeController != null) {
                    try {
                        iVolumeController.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                            @Override
                            public void binderDied() {
                                if (AudioService.this.mVolumeController.isSameBinder(iVolumeController)) {
                                    Log.w(AudioService.TAG, "Current remote volume controller died, unregistering");
                                    AudioService.this.setVolumeController(null);
                                }
                            }
                        }, 0);
                    }
                    catch (RemoteException remoteException) {}
                }
                this.mVolumeController.setController(iVolumeController);
                if (DEBUG_VOL) break block7;
            }
            return;
        }
        Log.d(TAG, "Volume controller: " + this.mVolumeController);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setWiredDeviceConnectionState(int n, int n2, String string2) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            int n3 = this.checkSendBecomingNoisyIntent(n, n2);
            this.queueMsgUnderWakeLock(this.mAudioHandler, 100, n, n2, string2, n3);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldVibrate(int n) {
        boolean bl = true;
        if (!this.mHasVibrator) {
            return false;
        }
        switch (this.getVibrateSetting(n)) {
            case 0: {
                return false;
            }
            default: {
                return false;
            }
            case 1: {
                if (this.getRingerMode() == 0) return false;
                return bl;
            }
            case 2: 
        }
        if (this.getRingerMode() != bl) return false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startBluetoothSco(IBinder iBinder, int n) {
        int n2 = n < 18 ? 0 : -1;
        this.startBluetoothScoInt(iBinder, n2);
    }

    void startBluetoothScoInt(IBinder iBinder, int n) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient scoClient = this.getScoClient(iBinder, true);
        long l = Binder.clearCallingIdentity();
        scoClient.incCount(n);
        Binder.restoreCallingIdentity(l);
    }

    @Override
    public void startBluetoothScoVirtualCall(IBinder iBinder) {
        this.startBluetoothScoInt(iBinder, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver iAudioRoutesObserver) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            AudioRoutesInfo audioRoutesInfo2 = new AudioRoutesInfo(this.mCurAudioRoutes);
            this.mRoutesObservers.register(iAudioRoutesObserver);
            return audioRoutesInfo2;
        }
    }

    @Override
    public void stopBluetoothSco(IBinder iBinder) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient scoClient = this.getScoClient(iBinder, false);
        long l = Binder.clearCallingIdentity();
        if (scoClient != null) {
            scoClient.decCount();
        }
        Binder.restoreCallingIdentity(l);
    }

    public void systemReady() {
        AudioService.sendMsg(this.mAudioHandler, 21, 2, 0, 0, null, 0);
    }

    @Override
    public void unloadSoundEffects() {
        AudioService.sendMsg(this.mAudioHandler, 20, 2, 0, 0, null, 0);
    }

    @Override
    public void unregisterAudioFocusClient(String string2) {
        this.mMediaFocusControl.unregisterAudioFocusClient(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterAudioPolicyAsync(IBinder iBinder) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy audioPolicyProxy = this.mAudioPolicies.remove(iBinder);
            if (audioPolicyProxy == null) {
                Slog.w(TAG, "Trying to unregister unknown audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid());
            } else {
                iBinder.unlinkToDeath(audioPolicyProxy, 0);
            }
            return;
        }
    }

    @Override
    public void unregisterRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        this.mMediaFocusControl.unregisterRemoteControlDisplay(iRemoteControlDisplay);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean updateRingerModeAffectedStreams() {
        int n;
        int n2;
        int n3 = 0x26 | Settings.System.getIntForUser(this.mContentResolver, "mode_ringer_streams_affected", 166, -2);
        switch (this.mPlatformType) {
            default: {
                n2 = n3 & 0xFFFFFFF7;
                break;
            }
            case 2: {
                n2 = 0;
            }
        }
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            n = this.mCameraSoundForced != false ? n2 & 0xFFFFFF7F : n2 | 0x80;
        }
        int n4 = this.mStreamVolumeAlias[8] == 2 ? n | 0x100 : n & 0xFFFFFEFF;
        if (n4 != this.mRingerModeAffectedStreams) {
            Settings.System.putIntForUser(this.mContentResolver, "mode_ringer_streams_affected", n4, -2);
            this.mRingerModeAffectedStreams = n4;
            return true;
        }
        return false;
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanupPlayer(MediaPlayer mediaPlayer) {
            if (mediaPlayer == null) return;
            try {
                mediaPlayer.stop();
                mediaPlayer.release();
                return;
            }
            catch (IllegalStateException illegalStateException) {
                Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + illegalStateException);
                return;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean onLoadSoundEffects() {
            var1_1 = AudioService.access$1800(AudioService.this);
            synchronized (var1_1) {
                block32: {
                    block30: {
                        if (!AudioService.access$5200(AudioService.this)) {
                            Log.w("AudioService", "onLoadSoundEffects() called before boot complete");
                            return false;
                        }
                        if (AudioService.access$1900(AudioService.this) != null) {
                            return true;
                        }
                        AudioService.access$5300(AudioService.this);
                        AudioService.access$1902(AudioService.this, new SoundPool.Builder().setMaxStreams(4).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setContentType(4).build()).build());
                        AudioService.access$2002(AudioService.this, null);
                        AudioService.access$5402(AudioService.this, new SoundPoolListenerThread());
                        AudioService.access$5400(AudioService.this).start();
                        var6_2 = 3;
                        while ((var7_5 = AudioService.access$2000(AudioService.this)) == null) {
                            var32_3 = var6_2 - 1;
                            if (var6_2 <= 0) break;
                            try {
                                AudioService.access$1800(AudioService.this).wait(5000L);
                                var6_2 = var32_3;
                            }
                            catch (InterruptedException var33_4) {
                                Log.w("AudioService", "Interrupted while waiting sound pool listener thread.");
                                var6_2 = var32_3;
                            }
                        }
                        if (AudioService.access$2000(AudioService.this) == null) {
                            Log.w("AudioService", "onLoadSoundEffects() SoundPool listener or thread creation error");
                            if (AudioService.access$1700(AudioService.this) != null) {
                                AudioService.access$1700(AudioService.this).quit();
                                AudioService.access$1702(AudioService.this, null);
                            }
                            AudioService.access$5402(AudioService.this, null);
                            AudioService.access$1900(AudioService.this).release();
                            AudioService.access$1902(AudioService.this, null);
                            return false;
                        }
                        var9_6 = new int[AudioService.access$5500().size()];
                        for (var10_7 = 0; var10_7 < AudioService.access$5500().size(); ++var10_7) {
                            var9_6[var10_7] = -1;
                        }
                        var11_8 = 0;
                        var12_9 = 0;
                        while (true) {
                            block29: {
                                block31: {
                                    if (var11_8 >= 10) break block31;
                                    if (AudioService.access$5600(AudioService.this)[var11_8][1] != 0) {
                                        if (var9_6[AudioService.access$5600(AudioService.this)[var11_8][0]] == -1) {
                                            var13_10 = Environment.getRootDirectory() + "/media/audio/ui/" + (String)AudioService.access$5500().get(AudioService.access$5600(AudioService.this)[var11_8][0]);
                                            var14_11 = AudioService.access$1900(AudioService.this).load(var13_10, 0);
                                            if (var14_11 <= 0) {
                                                Log.w("AudioService", "Soundpool could not load file: " + var13_10);
                                                break block29;
                                            } else {
                                                AudioService.access$5600((AudioService)AudioService.this)[var11_8][1] = var14_11;
                                                var9_6[AudioService.access$5600((AudioService)AudioService.this)[var11_8][0]] = var14_11;
                                                ++var12_9;
                                            }
                                            break block29;
                                        } else {
                                            AudioService.access$5600((AudioService)AudioService.this)[var11_8][1] = var9_6[AudioService.access$5600(AudioService.this)[var11_8][0]];
                                        }
                                    }
                                    break block29;
                                }
                                if (var12_9 <= 0) break;
                                AudioService.access$2000(AudioService.this).setSamples(var9_6);
                                var16_12 = 1;
                                var17_13 = 3;
                                break block30;
                            }
                            ++var11_8;
                        }
                        var16_12 = -1;
                        break block32;
                    }
                    while (var16_12 == 1) {
                        var24_14 = var17_13 - 1;
                        if (var17_13 <= 0) break;
                        try {
                            AudioService.access$1800(AudioService.this).wait(5000L);
                            var16_12 = var27_16 = AudioService.access$2000(AudioService.this).status();
                            var17_13 = var24_14;
                        }
                        catch (InterruptedException var25_15) {
                            Log.w("AudioService", "Interrupted while waiting sound pool callback.");
                            var17_13 = var24_14;
                        }
                    }
                }
                if (AudioService.access$1700(AudioService.this) != null) {
                    AudioService.access$1700(AudioService.this).quit();
                    AudioService.access$1702(AudioService.this, null);
                }
                AudioService.access$5402(AudioService.this, null);
                if (var16_12 == 0) ** GOTO lbl109
                Log.w("AudioService", "onLoadSoundEffects(), Error " + var16_12 + " while loading samples");
                var21_17 = 0;
                while (true) {
                    if (var21_17 < 10) {
                        if (AudioService.access$5600(AudioService.this)[var21_17][1] > 0) {
                            AudioService.access$5600((AudioService)AudioService.this)[var21_17][1] = -1;
                        }
                    } else {
                        AudioService.access$1900(AudioService.this).release();
                        AudioService.access$1902(AudioService.this, null);
lbl109:
                        // 2 sources

                        return var16_12 == 0;
                    }
                    ++var21_17;
                }
            }
        }

        private void onPersistSafeVolumeState(int n) {
            Settings.Global.putInt(AudioService.this.mContentResolver, "audio_safe_volume_state", n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void onPlaySoundEffect(int n, int n2) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                this.onLoadSoundEffects();
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                float f = n2 < 0 ? (float)Math.pow(10.0, (float)sSoundEffectVolumeDb / 20.0f) : (float)n2 / 1000.0f;
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[n][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[n][1], f, f, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    try {
                        mediaPlayer.setDataSource(Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[n][0]));
                        mediaPlayer.setAudioStreamType(1);
                        mediaPlayer.prepare();
                        mediaPlayer.setVolume(f);
                        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                            @Override
                            public void onCompletion(MediaPlayer mediaPlayer) {
                                AudioHandler.this.cleanupPlayer(mediaPlayer);
                            }
                        });
                        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                            @Override
                            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                                AudioHandler.this.cleanupPlayer(mediaPlayer);
                                return true;
                            }
                        });
                        mediaPlayer.start();
                    }
                    catch (IOException iOException) {
                        Log.w(AudioService.TAG, "MediaPlayer IOException: " + iOException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + illegalArgumentException);
                    }
                    catch (IllegalStateException illegalStateException) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + illegalStateException);
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void onUnloadSoundEffects() {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                int[] nArray = new int[SOUND_EFFECT_FILES.size()];
                for (int i = 0; i < SOUND_EFFECT_FILES.size(); ++i) {
                    nArray[i] = 0;
                }
                int n = 0;
                while (true) {
                    if (n >= 10) {
                        AudioService.this.mSoundPool.release();
                        AudioService.access$1902(AudioService.this, null);
                        return;
                    }
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[n][1] > 0 && nArray[AudioService.this.SOUND_EFFECT_FILES_MAP[n][0]] == 0) {
                        AudioService.this.mSoundPool.unload(AudioService.this.SOUND_EFFECT_FILES_MAP[n][1]);
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[n][1] = -1;
                        nArray[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[n][0]] = -1;
                    }
                    ++n;
                }
            }
        }

        private void persistRingerMode(int n) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            Settings.Global.putInt(AudioService.this.mContentResolver, "mode_ringer", n);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void persistVolume(VolumeStreamState volumeStreamState, int n) {
            if (AudioService.this.mUseFixedVolume || AudioService.this.isPlatformTelevision() && volumeStreamState.mStreamType != 3) {
                return;
            }
            Settings.System.putIntForUser(AudioService.this.mContentResolver, volumeStreamState.getSettingNameForDevice(n), (5 + volumeStreamState.getIndex(n)) / 10, -2);
        }

        private void setAllVolumes(VolumeStreamState volumeStreamState) {
            volumeStreamState.applyAllVolumes();
            for (int i = -1 + AudioSystem.getNumStreamTypes(); i >= 0; --i) {
                if (i == volumeStreamState.mStreamType || AudioService.this.mStreamVolumeAlias[i] != volumeStreamState.mStreamType) continue;
                AudioService.this.mStreamStates[i].applyAllVolumes();
            }
        }

        private void setDeviceVolume(VolumeStreamState volumeStreamState, int n) {
            volumeStreamState.applyDeviceVolume(n);
            for (int i = -1 + AudioSystem.getNumStreamTypes(); i >= 0; --i) {
                if (i == volumeStreamState.mStreamType || AudioService.this.mStreamVolumeAlias[i] != volumeStreamState.mStreamType) continue;
                int n2 = AudioService.this.getDeviceForStream(i);
                if (n != n2 && AudioService.this.mAvrcpAbsVolSupported && (n & 0x380) != 0) {
                    AudioService.this.mStreamStates[i].applyDeviceVolume(n);
                }
                AudioService.this.mStreamStates[i].applyDeviceVolume(n2);
            }
            AudioService.sendMsg(AudioService.this.mAudioHandler, 1, 2, n, 0, volumeStreamState, 500);
        }

        private void setForceUse(int n, int n2) {
            AudioSystem.setForceUse(n, n2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 0: {
                    this.setDeviceVolume((VolumeStreamState)message.obj, message.arg1);
                    return;
                }
                case 10: {
                    this.setAllVolumes((VolumeStreamState)message.obj);
                    return;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)message.obj, message.arg1);
                    return;
                }
                case 2: {
                    if (AudioService.this.mUseFixedVolume) return;
                    Settings.System.putFloatForUser(AudioService.this.mContentResolver, "volume_master", (float)message.arg1 / 1000.0f, -2);
                    return;
                }
                case 11: {
                    if (AudioService.this.mUseFixedVolume) return;
                    Settings.System.putIntForUser(AudioService.this.mContentResolver, "volume_master_mute", message.arg1, message.arg2);
                    return;
                }
                case 3: {
                    this.persistRingerMode(AudioService.this.getRingerMode());
                    return;
                }
                case 4: {
                    if (!AudioService.this.mSystemReady || AudioSystem.checkAudioFlinger() != 0) {
                        Log.e(AudioService.TAG, "Media server died.");
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 500);
                        return;
                    }
                    Log.e(AudioService.TAG, "Media server started.");
                    AudioSystem.setParameters("restarting=true");
                    AudioService.readAndSetLowRamDevice();
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    // MONITORENTER : hashMap
                    for (Map.Entry entry : AudioService.this.mConnectedDevices.entrySet()) {
                        AudioSystem.setDeviceConnectionState((Integer)entry.getKey(), 1, (String)entry.getValue());
                    }
                    // MONITOREXIT : hashMap
                    AudioSystem.setPhoneState(AudioService.this.mMode);
                    AudioSystem.setForceUse(0, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(2, AudioService.this.mForcedUseForComm);
                    int n = AudioService.this.mCameraSoundForced != false ? 11 : 0;
                    AudioSystem.setForceUse(4, n);
                    for (int i = -1 + AudioSystem.getNumStreamTypes(); i >= 0; --i) {
                        VolumeStreamState volumeStreamState = AudioService.this.mStreamStates[i];
                        int n2 = (5 + volumeStreamState.mIndexMax) / 10;
                        AudioSystem.initStreamVolume(i, 0, n2);
                        volumeStreamState.applyAllVolumes();
                    }
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                    AudioService.this.restoreMasterVolume();
                    if (AudioService.this.mMonitorOrientation) {
                        AudioService.this.setOrientationForAudioSystem();
                    }
                    if (AudioService.this.mMonitorRotation) {
                        AudioService.this.setRotationForAudioSystem();
                    }
                    Object object = AudioService.this.mBluetoothA2dpEnabledLock;
                    // MONITORENTER : object
                    int n3 = AudioService.this.mBluetoothA2dpEnabled ? 0 : 10;
                    AudioSystem.setForceUse(1, n3);
                    // MONITOREXIT : object
                    Object object2 = AudioService.this.mSettingsLock;
                    // MONITORENTER : object2
                    int n4 = AudioService.this.mDockAudioMediaEnabled ? 8 : 0;
                    AudioSystem.setForceUse(3, n4);
                    // MONITOREXIT : object2
                    if (AudioService.this.mHdmiManager != null) {
                        HdmiControlManager hdmiControlManager = AudioService.this.mHdmiManager;
                        // MONITORENTER : hdmiControlManager
                        if (AudioService.this.mHdmiTvClient != null) {
                            AudioService.this.setHdmiSystemAudioSupported(AudioService.this.mHdmiSystemAudioSupported);
                        }
                        // MONITOREXIT : hdmiControlManager
                    }
                    AudioSystem.setParameters("restarting=false");
                    return;
                }
                case 20: {
                    this.onUnloadSoundEffects();
                    return;
                }
                case 7: {
                    boolean bl = this.onLoadSoundEffects();
                    if (message.obj == null) return;
                    LoadSoundEffectReply loadSoundEffectReply = (LoadSoundEffectReply)message.obj;
                    // MONITORENTER : loadSoundEffectReply
                    int n = bl ? 0 : -1;
                    loadSoundEffectReply.mStatus = n;
                    loadSoundEffectReply.notify();
                    // MONITOREXIT : loadSoundEffectReply
                    return;
                }
                case 5: {
                    this.onPlaySoundEffect(message.arg1, message.arg2);
                    return;
                }
                case 6: {
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    // MONITORENTER : hashMap
                    AudioService.this.makeA2dpDeviceUnavailableNow((String)message.obj);
                    // MONITOREXIT : hashMap
                    return;
                }
                case 8: 
                case 13: {
                    this.setForceUse(message.arg1, message.arg2);
                    return;
                }
                case 9: {
                    AudioService.this.resetBluetoothSco();
                    return;
                }
                case 100: {
                    AudioService.this.onSetWiredDeviceConnectionState(message.arg1, message.arg2, (String)message.obj);
                    AudioService.this.mAudioEventWakeLock.release();
                    return;
                }
                case 101: {
                    AudioService.this.onSetA2dpSourceConnectionState((BluetoothDevice)message.obj, message.arg1);
                    AudioService.this.mAudioEventWakeLock.release();
                    return;
                }
                case 102: {
                    AudioService.this.onSetA2dpSinkConnectionState((BluetoothDevice)message.obj, message.arg1);
                    AudioService.this.mAudioEventWakeLock.release();
                    return;
                }
                case 12: {
                    int n = AudioService.this.mRoutesObservers.beginBroadcast();
                    if (n > 0) {
                        AudioRoutesInfo audioRoutesInfo = AudioService.this.mCurAudioRoutes;
                        // MONITORENTER : audioRoutesInfo
                        AudioRoutesInfo audioRoutesInfo2 = new AudioRoutesInfo(AudioService.this.mCurAudioRoutes);
                        // MONITOREXIT : audioRoutesInfo
                        while (n > 0) {
                            IAudioRoutesObserver iAudioRoutesObserver = AudioService.this.mRoutesObservers.getBroadcastItem(--n);
                            try {
                                iAudioRoutesObserver.dispatchAudioRoutesChanged(audioRoutesInfo2);
                            }
                            catch (RemoteException remoteException) {}
                        }
                    }
                    AudioService.this.mRoutesObservers.finishBroadcast();
                    return;
                }
                case 14: {
                    AudioService.this.onCheckMusicActive();
                    return;
                }
                case 15: {
                    AudioService.this.onSendBecomingNoisyIntent();
                    return;
                }
                case 16: 
                case 17: {
                    AudioService audioService = AudioService.this;
                    boolean bl = message.what == 17;
                    audioService.onConfigureSafeVolume(bl);
                    return;
                }
                case 18: {
                    this.onPersistSafeVolumeState(message.arg1);
                    return;
                }
                case 19: {
                    AudioService.this.onBroadcastScoConnectionState(message.arg1);
                    return;
                }
                case 21: {
                    AudioService.this.onSystemReady();
                    return;
                }
                case 22: {
                    int n = message.arg1;
                    Settings.Secure.putIntForUser(AudioService.this.mContentResolver, "unsafe_volume_music_active_ms", n, -2);
                    return;
                }
                case 23: 
            }
            Settings.System.putIntForUser(AudioService.this.mContentResolver, "microphone_mute", message.arg1, message.arg2);
        }
    }

    private class AudioOrientationEventListener
    extends OrientationEventListener {
        public AudioOrientationEventListener(Context context) {
            super(context);
        }

        @Override
        public void onOrientationChanged(int n) {
            int n2 = ((WindowManager)AudioService.this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
            if (n2 != AudioService.this.mDeviceRotation) {
                AudioService.access$702(AudioService.this, n2);
                AudioService.this.setRotationForAudioSystem();
            }
        }
    }

    public class AudioPolicyProxy
    implements IBinder.DeathRecipient {
        private static final String TAG = "AudioPolicyProxy";
        AudioPolicyConfig mConfig;
        IBinder mToken;

        AudioPolicyProxy(AudioPolicyConfig audioPolicyConfig, IBinder iBinder) {
            this.mConfig = audioPolicyConfig;
            this.mToken = iBinder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            HashMap hashMap = AudioService.this.mAudioPolicies;
            synchronized (hashMap) {
                Log.v(TAG, "audio policy " + this.mToken + " died");
                AudioService.this.mAudioPolicies.remove(this.mToken);
                return;
            }
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            boolean bl;
            int n;
            block43: {
                int n2;
                block41: {
                    block42: {
                        String string2;
                        block40: {
                            string2 = intent.getAction();
                            if (string2.equals("android.intent.action.DOCK_EVENT")) {
                                int n3;
                                int n4 = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                                switch (n4) {
                                    default: {
                                        n3 = 0;
                                        break;
                                    }
                                    case 1: {
                                        n3 = 7;
                                        break;
                                    }
                                    case 2: {
                                        n3 = 6;
                                        break;
                                    }
                                    case 3: {
                                        n3 = 8;
                                        break;
                                    }
                                    case 4: {
                                        n3 = 9;
                                    }
                                }
                                if (n4 != 3 && (n4 != 0 || AudioService.this.mDockState != 3)) {
                                    AudioSystem.setForceUse(3, n3);
                                }
                                AudioService.access$8502(AudioService.this, n4);
                                return;
                            }
                            if (string2.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                                int n5 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                                int n6 = 16;
                                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                                if (bluetoothDevice == null) return;
                                String string3 = bluetoothDevice.getAddress();
                                BluetoothClass bluetoothClass = bluetoothDevice.getBluetoothClass();
                                if (bluetoothClass != null) {
                                    switch (bluetoothClass.getDeviceClass()) {
                                        case 1028: 
                                        case 1032: {
                                            n6 = 32;
                                            break;
                                        }
                                        case 1056: {
                                            n6 = 64;
                                        }
                                    }
                                }
                                if (!BluetoothAdapter.checkBluetoothAddress(string3)) {
                                    string3 = "";
                                }
                                if (bluetoothClass != null) {
                                    boolean bl2 = bluetoothClass.doesClassMatch(1);
                                    Log.i(AudioService.TAG, " IsA2DPHeadset: " + bl2);
                                    if (bl2) {
                                        AudioSystem.setParameters("A2DPHeadset=unknown");
                                    } else {
                                        AudioSystem.setParameters("A2DPHeadset=none");
                                    }
                                }
                                boolean bl3 = n5 == 2;
                                boolean bl4 = AudioService.this.handleDeviceConnection(bl3, n6, string3) && AudioService.this.handleDeviceConnection(bl3, -2147483640, string3);
                                if (!bl4) return;
                                ArrayList arrayList = AudioService.this.mScoClients;
                                // MONITORENTER : arrayList
                                if (bl3) {
                                    AudioService.access$3002(AudioService.this, bluetoothDevice);
                                    // MONITOREXIT : arrayList
                                    return;
                                }
                                AudioService.access$3002(AudioService.this, null);
                                AudioService.this.resetBluetoothSco();
                                return;
                            }
                            if (string2.equals("android.media.action.USB_AUDIO_ACCESSORY_PLUG")) {
                                int n7 = intent.getIntExtra("state", 0);
                                int n8 = intent.getIntExtra("card", -1);
                                int n9 = intent.getIntExtra("device", -1);
                                String string4 = n8 == -1 && n9 == -1 ? "" : "card=" + n8 + ";device=" + n9;
                                AudioService.this.setWiredDeviceConnectionState(8192, n7, string4);
                                return;
                            }
                            if (string2.equals("android.media.action.USB_AUDIO_DEVICE_PLUG")) {
                                if (Settings.Secure.getInt(AudioService.this.mContentResolver, "usb_audio_automatic_routing_disabled", 0) != 0) return;
                                int n10 = intent.getIntExtra("state", 0);
                                int n11 = intent.getIntExtra("card", -1);
                                int n12 = intent.getIntExtra("device", -1);
                                boolean bl5 = intent.getBooleanExtra("hasPlayback", false);
                                boolean bl6 = intent.getBooleanExtra("hasCapture", false);
                                intent.getBooleanExtra("hasMIDI", false);
                                String string5 = n11 == -1 && n12 == -1 ? "" : "card=" + n11 + ";device=" + n12;
                                if (bl5) {
                                    AudioService.this.setWiredDeviceConnectionState(16384, n10, string5);
                                }
                                if (!bl6) return;
                                AudioService.this.setWiredDeviceConnectionState(-2147479552, n10, string5);
                                return;
                            }
                            if (!string2.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) break block40;
                            n = -1;
                            ArrayList arrayList = AudioService.this.mScoClients;
                            // MONITORENTER : arrayList
                            n2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                            boolean bl7 = AudioService.this.mScoClients.isEmpty();
                            bl = false;
                            if (bl7) break block41;
                            if (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 1) break block42;
                            int n13 = AudioService.this.mScoAudioState;
                            bl = false;
                            if (n13 != 5) break block41;
                            break block42;
                        }
                        if (string2.equals("android.intent.action.SCREEN_ON")) {
                            if (AudioService.this.mMonitorRotation) {
                                AudioService.this.mOrientationListener.onOrientationChanged(0);
                                AudioService.this.mOrientationListener.enable();
                            }
                            AudioSystem.setParameters("screen_state=on");
                            return;
                        }
                        if (string2.equals("android.intent.action.SCREEN_OFF")) {
                            if (AudioService.this.mMonitorRotation) {
                                AudioService.this.mOrientationListener.disable();
                            }
                            AudioSystem.setParameters("screen_state=off");
                            return;
                        }
                        if (string2.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                            AudioService.this.handleConfigurationChanged(context);
                            return;
                        }
                        if (!string2.equals("android.intent.action.USER_SWITCHED")) return;
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 15, 0, 0, 0, null, 0);
                        AudioService.this.mMediaFocusControl.discardAudioFocusOwner();
                        AudioService.this.readAudioSettings(true);
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 10, 2, 0, 0, AudioService.this.mStreamStates[3], 0);
                        return;
                    }
                    bl = true;
                }
                switch (n2) {
                    case 12: {
                        n = 1;
                        if (AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 5 && AudioService.this.mScoAudioState != 4) {
                            AudioService.access$2702(AudioService.this, 2);
                        }
                        break block43;
                    }
                    case 10: {
                        AudioService.access$2702(AudioService.this, 0);
                        AudioService.this.clearAllScoClients(0, false);
                        n = 0;
                        break block43;
                    }
                    case 11: {
                        if (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) break;
                        AudioService.access$2702(AudioService.this, 2);
                        break;
                    }
                }
                bl = false;
            }
            // MONITOREXIT : arrayList
            if (!bl) return;
            AudioService.this.broadcastScoConnectionState(n);
            Intent intent2 = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
            intent2.putExtra("android.media.extra.SCO_AUDIO_STATE", n);
            AudioService.this.sendStickyBroadcastToAll(intent2);
        }
    }

    final class AudioServiceInternal
    extends AudioManagerInternal {
        AudioServiceInternal() {
        }

        @Override
        public void adjustStreamVolumeForUid(int n, int n2, int n3, String string2, int n4) {
            AudioService.this.adjustStreamVolume(n, n2, n3, string2, n4);
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int n, int n2, int n3, String string2, int n4) {
            AudioService.this.adjustSuggestedStreamVolume(n2, n, n3, string2, n4);
        }

        @Override
        public void setStreamVolumeForUid(int n, int n2, int n3, String string2, int n4) {
            AudioService.this.setStreamVolume(n, n2, n3, string2, n4);
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.access$002(AudioService.this, new AudioHandler());
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    private class ForceControlStreamClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ForceControlStreamClient(IBinder iBinder) {
            if (iBinder != null) {
                try {
                    iBinder.linkToDeath(this, 0);
                }
                catch (RemoteException remoteException) {
                    Log.w(AudioService.TAG, "ForceControlStreamClient() could not link to " + iBinder + " binder death");
                    iBinder = null;
                }
            }
            this.mCb = iBinder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            Object object = AudioService.this.mForceControlStreamLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mForceControlStreamClient != this) {
                    Log.w(AudioService.TAG, "unregistered control stream client died");
                } else {
                    AudioService.access$1002(AudioService.this, null);
                    AudioService.access$1102(AudioService.this, -1);
                }
                return;
            }
        }

        public void release() {
            if (this.mCb != null) {
                this.mCb.unlinkToDeath(this, 0);
                this.mCb = null;
            }
        }
    }

    class LoadSoundEffectReply {
        public int mStatus = 1;

        LoadSoundEffectReply() {
        }
    }

    private class MyDisplayStatusCallback
    implements HdmiPlaybackClient.DisplayStatusCallback {
        private MyDisplayStatusCallback() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onComplete(int n) {
            if (AudioService.this.mHdmiManager == null) {
                return;
            }
            HdmiControlManager hdmiControlManager = AudioService.this.mHdmiManager;
            synchronized (hdmiControlManager) {
                AudioService audioService = AudioService.this;
                boolean bl = n != -1;
                AudioService.access$9202(audioService, bl);
                if (AudioService.this.isPlatformTelevision() && !AudioService.this.mHdmiCecSink) {
                    AudioService audioService2 = AudioService.this;
                    audioService2.mFixedVolumeDevices = 0xFFFFFBFF & audioService2.mFixedVolumeDevices;
                }
                AudioService.this.checkAllFixedVolumeDevices();
                return;
            }
        }
    }

    private class RmtSbmxFullVolDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mICallback;

        RmtSbmxFullVolDeathHandler(IBinder iBinder) {
            this.mICallback = iBinder;
            try {
                iBinder.linkToDeath(this, 0);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(AudioService.TAG, "can't link to death", remoteException);
                return;
            }
        }

        @Override
        public void binderDied() {
            Log.w(AudioService.TAG, "Recorder with remote submix at full volume died " + this.mICallback);
            AudioService.this.forceRemoteSubmixFullVolume(false, this.mICallback);
        }

        void forget() {
            try {
                this.mICallback.unlinkToDeath(this, 0);
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                Log.e(AudioService.TAG, "error unlinking to death", noSuchElementException);
                return;
            }
        }

        boolean isHandlerFor(IBinder iBinder) {
            return this.mICallback.equals(iBinder);
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mCreatorPid;
        private int mStartcount;

        ScoClient(IBinder iBinder) {
            this.mCb = iBinder;
            this.mCreatorPid = Binder.getCallingPid();
            this.mStartcount = 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void requestScoState(int n, int n2) {
            block26: {
                AudioService.this.checkScoAudioState();
                if (this.totalCount() != 0) return;
                if (n != 12) break block26;
                AudioService.this.broadcastScoConnectionState(2);
                ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
                synchronized (arrayList) {
                    block25: {
                        block27: {
                            block28: {
                                if (!AudioService.this.mSetModeDeathHandlers.isEmpty() && ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getPid() != this.mCreatorPid || AudioService.this.mScoAudioState != 0 && AudioService.this.mScoAudioState != 5) break block27;
                                if (AudioService.this.mScoAudioState != 0) break block28;
                                AudioService.access$2802(AudioService.this, n2);
                                if (n2 == -1) {
                                    AudioService.access$2802(AudioService.this, new Integer(Settings.Global.getInt(AudioService.this.mContentResolver, "bluetooth_sco_channel_" + AudioService.this.mBluetoothHeadsetDevice.getAddress(), 0)));
                                    if (AudioService.this.mScoAudioMode > 2 || AudioService.this.mScoAudioMode < 0) {
                                        AudioService.access$2802(AudioService.this, 0);
                                    }
                                }
                                if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                                    boolean bl;
                                    if (AudioService.this.mScoAudioMode == 1) {
                                        bl = AudioService.this.mBluetoothHeadset.connectAudio();
                                    } else if (AudioService.this.mScoAudioMode == 0) {
                                        bl = AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                    } else {
                                        int n3 = AudioService.this.mScoAudioMode;
                                        bl = false;
                                        if (n3 == 2) {
                                            bl = AudioService.this.mBluetoothHeadset.startVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                        }
                                    }
                                    if (bl) {
                                        AudioService.access$2702(AudioService.this, 3);
                                        break block25;
                                    } else {
                                        AudioService.this.broadcastScoConnectionState(0);
                                    }
                                    break block25;
                                } else {
                                    if (!AudioService.this.getBluetoothHeadset()) return;
                                    AudioService.access$2702(AudioService.this, 1);
                                }
                                break block25;
                            }
                            AudioService.access$2702(AudioService.this, 3);
                            AudioService.this.broadcastScoConnectionState(1);
                            break block25;
                        }
                        AudioService.this.broadcastScoConnectionState(0);
                    }
                    return;
                }
            }
            if (n != 10 || AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 1) return;
            if (AudioService.this.mScoAudioState == 3) {
                if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                    boolean bl;
                    if (AudioService.this.mScoAudioMode == 1) {
                        bl = AudioService.this.mBluetoothHeadset.disconnectAudio();
                    } else if (AudioService.this.mScoAudioMode == 0) {
                        bl = AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                    } else {
                        int n4 = AudioService.this.mScoAudioMode;
                        bl = false;
                        if (n4 == 2) {
                            bl = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                        }
                    }
                    if (bl) return;
                    AudioService.access$2702(AudioService.this, 0);
                    AudioService.this.broadcastScoConnectionState(0);
                    return;
                } else {
                    if (!AudioService.this.getBluetoothHeadset()) return;
                    AudioService.access$2702(AudioService.this, 5);
                    return;
                }
            }
            AudioService.access$2702(AudioService.this, 0);
            AudioService.this.broadcastScoConnectionState(0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mScoClients.indexOf(this) < 0) {
                    Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    AudioService.this.mScoClients.remove(this);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clearCount(boolean bl) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n = this.mStartcount;
                if (n != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        Log.w(AudioService.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (bl) {
                    this.requestScoState(10, 0);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    this.mStartcount = -1 + this.mStartcount;
                    int n = this.mStartcount;
                    if (n == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(10, 0);
                }
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getCount() {
            return this.mStartcount;
        }

        public int getPid() {
            return this.mCreatorPid;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void incCount(int n) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(12, n);
                int n2 = this.mStartcount;
                if (n2 == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException remoteException) {
                        Log.w(AudioService.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                this.mStartcount = 1 + this.mStartcount;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n = 0;
                int n2 = AudioService.this.mScoClients.size();
                int n3 = 0;
                while (n3 < n2) {
                    n += ((ScoClient)AudioService.this.mScoClients.get(n3)).getCount();
                    ++n3;
                }
                return n;
            }
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mMode = 0;
        private int mPid;

        SetModeDeathHandler(IBinder iBinder, int n) {
            this.mCb = iBinder;
            this.mPid = n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void binderDied() {
            int n = 0;
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            // MONITORENTER : arrayList
            Log.w(AudioService.TAG, "setMode() client died");
            if (AudioService.this.mSetModeDeathHandlers.indexOf(this) < 0) {
                Log.w(AudioService.TAG, "unregistered setMode() client died");
            } else {
                n = AudioService.this.setModeInt(0, this.mCb, this.mPid);
            }
            // MONITOREXIT : arrayList
            if (n == 0) return;
            long l = Binder.clearCallingIdentity();
            AudioService.this.disconnectBluetoothSco(n);
            Binder.restoreCallingIdentity(l);
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getMode() {
            return this.mMode;
        }

        public int getPid() {
            return this.mPid;
        }

        public void setMode(int n) {
            this.mMode = n;
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("dock_audio_media_enabled"), false, this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onChange(boolean bl) {
            super.onChange(bl);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                if (AudioService.this.updateRingerModeAffectedStreams()) {
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                }
                AudioService.this.readDockAudioSettings(AudioService.this.mContentResolver);
                return;
            }
        }
    }

    private final class SoundPoolCallback
    implements SoundPool.OnLoadCompleteListener {
        List<Integer> mSamples = new ArrayList<Integer>();
        int mStatus = 1;

        private SoundPoolCallback() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onLoadComplete(SoundPool soundPool, int n, int n2) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int n3 = this.mSamples.indexOf(n);
                if (n3 >= 0) {
                    this.mSamples.remove(n3);
                }
                if (n2 != 0 || this.mSamples.isEmpty()) {
                    this.mStatus = n2;
                    AudioService.this.mSoundEffectsLock.notify();
                }
                return;
            }
        }

        public void setSamples(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= 0) continue;
                this.mSamples.add(nArray[i]);
            }
        }

        public int status() {
            return this.mStatus;
        }
    }

    class SoundPoolListenerThread
    extends Thread {
        public SoundPoolListenerThread() {
            super("SoundPoolListenerThread");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService.access$1702(AudioService.this, Looper.myLooper());
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool != null) {
                    AudioService.access$2002(AudioService.this, new SoundPoolCallback());
                    AudioService.this.mSoundPool.setOnLoadCompleteListener(AudioService.this.mSoundPoolCallBack);
                }
                AudioService.this.mSoundEffectsLock.notify();
            }
            Looper.loop();
        }
    }

    private static class StreamOverride
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        private static final int DEFAULT_STREAM_TYPE_OVERRIDE_DELAY_MS = 5000;
        private static final int TOUCH_EXPLORE_STREAM_TYPE_OVERRIDE_DELAY_MS = 1000;
        static int sDelayMs;

        private StreamOverride() {
        }

        static void init(Context context) {
            AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
            StreamOverride.updateDefaultStreamOverrideDelay(accessibilityManager.isTouchExplorationEnabled());
            accessibilityManager.addTouchExplorationStateChangeListener(new StreamOverride());
        }

        /*
         * Enabled aggressive block sorting
         */
        private static void updateDefaultStreamOverrideDelay(boolean bl) {
            sDelayMs = bl ? 1000 : 5000;
            if (DEBUG_VOL) {
                Log.d(AudioService.TAG, "Touch exploration enabled=" + bl + " stream override delay is now " + sDelayMs + " ms");
            }
        }

        @Override
        public void onTouchExplorationStateChanged(boolean bl) {
            StreamOverride.updateDefaultStreamOverrideDelay(bl);
        }
    }

    class StreamVolumeCommand {
        public final int mDevice;
        public final int mFlags;
        public final int mIndex;
        public final int mStreamType;

        StreamVolumeCommand(int n, int n2, int n3, int n4) {
            this.mStreamType = n;
            this.mIndex = n2;
            this.mFlags = n3;
            this.mDevice = n4;
        }

        public String toString() {
            return "{streamType=" + this.mStreamType + ",index=" + this.mIndex + ",flags=" + this.mFlags + ",device=" + this.mDevice + '}';
        }
    }

    public static class VolumeController {
        private static final String TAG = "VolumeController";
        private IVolumeController mController;
        private int mLongPressTimeout;
        private long mNextLongPress;
        private boolean mVisible;

        private static IBinder binder(IVolumeController iVolumeController) {
            if (iVolumeController == null) {
                return null;
            }
            return iVolumeController.asBinder();
        }

        public IBinder asBinder() {
            return VolumeController.binder(this.mController);
        }

        public boolean isSameBinder(IVolumeController iVolumeController) {
            return Objects.equals(this.asBinder(), VolumeController.binder(iVolumeController));
        }

        public void loadSettings(ContentResolver contentResolver) {
            this.mLongPressTimeout = Settings.Secure.getIntForUser(contentResolver, "long_press_timeout", 500, -2);
        }

        public void postDismiss() {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.dismiss();
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling dismiss", remoteException);
                return;
            }
        }

        public void postDisplaySafeVolumeWarning(int n) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.displaySafeVolumeWarning(n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling displaySafeVolumeWarning", remoteException);
                return;
            }
        }

        public void postMasterMuteChanged(int n) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterMuteChanged(n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling masterMuteChanged", remoteException);
                return;
            }
        }

        public void postMasterVolumeChanged(int n) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterVolumeChanged(n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling masterVolumeChanged", remoteException);
                return;
            }
        }

        public void postVolumeChanged(int n, int n2) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.volumeChanged(n, n2);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling volumeChanged", remoteException);
                return;
            }
        }

        public void setController(IVolumeController iVolumeController) {
            this.mController = iVolumeController;
            this.mVisible = false;
        }

        public void setLayoutDirection(int n) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.setLayoutDirection(n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling setLayoutDirection", remoteException);
                return;
            }
        }

        public void setVisible(boolean bl) {
            this.mVisible = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean suppressAdjustment(int n, int n2) {
            boolean bl = false;
            if (n != 2) return bl;
            IVolumeController iVolumeController = this.mController;
            bl = false;
            if (iVolumeController == null) return bl;
            long l = SystemClock.uptimeMillis();
            if ((n2 & 1) != 0 && !this.mVisible) {
                if (this.mNextLongPress >= l) return true;
                this.mNextLongPress = l + (long)this.mLongPressTimeout;
                return true;
            }
            long l2 = this.mNextLongPress - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            bl = false;
            if (l3 <= 0) return bl;
            if (l <= this.mNextLongPress) return true;
            this.mNextLongPress = 0L;
            return false;
        }

        public String toString() {
            return "VolumeController(" + this.asBinder() + ",mVisible=" + this.mVisible + ")";
        }
    }

    public class VolumeStreamState {
        private ArrayList<VolumeDeathHandler> mDeathHandlers;
        private final ConcurrentHashMap<Integer, Integer> mIndex = new ConcurrentHashMap(8, 0.75f, 4);
        private int mIndexMax;
        private final int mStreamType;
        private String mVolumeIndexSettingName;

        private VolumeStreamState(String string2, int n) {
            this.mVolumeIndexSettingName = string2;
            this.mStreamType = n;
            this.mIndexMax = MAX_STREAM_VOLUME[n];
            AudioSystem.initStreamVolume(n, 0, this.mIndexMax);
            this.mIndexMax = 10 * this.mIndexMax;
            this.mDeathHandlers = new ArrayList();
            this.readSettings();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void dump(PrintWriter printWriter) {
            printWriter.print("   Mute count: ");
            printWriter.println(this.muteCount());
            printWriter.print("   Max: ");
            printWriter.println((5 + this.mIndexMax) / 10);
            printWriter.print("   Current: ");
            Iterator<Map.Entry<Integer, Integer>> iterator = this.mIndex.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, Integer> entry = iterator.next();
                int n = entry.getKey();
                printWriter.print(Integer.toHexString(n));
                String string2 = n == 0x40000000 ? "default" : AudioSystem.getOutputDeviceName(n);
                if (!string2.isEmpty()) {
                    printWriter.print(" (");
                    printWriter.print(string2);
                    printWriter.print(")");
                }
                printWriter.print(": ");
                printWriter.print((5 + entry.getValue()) / 10);
                if (!iterator.hasNext()) continue;
                printWriter.print(", ");
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private VolumeDeathHandler getDeathHandler(IBinder iBinder, boolean bl) {
            int n = this.mDeathHandlers.size();
            for (int i = 0; i < n; ++i) {
                VolumeDeathHandler volumeDeathHandler = this.mDeathHandlers.get(i);
                if (iBinder != volumeDeathHandler.mICallback) continue;
                return volumeDeathHandler;
            }
            if (bl) {
                return new VolumeDeathHandler(iBinder);
            }
            Log.w(AudioService.TAG, "stream was not muted by this client");
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getValidIndex(int n) {
            if (n < 0) {
                return 0;
            }
            if (AudioService.this.mUseFixedVolume) return this.mIndexMax;
            if (n <= this.mIndexMax) return n;
            return this.mIndexMax;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isMuted() {
            synchronized (this) {
                int n = this.muteCount();
                if (n == 0) return false;
                return true;
            }
        }

        private int muteCount() {
            synchronized (this) {
                int n = 0;
                int n2 = this.mDeathHandlers.size();
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.mDeathHandlers.get(i).mMuteCount;
                    n += n3;
                    continue;
                }
                return n;
            }
        }

        public boolean adjustIndex(int n, int n2) {
            return this.setIndex(n + this.getIndex(n2), n2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void applyAllVolumes() {
            synchronized (VolumeStreamState.class) {
                int n = this.isMuted() ? 0 : (5 + this.getIndex(0x40000000)) / 10;
                AudioSystem.setStreamVolumeIndex(this.mStreamType, n, 0x40000000);
                Iterator<Map.Entry<Integer, Integer>> iterator = this.mIndex.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Integer> entry = iterator.next();
                    int n2 = entry.getKey();
                    if (n2 == 0x40000000) continue;
                    int n3 = this.isMuted() ? 0 : ((n2 & 0x380) != 0 && AudioService.this.mAvrcpAbsVolSupported || (n2 & AudioService.this.mFullVolumeDevices) != 0 ? (5 + this.mIndexMax) / 10 : (5 + entry.getValue()) / 10);
                    AudioSystem.setStreamVolumeIndex(this.mStreamType, n3, n2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void applyDeviceVolume(int n) {
            int n2 = this.isMuted() ? 0 : ((n & 0x380) != 0 && AudioService.this.mAvrcpAbsVolSupported || (n & AudioService.this.mFullVolumeDevices) != 0 ? (5 + this.mIndexMax) / 10 : (5 + this.getIndex(n)) / 10);
            AudioSystem.setStreamVolumeIndex(this.mStreamType, n2, n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void checkFixedVolumeDevices() {
            synchronized (VolumeStreamState.class) {
                if (AudioService.this.mStreamVolumeAlias[this.mStreamType] == 3) {
                    for (Map.Entry<Integer, Integer> entry : this.mIndex.entrySet()) {
                        int n = entry.getKey();
                        int n2 = entry.getValue();
                        if ((n & AudioService.this.mFullVolumeDevices) != 0 || (n & AudioService.this.mFixedVolumeDevices) != 0 && n2 != 0) {
                            entry.setValue(this.mIndexMax);
                        }
                        this.applyDeviceVolume(n);
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getIndex(int n) {
            synchronized (VolumeStreamState.class) {
                Integer n2 = this.mIndex.get(n);
                if (n2 != null) return n2;
                n2 = this.mIndex.get(0x40000000);
                return n2;
            }
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public String getSettingNameForDevice(int n) {
            String string2 = this.mVolumeIndexSettingName;
            String string3 = AudioSystem.getOutputDeviceName(n);
            if (string3.isEmpty()) {
                return string2;
            }
            return string2 + "_" + string3;
        }

        public int getStreamType() {
            return this.mStreamType;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void mute(IBinder iBinder, boolean bl) {
            synchronized (VolumeStreamState.class) {
                VolumeDeathHandler volumeDeathHandler = this.getDeathHandler(iBinder, bl);
                if (volumeDeathHandler == null) {
                    Log.e(AudioService.TAG, "Could not get client death handler for stream: " + this.mStreamType);
                    return;
                }
                volumeDeathHandler.mute(bl);
                return;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readSettings() {
            synchronized (VolumeStreamState.class) {
                block15: {
                    if (AudioService.access$4100(AudioService.this)) {
                        this.mIndex.put(0x40000000, this.mIndexMax);
                        return;
                    }
                    if (this.mStreamType == 1 || this.mStreamType == 7) {
                        var2_1 = 10 * AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType];
                        var3_2 = AudioService.access$4200(AudioService.this);
                        synchronized (var3_2) {
                            if (AudioService.access$4200(AudioService.this).booleanValue()) {
                                var2_1 = this.mIndexMax;
                            }
                        }
                        this.mIndex.put(0x40000000, var2_1);
                        return;
                    }
                    var6_3 = 1077936127;
                    var7_4 = 0;
                    break block15;
                    while (true) {
                        var6_3 &= ~var8_5;
                        var9_6 = this.getSettingNameForDevice(var8_5);
                        var10_7 = var8_5 == 0x40000000 ? AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType] : -1;
                        var11_8 = Settings.System.getIntForUser(AudioService.access$2900(AudioService.this), var9_6, var10_7, -2);
                        if (var11_8 != -1) {
                            this.mIndex.put(var8_5, this.getValidIndex(var11_8 * 10));
                        }
                        ** GOTO lbl32
                        break;
                    }
                }
                while (true) {
                    if (var6_3 == 0) {
                        return;
                    }
                    if (((var8_5 = 1 << var7_4) & var6_3) != 0) ** continue;
lbl32:
                    // 2 sources

                    ++var7_4;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setAllIndexes(VolumeStreamState volumeStreamState) {
            synchronized (VolumeStreamState.class) {
                int n = volumeStreamState.getStreamType();
                int n2 = volumeStreamState.getIndex(0x40000000);
                int n3 = AudioService.this.rescaleIndex(n2, n, this.mStreamType);
                Iterator<Map.Entry<Integer, Integer>> iterator = this.mIndex.entrySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().setValue(n3);
                }
                Iterator<Map.Entry<Integer, Integer>> iterator2 = volumeStreamState.mIndex.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Integer, Integer> entry = iterator2.next();
                    int n4 = entry.getKey();
                    int n5 = entry.getValue();
                    this.setIndex(AudioService.this.rescaleIndex(n5, n, this.mStreamType), n4);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setAllIndexesToMax() {
            synchronized (VolumeStreamState.class) {
                Iterator<Map.Entry<Integer, Integer>> iterator = this.mIndex.entrySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().setValue(this.mIndexMax);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean setIndex(int n, int n2) {
            synchronized (VolumeStreamState.class) {
                int n3 = this.getIndex(n2);
                int n4 = this.getValidIndex(n);
                Boolean bl = AudioService.this.mCameraSoundForced;
                synchronized (bl) {
                    if (this.mStreamType == 7 && AudioService.this.mCameraSoundForced.booleanValue()) {
                        n4 = this.mIndexMax;
                    }
                }
                this.mIndex.put(n2, n4);
                if (n3 == n4) {
                    return false;
                }
                boolean bl2 = n2 == AudioService.this.getDeviceForStream(this.mStreamType);
                int n5 = -1 + AudioSystem.getNumStreamTypes();
                while (n5 >= 0) {
                    if (n5 != this.mStreamType && AudioService.this.mStreamVolumeAlias[n5] == this.mStreamType) {
                        int n6 = AudioService.this.rescaleIndex(n4, this.mStreamType, n5);
                        AudioService.this.mStreamStates[n5].setIndex(n6, n2);
                        if (bl2) {
                            AudioService.this.mStreamStates[n5].setIndex(n6, AudioService.this.getDeviceForStream(n5));
                        }
                    }
                    --n5;
                }
                return true;
            }
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            private IBinder mICallback;
            private int mMuteCount;

            VolumeDeathHandler(IBinder iBinder) {
                this.mICallback = iBinder;
            }

            static /* synthetic */ int access$2302(VolumeDeathHandler volumeDeathHandler, int n) {
                volumeDeathHandler.mMuteCount = n;
                return n;
            }

            @Override
            public void binderDied() {
                Log.w(AudioService.TAG, "Volume service client died for stream: " + VolumeStreamState.this.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }

            /*
             * Unable to fully structure code
             */
            public void mute(boolean var1_1) {
                block10: {
                    if (var1_1) {
                        if (this.mMuteCount == 0) {
                            block9: {
                                try {
                                    if (this.mICallback != null) {
                                        this.mICallback.linkToDeath(this, 0);
                                    }
                                    VolumeStreamState.access$2200(VolumeStreamState.this).add(this);
                                    var11_2 = VolumeStreamState.access$300(VolumeStreamState.this);
                                    var3_3 = false;
                                    if (var11_2) break block9;
                                    var3_3 = true;
                                }
                                catch (RemoteException var9_4) {
                                    this.binderDied();
                                    return;
                                }
                            }
lbl13:
                            // 2 sources

                            while (true) {
                                this.mMuteCount = 1 + this.mMuteCount;
lbl15:
                                // 5 sources

                                while (true) {
                                    if (var3_3) {
                                        AudioService.access$100(AudioService.access$000(AudioService.this), 10, 2, 0, 0, VolumeStreamState.this, 0);
                                    }
                                    return;
                                }
                                break;
                            }
                        }
                        Log.w("AudioService", "stream: " + VolumeStreamState.access$4800(VolumeStreamState.this) + " was already muted by this client");
                        var3_3 = false;
                        ** continue;
                    }
                    if (this.mMuteCount != 0) break block10;
                    Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$4800(VolumeStreamState.this));
                    var3_3 = false;
                    ** GOTO lbl15
                }
                var2_5 = this.mMuteCount = -1 + this.mMuteCount;
                var3_3 = false;
                if (var2_5 != 0) ** GOTO lbl15
                VolumeStreamState.access$2200(VolumeStreamState.this).remove(this);
                if (this.mICallback != null) {
                    this.mICallback.unlinkToDeath(this, 0);
                }
                var5_6 = VolumeStreamState.access$300(VolumeStreamState.this);
                var3_3 = false;
                if (var5_6) ** GOTO lbl15
                var3_3 = true;
                ** while (true)
            }
        }
    }
}

