/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioSystem;
import android.media.AudioTimestamp;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.app.IAppOpsService;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.NioUtils;

public class AudioTrack {
    private static final int CHANNEL_COUNT_MAX = 8;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    private static final int ERROR_NATIVESETUP_AUDIOSYSTEM = -16;
    private static final int ERROR_NATIVESETUP_INVALIDCHANNELMASK = -17;
    private static final int ERROR_NATIVESETUP_INVALIDFORMAT = -18;
    private static final int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = -19;
    private static final int ERROR_NATIVESETUP_NATIVEINITFAILED = -20;
    private static final float GAIN_MAX = 1.0f;
    private static final float GAIN_MIN = 0.0f;
    public static final int MODE_STATIC = 0;
    public static final int MODE_STREAM = 1;
    private static final int NATIVE_EVENT_MARKER = 3;
    private static final int NATIVE_EVENT_NEW_POS = 4;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int PLAYSTATE_STOPPED = 1;
    private static final int SAMPLE_RATE_HZ_MAX = 96000;
    private static final int SAMPLE_RATE_HZ_MIN = 4000;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_NO_STATIC_DATA = 2;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;
    private static final int SUPPORTED_OUT_CHANNELS = 7420;
    private static final String TAG = "android.media.AudioTrack";
    public static final int WRITE_BLOCKING = 0;
    public static final int WRITE_NON_BLOCKING = 1;
    private final IAppOpsService mAppOps;
    private final AudioAttributes mAttributes;
    private int mAudioFormat = 2;
    private int mChannelConfiguration = 4;
    private int mChannelCount = 1;
    private int mChannels = 4;
    private int mDataLoadMode = 1;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    private final Looper mInitializationLooper;
    private long mJniData;
    private int mNativeBufferSizeInBytes = 0;
    private int mNativeBufferSizeInFrames = 0;
    private long mNativeTrackInJavaObj;
    private int mPlayState = 1;
    private final Object mPlayStateLock = new Object();
    private int mSampleRate;
    private int mSessionId = 0;
    private int mState = 0;
    private int mStreamType = 3;

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this(n, n2, n3, n4, n5, n6, 0);
    }

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setLegacyStreamType(n).build(), new AudioFormat.Builder().setChannelMask(n3).setEncoding(n4).setSampleRate(n2).build(), n5, n6, n7);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AudioTrack(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3) throws IllegalArgumentException {
        int n4;
        if (audioAttributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (audioFormat == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        if ((2 & audioFormat.getPropertySetMask()) != 0) {
            n4 = audioFormat.getSampleRate();
        } else {
            n4 = AudioSystem.getPrimaryOutputSamplingRate();
            if (n4 <= 0) {
                n4 = 44100;
            }
        }
        int n5 = 12;
        if ((4 & audioFormat.getPropertySetMask()) != 0) {
            n5 = audioFormat.getChannelMask();
        }
        int n6 = 1;
        if ((1 & audioFormat.getPropertySetMask()) != 0) {
            n6 = audioFormat.getEncoding();
        }
        this.audioParamCheck(n4, n5, n6, n2);
        this.mStreamType = -1;
        this.audioBuffSizeCheck(n);
        this.mInitializationLooper = looper;
        this.mAppOps = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        this.mAttributes = new AudioAttributes.Builder(audioAttributes).build();
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid audio session ID: " + n3);
        }
        int[] nArray = new int[]{n3};
        int n7 = this.native_setup(new WeakReference<AudioTrack>(this), this.mAttributes, this.mSampleRate, this.mChannels, this.mAudioFormat, this.mNativeBufferSizeInBytes, this.mDataLoadMode, nArray);
        if (n7 != 0) {
            AudioTrack.loge("Error code " + n7 + " when initializing AudioTrack.");
            return;
        }
        this.mSessionId = nArray[0];
        if (this.mDataLoadMode == 0) {
            this.mState = 2;
            return;
        }
        this.mState = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void audioBuffSizeCheck(int n) {
        int n2 = AudioFormat.isEncodingLinearPcm(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
        if (n % n2 == 0 && n >= 1) {
            this.mNativeBufferSizeInBytes = n;
            this.mNativeBufferSizeInFrames = n / n2;
            return;
        }
        throw new IllegalArgumentException("Invalid audio buffer size.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void audioParamCheck(int n, int n2, int n3, int n4) {
        block8: {
            if (n < 4000 || n > 96000) {
                throw new IllegalArgumentException(n + "Hz is not a supported sample rate.");
            }
            this.mSampleRate = n;
            this.mChannelConfiguration = n2;
            switch (n2) {
                default: {
                    if (AudioTrack.isMultichannelConfigSupported(n2)) break;
                    throw new IllegalArgumentException("Unsupported channel configuration.");
                }
                case 1: 
                case 2: 
                case 4: {
                    this.mChannelCount = 1;
                    this.mChannels = 4;
                    break block8;
                }
                case 3: 
                case 12: {
                    this.mChannelCount = 2;
                    this.mChannels = 12;
                    break block8;
                }
            }
            this.mChannels = n2;
            this.mChannelCount = Integer.bitCount(n2);
        }
        if (n3 == 1) {
            n3 = 2;
        }
        if (!AudioFormat.isValidEncoding(n3)) {
            throw new IllegalArgumentException("Unsupported audio encoding.");
        }
        this.mAudioFormat = n3;
        if (n4 != 1 && n4 != 0 || n4 != 1 && !AudioFormat.isEncodingLinearPcm(this.mAudioFormat)) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float clampGainOrLevel(float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException();
        }
        if (f < 0.0f) {
            return 0.0f;
        }
        if (!(f > 1.0f)) return f;
        return 1.0f;
    }

    public static float getMaxVolume() {
        return 1.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMinBufferSize(int n, int n2, int n3) {
        int n4;
        int n5;
        block7: {
            n5 = -2;
            switch (n2) {
                default: {
                    if ((n2 & 0x1CFC) == n2) break;
                    AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                    return n5;
                }
                case 2: 
                case 4: {
                    n4 = 1;
                    break block7;
                }
                case 3: 
                case 12: {
                    n4 = 2;
                    break block7;
                }
            }
            n4 = Integer.bitCount(n2);
        }
        if (!AudioFormat.isValidEncoding(n3)) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return n5;
        }
        if (n < 4000 || n > 96000) {
            AudioTrack.loge("getMinBufferSize(): " + n + " Hz is not a supported sample rate.");
            return n5;
        }
        n5 = AudioTrack.native_get_min_buff_size(n, n4, n3);
        if (n5 > 0) return n5;
        AudioTrack.loge("getMinBufferSize(): error querying hardware");
        return -1;
    }

    public static float getMinVolume() {
        return 0.0f;
    }

    public static int getNativeOutputSampleRate(int n) {
        return AudioTrack.native_get_output_sample_rate(n);
    }

    private static boolean isMultichannelConfigSupported(int n) {
        if ((n & 0x1CFC) != n) {
            AudioTrack.loge("Channel configuration features unsupported channels");
            return false;
        }
        int n2 = Integer.bitCount(n);
        if (n2 > 8) {
            AudioTrack.loge("Channel configuration contains too many channels " + n2 + ">" + 8);
            return false;
        }
        if ((n & 0xC) != 12) {
            AudioTrack.loge("Front channels must be present in multichannel configurations");
            return false;
        }
        if ((n & 0xC0) != 0 && (n & 0xC0) != 192) {
            AudioTrack.loge("Rear channels can't be used independently");
            return false;
        }
        if ((n & 0x1800) != 0 && (n & 0x1800) != 6144) {
            AudioTrack.loge("Side channels can't be used independently");
            return false;
        }
        return true;
    }

    private boolean isRestricted() {
        try {
            int n = AudioAttributes.usageForLegacyStreamType(this.mStreamType);
            int n2 = this.mAppOps.checkAudioOperation(28, n, Process.myUid(), ActivityThread.currentPackageName());
            boolean bl = false;
            if (n2 != 0) {
                bl = true;
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private static void logd(String string2) {
        Log.d(TAG, string2);
    }

    private static void loge(String string2) {
        Log.e(TAG, string2);
    }

    private final native int native_attachAuxEffect(int var1);

    private final native void native_finalize();

    private final native void native_flush();

    private final native int native_get_latency();

    private final native int native_get_marker_pos();

    private static final native int native_get_min_buff_size(int var0, int var1, int var2);

    private final native int native_get_native_frame_count();

    private static final native int native_get_output_sample_rate(int var0);

    private final native int native_get_playback_rate();

    private final native int native_get_pos_update_period();

    private final native int native_get_position();

    private final native int native_get_timestamp(long[] var1);

    private final native void native_pause();

    private final native void native_release();

    private final native int native_reload_static();

    private final native int native_setAuxEffectSendLevel(float var1);

    private final native void native_setVolume(float var1, float var2);

    private final native int native_set_loop(int var1, int var2, int var3);

    private final native int native_set_marker_pos(int var1);

    private final native int native_set_playback_rate(int var1);

    private final native int native_set_pos_update_period(int var1);

    private final native int native_set_position(int var1);

    private final native int native_setup(Object var1, Object var2, int var3, int var4, int var5, int var6, int var7, int[] var8);

    private final native void native_start();

    private final native void native_stop();

    private final native int native_write_byte(byte[] var1, int var2, int var3, int var4, boolean var5);

    private final native int native_write_float(float[] var1, int var2, int var3, int var4, boolean var5);

    private final native int native_write_native_bytes(Object var1, int var2, int var3, int var4, boolean var5);

    private final native int native_write_short(short[] var1, int var2, int var3, int var4);

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        Handler handler;
        NativeEventHandlerDelegate nativeEventHandlerDelegate;
        AudioTrack audioTrack = (AudioTrack)((WeakReference)object).get();
        if (audioTrack == null || (nativeEventHandlerDelegate = audioTrack.mEventHandlerDelegate) == null || (handler = nativeEventHandlerDelegate.getHandler()) == null) {
            return;
        }
        handler.sendMessage(handler.obtainMessage(n, n2, n3, object2));
    }

    public int attachAuxEffect(int n) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_attachAuxEffect(n);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public void flush() {
        if (this.mState == 1) {
            this.native_flush();
        }
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public int getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getLatency() {
        return this.native_get_latency();
    }

    @Deprecated
    protected int getNativeFrameCount() {
        return this.native_get_native_frame_count();
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayState() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            return this.mPlayState;
        }
    }

    public int getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    public int getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getState() {
        return this.mState;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public boolean getTimestamp(AudioTimestamp audioTimestamp) {
        if (audioTimestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] lArray = new long[2];
        if (this.native_get_timestamp(lArray) != 0) {
            return false;
        }
        audioTimestamp.framePosition = lArray[0];
        audioTimestamp.nanoTime = lArray[1];
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.mPlayState = 2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        if (this.isRestricted()) {
            this.setVolume(0.0f);
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_start();
            this.mPlayState = 3;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {}
        this.native_release();
        this.mState = 0;
    }

    public int reloadStaticData() {
        if (this.mDataLoadMode == 1 || this.mState != 1) {
            return -3;
        }
        return this.native_reload_static();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int setAuxEffectSendLevel(float f) {
        block5: {
            block4: {
                if (this.isRestricted()) break block4;
                if (this.mState == 0) {
                    return -3;
                }
                if (this.native_setAuxEffectSendLevel(AudioTrack.clampGainOrLevel(f)) != 0) break block5;
            }
            return 0;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int setLoopPoints(int n, int n2, int n3) {
        if (this.mDataLoadMode == 1 || this.mState != 1 || this.getPlayState() == 3) {
            return -3;
        }
        if (n3 == 0 || n >= 0 && n < this.mNativeBufferSizeInFrames && n < n2 && n2 <= this.mNativeBufferSizeInFrames) {
            return this.native_set_loop(n, n2, n3);
        }
        return -2;
    }

    public int setNotificationMarkerPosition(int n) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(n);
    }

    public int setPlaybackHeadPosition(int n) {
        if (this.mDataLoadMode == 1 || this.mState != 1 || this.getPlayState() == 3) {
            return -3;
        }
        if (n < 0 || n > this.mNativeBufferSizeInFrames) {
            return -2;
        }
        return this.native_set_position(n);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
        this.setPlaybackPositionUpdateListener(onPlaybackPositionUpdateListener, null);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
        if (onPlaybackPositionUpdateListener != null) {
            this.mEventHandlerDelegate = new NativeEventHandlerDelegate(this, onPlaybackPositionUpdateListener, handler);
            return;
        }
        this.mEventHandlerDelegate = null;
    }

    public int setPlaybackRate(int n) {
        if (this.mState != 1) {
            return -3;
        }
        if (n <= 0) {
            return -2;
        }
        return this.native_set_playback_rate(n);
    }

    public int setPositionNotificationPeriod(int n) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(n);
    }

    @Deprecated
    protected void setState(int n) {
        this.mState = n;
    }

    public int setStereoVolume(float f, float f2) {
        if (this.isRestricted()) {
            return 0;
        }
        if (this.mState == 0) {
            return -3;
        }
        this.native_setVolume(AudioTrack.clampGainOrLevel(f), AudioTrack.clampGainOrLevel(f2));
        return 0;
    }

    public int setVolume(float f) {
        return this.setStereoVolume(f, f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.mPlayState = 1;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int write(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (n2 != 0 && n2 != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (byteBuffer == null || n < 0 || n > byteBuffer.remaining()) {
            Log.e(TAG, "AudioTrack.write() called with invalid size (" + n + ") value");
            return -2;
        }
        if (byteBuffer.isDirect()) {
            int n4 = byteBuffer.position();
            int n5 = this.mAudioFormat;
            boolean bl = false;
            if (n2 == 0) {
                bl = true;
            }
            n3 = this.native_write_native_bytes(byteBuffer, n4, n, n5, bl);
        } else {
            byte[] byArray = NioUtils.unsafeArray((ByteBuffer)byteBuffer);
            int n6 = NioUtils.unsafeArrayOffset((ByteBuffer)byteBuffer) + byteBuffer.position();
            int n7 = this.mAudioFormat;
            boolean bl = false;
            if (n2 == 0) {
                bl = true;
            }
            n3 = this.native_write_byte(byArray, n6, n, n7, bl);
        }
        if (this.mDataLoadMode == 0 && this.mState == 2 && n3 > 0) {
            this.mState = 1;
        }
        if (n3 <= 0) return n3;
        byteBuffer.position(n3 + byteBuffer.position());
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(byte[] byArray, int n, int n2) {
        if (this.mState == 0) return -3;
        if (this.mAudioFormat == 4) {
            return -3;
        }
        if (byArray == null) return -2;
        if (n < 0) return -2;
        if (n2 < 0) return -2;
        if (n + n2 < 0) return -2;
        if (n + n2 > byArray.length) {
            return -2;
        }
        int n3 = this.native_write_byte(byArray, n, n2, this.mAudioFormat, true);
        if (this.mDataLoadMode != 0) return n3;
        if (this.mState != 2) return n3;
        if (n3 <= 0) return n3;
        this.mState = 1;
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int write(float[] fArray, int n, int n2, int n3) {
        int n4 = -3;
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return n4;
        } else {
            if (this.mAudioFormat != 4) {
                Log.e(TAG, "AudioTrack.write(float[] ...) requires format ENCODING_PCM_FLOAT");
                return n4;
            }
            if (n3 != 0 && n3 != 1) {
                Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
                return -2;
            }
            if (fArray == null || n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > fArray.length) {
                Log.e(TAG, "AudioTrack.write() called with invalid array, offset, or size");
                return -2;
            }
            int n5 = this.mAudioFormat;
            boolean bl = n3 == 0;
            n4 = this.native_write_float(fArray, n, n2, n5, bl);
            if (this.mDataLoadMode != 0 || this.mState != 2 || n4 <= 0) return n4;
            this.mState = 1;
            return n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(short[] sArray, int n, int n2) {
        if (this.mState == 0) return -3;
        if (this.mAudioFormat == 4) {
            return -3;
        }
        if (sArray == null) return -2;
        if (n < 0) return -2;
        if (n2 < 0) return -2;
        if (n + n2 < 0) return -2;
        if (n + n2 > sArray.length) {
            return -2;
        }
        int n3 = this.native_write_short(sArray, n, n2, this.mAudioFormat);
        if (this.mDataLoadMode != 0) return n3;
        if (this.mState != 2) return n3;
        if (n3 <= 0) return n3;
        this.mState = 1;
        return n3;
    }

    private class NativeEventHandlerDelegate {
        private final Handler mHandler;

        /*
         * Enabled aggressive block sorting
         */
        NativeEventHandlerDelegate(final AudioTrack audioTrack2, final OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : AudioTrack.this.mInitializationLooper;
            if (looper != null) {
                this.mHandler = new Handler(looper){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void handleMessage(Message message) {
                        block5: {
                            block4: {
                                if (audioTrack2 == null) break block4;
                                switch (message.what) {
                                    default: {
                                        AudioTrack.loge("Unknown native event type: " + message.what);
                                        return;
                                    }
                                    case 3: {
                                        if (onPlaybackPositionUpdateListener == null) break;
                                        onPlaybackPositionUpdateListener.onMarkerReached(audioTrack2);
                                        return;
                                    }
                                    case 4: {
                                        if (onPlaybackPositionUpdateListener != null) break block5;
                                    }
                                }
                            }
                            return;
                        }
                        onPlaybackPositionUpdateListener.onPeriodicNotification(audioTrack2);
                    }
                };
                return;
            }
            this.mHandler = null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }
}

