/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.CCParser;
import android.media.MutableBackgroundColorSpan;
import android.media.SubtitleTrack;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;
import android.widget.LinearLayout;
import android.widget.TextView;

class ClosedCaptionWidget
extends ViewGroup
implements SubtitleTrack.RenderingWidget,
CCParser.DisplayListener {
    private static final CaptioningManager.CaptionStyle DEFAULT_CAPTION_STYLE;
    private static final String TAG = "ClosedCaptionWidget";
    private static final String mDummyText = "1234567890123456789012345678901234";
    private static final Rect mTextBounds;
    private CaptioningManager.CaptionStyle mCaptionStyle;
    private final CaptioningManager.CaptioningChangeListener mCaptioningListener = new CaptioningManager.CaptioningChangeListener(){

        @Override
        public void onUserStyleChanged(CaptioningManager.CaptionStyle captionStyle) {
            ClosedCaptionWidget.access$002(ClosedCaptionWidget.this, DEFAULT_CAPTION_STYLE.applyStyle(captionStyle));
            ClosedCaptionWidget.this.mClosedCaptionLayout.setCaptionStyle(ClosedCaptionWidget.this.mCaptionStyle);
        }
    };
    private CCLayout mClosedCaptionLayout;
    private boolean mHasChangeListener;
    private SubtitleTrack.RenderingWidget.OnChangedListener mListener;
    private final CaptioningManager mManager;

    static {
        mTextBounds = new Rect();
        DEFAULT_CAPTION_STYLE = CaptioningManager.CaptionStyle.DEFAULT;
    }

    public ClosedCaptionWidget(Context context) {
        this(context, null);
    }

    public ClosedCaptionWidget(Context context, AttributeSet attributeSet) {
        this(context, null, 0);
    }

    public ClosedCaptionWidget(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setLayerType(1, null);
        this.mManager = (CaptioningManager)context.getSystemService("captioning");
        this.mCaptionStyle = DEFAULT_CAPTION_STYLE.applyStyle(this.mManager.getUserStyle());
        this.mClosedCaptionLayout = new CCLayout(context);
        this.mClosedCaptionLayout.setCaptionStyle(this.mCaptionStyle);
        this.addView((View)this.mClosedCaptionLayout, -1, -1);
        this.requestLayout();
    }

    static /* synthetic */ CaptioningManager.CaptionStyle access$002(ClosedCaptionWidget closedCaptionWidget, CaptioningManager.CaptionStyle captionStyle) {
        closedCaptionWidget.mCaptionStyle = captionStyle;
        return captionStyle;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void manageChangeListener() {
        boolean bl = this.isAttachedToWindow() && this.getVisibility() == 0;
        if (this.mHasChangeListener != bl) {
            this.mHasChangeListener = bl;
            if (!bl) {
                this.mManager.removeCaptioningChangeListener(this.mCaptioningListener);
                return;
            }
            this.mManager.addCaptioningChangeListener(this.mCaptioningListener);
        }
    }

    @Override
    public CaptioningManager.CaptionStyle getCaptionStyle() {
        return this.mCaptionStyle;
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.manageChangeListener();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.manageChangeListener();
    }

    @Override
    public void onDisplayChanged(SpannableStringBuilder[] spannableStringBuilderArray) {
        this.mClosedCaptionLayout.update(spannableStringBuilderArray);
        if (this.mListener != null) {
            this.mListener.onChanged(this);
        }
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mClosedCaptionLayout.layout(n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.mClosedCaptionLayout.measure(n, n2);
    }

    @Override
    public void setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener onChangedListener) {
        this.mListener = onChangedListener;
    }

    @Override
    public void setSize(int n, int n2) {
        this.measure(View.MeasureSpec.makeMeasureSpec(n, 0x40000000), View.MeasureSpec.makeMeasureSpec(n2, 0x40000000));
        this.layout(0, 0, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
        this.manageChangeListener();
    }

    private static class CCLayout
    extends LinearLayout {
        private static final int MAX_ROWS = 15;
        private static final float SAFE_AREA_RATIO = 0.9f;
        private final CCLineBox[] mLineBoxes = new CCLineBox[15];

        CCLayout(Context context) {
            super(context);
            this.setGravity(0x800003);
            this.setOrientation(1);
            for (int i = 0; i < 15; ++i) {
                this.mLineBoxes[i] = new CCLineBox(this.getContext());
                this.addView((View)this.mLineBoxes[i], -2, -2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            int n7 = n3 - n;
            int n8 = n4 - n2;
            if (n7 * 3 >= n8 * 4) {
                n6 = n8 * 4 / 3;
                n5 = n8;
            } else {
                n6 = n7;
                n5 = n7 * 3 / 4;
            }
            int n9 = (int)(0.9f * (float)n6);
            int n10 = (int)(0.9f * (float)n5);
            int n11 = (n7 - n9) / 2;
            int n12 = (n8 - n10) / 2;
            int n13 = 0;
            while (n13 < 15) {
                this.mLineBoxes[n13].layout(n11, n12 + n10 * n13 / 15, n11 + n9, n12 + n10 * (n13 + 1) / 15);
                ++n13;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onMeasure(int n, int n2) {
            super.onMeasure(n, n2);
            int n3 = this.getMeasuredWidth();
            int n4 = this.getMeasuredHeight();
            if (n3 * 3 >= n4 * 4) {
                n3 = n4 * 4 / 3;
            } else {
                n4 = n3 * 3 / 4;
            }
            int n5 = (int)(0.9f * (float)n3);
            int n6 = View.MeasureSpec.makeMeasureSpec((int)(0.9f * (float)n4) / 15, 0x40000000);
            int n7 = View.MeasureSpec.makeMeasureSpec(n5, 0x40000000);
            int n8 = 0;
            while (n8 < 15) {
                this.mLineBoxes[n8].measure(n7, n6);
                ++n8;
            }
            return;
        }

        void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
            for (int i = 0; i < 15; ++i) {
                this.mLineBoxes[i].setCaptionStyle(captionStyle);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void update(SpannableStringBuilder[] spannableStringBuilderArray) {
            int n = 0;
            while (n < 15) {
                if (spannableStringBuilderArray[n] != null) {
                    this.mLineBoxes[n].setText(spannableStringBuilderArray[n], TextView.BufferType.SPANNABLE);
                    this.mLineBoxes[n].setVisibility(0);
                } else {
                    this.mLineBoxes[n].setVisibility(4);
                }
                ++n;
            }
            return;
        }
    }

    private static class CCLineBox
    extends TextView {
        private static final float EDGE_OUTLINE_RATIO = 0.1f;
        private static final float EDGE_SHADOW_RATIO = 0.05f;
        private static final float FONT_PADDING_RATIO = 0.75f;
        private int mBgColor = -16777216;
        private int mEdgeColor = 0;
        private int mEdgeType = 0;
        private float mOutlineWidth;
        private float mShadowOffset;
        private float mShadowRadius;
        private int mTextColor = -1;

        CCLineBox(Context context) {
            super(context);
            this.setGravity(17);
            this.setBackgroundColor(0);
            this.setTextColor(-1);
            this.setTypeface(Typeface.MONOSPACE);
            this.setVisibility(4);
            Resources resources = this.getContext().getResources();
            this.mOutlineWidth = resources.getDimensionPixelSize(17105021);
            this.mShadowRadius = resources.getDimensionPixelSize(17105019);
            this.mShadowOffset = resources.getDimensionPixelSize(17105020);
        }

        private void drawEdgeOutline(Canvas canvas) {
            TextPaint textPaint = this.getPaint();
            Paint.Style style2 = textPaint.getStyle();
            Paint.Join join = textPaint.getStrokeJoin();
            float f = textPaint.getStrokeWidth();
            this.setTextColor(this.mEdgeColor);
            textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            textPaint.setStrokeJoin(Paint.Join.ROUND);
            textPaint.setStrokeWidth(this.mOutlineWidth);
            super.onDraw(canvas);
            this.setTextColor(this.mTextColor);
            textPaint.setStyle(style2);
            textPaint.setStrokeJoin(join);
            textPaint.setStrokeWidth(f);
            this.setBackgroundSpans(0);
            super.onDraw(canvas);
            this.setBackgroundSpans(this.mBgColor);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void drawEdgeRaisedOrDepressed(Canvas canvas) {
            int n = -1;
            TextPaint textPaint = this.getPaint();
            Paint.Style style2 = textPaint.getStyle();
            textPaint.setStyle(Paint.Style.FILL);
            boolean bl = this.mEdgeType == 3;
            int n2 = bl ? n : this.mEdgeColor;
            if (bl) {
                n = this.mEdgeColor;
            }
            float f = this.mShadowRadius / 2.0f;
            this.setShadowLayer(this.mShadowRadius, -f, -f, n2);
            super.onDraw(canvas);
            this.setBackgroundSpans(0);
            this.setShadowLayer(this.mShadowRadius, f, f, n);
            super.onDraw(canvas);
            textPaint.setStyle(style2);
            this.setBackgroundSpans(this.mBgColor);
        }

        private void setBackgroundSpans(int n) {
            CharSequence charSequence = this.getText();
            if (charSequence instanceof Spannable) {
                Spannable spannable = (Spannable)charSequence;
                MutableBackgroundColorSpan[] mutableBackgroundColorSpanArray = spannable.getSpans(0, spannable.length(), MutableBackgroundColorSpan.class);
                for (int i = 0; i < mutableBackgroundColorSpanArray.length; ++i) {
                    mutableBackgroundColorSpanArray[i].setBackgroundColor(n);
                }
            }
        }

        @Override
        protected void onDraw(Canvas canvas) {
            if (this.mEdgeType == -1 || this.mEdgeType == 0 || this.mEdgeType == 2) {
                super.onDraw(canvas);
                return;
            }
            if (this.mEdgeType == 1) {
                this.drawEdgeOutline(canvas);
                return;
            }
            this.drawEdgeRaisedOrDepressed(canvas);
        }

        @Override
        protected void onMeasure(int n, int n2) {
            float f = 0.75f * (float)View.MeasureSpec.getSize(n2);
            this.setTextSize(0, f);
            this.mOutlineWidth = 1.0f + 0.1f * f;
            this.mShadowOffset = this.mShadowRadius = 1.0f + 0.05f * f;
            this.setScaleX(1.0f);
            this.getPaint().getTextBounds(ClosedCaptionWidget.mDummyText, 0, ClosedCaptionWidget.mDummyText.length(), mTextBounds);
            float f2 = mTextBounds.width();
            this.setScaleX((float)View.MeasureSpec.getSize(n) / f2);
            super.onMeasure(n, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
            this.mTextColor = captionStyle.foregroundColor;
            this.mBgColor = captionStyle.backgroundColor;
            this.mEdgeType = captionStyle.edgeType;
            this.mEdgeColor = captionStyle.edgeColor;
            this.setTextColor(this.mTextColor);
            if (this.mEdgeType == 2) {
                this.setShadowLayer(this.mShadowRadius, this.mShadowOffset, this.mShadowOffset, this.mEdgeColor);
            } else {
                this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            }
            this.invalidate();
        }
    }
}

