/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.media.MediaTimeProvider;
import android.media.Metadata;
import android.media.SRTRenderer;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.TimedText;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.app.IAppOpsService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import libcore.io.IoBridge;
import libcore.io.Libcore;

public class MediaPlayer
implements SubtitleController.Listener {
    public static final boolean APPLY_METADATA_FILTER = true;
    public static final boolean BYPASS_METADATA_FILTER = false;
    private static final String IMEDIA_PLAYER = "android.media.IMediaPlayer";
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE = 2;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE_FD = 3;
    private static final int INVOKE_ID_DESELECT_TRACK = 5;
    private static final int INVOKE_ID_GET_SELECTED_TRACK = 7;
    private static final int INVOKE_ID_GET_TRACK_INFO = 1;
    private static final int INVOKE_ID_SELECT_TRACK = 4;
    private static final int INVOKE_ID_SET_VIDEO_SCALE_MODE = 6;
    private static final int KEY_PARAMETER_AUDIO_ATTRIBUTES = 1400;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_ERROR = 100;
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    private static final int MEDIA_INFO = 200;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_EXTERNAL_METADATA_UPDATE = 803;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    public static final int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final String MEDIA_MIMETYPE_TEXT_CEA_608 = "text/cea-608";
    public static final String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static final String MEDIA_MIMETYPE_TEXT_VTT = "text/vtt";
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PAUSED = 7;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_SKIPPED = 9;
    private static final int MEDIA_STARTED = 6;
    private static final int MEDIA_STOPPED = 8;
    private static final int MEDIA_SUBTITLE_DATA = 201;
    private static final int MEDIA_TIMED_TEXT = 99;
    public static final boolean METADATA_ALL = false;
    public static final boolean METADATA_UPDATE_ONLY = true;
    private static final String TAG = "MediaPlayer";
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    private final IAppOpsService mAppOps;
    private EventHandler mEventHandler;
    private final Object mInbandSubtitleLock;
    private SubtitleTrack[] mInbandSubtitleTracks;
    private int mListenerContext;
    private long mNativeContext;
    private long mNativeSurfaceTexture;
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    private OnCompletionListener mOnCompletionListener;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    private OnPreparedListener mOnPreparedListener;
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnSubtitleDataListener mOnSubtitleDataListener;
    private OnTimedTextListener mOnTimedTextListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private Vector<InputStream> mOpenSubtitleSources;
    private Vector<SubtitleTrack> mOutOfBandSubtitleTracks;
    private boolean mScreenOnWhilePlaying;
    private int mSelectedSubtitleTrackIndex = -1;
    private boolean mStayAwake;
    private int mStreamType = Integer.MIN_VALUE;
    private SubtitleController mSubtitleController;
    private OnSubtitleDataListener mSubtitleDataListener;
    private SurfaceHolder mSurfaceHolder;
    private TimeProvider mTimeProvider;
    private int mUsage = -1;
    private PowerManager.WakeLock mWakeLock = null;

    static {
        System.loadLibrary("media_jni");
        MediaPlayer.native_init();
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaPlayer() {
        Looper looper;
        this.mInbandSubtitleLock = new Object();
        this.mSubtitleDataListener = new OnSubtitleDataListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onSubtitleData(MediaPlayer mediaPlayer, SubtitleData subtitleData) {
                SubtitleTrack subtitleTrack;
                int n = subtitleData.getTrackIndex();
                if (n >= MediaPlayer.this.mInbandSubtitleTracks.length || (subtitleTrack = MediaPlayer.this.mInbandSubtitleTracks[n]) == null) {
                    return;
                }
                subtitleTrack.onData(subtitleData);
            }
        };
        Looper looper2 = Looper.myLooper();
        this.mEventHandler = looper2 != null ? new EventHandler(this, looper2) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mTimeProvider = new TimeProvider(this);
        this.mOutOfBandSubtitleTracks = new Vector();
        this.mOpenSubtitleSources = new Vector();
        this.mInbandSubtitleTracks = new SubtitleTrack[0];
        this.mAppOps = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        this.native_setup(new WeakReference<MediaPlayer>(this));
    }

    private native int _getAudioStreamType() throws IllegalStateException;

    private native void _pause() throws IllegalStateException;

    private native void _prepare() throws IOException, IllegalStateException;

    private native void _release();

    private native void _reset();

    private native void _setAudioStreamType(int var1);

    private native void _setAuxEffectSendLevel(float var1);

    private native void _setDataSource(FileDescriptor var1, long var2, long var4) throws IOException, IllegalArgumentException, IllegalStateException;

    private native void _setVideoSurface(Surface var1);

    private native void _setVolume(float var1, float var2);

    private native void _start() throws IllegalStateException;

    private native void _stop() throws IllegalStateException;

    static /* synthetic */ TimeProvider access$1000(MediaPlayer mediaPlayer) {
        return mediaPlayer.mTimeProvider;
    }

    static /* synthetic */ OnBufferingUpdateListener access$1100(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnBufferingUpdateListener;
    }

    static /* synthetic */ OnSeekCompleteListener access$1200(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnSeekCompleteListener;
    }

    static /* synthetic */ OnVideoSizeChangedListener access$1300(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnVideoSizeChangedListener;
    }

    static /* synthetic */ OnErrorListener access$1400(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnErrorListener;
    }

    static /* synthetic */ OnInfoListener access$1500(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnInfoListener;
    }

    static /* synthetic */ OnTimedTextListener access$1600(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnTimedTextListener;
    }

    static /* synthetic */ OnSubtitleDataListener access$1700(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnSubtitleDataListener;
    }

    static /* synthetic */ long access$500(MediaPlayer mediaPlayer) {
        return mediaPlayer.mNativeContext;
    }

    static /* synthetic */ void access$600(MediaPlayer mediaPlayer) {
        mediaPlayer.scanInternalSubtitleTracks();
    }

    static /* synthetic */ OnPreparedListener access$700(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnPreparedListener;
    }

    static /* synthetic */ OnCompletionListener access$800(MediaPlayer mediaPlayer) {
        return mediaPlayer.mOnCompletionListener;
    }

    static /* synthetic */ void access$900(MediaPlayer mediaPlayer, boolean bl) {
        mediaPlayer.stayAwake(bl);
    }

    private static boolean availableMimeTypeForExternalSource(String string2) {
        return MEDIA_MIMETYPE_TEXT_SUBRIP.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaPlayer create(Context context, int n) {
        int n2 = AudioSystem.newAudioSessionId();
        if (n2 > 0) {
            return MediaPlayer.create(context, n, null, n2);
        }
        n2 = 0;
        return MediaPlayer.create(context, n, null, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaPlayer create(Context context, int n, AudioAttributes audioAttributes, int n2) {
        try {
            AudioAttributes audioAttributes2;
            AssetFileDescriptor assetFileDescriptor = context.getResources().openRawResourceFd(n);
            if (assetFileDescriptor == null) {
                return null;
            }
            MediaPlayer mediaPlayer = new MediaPlayer();
            AudioAttributes audioAttributes3 = audioAttributes != null ? audioAttributes : (audioAttributes2 = new AudioAttributes.Builder().build());
            mediaPlayer.setAudioAttributes(audioAttributes3);
            mediaPlayer.setAudioSessionId(n2);
            mediaPlayer.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
            assetFileDescriptor.close();
            mediaPlayer.prepare();
            return mediaPlayer;
        }
        catch (IOException iOException) {
            Log.d(TAG, "create failed:", iOException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.d(TAG, "create failed:", illegalArgumentException);
            return null;
        }
        catch (SecurityException securityException) {
            Log.d(TAG, "create failed:", securityException);
            return null;
        }
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder surfaceHolder) {
        int n = AudioSystem.newAudioSessionId();
        if (n > 0) {
            return MediaPlayer.create(context, uri, surfaceHolder, null, n);
        }
        n = 0;
        return MediaPlayer.create(context, uri, surfaceHolder, null, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder surfaceHolder, AudioAttributes audioAttributes, int n) {
        try {
            AudioAttributes audioAttributes2;
            MediaPlayer mediaPlayer = new MediaPlayer();
            AudioAttributes audioAttributes3 = audioAttributes != null ? audioAttributes : (audioAttributes2 = new AudioAttributes.Builder().build());
            mediaPlayer.setAudioAttributes(audioAttributes3);
            mediaPlayer.setAudioSessionId(n);
            mediaPlayer.setDataSource(context, uri);
            if (surfaceHolder != null) {
                mediaPlayer.setDisplay(surfaceHolder);
            }
            mediaPlayer.prepare();
            return mediaPlayer;
        }
        catch (IOException iOException) {
            Log.d(TAG, "create failed:", iOException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.d(TAG, "create failed:", illegalArgumentException);
            return null;
        }
        catch (SecurityException securityException) {
            Log.d(TAG, "create failed:", securityException);
            return null;
        }
    }

    private int getAudioStreamType() {
        if (this.mStreamType == Integer.MIN_VALUE) {
            this.mStreamType = this._getAudioStreamType();
        }
        return this.mStreamType;
    }

    private TrackInfo[] getInbandTrackInfo() throws IllegalStateException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(IMEDIA_PLAYER);
            parcel.writeInt(1);
            this.invoke(parcel, parcel2);
            TrackInfo[] trackInfoArray = parcel2.createTypedArray(TrackInfo.CREATOR);
            return trackInfoArray;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRestricted() {
        try {
            int n;
            int n2 = this.mUsage != -1 ? this.mUsage : (n = AudioAttributes.usageForLegacyStreamType(this.getAudioStreamType()));
            if (this.mAppOps.checkAudioOperation(28, n2, Process.myUid(), ActivityThread.currentPackageName()) == 0) return false;
            return true;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private boolean isVideoScalingModeSupported(int n) {
        return n == 1 || n == 2;
    }

    private native void nativeSetDataSource(IBinder var1, String var2, String[] var3, String[] var4) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private final native void native_finalize();

    private final native boolean native_getMetadata(boolean var1, boolean var2, Parcel var3);

    private static final native void native_init();

    private final native int native_invoke(Parcel var1, Parcel var2);

    public static native int native_pullBatteryData(Parcel var0);

    private final native int native_setMetadataFilter(Parcel var1);

    private final native int native_setRetransmitEndpoint(String var1, int var2);

    private final native void native_setup(Object var1);

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        MediaPlayer mediaPlayer;
        block5: {
            block4: {
                mediaPlayer = (MediaPlayer)((WeakReference)object).get();
                if (mediaPlayer == null) break block4;
                if (n == 200 && n2 == 2) {
                    mediaPlayer.start();
                }
                if (mediaPlayer.mEventHandler != null) break block5;
            }
            return;
        }
        Message message = mediaPlayer.mEventHandler.obtainMessage(n, n2, n3, object2);
        mediaPlayer.mEventHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanInternalSubtitleTracks() {
        if (this.mSubtitleController == null) {
            Log.e(TAG, "Should have subtitle controller already set");
            return;
        }
        TrackInfo[] trackInfoArray = this.getInbandTrackInfo();
        Object object = this.mInbandSubtitleLock;
        synchronized (object) {
            SubtitleTrack[] subtitleTrackArray = new SubtitleTrack[trackInfoArray.length];
            int n = 0;
            while (true) {
                if (n >= trackInfoArray.length) {
                    this.mInbandSubtitleTracks = subtitleTrackArray;
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.mSubtitleController.selectDefaultTrack();
                    return;
                }
                if (trackInfoArray[n].getTrackType() == 4) {
                    subtitleTrackArray[n] = n < this.mInbandSubtitleTracks.length ? this.mInbandSubtitleTracks[n] : this.mSubtitleController.addTrack(trackInfoArray[n].getFormat());
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectOrDeselectInbandTrack(int n, boolean bl) throws IllegalStateException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(IMEDIA_PLAYER);
            int n2 = bl ? 4 : 5;
            parcel.writeInt(n2);
            parcel.writeInt(n);
            this.invoke(parcel, parcel2);
            parcel.recycle();
            parcel2.recycle();
            return;
        }
        catch (Throwable throwable) {
            parcel.recycle();
            parcel2.recycle();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void selectOrDeselectTrack(int n, boolean bl) throws IllegalStateException {
        SubtitleTrack subtitleTrack;
        Object object = this.mInbandSubtitleLock;
        // MONITORENTER : object
        if (this.mInbandSubtitleTracks.length == 0) {
            TrackInfo[] trackInfoArray = this.getInbandTrackInfo();
            this.mInbandSubtitleTracks = new SubtitleTrack[trackInfoArray.length];
            for (int i = 0; i < trackInfoArray.length; ++i) {
                if (trackInfoArray[i].getTrackType() != 4) continue;
                this.mInbandSubtitleTracks[i] = this.mSubtitleController.addTrack(trackInfoArray[i].getFormat());
            }
        }
        // MONITOREXIT : object
        if (n < this.mInbandSubtitleTracks.length) {
            subtitleTrack = this.mInbandSubtitleTracks[n];
        } else {
            int n2 = this.mInbandSubtitleTracks.length + this.mOutOfBandSubtitleTracks.size();
            subtitleTrack = null;
            if (n < n2) {
                subtitleTrack = this.mOutOfBandSubtitleTracks.get(n - this.mInbandSubtitleTracks.length);
            }
        }
        if (this.mSubtitleController != null && subtitleTrack != null) {
            if (bl) {
                int n3;
                if (subtitleTrack.isTimedText() && (n3 = this.getSelectedTrack(3)) >= 0 && n3 < this.mInbandSubtitleTracks.length) {
                    this.selectOrDeselectInbandTrack(n3, false);
                }
                this.mSubtitleController.selectTrack(subtitleTrack);
                return;
            }
            if (this.mSubtitleController.getSelectedTrack() == subtitleTrack) {
                this.mSubtitleController.selectTrack(null);
                return;
            }
            Log.w(TAG, "trying to deselect track that was not selected");
            return;
        }
        this.selectOrDeselectInbandTrack(n, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDataSource(String string2, String[] stringArray, String[] stringArray2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        File file;
        Uri uri = Uri.parse(string2);
        String string3 = uri.getScheme();
        if ("file".equals(string3)) {
            string2 = uri.getPath();
        } else if (string3 != null) {
            this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(string2), string2, stringArray, stringArray2);
            return;
        }
        if ((file = new File(string2)).exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.setDataSource(fileInputStream.getFD());
            fileInputStream.close();
            return;
        }
        throw new IOException("setDataSource failed.");
    }

    private native boolean setParameter(int var1, Parcel var2);

    /*
     * Enabled aggressive block sorting
     */
    private void stayAwake(boolean bl) {
        if (this.mWakeLock != null) {
            if (bl && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!bl && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = bl;
        this.updateSurfaceScreenOn();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            SurfaceHolder surfaceHolder = this.mSurfaceHolder;
            boolean bl = this.mScreenOnWhilePlaying && this.mStayAwake;
            surfaceHolder.setKeepScreenOn(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSubtitleSource(final InputStream inputStream, final MediaFormat mediaFormat) throws IllegalStateException {
        Vector<InputStream> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            this.mOpenSubtitleSources.add(inputStream);
        }
        final HandlerThread handlerThread = new HandlerThread("SubtitleReadThread", 9);
        handlerThread.start();
        new Handler(handlerThread.getLooper()).post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private int addTrack() {
                SubtitleTrack subtitleTrack;
                if (inputStream == null || MediaPlayer.this.mSubtitleController == null || (subtitleTrack = MediaPlayer.this.mSubtitleController.addTrack(mediaFormat)) == null) {
                    return 901;
                }
                Scanner scanner = new Scanner(inputStream, "UTF-8");
                String string2 = scanner.useDelimiter("\\A").next();
                Vector vector = MediaPlayer.this.mOpenSubtitleSources;
                synchronized (vector) {
                    MediaPlayer.this.mOpenSubtitleSources.remove(inputStream);
                }
                scanner.close();
                MediaPlayer.this.mOutOfBandSubtitleTracks.add(subtitleTrack);
                subtitleTrack.onData(string2.getBytes(), true, -1L);
                return 803;
            }

            @Override
            public void run() {
                int n = this.addTrack();
                if (MediaPlayer.this.mEventHandler != null) {
                    Message message = MediaPlayer.this.mEventHandler.obtainMessage(200, n, 0, null);
                    MediaPlayer.this.mEventHandler.sendMessage(message);
                }
                handlerThread.getLooper().quitSafely();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTimedTextSource(Context context, Uri uri, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        AssetFileDescriptor assetFileDescriptor;
        block10: {
            AssetFileDescriptor assetFileDescriptor2;
            String string3 = uri.getScheme();
            if (string3 == null || string3.equals("file")) {
                this.addTimedTextSource(uri.getPath(), string2);
                return;
            }
            assetFileDescriptor = null;
            assetFileDescriptor = assetFileDescriptor2 = context.getContentResolver().openAssetFileDescriptor(uri, "r");
            if (assetFileDescriptor != null) break block10;
            if (assetFileDescriptor == null) return;
            assetFileDescriptor.close();
            return;
        }
        try {
            this.addTimedTextSource(assetFileDescriptor.getFileDescriptor(), string2);
            if (assetFileDescriptor == null) return;
        }
        catch (SecurityException securityException) {
            if (assetFileDescriptor == null) return;
            assetFileDescriptor.close();
            return;
        }
        catch (IOException iOException) {
            if (assetFileDescriptor == null) return;
            assetFileDescriptor.close();
            return;
        }
        catch (Throwable throwable) {
            if (assetFileDescriptor == null) throw throwable;
            assetFileDescriptor.close();
            throw throwable;
        }
        assetFileDescriptor.close();
        return;
    }

    public void addTimedTextSource(FileDescriptor fileDescriptor, final long l, final long l2, String string2) throws IllegalArgumentException, IllegalStateException {
        MediaFormat mediaFormat;
        FileDescriptor fileDescriptor2;
        if (!MediaPlayer.availableMimeTypeForExternalSource(string2)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + string2);
        }
        try {
            fileDescriptor2 = Libcore.os.dup(fileDescriptor);
            mediaFormat = new MediaFormat();
            mediaFormat.setString("mime", string2);
            mediaFormat.setInteger("is-timed-text", 1);
        }
        catch (ErrnoException errnoException) {
            Log.e(TAG, errnoException.getMessage(), errnoException);
            throw new RuntimeException(errnoException);
        }
        Application application = ActivityThread.currentApplication();
        if (this.mSubtitleController == null) {
            this.mSubtitleController = new SubtitleController(application, this.mTimeProvider, this);
            this.mSubtitleController.setAnchor(new SubtitleController.Anchor(){

                @Override
                public Looper getSubtitleLooper() {
                    return Looper.getMainLooper();
                }

                @Override
                public void setSubtitleWidget(SubtitleTrack.RenderingWidget renderingWidget) {
                }
            });
        }
        if (!this.mSubtitleController.hasRendererFor(mediaFormat)) {
            this.mSubtitleController.registerRenderer(new SRTRenderer(application, this.mEventHandler));
        }
        final SubtitleTrack subtitleTrack = this.mSubtitleController.addTrack(mediaFormat);
        this.mOutOfBandSubtitleTracks.add(subtitleTrack);
        final HandlerThread handlerThread = new HandlerThread("TimedTextReadThread", 9);
        handlerThread.start();
        new Handler(handlerThread.getLooper()).post(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private int addTrack() {
                long l3;
                byte[] byArray;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    Libcore.os.lseek(fileDescriptor2, l, OsConstants.SEEK_SET);
                    byArray = new byte[4096];
                    l3 = 0L;
                }
                catch (Exception exception) {
                    try {
                        Log.e(MediaPlayer.TAG, exception.getMessage(), exception);
                        return 900;
                    }
                    catch (Throwable throwable) {
                        if (!false) throw throwable;
                        try {
                            ((InputStream)null).close();
                        }
                        catch (IOException iOException) {
                            Log.e(MediaPlayer.TAG, iOException.getMessage(), iOException);
                            throw throwable;
                        }
                        throw throwable;
                    }
                }
                while (true) {
                    int n;
                    block15: {
                        int n2;
                        if (l3 < l2 && (n = IoBridge.read((FileDescriptor)fileDescriptor2, (byte[])byArray, (int)0, (int)(n2 = (int)Math.min((long)byArray.length, l2 - l3)))) >= 0) break block15;
                        subtitleTrack.onData(byteArrayOutputStream.toByteArray(), true, -1L);
                        return 803;
                    }
                    byteArrayOutputStream.write(byArray, 0, n);
                    l3 += (long)n;
                }
            }

            @Override
            public void run() {
                int n = this.addTrack();
                if (MediaPlayer.this.mEventHandler != null) {
                    Message message = MediaPlayer.this.mEventHandler.obtainMessage(200, n, 0, null);
                    MediaPlayer.this.mEventHandler.sendMessage(message);
                }
                handlerThread.getLooper().quitSafely();
            }
        });
    }

    public void addTimedTextSource(FileDescriptor fileDescriptor, String string2) throws IllegalArgumentException, IllegalStateException {
        this.addTimedTextSource(fileDescriptor, 0L, 0x7FFFFFFFFFFFFFFL, string2);
    }

    public void addTimedTextSource(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        if (!MediaPlayer.availableMimeTypeForExternalSource(string3)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + string3);
        }
        File file = new File(string2);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.addTimedTextSource(fileInputStream.getFD(), string3);
            fileInputStream.close();
            return;
        }
        throw new IOException(string2);
    }

    public native void attachAuxEffect(int var1);

    public void deselectTrack(int n) throws IllegalStateException {
        this.selectOrDeselectTrack(n, false);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public native int getAudioSessionId();

    public native int getCurrentPosition();

    public native int getDuration();

    public MediaTimeProvider getMediaTimeProvider() {
        if (this.mTimeProvider == null) {
            this.mTimeProvider = new TimeProvider(this);
        }
        return this.mTimeProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Metadata getMetadata(boolean bl, boolean bl2) {
        Parcel parcel = Parcel.obtain();
        Metadata metadata = new Metadata();
        if (!this.native_getMetadata(bl, bl2, parcel)) {
            parcel.recycle();
            return null;
        }
        if (metadata.parse(parcel)) return metadata;
        parcel.recycle();
        return null;
    }

    public int getSelectedTrack(int n) throws IllegalStateException {
        int n2;
        SubtitleTrack subtitleTrack;
        if (n == 4 && this.mSubtitleController != null && (subtitleTrack = this.mSubtitleController.getSelectedTrack()) != null && (n2 = this.mOutOfBandSubtitleTracks.indexOf(subtitleTrack)) >= 0) {
            return n2 + this.mInbandSubtitleTracks.length;
        }
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(IMEDIA_PLAYER);
            parcel.writeInt(7);
            parcel.writeInt(n);
            this.invoke(parcel, parcel2);
            int n3 = parcel2.readInt();
            return n3;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public TrackInfo[] getTrackInfo() throws IllegalStateException {
        TrackInfo[] trackInfoArray = this.getInbandTrackInfo();
        TrackInfo[] trackInfoArray2 = new TrackInfo[trackInfoArray.length + this.mOutOfBandSubtitleTracks.size()];
        System.arraycopy(trackInfoArray, 0, trackInfoArray2, 0, trackInfoArray.length);
        int n = trackInfoArray.length;
        Iterator iterator = this.mOutOfBandSubtitleTracks.iterator();
        while (iterator.hasNext()) {
            SubtitleTrack subtitleTrack = (SubtitleTrack)iterator.next();
            int n2 = subtitleTrack.isTimedText() ? 3 : 4;
            trackInfoArray2[n] = new TrackInfo(n2, subtitleTrack.getFormat());
            ++n;
        }
        return trackInfoArray2;
    }

    public native int getVideoHeight();

    public native int getVideoWidth();

    public void invoke(Parcel parcel, Parcel parcel2) {
        int n = this.native_invoke(parcel, parcel2);
        parcel2.setDataPosition(0);
        if (n != 0) {
            throw new RuntimeException("failure code: " + n);
        }
    }

    public native boolean isLooping();

    public native boolean isPlaying();

    public Parcel newRequest() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken(IMEDIA_PLAYER);
        return parcel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onSubtitleTrackSelected(SubtitleTrack subtitleTrack) {
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, false);
            }
            catch (IllegalStateException illegalStateException) {}
            this.mSelectedSubtitleTrackIndex = -1;
        }
        this.setOnSubtitleDataListener(null);
        if (subtitleTrack != null) {
            for (int i = 0; i < this.mInbandSubtitleTracks.length; ++i) {
                if (this.mInbandSubtitleTracks[i] != subtitleTrack) continue;
                Log.v(TAG, "Selecting subtitle track " + i);
                this.mSelectedSubtitleTrackIndex = i;
                try {
                    this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, true);
                }
                catch (IllegalStateException illegalStateException) {}
                this.setOnSubtitleDataListener(this.mSubtitleDataListener);
                return;
            }
        }
    }

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    public void prepare() throws IOException, IllegalStateException {
        this._prepare();
        this.scanInternalSubtitleTracks();
    }

    public native void prepareAsync() throws IllegalStateException;

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnTimedTextListener = null;
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.mOnSubtitleDataListener = null;
        this._release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        this.mSelectedSubtitleTrackIndex = -1;
        Vector<InputStream> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            for (InputStream inputStream : this.mOpenSubtitleSources) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.mOpenSubtitleSources.clear();
        }
        this.mOutOfBandSubtitleTracks.clear();
        this.mInbandSubtitleTracks = new SubtitleTrack[0];
        if (this.mSubtitleController != null) {
            this.mSubtitleController.reset();
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.stayAwake(false);
        this._reset();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
    }

    public native void seekTo(int var1) throws IllegalStateException;

    public void selectTrack(int n) throws IllegalStateException {
        this.selectOrDeselectTrack(n, true);
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
        if (audioAttributes == null) {
            throw new IllegalArgumentException("Cannot set AudioAttributes to null");
        }
        this.mUsage = audioAttributes.getUsage();
        Parcel parcel = Parcel.obtain();
        audioAttributes.writeToParcel(parcel, 1);
        this.setParameter(1400, parcel);
        parcel.recycle();
    }

    public native void setAudioSessionId(int var1) throws IllegalArgumentException, IllegalStateException;

    public void setAudioStreamType(int n) {
        this._setAudioStreamType(n);
        this.mStreamType = n;
    }

    public void setAuxEffectSendLevel(float f) {
        if (this.isRestricted()) {
            return;
        }
        this._setAuxEffectSendLevel(f);
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        block18: {
            AssetFileDescriptor assetFileDescriptor;
            block16: {
                String string2;
                block15: {
                    block14: {
                        AssetFileDescriptor assetFileDescriptor2;
                        string2 = uri.getScheme();
                        if (string2 == null || string2.equals("file")) {
                            this.setDataSource(uri.getPath());
                            return;
                        }
                        assetFileDescriptor = null;
                        assetFileDescriptor = assetFileDescriptor2 = context.getContentResolver().openAssetFileDescriptor(uri, "r");
                        if (assetFileDescriptor != null) break block14;
                        if (assetFileDescriptor == null) return;
                        assetFileDescriptor.close();
                        return;
                    }
                    if (assetFileDescriptor.getDeclaredLength() >= 0L) break block15;
                    this.setDataSource(assetFileDescriptor.getFileDescriptor());
                    break block16;
                }
                try {
                    this.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getDeclaredLength());
                }
                catch (SecurityException securityException) {
                    block17: {
                        if (assetFileDescriptor != null) {
                            assetFileDescriptor.close();
                        }
                        break block17;
                        catch (IOException iOException) {
                            if (assetFileDescriptor == null) break block17;
                            assetFileDescriptor.close();
                        }
                    }
                    Cursor cursor = null;
                    boolean bl = "content".equals(string2);
                    cursor = null;
                    if (bl) {
                        String[] stringArray = new String[]{"_data", "_id"};
                        cursor = context.getContentResolver().query(uri, stringArray, null, null, null);
                        if (cursor.getCount() > 0) {
                            cursor.moveToFirst();
                            this.setDataSource(cursor.getString(cursor.getColumnIndex("_data")));
                            return;
                        }
                    }
                    break block18;
                    catch (Throwable throwable) {
                        if (assetFileDescriptor == null) throw throwable;
                        assetFileDescriptor.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    break block18;
                    finally {
                        if (cursor == null) return;
                        cursor.close();
                    }
                }
            }
            if (assetFileDescriptor == null) return;
            assetFileDescriptor.close();
            return;
        }
        Log.d(TAG, "Couldn't open file on client side, trying server side");
        this.setDataSource(uri.toString(), map);
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fileDescriptor, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
        this._setDataSource(fileDescriptor, l, l2);
    }

    public void setDataSource(String string2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(string2, null, null);
    }

    public void setDataSource(String string2, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (map != null) {
            stringArray = new String[map.size()];
            stringArray2 = new String[map.size()];
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringArray[n] = entry.getKey();
                stringArray2[n] = entry.getValue();
                ++n;
            }
        }
        this.setDataSource(string2, stringArray, stringArray2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDisplay(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
        Surface surface = surfaceHolder != null ? surfaceHolder.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public native void setLooping(boolean var1);

    public int setMetadataFilter(Set<Integer> set, Set<Integer> set2) {
        Parcel parcel = this.newRequest();
        int n = parcel.dataSize() + 4 * (1 + (1 + set.size()) + set2.size());
        if (parcel.dataCapacity() < n) {
            parcel.setDataCapacity(n);
        }
        parcel.writeInt(set.size());
        Iterator<Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            parcel.writeInt(iterator.next());
        }
        parcel.writeInt(set2.size());
        Iterator<Integer> iterator2 = set2.iterator();
        while (iterator2.hasNext()) {
            parcel.writeInt(iterator2.next());
        }
        return this.native_setMetadataFilter(parcel);
    }

    public native void setNextMediaPlayer(MediaPlayer var1);

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener onBufferingUpdateListener) {
        this.mOnBufferingUpdateListener = onBufferingUpdateListener;
    }

    public void setOnCompletionListener(OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener onSeekCompleteListener) {
        this.mOnSeekCompleteListener = onSeekCompleteListener;
    }

    public void setOnSubtitleDataListener(OnSubtitleDataListener onSubtitleDataListener) {
        this.mOnSubtitleDataListener = onSubtitleDataListener;
    }

    public void setOnTimedTextListener(OnTimedTextListener onTimedTextListener) {
        this.mOnTimedTextListener = onTimedTextListener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.mOnVideoSizeChangedListener = onVideoSizeChangedListener;
    }

    public void setRetransmitEndpoint(InetSocketAddress inetSocketAddress) throws IllegalStateException, IllegalArgumentException {
        int n;
        String string2 = null;
        int n2 = 0;
        if (inetSocketAddress != null) {
            string2 = inetSocketAddress.getAddress().getHostAddress();
            n2 = inetSocketAddress.getPort();
        }
        if ((n = this.native_setRetransmitEndpoint(string2, n2)) != 0) {
            throw new IllegalArgumentException("Illegal re-transmit endpoint; native ret " + n);
        }
    }

    public void setScreenOnWhilePlaying(boolean bl) {
        if (this.mScreenOnWhilePlaying != bl) {
            if (bl && this.mSurfaceHolder == null) {
                Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = bl;
            this.updateSurfaceScreenOn();
        }
    }

    public void setSubtitleAnchor(SubtitleController subtitleController, SubtitleController.Anchor anchor) {
        this.mSubtitleController = subtitleController;
        this.mSubtitleController.setAnchor(anchor);
    }

    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public void setVideoScalingMode(int n) {
        if (!this.isVideoScalingModeSupported(n)) {
            throw new IllegalArgumentException("Scaling mode " + n + " is not supported");
        }
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(IMEDIA_PLAYER);
            parcel.writeInt(6);
            parcel.writeInt(n);
            this.invoke(parcel, parcel2);
            return;
        }
        finally {
            parcel.recycle();
            parcel2.recycle();
        }
    }

    public void setVolume(float f) {
        this.setVolume(f, f);
    }

    public void setVolume(float f, float f2) {
        if (this.isRestricted()) {
            return;
        }
        this._setVolume(f, f2);
    }

    public void setWakeMode(Context context, int n) {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        boolean bl = false;
        if (wakeLock != null) {
            boolean bl2 = this.mWakeLock.isHeld();
            bl = false;
            if (bl2) {
                bl = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(0x20000000 | n, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (bl) {
            this.mWakeLock.acquire();
        }
    }

    public void start() throws IllegalStateException {
        if (this.isRestricted()) {
            this._setVolume(0.0f, 0.0f);
        }
        this.stayAwake(true);
        this._start();
    }

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private class EventHandler
    extends Handler {
        private MediaPlayer mMediaPlayer;

        public EventHandler(MediaPlayer mediaPlayer2, Looper looper) {
            super(looper);
            this.mMediaPlayer = mediaPlayer2;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message var1_1) {
            if (MediaPlayer.access$500(this.mMediaPlayer) == 0L) {
                Log.w("MediaPlayer", "mediaplayer went away with unhandled events");
lbl4:
                // 12 sources

                return;
            }
            switch (var1_1.what) {
                case 0: {
                    ** GOTO lbl4
                }
                default: {
                    Log.e("MediaPlayer", "Unknown message type " + var1_1.what);
                    return;
                }
                case 1: {
                    MediaPlayer.access$600(MediaPlayer.this);
                    if (MediaPlayer.access$700(MediaPlayer.this) == null) ** GOTO lbl4
                    MediaPlayer.access$700(MediaPlayer.this).onPrepared(this.mMediaPlayer);
                    return;
                }
                case 2: {
                    if (MediaPlayer.access$800(MediaPlayer.this) != null) {
                        MediaPlayer.access$800(MediaPlayer.this).onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.access$900(MediaPlayer.this, false);
                    return;
                }
                case 8: {
                    if (MediaPlayer.access$1000(MediaPlayer.this) == null) ** GOTO lbl4
                    MediaPlayer.access$1000(MediaPlayer.this).onStopped();
                    return;
                }
                case 6: 
                case 7: {
                    if (MediaPlayer.access$1000(MediaPlayer.this) == null) ** GOTO lbl4
                    var11_2 = MediaPlayer.access$1000(MediaPlayer.this);
                    var12_3 = var1_1.what;
                    var13_4 = false;
                    if (var12_3 == 7) {
                        var13_4 = true;
                    }
                    var11_2.onPaused(var13_4);
                    return;
                }
                case 3: {
                    if (MediaPlayer.access$1100(MediaPlayer.this) == null) ** GOTO lbl4
                    MediaPlayer.access$1100(MediaPlayer.this).onBufferingUpdate(this.mMediaPlayer, var1_1.arg1);
                    return;
                }
                case 4: {
                    if (MediaPlayer.access$1200(MediaPlayer.this) != null) {
                        MediaPlayer.access$1200(MediaPlayer.this).onSeekComplete(this.mMediaPlayer);
                    }
                }
                case 9: {
                    if (MediaPlayer.access$1000(MediaPlayer.this) == null) ** GOTO lbl4
                    MediaPlayer.access$1000(MediaPlayer.this).onSeekComplete(this.mMediaPlayer);
                    return;
                }
                case 5: {
                    if (MediaPlayer.access$1300(MediaPlayer.this) == null) ** GOTO lbl4
                    MediaPlayer.access$1300(MediaPlayer.this).onVideoSizeChanged(this.mMediaPlayer, var1_1.arg1, var1_1.arg2);
                    return;
                }
                case 100: {
                    Log.e("MediaPlayer", "Error (" + var1_1.arg1 + "," + var1_1.arg2 + ")");
                    var9_5 = MediaPlayer.access$1400(MediaPlayer.this);
                    var10_6 = false;
                    if (var9_5 != null) {
                        var10_6 = MediaPlayer.access$1400(MediaPlayer.this).onError(this.mMediaPlayer, var1_1.arg1, var1_1.arg2);
                    }
                    if (MediaPlayer.access$800(MediaPlayer.this) != null && !var10_6) {
                        MediaPlayer.access$800(MediaPlayer.this).onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.access$900(MediaPlayer.this, false);
                    return;
                }
                case 200: {
                    switch (var1_1.arg1) lbl-1000:
                    // 2 sources

                    {
                        default: lbl-1000:
                        // 3 sources

                        {
                            while (true) {
                                if (MediaPlayer.access$1500(MediaPlayer.this) == null) ** GOTO lbl4
                                MediaPlayer.access$1500(MediaPlayer.this).onInfo(this.mMediaPlayer, var1_1.arg1, var1_1.arg2);
                                return;
                            }
                        }
                        case 700: {
                            Log.i("MediaPlayer", "Info (" + var1_1.arg1 + "," + var1_1.arg2 + ")");
                            ** GOTO lbl-1000
                        }
                        case 802: {
                            MediaPlayer.access$600(MediaPlayer.this);
                        }
                        case 803: 
                    }
                    var1_1.arg1 = 802;
                    if (MediaPlayer.access$100(MediaPlayer.this) == null) ** GOTO lbl-1000
                    MediaPlayer.access$100(MediaPlayer.this).selectDefaultTrack();
                    ** continue;
                }
                case 99: {
                    if (MediaPlayer.access$1600(MediaPlayer.this) == null) ** GOTO lbl4
                    if (var1_1.obj == null) {
                        MediaPlayer.access$1600(MediaPlayer.this).onTimedText(this.mMediaPlayer, null);
                        return;
                    }
                    if (!(var1_1.obj instanceof Parcel)) ** GOTO lbl4
                    var4_7 = (Parcel)var1_1.obj;
                    var5_8 = new TimedText(var4_7);
                    var4_7.recycle();
                    MediaPlayer.access$1600(MediaPlayer.this).onTimedText(this.mMediaPlayer, var5_8);
                    return;
                }
                case 201: 
            }
            if (MediaPlayer.access$1700(MediaPlayer.this) != null && var1_1.obj instanceof Parcel) ** break;
            ** while (true)
            var2_9 = (Parcel)var1_1.obj;
            var3_10 = new SubtitleData(var2_9);
            var2_9.recycle();
            MediaPlayer.access$1700(MediaPlayer.this).onSubtitleData(this.mMediaPlayer, var3_10);
        }
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnSubtitleDataListener {
        public void onSubtitleData(MediaPlayer var1, SubtitleData var2);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(MediaPlayer var1, TimedText var2);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    static class TimeProvider
    implements OnSeekCompleteListener,
    MediaTimeProvider {
        private static final long MAX_EARLY_CALLBACK_US = 1000L;
        private static final long MAX_NS_WITHOUT_POSITION_CHECK = 5000000000L;
        private static final int NOTIFY = 1;
        private static final int NOTIFY_SEEK = 3;
        private static final int NOTIFY_STOP = 2;
        private static final int NOTIFY_TIME = 0;
        private static final int REFRESH_AND_NOTIFY_TIME = 1;
        private static final String TAG = "MTP";
        private static final long TIME_ADJUSTMENT_RATE = 2L;
        public boolean DEBUG = false;
        private Handler mEventHandler;
        private HandlerThread mHandlerThread;
        private long mLastNanoTime;
        private long mLastReportedTime;
        private long mLastTimeUs = 0L;
        private MediaTimeProvider.OnMediaTimeListener[] mListeners;
        private boolean mPaused = true;
        private boolean mPausing = false;
        private MediaPlayer mPlayer;
        private boolean mRefresh = false;
        private boolean mSeeking = false;
        private boolean mStopped = true;
        private long mTimeAdjustment;
        private long[] mTimes;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TimeProvider(MediaPlayer mediaPlayer) {
            Looper looper;
            this.mPlayer = mediaPlayer;
            try {
                this.getCurrentTimeUs(true, false);
            }
            catch (IllegalStateException illegalStateException) {
                this.mRefresh = true;
            }
            if ((looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
                this.mHandlerThread = new HandlerThread("MediaPlayerMTPEventThread", -2);
                this.mHandlerThread.start();
                looper = this.mHandlerThread.getLooper();
            }
            this.mEventHandler = new EventHandler(looper);
            this.mListeners = new MediaTimeProvider.OnMediaTimeListener[0];
            this.mTimes = new long[0];
            this.mLastTimeUs = 0L;
            this.mTimeAdjustment = 0L;
        }

        /*
         * Enabled aggressive block sorting
         */
        private long getEstimatedTime(long l, boolean bl) {
            if (this.mPaused) {
                this.mLastReportedTime = this.mLastTimeUs + this.mTimeAdjustment;
                return this.mLastReportedTime;
            }
            long l2 = (l - this.mLastNanoTime) / 1000L;
            this.mLastReportedTime = l2 + this.mLastTimeUs;
            if (this.mTimeAdjustment <= 0L) return this.mLastReportedTime;
            long l3 = this.mTimeAdjustment - l2 / 2L;
            if (l3 <= 0L) {
                this.mTimeAdjustment = 0L;
                return this.mLastReportedTime;
            }
            this.mLastReportedTime = l3 + this.mLastReportedTime;
            return this.mLastReportedTime;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void notifySeek() {
            synchronized (this) {
                this.mSeeking = false;
                try {
                    long l = this.getCurrentTimeUs(true, false);
                    if (this.DEBUG) {
                        Log.d(TAG, "onSeekComplete at " + l);
                    }
                    for (MediaTimeProvider.OnMediaTimeListener onMediaTimeListener : this.mListeners) {
                        if (onMediaTimeListener == null) break;
                        onMediaTimeListener.onSeek(l);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (this.DEBUG) {
                        Log.d(TAG, "onSeekComplete but no player");
                    }
                    this.mPausing = true;
                    this.notifyTimedEvent(false);
                }
                return;
            }
        }

        private void notifyStop() {
            synchronized (this) {
                MediaTimeProvider.OnMediaTimeListener[] onMediaTimeListenerArray = this.mListeners;
                int n = onMediaTimeListenerArray.length;
                int n2 = 0;
                while (true) {
                    MediaTimeProvider.OnMediaTimeListener onMediaTimeListener;
                    block7: {
                        if (n2 < n) {
                            onMediaTimeListener = onMediaTimeListenerArray[n2];
                            if (onMediaTimeListener != null) break block7;
                        }
                        return;
                    }
                    onMediaTimeListener.onStop();
                    ++n2;
                    continue;
                    break;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void notifyTimedEvent(boolean bl) {
            synchronized (this) {
                block16: {
                    Iterator iterator;
                    long l;
                    try {
                        long l2;
                        l = l2 = this.getCurrentTimeUs(bl, true);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.mRefresh = true;
                        this.mPausing = true;
                        l = this.getCurrentTimeUs(bl, true);
                    }
                    long l3 = l;
                    boolean bl2 = this.mSeeking;
                    if (bl2) break block16;
                    if (this.DEBUG) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("notifyTimedEvent(").append(this.mLastTimeUs).append(" -> ").append(l).append(") from {");
                        boolean bl3 = true;
                        long[] lArray = this.mTimes;
                        int n = lArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 < n) {
                                long l4 = lArray[n2];
                                if (l4 != -1L) {
                                    if (!bl3) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(l4);
                                    bl3 = false;
                                }
                            } else {
                                stringBuilder.append("}");
                                Log.d(TAG, stringBuilder.toString());
                                break;
                            }
                            ++n2;
                        }
                    }
                    Vector<MediaTimeProvider.OnMediaTimeListener> vector = new Vector<MediaTimeProvider.OnMediaTimeListener>();
                    int n = 0;
                    while (true) {
                        block20: {
                            block19: {
                                block18: {
                                    block21: {
                                        block17: {
                                            if (n < this.mTimes.length && this.mListeners[n] != null) break block17;
                                            if (l3 <= l || this.mPaused) break block18;
                                            if (this.DEBUG) {
                                                Log.d(TAG, "scheduling for " + l3 + " and " + l);
                                            }
                                            this.scheduleNotification(0, l3 - l);
                                            break block19;
                                        }
                                        if (this.mTimes[n] <= -1L) break block20;
                                        if (this.mTimes[n] > 1000L + l) break block21;
                                        vector.add(this.mListeners[n]);
                                        if (this.DEBUG) {
                                            Log.d(TAG, "removed");
                                        }
                                        this.mTimes[n] = -1L;
                                        break block20;
                                    }
                                    if (l3 != l && this.mTimes[n] >= l3) break block20;
                                    l3 = this.mTimes[n];
                                    break block20;
                                }
                                this.mEventHandler.removeMessages(1);
                            }
                            iterator = vector.iterator();
                            break;
                        }
                        ++n;
                    }
                    while (iterator.hasNext()) {
                        ((MediaTimeProvider.OnMediaTimeListener)iterator.next()).onTimedEvent(l);
                    }
                }
                return;
            }
        }

        private int registerListener(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            int n = 0;
            while (true) {
                if (n >= this.mListeners.length || this.mListeners[n] == onMediaTimeListener || this.mListeners[n] == null) {
                    if (n >= this.mListeners.length) {
                        MediaTimeProvider.OnMediaTimeListener[] onMediaTimeListenerArray = new MediaTimeProvider.OnMediaTimeListener[n + 1];
                        long[] lArray = new long[n + 1];
                        System.arraycopy(this.mListeners, 0, onMediaTimeListenerArray, 0, this.mListeners.length);
                        System.arraycopy((long[])this.mTimes, (int)0, (long[])lArray, (int)0, (int)this.mTimes.length);
                        this.mListeners = onMediaTimeListenerArray;
                        this.mTimes = lArray;
                    }
                    if (this.mListeners[n] == null) {
                        this.mListeners[n] = onMediaTimeListener;
                        this.mTimes[n] = -1L;
                    }
                    return n;
                }
                ++n;
            }
        }

        private void scheduleNotification(int n, long l) {
            if (this.mSeeking && (n == 0 || n == 1)) {
                return;
            }
            if (this.DEBUG) {
                Log.v(TAG, "scheduleNotification " + n + " in " + l);
            }
            this.mEventHandler.removeMessages(1);
            Message message = this.mEventHandler.obtainMessage(1, n, 0);
            this.mEventHandler.sendMessageDelayed(message, (int)(l / 1000L));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void cancelNotifications(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            synchronized (this) {
                for (int i = 0; i < this.mListeners.length; ++i) {
                    if (this.mListeners[i] == onMediaTimeListener) {
                        System.arraycopy(this.mListeners, i + 1, this.mListeners, i, -1 + (this.mListeners.length - i));
                        System.arraycopy((long[])this.mTimes, (int)(i + 1), (long[])this.mTimes, (int)i, (int)(-1 + (this.mTimes.length - i)));
                        this.mListeners[-1 + this.mListeners.length] = null;
                        this.mTimes[-1 + this.mTimes.length] = -1L;
                        break;
                    }
                    if (this.mListeners[i] == null) break;
                }
                this.scheduleNotification(0, 0L);
                return;
            }
        }

        public void close() {
            this.mEventHandler.removeMessages(1);
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
            }
        }

        protected void finalize() {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long getCurrentTimeUs(boolean bl, boolean bl2) throws IllegalStateException {
            boolean bl3 = true;
            synchronized (this) {
                long l;
                block10: {
                    if (this.mPaused && !bl) {
                        return this.mLastReportedTime;
                    }
                    l = System.nanoTime();
                    if (!bl) {
                        long l2 = this.mLastNanoTime;
                        if (l < l2 + 5000000000L) return this.getEstimatedTime(l, bl2);
                    }
                    try {
                        this.mLastTimeUs = 1000L * (long)this.mPlayer.getCurrentPosition();
                        if (this.mPlayer.isPlaying()) {
                            bl3 = false;
                        }
                        this.mPaused = bl3;
                        if (this.DEBUG) {
                            StringBuilder stringBuilder = new StringBuilder();
                            String string2 = this.mPaused ? "paused" : "playing";
                            Log.v(TAG, stringBuilder.append(string2).append(" at ").append(this.mLastTimeUs).toString());
                        }
                        this.mLastNanoTime = l;
                        if (!bl2 || this.mLastTimeUs >= this.mLastReportedTime) break block10;
                        this.mTimeAdjustment = this.mLastReportedTime - this.mLastTimeUs;
                        if (this.mTimeAdjustment <= 1000000L) return this.getEstimatedTime(l, bl2);
                        this.mStopped = false;
                        this.mSeeking = true;
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!this.mPausing) {
                            throw illegalStateException;
                        }
                        this.mPausing = false;
                        this.getEstimatedTime(l, bl2);
                        this.mPaused = true;
                        if (!this.DEBUG) return this.mLastReportedTime;
                        Log.d(TAG, "illegal state, but pausing: estimating at " + this.mLastReportedTime);
                        return this.mLastReportedTime;
                    }
                    this.scheduleNotification(3, 0L);
                    return this.getEstimatedTime(l, bl2);
                }
                this.mTimeAdjustment = 0L;
                return this.getEstimatedTime(l, bl2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void notifyAt(long l, MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            synchronized (this) {
                if (this.DEBUG) {
                    Log.d(TAG, "notifyAt " + l);
                }
                this.mTimes[this.registerListener((MediaTimeProvider.OnMediaTimeListener)onMediaTimeListener)] = l;
                this.scheduleNotification(0, 0L);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onNewPlayer() {
            if (this.mRefresh) {
                synchronized (this) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                    return;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPaused(boolean bl) {
            synchronized (this) {
                if (this.DEBUG) {
                    Log.d(TAG, "onPaused: " + bl);
                }
                if (this.mStopped) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                } else {
                    this.mPausing = bl;
                    this.mSeeking = false;
                    this.scheduleNotification(1, 0L);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onSeekComplete(MediaPlayer mediaPlayer) {
            synchronized (this) {
                this.mStopped = false;
                this.mSeeking = true;
                this.scheduleNotification(3, 0L);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onStopped() {
            synchronized (this) {
                if (this.DEBUG) {
                    Log.d(TAG, "onStopped");
                }
                this.mPaused = true;
                this.mStopped = true;
                this.mSeeking = false;
                this.scheduleNotification(2, 0L);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void scheduleUpdate(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            synchronized (this) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduleUpdate");
                }
                int n = this.registerListener(onMediaTimeListener);
                if (!this.mStopped) {
                    this.mTimes[n] = 0L;
                    this.scheduleNotification(0, 0L);
                }
                return;
            }
        }

        private class EventHandler
        extends Handler {
            public EventHandler(Looper looper) {
                super(looper);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void handleMessage(Message message) {
                if (message.what != 1) return;
                switch (message.arg1) {
                    default: {
                        return;
                    }
                    case 0: {
                        TimeProvider.this.notifyTimedEvent(false);
                        return;
                    }
                    case 1: {
                        TimeProvider.this.notifyTimedEvent(true);
                        return;
                    }
                    case 2: {
                        TimeProvider.this.notifyStop();
                        return;
                    }
                    case 3: 
                }
                TimeProvider.this.notifySeek();
            }
        }
    }

    public static class TrackInfo
    implements Parcelable {
        static final Parcelable.Creator<TrackInfo> CREATOR = new Parcelable.Creator<TrackInfo>(){

            @Override
            public TrackInfo createFromParcel(Parcel parcel) {
                return new TrackInfo(parcel);
            }

            public TrackInfo[] newArray(int n) {
                return new TrackInfo[n];
            }
        };
        public static final int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static final int MEDIA_TRACK_TYPE_VIDEO = 1;
        final MediaFormat mFormat;
        final int mTrackType;

        TrackInfo(int n, MediaFormat mediaFormat) {
            this.mTrackType = n;
            this.mFormat = mediaFormat;
        }

        TrackInfo(Parcel parcel) {
            this.mTrackType = parcel.readInt();
            String string2 = parcel.readString();
            if (this.mTrackType == 3) {
                this.mFormat = MediaFormat.createSubtitleFormat(MediaPlayer.MEDIA_MIMETYPE_TEXT_SUBRIP, string2);
                return;
            }
            if (this.mTrackType == 4) {
                this.mFormat = MediaFormat.createSubtitleFormat(parcel.readString(), string2);
                this.mFormat.setInteger("is-autoselect", parcel.readInt());
                this.mFormat.setInteger("is-default", parcel.readInt());
                this.mFormat.setInteger("is-forced-subtitle", parcel.readInt());
                return;
            }
            this.mFormat = new MediaFormat();
            this.mFormat.setString("language", string2);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public MediaFormat getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        public String getLanguage() {
            String string2 = this.mFormat.getString("language");
            if (string2 == null) {
                string2 = "und";
            }
            return string2;
        }

        public int getTrackType() {
            return this.mTrackType;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append('{');
            switch (this.mTrackType) {
                default: {
                    stringBuilder.append("UNKNOWN");
                    break;
                }
                case 1: {
                    stringBuilder.append("VIDEO");
                    break;
                }
                case 2: {
                    stringBuilder.append("AUDIO");
                    break;
                }
                case 3: {
                    stringBuilder.append("TIMEDTEXT");
                    break;
                }
                case 4: {
                    stringBuilder.append("SUBTITLE");
                }
            }
            stringBuilder.append(", " + this.mFormat.toString());
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mTrackType);
            parcel.writeString(this.getLanguage());
            if (this.mTrackType == 4) {
                parcel.writeString(this.mFormat.getString("mime"));
                parcel.writeInt(this.mFormat.getInteger("is-autoselect"));
                parcel.writeInt(this.mFormat.getInteger("is-default"));
                parcel.writeInt(this.mFormat.getInteger("is-forced-subtitle"));
            }
        }
    }
}

